/*
 * Decompiled with CFR 0.152.
 */
package org.das2.sdi;

import org.das2.sdi.BinImpl;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.SemanticOps;
import org.virbo.dataset.examples.Schemes;
import org.virbo.dsops.Ops;
import sdi.data.Bin;
import sdi.data.SimpleBinnedData2D;

class SimpleBinnedData2DImpl
implements SimpleBinnedData2D {
    QDataSet x;
    QDataSet y;
    QDataSet z;

    public SimpleBinnedData2DImpl(QDataSet x, QDataSet y, QDataSet z) {
        QDataSet cadence;
        if (!Schemes.isSimpleSpectrogram((QDataSet)z)) {
            throw new IllegalArgumentException("data cannot be converted to SimpleBinnedData2D");
        }
        if ((QDataSet)x.property("BIN_MINUS") == null || (QDataSet)x.property("BIN_PLUS") == null) {
            cadence = DataSetUtil.guessCadence((QDataSet)x, null);
            if (cadence != null) {
                cadence = Ops.divide((Object)cadence, (Object)2);
                x = Ops.putProperty((QDataSet)x, (String)"BIN_PLUS", (Object)cadence);
                x = Ops.putProperty((QDataSet)x, (String)"BIN_MINUS", (Object)cadence);
            } else {
                throw new IllegalArgumentException("source x must have BIN_PLUS and BIN_MINUS");
            }
        }
        if ((QDataSet)y.property("BIN_MINUS") == null || (QDataSet)y.property("BIN_PLUS") == null) {
            cadence = DataSetUtil.guessCadence((QDataSet)y, null);
            if (cadence != null) {
                cadence = Ops.divide((Object)cadence, (Object)2);
                y = Ops.putProperty((QDataSet)y, (String)"BIN_PLUS", (Object)cadence);
                y = Ops.putProperty((QDataSet)y, (String)"BIN_MINUS", (Object)cadence);
            } else {
                throw new IllegalArgumentException("source y must have BIN_PLUS and BIN_MINUS");
            }
        }
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public SimpleBinnedData2DImpl(QDataSet ds) {
        this(SemanticOps.xtagsDataSet((QDataSet)ds), SemanticOps.ytagsDataSet((QDataSet)ds), ds);
    }

    public int sizeX() {
        return this.x.length();
    }

    public Bin getXBin(int i) {
        return new BinImpl(this.x, i);
    }

    public int sizeY() {
        return this.y.length();
    }

    public Bin getYBin(int j) {
        return new BinImpl(this.y, j);
    }

    public double getZ(int i, int j) {
        return this.z.value(i, j);
    }
}

