/*
 * Decompiled with CFR 0.152.
 */
package org.das2.sdi;

import org.virbo.dataset.QDataSet;
import org.virbo.dataset.SemanticOps;
import sdi.data.SimpleXYZData;

class SimpleXYZDataImpl
implements SimpleXYZData {
    QDataSet y;
    QDataSet x;
    QDataSet z;

    public SimpleXYZDataImpl(QDataSet x, QDataSet y, QDataSet z) {
        this.y = y;
        this.x = x;
        this.z = z;
        if (z.rank() != 1) {
            throw new IllegalArgumentException("source z is not rank 1: " + z);
        }
        if (y.rank() != 1) {
            throw new IllegalArgumentException("source y is not rank 1: " + y);
        }
        if (x.rank() != 1) {
            throw new IllegalArgumentException("source x is not rank 1: " + x);
        }
    }

    public SimpleXYZDataImpl(QDataSet ds) {
        this.x = SemanticOps.xtagsDataSet((QDataSet)ds);
        this.y = SemanticOps.ytagsDataSet((QDataSet)ds);
        this.z = SemanticOps.getDependentDataSet((QDataSet)ds);
        if (this.z.rank() != 1) {
            throw new IllegalArgumentException("source z is not rank 1: " + this.z);
        }
        if (this.y.rank() != 1) {
            throw new IllegalArgumentException("source y is not rank 1: " + this.y);
        }
        if (this.x.rank() != 1) {
            throw new IllegalArgumentException("source x is not rank 1: " + this.x);
        }
    }

    public int size() {
        return this.x.length();
    }

    public double getX(int i) {
        return this.x.value(i);
    }

    public double getY(int i) {
        return this.y.value(i);
    }

    public double getZ(int i) {
        return this.z.value(i);
    }
}

