/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.formula.ScalarConstantPtg;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.StringUtil;

public final class StringPtg
extends ScalarConstantPtg {
    public static final int SIZE = 9;
    public static final byte sid = 23;
    private static final BitField fHighByte = BitFieldFactory.getInstance(1);
    private static final char FORMULA_DELIMITER = '\"';
    private final int field_1_length;
    private final byte field_2_options;
    private final String field_3_string;

    public StringPtg(RecordInputStream in) {
        this.field_1_length = in.readUByte();
        this.field_2_options = in.readByte();
        this.field_3_string = fHighByte.isSet(this.field_2_options) ? in.readUnicodeLEString(this.field_1_length) : in.readCompressedUnicode(this.field_1_length);
    }

    public StringPtg(String value) {
        if (value.length() > 255) {
            throw new IllegalArgumentException("String literals in formulas can't be bigger than 255 characters ASCII");
        }
        this.field_2_options = (byte)fHighByte.setBoolean(0, StringUtil.hasMultibyte(value));
        this.field_3_string = value;
        this.field_1_length = value.length();
    }

    public String getValue() {
        return this.field_3_string;
    }

    public void writeBytes(byte[] array, int offset) {
        array[offset + 0] = 23;
        array[offset + 1] = (byte)this.field_1_length;
        array[offset + 2] = this.field_2_options;
        if (fHighByte.isSet(this.field_2_options)) {
            StringUtil.putUnicodeLE(this.getValue(), array, offset + 3);
        } else {
            StringUtil.putCompressedUnicode(this.getValue(), array, offset + 3);
        }
    }

    public int getSize() {
        if (fHighByte.isSet(this.field_2_options)) {
            return 2 * this.field_1_length + 3;
        }
        return this.field_1_length + 3;
    }

    public String toFormulaString(HSSFWorkbook book) {
        String value = this.field_3_string;
        int len = value.length();
        StringBuffer sb = new StringBuffer(len + 4);
        sb.append('\"');
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c == '\"') {
                sb.append('\"');
            }
            sb.append(c);
        }
        sb.append('\"');
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append(this.getClass().getName()).append(" [");
        sb.append(this.field_3_string);
        sb.append("]");
        return sb.toString();
    }
}

