/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import opendap.dap.Attribute;
import opendap.dap.BadSemanticsException;
import opendap.dap.BaseType;
import opendap.dap.BaseTypePrimitiveVector;
import opendap.dap.DArrayDimension;
import opendap.dap.DVector;
import opendap.dap.NoSuchAttributeException;
import opendap.dap.PrimitiveVector;
import opendap.dap.Server.InvalidParameterException;
import opendap.dap.XMLparser.DDSXMLParser;

public class DArray
extends DVector
implements Cloneable {
    private Vector dimVector = new Vector();

    public DArray() {
        this(null);
    }

    public DArray(String n) {
        super(n);
    }

    public Object clone() {
        DArray a = (DArray)super.clone();
        a.dimVector = new Vector();
        for (int i = 0; i < this.dimVector.size(); ++i) {
            DArrayDimension d = (DArrayDimension)this.dimVector.elementAt(i);
            a.dimVector.addElement(d.clone());
        }
        return a;
    }

    public String getTypeName() {
        return "Array";
    }

    public void checkSemantics(boolean all) throws BadSemanticsException {
        super.checkSemantics(all);
        if (this.dimVector.isEmpty()) {
            throw new BadSemanticsException("An array variable must have dimensions");
        }
    }

    public void printDecl(PrintWriter os, String space, boolean print_semi, boolean constrained) {
        this.getPrimitiveVector().printDecl(os, space, false, constrained);
        Enumeration e = this.dimVector.elements();
        while (e.hasMoreElements()) {
            DArrayDimension d = (DArrayDimension)e.nextElement();
            os.print("[");
            if (d.getName() != null) {
                os.print(d.getName() + " = ");
            }
            os.print(d.getSize() + "]");
        }
        if (print_semi) {
            os.println(";");
        }
    }

    public void printVal(PrintWriter pw, String space, boolean print_decl_p) {
        if (print_decl_p) {
            this.printDecl(pw, space, false);
            pw.print(" = ");
        }
        int dims = this.numDimensions();
        int[] shape = new int[dims];
        int i = 0;
        Enumeration e = this.dimVector.elements();
        while (e.hasMoreElements()) {
            DArrayDimension d = (DArrayDimension)e.nextElement();
            shape[i++] = d.getSize();
        }
        this.printArray(pw, 0, dims, shape, 0);
        if (print_decl_p) {
            pw.println(";");
        }
        pw.flush();
    }

    private int printArray(PrintWriter os, int index, int dims, int[] shape, int offset) {
        if (dims == 1) {
            os.print("{");
            for (int i = 0; i < shape[offset] - 1; ++i) {
                this.getPrimitiveVector().printSingleVal(os, index++);
                os.print(", ");
            }
            this.getPrimitiveVector().printSingleVal(os, index++);
            os.print("}");
            return index;
        }
        os.print("{");
        for (int i = 0; i < shape[offset] - 1; ++i) {
            index = this.printArray(os, index, dims - 1, shape, offset + 1);
            os.print(",");
        }
        index = this.printArray(os, index, dims - 1, shape, offset + 1);
        os.print("}");
        return index;
    }

    public void appendDim(int size, String name) {
        DArrayDimension newDim = new DArrayDimension(size, name);
        this.dimVector.addElement(newDim);
    }

    public void appendDim(int size, String name, boolean decodeName) {
        DArrayDimension newDim = new DArrayDimension(size, name, decodeName);
        this.dimVector.addElement(newDim);
    }

    public void appendDim(int size) {
        this.appendDim(size, null);
    }

    public final Enumeration getDimensions() {
        return this.dimVector.elements();
    }

    public final int numDimensions() {
        return this.dimVector.size();
    }

    public DArrayDimension getDimension(int dimension) throws InvalidParameterException {
        if (dimension < this.dimVector.size()) {
            return (DArrayDimension)this.dimVector.get(dimension);
        }
        throw new InvalidParameterException("DArray.getDimension(): Bad dimension request: dimension > # of dimensions");
    }

    public DArrayDimension getFirstDimension() {
        return (DArrayDimension)this.dimVector.get(0);
    }

    public void printXML(PrintWriter pw, String pad, boolean constrained) {
        pw.print(pad + "<Array");
        if (this.getName() != null) {
            pw.print(" name=\"" + DDSXMLParser.normalizeToXML(this.getClearName()) + "\"");
        }
        pw.println(">");
        this.printXMLcore(pw, pad, constrained);
        pw.println(pad + "</Array>");
    }

    public void printAsMapXML(PrintWriter pw, String pad, boolean constrained) {
        pw.print(pad + "<Map");
        if (this.getName() != null) {
            pw.print(" name=\"" + DDSXMLParser.normalizeToXML(this.getClearName()) + "\"");
        }
        pw.println(">");
        this.printXMLcore(pw, pad, constrained);
        pw.println(pad + "</Map>");
    }

    private void printXMLcore(PrintWriter pw, String pad, boolean constrained) {
        Enumeration e = this.getAttributeNames();
        while (e.hasMoreElements()) {
            String aName = (String)e.nextElement();
            try {
                Attribute a = this.getAttribute(aName);
                a.printXML(pw, pad + "\t", constrained);
            }
            catch (NoSuchAttributeException nsae) {}
        }
        BaseType bt = null;
        PrimitiveVector pv = this.getPrimitiveVector();
        bt = pv instanceof BaseTypePrimitiveVector ? pv.getTemplate() : pv.getTemplate();
        String nameCache = bt.getName();
        bt.setName(null);
        bt.printXML(pw, pad + "\t", constrained);
        bt.setName(nameCache);
        Enumeration dae = this.getDimensions();
        while (dae.hasMoreElements()) {
            DArrayDimension dad = (DArrayDimension)dae.nextElement();
            int size = dad.getSize();
            String name = dad.getName();
            if (name == null) {
                pw.println(pad + "\t" + "<dimension size=\"" + size + "\"/>");
                continue;
            }
            pw.println(pad + "\t" + "<dimension name=\"" + DDSXMLParser.normalizeToXML(name) + "\" size=\"" + size + "\"/>");
        }
    }
}

