/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap.parser;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import opendap.dap.Attribute;
import opendap.dap.AttributeBadValueException;
import opendap.dap.AttributeExistsException;
import opendap.dap.AttributeTable;
import opendap.dap.DAS;
import opendap.dap.DASException;
import opendap.dap.NoSuchAttributeException;
import opendap.dap.parser.DASParserConstants;
import opendap.dap.parser.DASParserTokenManager;
import opendap.dap.parser.ParseException;
import opendap.dap.parser.SimpleCharStream;
import opendap.dap.parser.Token;
import opendap.dap.parser.TokenMgrError;

public class DASParser
implements DASParserConstants {
    private DAS das;
    private Stack stack;
    private String name;
    private int type;
    private static final String attrTupleMsg = "Error: Expected an attribute type. Such as Byte, Int32, String, et c.\nfollowed by a name and value.\n";
    private static final String noDASMsg = "The attribute object returned from the dataset was null\nCheck that the URL is correct.";
    public DASParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[14];
    private static int[] jj_la1_0;
    private final JJCalls[] jj_2_rtns = new JJCalls[11];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    private final AttributeTable topOfStack() {
        return (AttributeTable)this.stack.peek();
    }

    private final boolean isStackEmpty() {
        return this.stack.isEmpty();
    }

    private final String attrName(String name) {
        int i = name.lastIndexOf(".");
        if (i == -1) {
            return name;
        }
        return name.substring(i + 1);
    }

    public final void Attributes(DAS das) throws ParseException, DASException {
        this.das = das;
        this.stack = new Stack();
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 6: {
                    block9: while (true) {
                        this.Attribute();
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 6: {
                                continue block9;
                            }
                        }
                        break;
                    }
                    this.jj_la1[0] = this.jj_gen;
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    this.error(noDASMsg);
                    break;
                }
            }
        }
        catch (TokenMgrError e) {
            this.error("Error parsing the Attribute object:\n" + e.getMessage() + "\n");
        }
        catch (ParseException e) {
            this.error("Error parsing the Attribute object:\n" + e.getMessage() + "\n");
        }
    }

    public final void Attribute() throws ParseException, DASException {
        this.jj_consume_token(6);
        this.jj_consume_token(19);
        this.AttrList();
        this.jj_consume_token(20);
    }

    public final void AttrList() throws ParseException, DASException {
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block3;
                }
            }
            this.AttrTuple();
        }
    }

    public final void AttrTuple() throws ParseException, DASException {
        block52: {
            Token t = new Token();
            try {
                if (this.jj_2_1(2)) {
                    this.Alias();
                    break block52;
                }
                if (this.jj_2_2(2)) {
                    this.jj_consume_token(8);
                    this.type = 3;
                    t = this.Name();
                    this.name = t.image;
                    this.Bytes();
                    block29: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 21: {
                                break;
                            }
                            default: {
                                this.jj_la1[3] = this.jj_gen;
                                break block29;
                            }
                        }
                        this.jj_consume_token(21);
                        this.Bytes();
                    }
                    this.jj_consume_token(22);
                    break block52;
                }
                if (this.jj_2_3(2)) {
                    this.jj_consume_token(9);
                    this.type = 4;
                    t = this.Name();
                    this.name = t.image;
                    this.Ints();
                    block30: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 21: {
                                break;
                            }
                            default: {
                                this.jj_la1[4] = this.jj_gen;
                                break block30;
                            }
                        }
                        this.jj_consume_token(21);
                        this.Ints();
                    }
                    this.jj_consume_token(22);
                    break block52;
                }
                if (this.jj_2_4(2)) {
                    this.jj_consume_token(10);
                    this.type = 5;
                    t = this.Name();
                    this.name = t.image;
                    this.Ints();
                    block31: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 21: {
                                break;
                            }
                            default: {
                                this.jj_la1[5] = this.jj_gen;
                                break block31;
                            }
                        }
                        this.jj_consume_token(21);
                        this.Ints();
                    }
                    this.jj_consume_token(22);
                    break block52;
                }
                if (this.jj_2_5(2)) {
                    this.jj_consume_token(11);
                    this.type = 6;
                    t = this.Name();
                    this.name = t.image;
                    this.Ints();
                    block32: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 21: {
                                break;
                            }
                            default: {
                                this.jj_la1[6] = this.jj_gen;
                                break block32;
                            }
                        }
                        this.jj_consume_token(21);
                        this.Ints();
                    }
                    this.jj_consume_token(22);
                    break block52;
                }
                if (this.jj_2_6(2)) {
                    this.jj_consume_token(12);
                    this.type = 7;
                    t = this.Name();
                    this.name = t.image;
                    this.Ints();
                    block33: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 21: {
                                break;
                            }
                            default: {
                                this.jj_la1[7] = this.jj_gen;
                                break block33;
                            }
                        }
                        this.jj_consume_token(21);
                        this.Ints();
                    }
                    this.jj_consume_token(22);
                    break block52;
                }
                if (this.jj_2_7(2)) {
                    this.jj_consume_token(13);
                    this.type = 8;
                    t = this.Name();
                    this.name = t.image;
                    this.Floats();
                    block34: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 21: {
                                break;
                            }
                            default: {
                                this.jj_la1[8] = this.jj_gen;
                                break block34;
                            }
                        }
                        this.jj_consume_token(21);
                        this.Floats();
                    }
                    this.jj_consume_token(22);
                    break block52;
                }
                if (this.jj_2_8(2)) {
                    this.jj_consume_token(14);
                    this.type = 9;
                    t = this.Name();
                    this.name = t.image;
                    this.Floats();
                    block35: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 21: {
                                break;
                            }
                            default: {
                                this.jj_la1[9] = this.jj_gen;
                                break block35;
                            }
                        }
                        this.jj_consume_token(21);
                        this.Floats();
                    }
                    this.jj_consume_token(22);
                    break block52;
                }
                if (this.jj_2_9(2)) {
                    this.jj_consume_token(15);
                    this.type = 10;
                    t = this.Name();
                    this.name = t.image;
                    this.Strs();
                    block36: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 21: {
                                break;
                            }
                            default: {
                                this.jj_la1[10] = this.jj_gen;
                                break block36;
                            }
                        }
                        this.jj_consume_token(21);
                        this.Strs();
                    }
                    this.jj_consume_token(22);
                    break block52;
                }
                if (this.jj_2_10(2)) {
                    this.jj_consume_token(16);
                    this.type = 11;
                    t = this.Name();
                    this.name = t.image;
                    this.Urls();
                    block37: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 21: {
                                break;
                            }
                            default: {
                                this.jj_la1[11] = this.jj_gen;
                                break block37;
                            }
                        }
                        this.jj_consume_token(21);
                        this.Urls();
                    }
                    this.jj_consume_token(22);
                    break block52;
                }
                if (this.jj_2_11(2)) {
                    AttributeTable at;
                    t = this.Name();
                    if (this.isStackEmpty()) {
                        at = this.das.getAttributeTable(t.image);
                        if (at == null) {
                            at = new AttributeTable(t.image);
                            this.das.addAttributeTable(t.image, at);
                        }
                    } else {
                        Attribute a = this.topOfStack().getAttribute(t.image);
                        at = a != null ? a.getContainer() : this.topOfStack().appendContainer(t.image);
                    }
                    this.stack.push(at);
                    this.jj_consume_token(19);
                    this.AttrList();
                    this.stack.pop();
                    this.jj_consume_token(20);
                    break block52;
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            catch (ParseException e) {
                this.error("Error: Expected an attribute type. Such as Byte, Int32, String, et c.\nfollowed by a name and value.\n\nThe offending line contained the token: '" + t + "'\n" + "ParseException Message: '" + e.getMessage() + "'\n");
            }
        }
    }

    public final void Bytes() throws ParseException, DASException {
        Token t = this.jj_consume_token(17);
        this.addAttribute(this.type, this.name, t.image);
    }

    public final void Ints() throws ParseException, DASException {
        Token t = this.jj_consume_token(17);
        this.addAttribute(this.type, this.name, t.image);
    }

    public final void Floats() throws ParseException, DASException {
        Token t = this.jj_consume_token(17);
        this.addAttribute(this.type, this.name, t.image);
    }

    public final void Strs() throws ParseException, DASException {
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 17: {
                    Token t = this.jj_consume_token(17);
                    this.addAttribute(this.type, this.name, t.image);
                    break;
                }
                case 18: {
                    Token t = this.jj_consume_token(18);
                    this.addAttribute(this.type, this.name, t.image);
                    break;
                }
                default: {
                    this.jj_la1[12] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (TokenMgrError e) {
            this.error("Unterminated quote: " + e.getMessage() + ")");
        }
    }

    public final void Urls() throws ParseException, DASException {
        this.Strs();
    }

    public final void Alias() throws ParseException, DASException {
        String alias = "";
        String attr = "";
        try {
            this.jj_consume_token(7);
            Token t = this.jj_consume_token(17);
            alias = t.image;
            t = this.jj_consume_token(17);
            attr = t.image;
            if (this.isStackEmpty()) {
                this.das.addAlias(alias, attr);
            } else {
                this.topOfStack().addAlias(alias, attr);
            }
            this.jj_consume_token(22);
        }
        catch (NoSuchAttributeException e) {
            this.error("Error: The attribute " + attr + " does not exist.");
        }
        catch (AttributeExistsException e) {
            this.error("Error: The alias " + alias + " already exists in this DAS.");
        }
    }

    public final Token Name() throws ParseException, DASException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: {
                Token t = this.jj_consume_token(17);
                return t;
            }
            case 6: {
                Token t = this.jj_consume_token(6);
                return t;
            }
            case 7: {
                Token t = this.jj_consume_token(7);
                return t;
            }
            case 8: {
                Token t = this.jj_consume_token(8);
                return t;
            }
            case 9: {
                Token t = this.jj_consume_token(9);
                return t;
            }
            case 10: {
                Token t = this.jj_consume_token(10);
                return t;
            }
            case 11: {
                Token t = this.jj_consume_token(11);
                return t;
            }
            case 12: {
                Token t = this.jj_consume_token(12);
                return t;
            }
            case 13: {
                Token t = this.jj_consume_token(13);
                return t;
            }
            case 14: {
                Token t = this.jj_consume_token(14);
                return t;
            }
            case 15: {
                Token t = this.jj_consume_token(15);
                return t;
            }
            case 16: {
                Token t = this.jj_consume_token(16);
                return t;
            }
        }
        this.jj_la1[13] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    void error(String msg) throws ParseException, DASException {
        throw new DASException(3, msg);
    }

    void addAttribute(int type, String name, String value) throws ParseException, DASException {
        try {
            if (this.isStackEmpty()) {
                String msg = "Whoa! Attribute table stack empty when adding `" + name + ".'";
                this.error(msg);
            }
            this.topOfStack().appendAttribute(name, type, value);
        }
        catch (AttributeBadValueException e) {
            String msg = "`" + value + "' is not " + this.aOrAn(this.getTypeName(type)) + " " + this.getTypeName(type) + " value.";
            this.addBadAttribute(this.topOfStack().getName(), type, name, value, msg);
        }
    }

    void addBadAttribute(String container_name, int type, String name, String value, String msg) throws ParseException, DASException {
        String errorContainerName = container_name + "_dods_errors";
        if (this.topOfStack().getName().equals(errorContainerName)) {
            this.topOfStack().appendAttribute(name, type, value, false);
        } else {
            AttributeTable errorContainer = null;
            try {
                Attribute a = this.topOfStack().getAttribute(errorContainerName);
                errorContainer = a.getContainer();
            }
            catch (NoSuchAttributeException nsae) {
                errorContainer = this.topOfStack().appendContainer(errorContainerName);
            }
            errorContainer.appendAttribute(name, type, value, false);
            errorContainer.appendAttribute(name + "_explanation", 10, "\"" + msg + "\"");
        }
    }

    String aOrAn(String subject) throws ParseException {
        String vowels = "aeiouAEIOUyY";
        if (vowels.indexOf(subject.charAt(0)) >= 0) {
            return "an";
        }
        return "a";
    }

    String getTypeName(int type) throws ParseException {
        switch (type) {
            case 2: {
                return "Container";
            }
            case 3: {
                return "Byte";
            }
            case 4: {
                return "Int16";
            }
            case 5: {
                return "UInt16";
            }
            case 6: {
                return "Int32";
            }
            case 7: {
                return "UInt32";
            }
            case 8: {
                return "Float32";
            }
            case 9: {
                return "Float64";
            }
            case 10: {
                return "String";
            }
            case 11: {
                return "Url";
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, xla);
        }
    }

    private final boolean jj_3_4() {
        if (this.jj_scan_token(10)) {
            return true;
        }
        return this.jj_3R_13();
    }

    private final boolean jj_3R_25() {
        return this.jj_scan_token(16);
    }

    private final boolean jj_3R_24() {
        return this.jj_scan_token(15);
    }

    private final boolean jj_3R_12() {
        if (this.jj_scan_token(7)) {
            return true;
        }
        return this.jj_scan_token(17);
    }

    private final boolean jj_3R_23() {
        return this.jj_scan_token(14);
    }

    private final boolean jj_3_3() {
        if (this.jj_scan_token(9)) {
            return true;
        }
        return this.jj_3R_13();
    }

    private final boolean jj_3R_22() {
        return this.jj_scan_token(13);
    }

    private final boolean jj_3R_21() {
        return this.jj_scan_token(12);
    }

    private final boolean jj_3R_20() {
        return this.jj_scan_token(11);
    }

    private final boolean jj_3R_19() {
        return this.jj_scan_token(10);
    }

    private final boolean jj_3_2() {
        if (this.jj_scan_token(8)) {
            return true;
        }
        return this.jj_3R_13();
    }

    private final boolean jj_3R_18() {
        return this.jj_scan_token(9);
    }

    private final boolean jj_3R_17() {
        return this.jj_scan_token(8);
    }

    private final boolean jj_3R_16() {
        return this.jj_scan_token(7);
    }

    private final boolean jj_3_1() {
        return this.jj_3R_12();
    }

    private final boolean jj_3R_15() {
        return this.jj_scan_token(6);
    }

    private final boolean jj_3R_13() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_14()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_15()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_16()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_17()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_18()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_19()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_20()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_21()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_22()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3R_23()) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_3R_24()) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_3R_25()) {
                                                        return true;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_14() {
        return this.jj_scan_token(17);
    }

    private final boolean jj_3_11() {
        if (this.jj_3R_13()) {
            return true;
        }
        return this.jj_scan_token(19);
    }

    private final boolean jj_3_10() {
        if (this.jj_scan_token(16)) {
            return true;
        }
        return this.jj_3R_13();
    }

    private final boolean jj_3_9() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_3R_13();
    }

    private final boolean jj_3_8() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        return this.jj_3R_13();
    }

    private final boolean jj_3_7() {
        if (this.jj_scan_token(13)) {
            return true;
        }
        return this.jj_3R_13();
    }

    private final boolean jj_3_6() {
        if (this.jj_scan_token(12)) {
            return true;
        }
        return this.jj_3R_13();
    }

    private final boolean jj_3_5() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        return this.jj_3R_13();
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{64, 64, 262080, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 393216, 262080};
    }

    public DASParser(InputStream stream) {
        this(stream, null);
    }

    public DASParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new DASParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 14; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 14; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public DASParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new DASParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 14; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 14; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public DASParser(DASParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 14; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(DASParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 14; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            boolean exists = false;
            Enumeration e = this.jj_expentries.elements();
            while (e.hasMoreElements()) {
                int[] oldentry = (int[])e.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    exists = false;
                    break;
                }
                if (!exists) continue;
                break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[23];
        for (i = 0; i < 23; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 14; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 23; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 11; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                            break;
                        }
                        case 10: {
                            this.jj_3_11();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        DASParser.jj_la1_0();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

