/*
 * Decompiled with CFR 0.152.
 */
package org.eso.fits;

import java.io.DataInput;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eso.fits.FitsException;
import org.eso.fits.FitsKeyword;

public class FitsHeader {
    private Vector keywords = null;
    private Hashtable kwHash;
    private Hashtable commentHash;
    private int headerSpace = 0;

    public FitsHeader() {
        this.keywords = new Vector(36, 36);
        this.kwHash = new Hashtable();
        this.commentHash = new Hashtable();
    }

    /*
     * Unable to fully structure code
     */
    public FitsHeader(DataInput var1_1) throws FitsException {
        super();
        var2_2 = new byte[2880];
        var3_3 = new byte[80];
        try {
            var1_1.readFully(var2_2, 0, 2880);
            var4_4 = new FitsKeyword(var2_2);
            if (!var4_4.getName().equals("SIMPLE") && !var4_4.getName().equals("XTENSION")) {
                throw new FitsException("Not Standard records", 4);
            }
        }
        catch (IOException var5_5) {
            throw new FitsException("No more data", 4);
        }
        catch (FitsException var5_6) {
            throw new FitsException("", 4);
        }
        var5_7 = 1;
        this.keywords = new Vector<E>(36, 36);
        var5_7 = 0;
        try {
            var6_8 = 0;
            while (true) {
                for (var7_12 = 0; var7_12 < 80; ++var7_12) {
                    var3_3[var7_12] = var2_2[var6_8++];
                }
                var4_4 = new FitsKeyword(var3_3);
                this.keywords.setSize(var5_7++);
                this.keywords.addElement(var4_4);
                if (2880 > var6_8) ** continue;
                var1_1.readFully(var2_2, 0, 2880);
                var6_8 = 0;
            }
        }
        catch (IOException var6_9) {
            throw new FitsException("Cannot read header", 4);
        }
        catch (FitsException var6_10) {
            if (var6_10.getType() != 3) {
                throw new FitsException("Bad FITS keyword", 4);
            }
            var6_11 = this.keywords.size() - 1;
            while (((FitsKeyword)this.keywords.elementAt(var6_11)).isEmpty()) {
                this.keywords.removeElementAt(var6_11--);
            }
            this.keywords.trimToSize();
            this.headerSpace = (1 + var5_7 / 36) * 36;
            this.kwHash = new Hashtable<K, V>(this.keywords.size());
            this.commentHash = new Hashtable<K, V>();
            var7_13 = this.keywords.elements();
            while (var7_13.hasMoreElements()) {
                var4_4 = (FitsKeyword)var7_13.nextElement();
                this.hashKeyword(var4_4);
            }
            return;
        }
    }

    public void addKeyword(FitsKeyword fitsKeyword) {
        if (fitsKeyword == null) {
            return;
        }
        this.keywords.addElement(fitsKeyword);
        this.hashKeyword(fitsKeyword);
    }

    public void insertKeywordAt(FitsKeyword fitsKeyword, int n) {
        if (fitsKeyword == null) {
            return;
        }
        this.keywords.insertElementAt(fitsKeyword, n);
        this.hashKeyword(fitsKeyword);
    }

    public void removeKeywordAt(int n) {
        FitsKeyword fitsKeyword = (FitsKeyword)this.keywords.elementAt(n);
        if (fitsKeyword == null) {
            return;
        }
        this.kwHash.remove(fitsKeyword.getName());
        this.keywords.removeElementAt(n);
    }

    private void hashKeyword(FitsKeyword fitsKeyword) {
        if (fitsKeyword == null) {
            return;
        }
        if (fitsKeyword.getType() == 1) {
            Vector<FitsKeyword> vector = (Vector<FitsKeyword>)this.commentHash.get(fitsKeyword.getName());
            if (vector == null) {
                vector = new Vector<FitsKeyword>();
                this.commentHash.put(fitsKeyword.getName(), vector);
            }
            vector.addElement(fitsKeyword);
        } else {
            this.kwHash.put(fitsKeyword.getName(), fitsKeyword);
        }
    }

    public final int getType() {
        if (this.keywords.size() < 3) {
            return -1;
        }
        int n = -1;
        FitsKeyword fitsKeyword = (FitsKeyword)this.keywords.elementAt(0);
        if (fitsKeyword.getName().equals("SIMPLE") && fitsKeyword.getBool()) {
            fitsKeyword = (FitsKeyword)this.kwHash.get("NAXIS1");
            n = fitsKeyword != null && fitsKeyword.getInt() == 0 ? ((fitsKeyword = (FitsKeyword)this.kwHash.get("GROUPS")) != null && fitsKeyword.getBool() ? 4 : 1) : 1;
        } else if (fitsKeyword.getName().equals("XTENSION")) {
            n = fitsKeyword.getString().startsWith("IMAGE") ? 1 : (fitsKeyword.getString().startsWith("BINTABLE") ? 2 : (fitsKeyword.getString().startsWith("TABLE") ? 3 : 0));
        }
        return n;
    }

    public final long getDataSize() {
        if (this.kwHash == null) {
            return 0L;
        }
        int n = this.getType();
        FitsKeyword fitsKeyword = (FitsKeyword)this.kwHash.get("NAXIS");
        long l = fitsKeyword.getInt();
        if (l < 1L) {
            return 0L;
        }
        fitsKeyword = (FitsKeyword)this.kwHash.get("BITPIX");
        long l2 = Math.abs(fitsKeyword.getInt()) / 8;
        long l3 = 1L;
        int n2 = 1;
        while ((long)n2 <= l) {
            if (n != 4 || n2 != 1) {
                fitsKeyword = (FitsKeyword)this.kwHash.get("NAXIS" + n2);
                l3 *= (long)fitsKeyword.getInt();
            }
            ++n2;
        }
        fitsKeyword = (FitsKeyword)this.kwHash.get("PCOUNT");
        if (fitsKeyword != null) {
            l3 += (long)fitsKeyword.getInt();
        }
        if ((fitsKeyword = (FitsKeyword)this.kwHash.get("GCOUNT")) != null) {
            l3 *= (long)fitsKeyword.getInt();
        }
        return l3 *= l2;
    }

    public final String getName() {
        FitsKeyword fitsKeyword = (FitsKeyword)this.kwHash.get("EXTNAME");
        if (fitsKeyword == null || fitsKeyword.getType() != 2) {
            return "NONE";
        }
        return fitsKeyword.getString();
    }

    public final int getVersion() {
        FitsKeyword fitsKeyword = (FitsKeyword)this.kwHash.get("EXTVER");
        if (fitsKeyword == null || fitsKeyword.getType() != 4) {
            return 1;
        }
        return fitsKeyword.getInt();
    }

    public final int getNoKeywords() {
        return this.keywords.size();
    }

    public final FitsKeyword getKeyword(int n) {
        if (n < 0 || this.keywords.size() <= n) {
            return null;
        }
        return (FitsKeyword)this.keywords.elementAt(n);
    }

    public final FitsKeyword getKeyword(String string) {
        Vector vector;
        FitsKeyword fitsKeyword = (FitsKeyword)this.kwHash.get(string);
        if (fitsKeyword == null && (vector = (Vector)this.commentHash.get(string)) != null) {
            fitsKeyword = (FitsKeyword)vector.firstElement();
        }
        return fitsKeyword;
    }

    public final FitsKeyword[] getKeywords(String string) {
        FitsKeyword fitsKeyword = (FitsKeyword)this.kwHash.get(string);
        if (fitsKeyword == null) {
            Vector vector = (Vector)this.commentHash.get(string);
            if (vector == null) {
                return null;
            }
            FitsKeyword[] fitsKeywordArray = new FitsKeyword[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                fitsKeywordArray[i] = (FitsKeyword)vector.elementAt(i);
            }
            return fitsKeywordArray;
        }
        FitsKeyword[] fitsKeywordArray = new FitsKeyword[]{fitsKeyword};
        return fitsKeywordArray;
    }

    public final Enumeration getKeywords() {
        return this.keywords.elements();
    }

    public String toString() {
        int n = this.keywords.size();
        StringBuffer stringBuffer = new StringBuffer(80 * n);
        Enumeration enumeration = this.keywords.elements();
        while (enumeration.hasMoreElements()) {
            FitsKeyword fitsKeyword = (FitsKeyword)enumeration.nextElement();
            stringBuffer.append(fitsKeyword.toString());
        }
        return stringBuffer.toString();
    }

    public int getHeaderSpace() {
        return this.headerSpace;
    }

    public void setExtension(int n) {
        FitsKeyword fitsKeyword;
        switch (n) {
            case 1: {
                fitsKeyword = new FitsKeyword("XTENSION", "IMAGE", "Image extension");
                break;
            }
            case 2: {
                fitsKeyword = new FitsKeyword("XTENSION", "BINTABLE", "Binary table extension");
                break;
            }
            case 3: {
                fitsKeyword = new FitsKeyword("XTENSION", "TABLE", "ASCII table extension");
                break;
            }
            default: {
                return;
            }
        }
        this.removeKeywordAt(0);
        this.insertKeywordAt(fitsKeyword, 0);
    }
}

