/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import java.util.HashMap;
import java.util.Map;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryMember;
import proguard.classfile.Member;
import proguard.classfile.VisitorAccepter;
import proguard.classfile.util.MethodLinker;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.obfuscate.NameFactory;

public class MemberObfuscator
extends SimplifiedVisitor
implements MemberVisitor {
    private final boolean allowAggressiveOverloading;
    private final NameFactory nameFactory;
    private final Map descriptorMap;

    public MemberObfuscator(boolean bl, NameFactory nameFactory, Map map) {
        this.allowAggressiveOverloading = bl;
        this.nameFactory = nameFactory;
        this.descriptorMap = map;
    }

    @Override
    public void visitAnyMember(Clazz clazz, Member member) {
        String string = member.getName(clazz);
        if (string.equals("<clinit>") || string.equals("<init>")) {
            return;
        }
        String string2 = member.getDescriptor(clazz);
        if (!this.allowAggressiveOverloading) {
            string2 = string2.substring(0, string2.indexOf(41) + 1);
        }
        Map map = MemberObfuscator.retrieveNameMap(this.descriptorMap, string2);
        String string3 = MemberObfuscator.newMemberName(member);
        if (string3 == null) {
            this.nameFactory.reset();
            while (map.containsKey(string3 = this.nameFactory.nextName())) {
            }
            map.put(string3, string);
            MemberObfuscator.setNewMemberName(member, string3);
        }
    }

    static Map retrieveNameMap(Map map, String string) {
        HashMap hashMap = (HashMap)map.get(string);
        if (hashMap == null) {
            hashMap = new HashMap();
            map.put(string, hashMap);
        }
        return hashMap;
    }

    static void setFixedNewMemberName(Member member, String string) {
        VisitorAccepter visitorAccepter = MethodLinker.lastVisitorAccepter(member);
        if (!(visitorAccepter instanceof LibraryMember) && !(visitorAccepter instanceof MyFixedName)) {
            visitorAccepter.setVisitorInfo(new MyFixedName(string));
        } else {
            visitorAccepter.setVisitorInfo(string);
        }
    }

    static void setNewMemberName(Member member, String string) {
        MethodLinker.lastVisitorAccepter(member).setVisitorInfo(string);
    }

    static boolean hasFixedNewMemberName(Member member) {
        VisitorAccepter visitorAccepter = MethodLinker.lastVisitorAccepter(member);
        return visitorAccepter instanceof LibraryMember || visitorAccepter instanceof MyFixedName;
    }

    static String newMemberName(Member member) {
        return (String)MethodLinker.lastVisitorAccepter(member).getVisitorInfo();
    }

    private static class MyFixedName
    implements VisitorAccepter {
        private String newName;

        public MyFixedName(String string) {
            this.newName = string;
        }

        @Override
        public Object getVisitorInfo() {
            return this.newName;
        }

        @Override
        public void setVisitorInfo(Object object) {
            this.newName = (String)object;
        }
    }
}

