/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.pds.objectAccess;

import gov.nasa.arc.pds.xml.generated.Array;
import gov.nasa.arc.pds.xml.generated.Array2DImage;
import gov.nasa.arc.pds.xml.generated.Array3DImage;
import gov.nasa.arc.pds.xml.generated.Array3DSpectrum;
import gov.nasa.arc.pds.xml.generated.FieldBinary;
import gov.nasa.arc.pds.xml.generated.FieldCharacter;
import gov.nasa.arc.pds.xml.generated.FieldDelimited;
import gov.nasa.arc.pds.xml.generated.FileArea;
import gov.nasa.arc.pds.xml.generated.FileAreaAncillary;
import gov.nasa.arc.pds.xml.generated.FileAreaBrowse;
import gov.nasa.arc.pds.xml.generated.FileAreaObservational;
import gov.nasa.arc.pds.xml.generated.FileAreaObservationalSupplemental;
import gov.nasa.arc.pds.xml.generated.GroupFieldDelimited;
import gov.nasa.arc.pds.xml.generated.ProductObservational;
import gov.nasa.arc.pds.xml.generated.TableBinary;
import gov.nasa.arc.pds.xml.generated.TableCharacter;
import gov.nasa.arc.pds.xml.generated.TableDelimited;
import gov.nasa.pds.label.jaxb.XMLLabelContext;
import gov.nasa.pds.objectAccess.ParseException;
import java.io.File;
import java.net.URL;
import java.util.List;

public interface ObjectProvider {
    public String getArchiveRoot();

    public URL getRoot();

    public List<Array> getArrays(FileArea var1);

    public List<Array> getArrays(FileAreaObservational var1);

    public List<Array> getArrays(FileAreaBrowse var1);

    public List<Array2DImage> getArray2DImages(FileAreaObservational var1);

    public List<Array3DImage> getArray3DImages(FileAreaObservational var1);

    public List<Array3DSpectrum> getArray3DSpectrums(FileAreaObservational var1);

    public List<Object> getTableObjects(FileAreaObservational var1);

    public List<Object> getTableObjects(FileAreaBrowse var1);

    public List<Object> getTableObjects(FileAreaAncillary var1);

    public List<Object> getTableObjects(FileAreaObservationalSupplemental var1);

    public List<Object> getTableObjects(FileArea var1);

    public List<Object> getTablesAndImages(FileAreaObservational var1);

    public List<Object> getTablesAndImages(FileAreaBrowse var1);

    public List<Object> getTablesAndImages(FileArea var1);

    public List<Object> getHeaderObjects(FileAreaObservational var1);

    public List<Object> getHeaderObjects(FileAreaBrowse var1);

    public List<Object> getHeaderObjects(FileAreaAncillary var1);

    public List<Object> getHeaderObjects(FileArea var1);

    public List<TableCharacter> getTableCharacters(FileAreaObservational var1);

    public List<TableBinary> getTableBinaries(FileAreaObservational var1);

    public List<TableDelimited> getTableDelimiteds(FileAreaObservational var1);

    public List<FieldCharacter> getFieldCharacters(TableCharacter var1);

    public List<FieldBinary> getFieldBinaries(TableBinary var1);

    public List<FieldDelimited> getFieldDelimiteds(TableDelimited var1);

    public List<GroupFieldDelimited> getGroupFieldDelimiteds(TableDelimited var1);

    public List<Object> getFieldDelimitedAndGroupFieldDelimiteds(TableDelimited var1);

    public List<Object> getFieldCharacterAndGroupFieldCharacters(TableCharacter var1);

    public List<Object> getFieldBinaryAndGroupFieldBinaries(TableBinary var1);

    public ProductObservational getObservationalProduct(String var1);

    public <T> T getProduct(File var1, Class<T> var2) throws ParseException;

    public <T> T getProduct(URL var1, Class<T> var2) throws ParseException;

    public void setObservationalProduct(String var1, ProductObservational var2) throws Exception;

    public void setObservationalProduct(String var1, ProductObservational var2, XMLLabelContext var3) throws Exception;
}

