/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.pds.objectAccess;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import gov.nasa.arc.pds.xml.generated.FileAreaObservational;
import gov.nasa.arc.pds.xml.generated.TableDelimited;
import gov.nasa.pds.label.object.FieldDescription;
import gov.nasa.pds.objectAccess.ByteWiseFileAccessor;
import gov.nasa.pds.objectAccess.Exporter;
import gov.nasa.pds.objectAccess.InvalidTableException;
import gov.nasa.pds.objectAccess.ObjectExporter;
import gov.nasa.pds.objectAccess.ObjectProvider;
import gov.nasa.pds.objectAccess.table.AdapterFactory;
import gov.nasa.pds.objectAccess.table.TableAdapter;
import gov.nasa.pds.objectAccess.table.TableDelimitedAdapter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableExporter
extends ObjectExporter
implements Exporter<Object> {
    private Charset decoder;
    private Charset encoder;
    private String exportType = "CSV";
    private static final Logger LOGGER = LoggerFactory.getLogger(TableExporter.class);
    private static final String US_ASCII = "US-ASCII";

    TableExporter(File label, int fileAreaIndex) throws Exception {
        this(label.toURI().toURL(), fileAreaIndex);
    }

    TableExporter(URL label, int fileAreaIndex) throws Exception {
        super(label, fileAreaIndex);
        this.setDecoder(US_ASCII);
        this.setEncoder(US_ASCII);
    }

    TableExporter(FileAreaObservational fileArea, ObjectProvider provider) throws IOException {
        super(fileArea, provider);
        this.setDecoder(US_ASCII);
        this.setEncoder(US_ASCII);
    }

    public FieldDescription[] getTableFields(Object object) throws InvalidTableException {
        return AdapterFactory.INSTANCE.getTableAdapter(object).getFields();
    }

    @Override
    public void convert(Object object, OutputStream outputStream) throws IOException, InvalidTableException {
        URL dataFile = new URL(this.getObjectProvider().getRoot(), this.getObservationalFileArea().getFile().getFileName());
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, this.getEncoder()));
        if (this.getExportType().equals("CSV")) {
            this.exportToCSV(dataFile, writer, object);
        }
    }

    @Override
    public void convert(OutputStream outputStream, int objectIndex) throws IOException, InvalidTableException {
        List<Object> list = this.getObjectProvider().getTableObjects(this.getObservationalFileArea());
        this.convert(list.get(objectIndex), outputStream);
    }

    public String getExportType() {
        return this.exportType;
    }

    @Override
    public void setExportType(String exportType) {
        this.exportType = exportType;
    }

    public void setDecoder(String charsetName) {
        try {
            this.decoder = Charset.forName(charsetName);
        }
        catch (UnsupportedCharsetException ex) {
            String msg = "The character set name is not a legal name.";
            LOGGER.error(msg, (Throwable)ex);
            throw new UnsupportedCharsetException(msg);
        }
    }

    public Charset getDecoder() {
        return this.decoder;
    }

    public void setEncoder(String charsetName) {
        try {
            this.encoder = Charset.forName(charsetName);
        }
        catch (UnsupportedCharsetException ex) {
            String msg = "The character set name is not a legal name.";
            LOGGER.error(msg, (Throwable)ex);
            throw new UnsupportedCharsetException(msg);
        }
    }

    public Charset getEncoder() {
        return this.encoder;
    }

    private void exportToCSV(URL dataFile, Writer writer, Object table) throws FileNotFoundException, IOException, InvalidTableException {
        if (table instanceof TableDelimited) {
            this.exportDelimitedTableToCSV(dataFile, writer, (TableDelimited)table, this.getDecoder());
        } else {
            this.exportFixedWidthTableToCSV(dataFile, writer, table, this.getDecoder());
        }
    }

    private void exportFixedWidthTableToCSV(URL dataFile, Writer writer, Object table, Charset decoder) throws IOException, InvalidTableException {
        TableAdapter adapter = AdapterFactory.INSTANCE.getTableAdapter(table);
        FieldDescription[] fields = adapter.getFields();
        try {
            CSVWriter csvWriter = new CSVWriter(writer);
            ByteWiseFileAccessor fileAccessor = new ByteWiseFileAccessor(dataFile, adapter.getOffset(), adapter.getRecordLength(), adapter.getRecordCount());
            csvWriter.writeNext(this.getColumnHeaders(fields));
            for (int i = 1; i <= adapter.getRecordCount(); ++i) {
                String[] data = this.readColumnData(fields, i, adapter.getRecordLength(), fileAccessor, decoder);
                csvWriter.writeNext(data);
            }
            csvWriter.flush();
            csvWriter.close();
        }
        catch (FileNotFoundException ex) {
            LOGGER.error("The data file does not exist or for some other reason cannot be opened for reading.", (Throwable)ex);
            throw ex;
        }
        catch (IOException ex) {
            LOGGER.error("I/O error.", (Throwable)ex);
            throw ex;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void exportDelimitedTableToCSV(URL dataFile, Writer writer, TableDelimited table, Charset charset) throws FileNotFoundException, IOException, InvalidTableException {
        TableAdapter adapter = AdapterFactory.INSTANCE.getTableAdapter(table);
        int records = table.getRecords().intValueExact();
        long tableOffset = table.getOffset().getValue().longValueExact();
        InputStream is = null;
        try {
            CSVWriter csvWriter = new CSVWriter(writer);
            csvWriter.writeNext(this.getColumnHeaders(adapter.getFields()));
            is = dataFile.openStream();
            is.skip(tableOffset);
            BufferedReader buffer = new BufferedReader(new InputStreamReader(is, charset));
            CSVReader reader = new CSVReader((Reader)buffer, ((TableDelimitedAdapter)adapter).getFieldDelimiter());
            for (int i = 0; i < records; ++i) {
                String[] line = reader.readNext();
                csvWriter.writeNext(line);
            }
            csvWriter.flush();
            csvWriter.close();
            reader.close();
        }
        catch (FileNotFoundException ex) {
            try {
                LOGGER.error("The data file does not exist or for some other reason cannot be opened for reading.", (Throwable)ex);
                throw ex;
                catch (IOException ex2) {
                    LOGGER.error("I/O error.", (Throwable)ex2);
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
    }

    private String[] getColumnHeaders(FieldDescription[] fields) {
        ArrayList<String> headers = new ArrayList<String>();
        for (FieldDescription field : fields) {
            headers.add(field.getName());
        }
        return headers.toArray(new String[headers.size()]);
    }

    private String[] readColumnData(FieldDescription[] fields, int recordNum, int recordLength, ByteWiseFileAccessor fileAccessor, Charset charset) {
        ArrayList<String> data = new ArrayList<String>();
        byte[] bytes = fileAccessor.readRecordBytes(recordNum, 0, recordLength);
        for (FieldDescription field : fields) {
            String value = field.getType().getAdapter().getString(bytes, field.getOffset(), field.getLength(), field.getStartBit(), field.getStopBit(), charset);
            data.add(value);
        }
        return data.toArray(new String[data.size()]);
    }
}

