/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.pds.objectAccess;

import au.com.bytecode.opencsv.CSVReader;
import gov.nasa.pds.label.object.FieldDescription;
import gov.nasa.pds.label.object.TableRecord;
import gov.nasa.pds.objectAccess.ByteWiseFileAccessor;
import gov.nasa.pds.objectAccess.DelimitedTableRecord;
import gov.nasa.pds.objectAccess.FixedTableRecord;
import gov.nasa.pds.objectAccess.table.AdapterFactory;
import gov.nasa.pds.objectAccess.table.TableAdapter;
import gov.nasa.pds.objectAccess.table.TableBinaryAdapter;
import gov.nasa.pds.objectAccess.table.TableCharacterAdapter;
import gov.nasa.pds.objectAccess.table.TableDelimitedAdapter;
import gov.nasa.pds.objectAccess.utility.Utility;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableReader.class);
    private TableAdapter adapter;
    private long offset;
    private int currentRow = 0;
    private TableRecord record = null;
    protected ByteWiseFileAccessor accessor = null;
    private Map<String, Integer> map = new HashMap<String, Integer>();
    private CSVReader csvReader = null;
    private List<String[]> delimitedRecordList;
    private BufferedReader bufferedReader = null;
    private InputStream inputStream = null;
    private long recordSize = 0L;
    private char delimitedChar = (char)44;

    public TableReader(Object table, File dataFile) throws Exception {
        this(table, dataFile.toURI().toURL());
    }

    public TableReader(Object table, URL dataFile) throws Exception {
        this(table, dataFile, true);
    }

    public TableReader(Object table, URL dataFile, boolean checkSize) throws Exception {
        this(table, dataFile, checkSize, false);
    }

    public TableReader(Object table, URL dataFile, boolean checkSize, boolean readEntireFile) throws Exception {
        this.adapter = AdapterFactory.INSTANCE.getTableAdapter(table);
        try {
            this.offset = this.adapter.getOffset();
        }
        catch (NullPointerException ex) {
            LOGGER.error("The table offset cannot be null.");
            throw ex;
        }
        if (this.adapter instanceof TableDelimitedAdapter) {
            TableDelimitedAdapter tda = (TableDelimitedAdapter)this.adapter;
            this.inputStream = Utility.openConnection(dataFile.openConnection());
            this.inputStream.skip(this.offset);
            this.inputStream.mark(0);
            this.bufferedReader = new BufferedReader(new InputStreamReader(this.inputStream, "US-ASCII"));
            this.accessor = new ByteWiseFileAccessor(dataFile, this.offset, -1);
            this.delimitedChar = tda.getFieldDelimiter();
            this.csvReader = new CSVReader((Reader)this.bufferedReader, this.delimitedChar);
        } else {
            this.accessor = readEntireFile ? new ByteWiseFileAccessor(dataFile, this.offset, this.adapter.getRecordLength()) : new ByteWiseFileAccessor(dataFile, this.offset, this.adapter.getRecordLength(), this.adapter.getRecordCount(), checkSize);
        }
        this.createFieldMap();
    }

    public TableAdapter getAdapter() {
        return this.adapter;
    }

    public FieldDescription[] getFields() {
        return this.adapter.getFields();
    }

    public Map<String, Integer> getFieldMap() {
        return this.map;
    }

    public TableRecord readNext() throws IOException {
        ++this.currentRow;
        if (this.currentRow > this.adapter.getRecordCount()) {
            return null;
        }
        return this.getTableRecord();
    }

    public TableRecord getRecord(int index) throws IllegalArgumentException, IOException {
        int recordCount = this.adapter.getRecordCount();
        if (index < 1 || index > recordCount) {
            String msg = "The index is out of range 1 - " + recordCount;
            LOGGER.error(msg);
            throw new IllegalArgumentException(msg);
        }
        if (this.currentRow > index) {
            this.inputStream.reset();
            this.bufferedReader = new BufferedReader(new InputStreamReader(this.inputStream, "US-ASCII"));
            for (int i = 0; i < index - 1; ++i) {
                this.bufferedReader.readLine();
            }
            this.csvReader = new CSVReader((Reader)this.bufferedReader, this.delimitedChar);
        }
        this.currentRow = index;
        return this.getTableRecord();
    }

    private TableRecord getTableRecord() throws IOException {
        if (this.adapter instanceof TableDelimitedAdapter) {
            String[] recordValue = this.csvReader.readNext();
            if (recordValue != null && recordValue.length != this.adapter.getFieldCount()) {
                throw new IOException("Record " + this.currentRow + " has wrong number of fields (expected " + this.adapter.getFieldCount() + ", got " + recordValue.length + ")");
            }
            if (this.record != null) {
                ((DelimitedTableRecord)this.record).setRecordValue(recordValue);
            } else {
                this.record = new DelimitedTableRecord(this.map, this.adapter.getFieldCount(), recordValue);
            }
        } else {
            byte[] recordValue = this.accessor.readRecordBytes(this.currentRow, 0, this.adapter.getRecordLength());
            if (this.record != null) {
                ((FixedTableRecord)this.record).setRecordValue(recordValue);
            } else {
                this.record = new FixedTableRecord(recordValue, this.map, this.adapter.getFields());
            }
        }
        return this.record;
    }

    private void createFieldMap() {
        this.map = new HashMap<String, Integer>();
        int fieldIndex = 1;
        for (FieldDescription field : this.adapter.getFields()) {
            if (!this.map.containsKey(field.getName())) {
                this.map.put(field.getName(), fieldIndex);
            }
            ++fieldIndex;
        }
    }

    public void setCurrentRow(int row) {
        this.currentRow = row;
    }

    public int getCurrentRow() {
        return this.currentRow;
    }

    public ByteWiseFileAccessor getAccessor() {
        return this.accessor;
    }

    public long getRecordSize(URL dataFile, Object table) throws Exception {
        this.adapter = AdapterFactory.INSTANCE.getTableAdapter(table);
        InputStream is = Utility.openConnection(dataFile.openConnection());
        try {
            this.offset = this.adapter.getOffset();
        }
        catch (NullPointerException ex) {
            LOGGER.error("The table offset cannot be null.");
            throw ex;
        }
        if (this.adapter instanceof TableDelimitedAdapter) {
            is.skip(this.offset);
            this.bufferedReader = new BufferedReader(new InputStreamReader(is, "US-ASCII"));
            int numLines = 0;
            while (this.bufferedReader.readLine() != null) {
                ++numLines;
            }
            this.recordSize = numLines;
        } else {
            if (this.adapter instanceof TableBinaryAdapter) {
                this.offset = 0L;
            }
            is.skip(this.offset);
            this.bufferedReader = new BufferedReader(new InputStreamReader(is, "US-ASCII"));
            if (this.adapter instanceof TableCharacterAdapter) {
                int numLines = 0;
                while (this.bufferedReader.readLine() != null) {
                    ++numLines;
                }
                this.recordSize = numLines;
            } else {
                long fileSize;
                this.recordSize = is.available();
                File aFile = new File(dataFile.toURI());
                RandomAccessFile raf = new RandomAccessFile(aFile, "r");
                raf.seek(this.offset);
                FileChannel inChannel = raf.getChannel();
                this.recordSize = fileSize = inChannel.size();
                raf.close();
            }
        }
        return this.recordSize;
    }

    public long getOffset() {
        return this.offset;
    }
}

