/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.pds.objectAccess.table;

import gov.nasa.pds.objectAccess.table.FieldAdapter;
import gov.nasa.pds.objectAccess.table.IntegerBinaryFieldAdapter;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class FloatBinaryFieldAdapter
implements FieldAdapter {
    FieldAdapter intAdapter;

    public FloatBinaryFieldAdapter(boolean isBigEndian) {
        this.intAdapter = new IntegerBinaryFieldAdapter(4, true, isBigEndian);
    }

    @Override
    public String getString(byte[] buf, int offset, int length, int startBit, int stopBit) {
        return Float.toString(this.getFloat(buf, offset, length, startBit, stopBit));
    }

    @Override
    public String getString(byte[] buf, int offset, int length, int startBit, int stopBit, Charset charset) {
        return Float.toString(this.getFloat(buf, offset, length, startBit, stopBit));
    }

    @Override
    public byte getByte(byte[] buf, int offset, int length, int startBit, int stopBit) {
        throw new UnsupportedOperationException("Cannot get a binary float as an integer.");
    }

    @Override
    public short getShort(byte[] buf, int offset, int length, int startBit, int stopBit) {
        throw new UnsupportedOperationException("Cannot get a binary float as an integer.");
    }

    @Override
    public int getInt(byte[] buf, int offset, int length, int startBit, int stopBit) {
        throw new UnsupportedOperationException("Cannot get a binary float as an integer.");
    }

    @Override
    public long getLong(byte[] buf, int offset, int length, int startBit, int stopBit) {
        throw new UnsupportedOperationException("Cannot get a binary float as an integer.");
    }

    @Override
    public float getFloat(byte[] buf, int offset, int length, int startBit, int stopBit) {
        int bits = this.intAdapter.getInt(buf, offset, length, 0, 0);
        return Float.intBitsToFloat(bits);
    }

    @Override
    public double getDouble(byte[] buf, int offset, int length, int startBit, int stopBit) {
        return this.getFloat(buf, offset, length, startBit, stopBit);
    }

    @Override
    public void setString(String value, int offset, int length, ByteBuffer buffer, boolean isRightJustified) {
        this.setFloat(Float.parseFloat(value), offset, length, buffer, isRightJustified);
    }

    @Override
    public void setString(String value, int offset, int length, ByteBuffer buffer, boolean isRightJustified, Charset charset) {
        this.setFloat(Float.parseFloat(value), offset, length, buffer, isRightJustified);
    }

    @Override
    public void setByte(byte value, int offset, int length, ByteBuffer buffer, boolean isRightJustified) {
        throw new UnsupportedOperationException("Cannot set a binary float as an integer.");
    }

    @Override
    public void setShort(short value, int offset, int length, ByteBuffer buffer, boolean isRightJustified) {
        throw new UnsupportedOperationException("Cannot set a binary float as an integer.");
    }

    @Override
    public void setInt(int value, int offset, int length, ByteBuffer buffer, boolean isRightJustified) {
        throw new UnsupportedOperationException("Cannot set a binary float as an integer.");
    }

    @Override
    public void setLong(long value, int offset, int length, ByteBuffer buffer, boolean isRightJustified) {
        throw new UnsupportedOperationException("Cannot set a binary float as an integer.");
    }

    @Override
    public void setFloat(float value, int offset, int length, ByteBuffer buffer, boolean isRightJustified) {
        this.intAdapter.setFloat(value, offset, length, buffer, isRightJustified);
    }

    @Override
    public void setDouble(double value, int offset, int length, ByteBuffer buffer, boolean isRightJustified) {
        this.setFloat((float)value, offset, length, buffer, isRightJustified);
    }

    @Override
    public BigInteger getBigInteger(byte[] buf, int offset, int length, int startBit, int stopBit) {
        String stringValue = Double.toString(this.getDouble(buf, offset, length, startBit, stopBit));
        return new BigInteger(stringValue);
    }

    @Override
    public void setBigInteger(BigInteger value, int offset, int length, ByteBuffer buffer, boolean isRightJustified) {
        String stringValue = value.toString();
        this.setDouble(Double.parseDouble(stringValue), offset, length, buffer, isRightJustified);
    }
}

