/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.python.compiler.ClassConstants;
import org.python.compiler.Code;
import org.python.compiler.ConstantPool;
import org.python.compiler.Future;
import org.python.compiler.Label;
import org.python.compiler.Module;
import org.python.compiler.ScopeInfo;
import org.python.compiler.SymInfo;
import org.python.core.CompilerFlags;
import org.python.core.PyComplex;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.parser.ParseException;
import org.python.parser.SimpleNode;
import org.python.parser.Visitor;
import org.python.parser.ast.Assert;
import org.python.parser.ast.Assign;
import org.python.parser.ast.Attribute;
import org.python.parser.ast.AugAssign;
import org.python.parser.ast.BinOp;
import org.python.parser.ast.BoolOp;
import org.python.parser.ast.Break;
import org.python.parser.ast.Call;
import org.python.parser.ast.ClassDef;
import org.python.parser.ast.Compare;
import org.python.parser.ast.Continue;
import org.python.parser.ast.Delete;
import org.python.parser.ast.Dict;
import org.python.parser.ast.Ellipsis;
import org.python.parser.ast.Exec;
import org.python.parser.ast.Expr;
import org.python.parser.ast.Expression;
import org.python.parser.ast.ExtSlice;
import org.python.parser.ast.For;
import org.python.parser.ast.FunctionDef;
import org.python.parser.ast.Global;
import org.python.parser.ast.If;
import org.python.parser.ast.Import;
import org.python.parser.ast.ImportFrom;
import org.python.parser.ast.Index;
import org.python.parser.ast.Interactive;
import org.python.parser.ast.Lambda;
import org.python.parser.ast.List;
import org.python.parser.ast.ListComp;
import org.python.parser.ast.Name;
import org.python.parser.ast.Num;
import org.python.parser.ast.Pass;
import org.python.parser.ast.Print;
import org.python.parser.ast.Raise;
import org.python.parser.ast.Repr;
import org.python.parser.ast.Return;
import org.python.parser.ast.Slice;
import org.python.parser.ast.Str;
import org.python.parser.ast.Subscript;
import org.python.parser.ast.Suite;
import org.python.parser.ast.TryExcept;
import org.python.parser.ast.TryFinally;
import org.python.parser.ast.Tuple;
import org.python.parser.ast.UnaryOp;
import org.python.parser.ast.Unicode;
import org.python.parser.ast.While;
import org.python.parser.ast.Yield;
import org.python.parser.ast.excepthandlerType;
import org.python.parser.ast.exprType;
import org.python.parser.ast.keywordType;
import org.python.parser.ast.listcompType;
import org.python.parser.ast.modType;
import org.python.parser.ast.stmtType;

public class CodeCompiler
extends Visitor
implements ClassConstants {
    public static final Object Exit = new Integer(1);
    public static final Object NoExit = null;
    public static final int GET = 0;
    public static final int SET = 1;
    public static final int DEL = 2;
    public static final int AUGGET = 3;
    public static final int AUGSET = 4;
    public Module module;
    public Code code;
    public ConstantPool pool;
    public CodeCompiler mrefs;
    public CompilerFlags cflags;
    int temporary;
    int augmode;
    int augtmp1;
    int augtmp2;
    int augtmp3;
    int augtmp4;
    public boolean fast_locals;
    public boolean print_results;
    public Hashtable tbl;
    public ScopeInfo my_scope;
    boolean optimizeGlobals = true;
    public Vector names;
    public String className;
    public Stack continueLabels;
    public Stack breakLabels;
    public Stack exceptionHandlers;
    public Vector yields = new Vector();
    public int bcfLevel = 0;
    public int PyNone;
    int f_lasti;
    int f_back;
    public int setline;
    boolean inSet = false;
    public int EmptyObjects;
    int getclosure;
    int f_globals;
    int PyFunction_init;
    int PyFunction_closure_init;
    public int printResult;
    public int print1;
    public int print2;
    public int print3;
    public int print4;
    public int print5;
    public int print6;
    int yield_count = 0;
    int f_savedlocals;
    public int makeException0;
    public int makeException1;
    public int makeException2;
    public int makeException3;
    public int importOne;
    public int importOneAs;
    public int importAll;
    public int importFrom;
    public int exec;
    public int asserttype;
    public int nonzero;
    public int iter = 0;
    public int iternext = 0;
    public int match_exception;
    public int add_traceback;
    public int set_exception;
    int[] compare_ops = new int[11];
    static String[] bin_methods = new String[]{null, "_add", "_sub", "_mul", "_div", "_mod", "_pow", "_lshift", "_rshift", "_or", "_xor", "_and", "_floordiv"};
    int[] bin_ops = new int[13];
    static String[] unary_methods = new String[]{null, "__invert__", "__not__", "__pos__", "__neg__"};
    int[] unary_ops = new int[unary_methods.length];
    static String[] aug_methods = new String[]{null, "__iadd__", "__isub__", "__imul__", "__idiv__", "__imod__", "__ipow__", "__ilshift__", "__irshift__", "__ior__", "__ixor__", "__iand__", "__ifloordiv__"};
    int[] augbin_ops = new int[aug_methods.length];
    public int invokea0;
    public int invokea1;
    public int invokea2;
    public int invoke2;
    public int callextra;
    public int call1;
    public int call2;
    public int calla0;
    public int calla1;
    public int calla2;
    public int calla3;
    public int calla4;
    public int getslice;
    public int setslice;
    public int delslice;
    public int getitem;
    public int delitem;
    public int setitem;
    public int getattr;
    public int delattr;
    public int setattr;
    public int getitem2;
    public int unpackSequence;
    public int PyTuple_init;
    public int PyList_init;
    public int PyDictionary_init;
    int list_comprehension_count = 0;
    public int PyList_init2;
    public int PyFunction_init1;
    public int PyFunction_closure_init1;
    public int Ellipsis;
    public int PySlice_init;
    public int makeClass;
    public int makeClass_closure;
    int getglobal;
    int getlocal1;
    int getlocal2;
    int setglobal;
    int setlocal1;
    int setlocal2;
    int delglobal;
    int dellocal1;
    int dellocal2;
    int getderef;
    int setderef;

    public CodeCompiler(Module module, boolean print_results) {
        this.module = module;
        this.print_results = print_results;
        this.mrefs = this;
        this.pool = module.classfile.pool;
        this.continueLabels = new Stack();
        this.breakLabels = new Stack();
        this.exceptionHandlers = new Stack();
    }

    public void getNone() throws IOException {
        if (this.mrefs.PyNone == 0) {
            this.mrefs.PyNone = this.pool.Fieldref("org/python/core/Py", "None", "Lorg/python/core/PyObject;");
        }
        this.code.getstatic(this.mrefs.PyNone);
    }

    public void loadFrame() throws Exception {
        this.code.aload(1);
    }

    public void setLastI(int idx) throws Exception {
        if (this.mrefs.f_lasti == 0) {
            this.mrefs.f_lasti = this.code.pool.Fieldref("org/python/core/PyFrame", "f_lasti", "I");
        }
        this.loadFrame();
        this.code.iconst(idx);
        this.code.putfield(this.mrefs.f_lasti);
    }

    private void loadf_back() throws Exception {
        if (this.mrefs.f_back == 0) {
            this.mrefs.f_back = this.code.pool.Fieldref("org/python/core/PyFrame", "f_back", "Lorg/python/core/PyFrame;");
        }
        this.code.getfield(this.f_back);
    }

    public int storeTop() throws Exception {
        int tmp = this.code.getLocal("org/python/core/PyObject");
        this.code.astore(tmp);
        return tmp;
    }

    public void setline(int line) throws Exception {
        if (this.module.linenumbers) {
            this.code.setline(line);
            this.loadFrame();
            this.code.iconst(line);
            if (this.mrefs.setline == 0) {
                this.mrefs.setline = this.pool.Methodref("org/python/core/PyFrame", "setline", "(I)V");
            }
            this.code.invokevirtual(this.mrefs.setline);
        }
    }

    public void setline(SimpleNode node) throws Exception {
        this.setline(node.beginLine);
    }

    public void set(SimpleNode node) throws Exception {
        int tmp = this.storeTop();
        this.set(node, tmp);
        this.code.aconst_null();
        this.code.astore(tmp);
        this.code.freeLocal(tmp);
    }

    public void set(SimpleNode node, int tmp) throws Exception {
        if (this.inSet) {
            System.out.println("recurse set: " + tmp + ", " + this.temporary);
        }
        this.temporary = tmp;
        this.visit(node);
    }

    private void saveAugTmps(SimpleNode node, int count) throws Exception {
        if (count >= 4) {
            this.augtmp4 = this.code.getLocal("org/python/core/PyObject");
            this.code.astore(this.augtmp4);
        }
        if (count >= 3) {
            this.augtmp3 = this.code.getLocal("org/python/core/PyObject");
            this.code.astore(this.augtmp3);
        }
        if (count >= 2) {
            this.augtmp2 = this.code.getLocal("org/python/core/PyObject");
            this.code.astore(this.augtmp2);
        }
        this.augtmp1 = this.code.getLocal("org/python/core/PyObject");
        this.code.astore(this.augtmp1);
        this.code.aload(this.augtmp1);
        if (count >= 2) {
            this.code.aload(this.augtmp2);
        }
        if (count >= 3) {
            this.code.aload(this.augtmp3);
        }
        if (count >= 4) {
            this.code.aload(this.augtmp4);
        }
    }

    private void restoreAugTmps(SimpleNode node, int count) throws Exception {
        this.code.aload(this.augtmp1);
        this.code.freeLocal(this.augtmp1);
        if (count == 1) {
            return;
        }
        this.code.aload(this.augtmp2);
        this.code.freeLocal(this.augtmp2);
        if (count == 2) {
            return;
        }
        this.code.aload(this.augtmp3);
        this.code.freeLocal(this.augtmp3);
        if (count == 3) {
            return;
        }
        this.code.aload(this.augtmp4);
        this.code.freeLocal(this.augtmp4);
    }

    public void parse(modType node, Code code, boolean fast_locals, String className, boolean classBody, ScopeInfo scope, CompilerFlags cflags) throws Exception {
        this.fast_locals = fast_locals;
        this.className = className;
        this.code = code;
        this.cflags = cflags;
        this.my_scope = scope;
        this.names = scope.names;
        this.tbl = scope.tbl;
        this.optimizeGlobals = fast_locals && !scope.exec && !scope.from_import_star;
        Object exit = this.visit(node);
        if (classBody) {
            this.loadFrame();
            code.invokevirtual("org/python/core/PyFrame", "getf_locals", "()Lorg/python/core/PyObject;");
            code.areturn();
        } else if (exit == null) {
            this.setLastI(-1);
            this.getNone();
            code.areturn();
        }
    }

    public Object visitInteractive(Interactive node) throws Exception {
        this.traverse(node);
        return null;
    }

    public Object visitModule(org.python.parser.ast.Module suite) throws Exception {
        if (this.mrefs.setglobal == 0) {
            this.mrefs.setglobal = this.code.pool.Methodref("org/python/core/PyFrame", "setglobal", "(Ljava/lang/String;Lorg/python/core/PyObject;)V");
        }
        if (suite.body.length > 0 && suite.body[0] instanceof Expr && ((Expr)suite.body[0]).value instanceof Str) {
            this.loadFrame();
            this.code.ldc("__doc__");
            this.visit(((Expr)suite.body[0]).value);
            this.code.invokevirtual(this.mrefs.setglobal);
        }
        if (this.module.setFile) {
            this.loadFrame();
            this.code.ldc("__file__");
            this.module.filename.get(this.code);
            this.code.invokevirtual(this.mrefs.setglobal);
        }
        this.traverse(suite);
        return null;
    }

    public Object visitExpression(Expression node) throws Exception {
        if (this.my_scope.generator && node.body != null) {
            this.module.error("'return' with argument inside generator", true, node);
        }
        return this.visitReturn(new Return(node.body, node), true);
    }

    public void makeArray(SimpleNode[] nodes) throws Exception {
        int n = nodes == null ? 0 : nodes.length;
        if (n == 0) {
            if (this.mrefs.EmptyObjects == 0) {
                this.mrefs.EmptyObjects = this.code.pool.Fieldref("org/python/core/Py", "EmptyObjects", "[Lorg/python/core/PyObject;");
            }
            this.code.getstatic(this.mrefs.EmptyObjects);
        } else {
            int tmp = this.code.getLocal("[org/python/core/PyObject");
            this.code.iconst(n);
            this.code.anewarray(this.code.pool.Class("org/python/core/PyObject"));
            this.code.astore(tmp);
            for (int i = 0; i < n; ++i) {
                this.code.aload(tmp);
                this.code.iconst(i);
                this.visit(nodes[i]);
                this.code.aastore();
            }
            this.code.aload(tmp);
            this.code.freeLocal(tmp);
        }
    }

    public void getDocString(stmtType[] suite) throws Exception {
        if (suite.length > 0 && suite[0] instanceof Expr && ((Expr)suite[0]).value instanceof Str) {
            this.visit(((Expr)suite[0]).value);
        } else {
            this.code.aconst_null();
        }
    }

    public boolean makeClosure(ScopeInfo scope) throws Exception {
        if (scope == null || scope.freevars == null) {
            return false;
        }
        int n = scope.freevars.size();
        if (n == 0) {
            return false;
        }
        if (this.mrefs.getclosure == 0) {
            this.mrefs.getclosure = this.code.pool.Methodref("org/python/core/PyFrame", "getclosure", "(I)Lorg/python/core/PyObject;");
        }
        int tmp = this.code.getLocal("[org/python/core/PyObject");
        this.code.iconst(n);
        this.code.anewarray(this.code.pool.Class("org/python/core/PyObject"));
        this.code.astore(tmp);
        Hashtable upTbl = scope.up.tbl;
        for (int i = 0; i < n; ++i) {
            this.code.aload(tmp);
            this.code.iconst(i);
            this.loadFrame();
            for (int j = 1; j < scope.distance; ++j) {
                this.loadf_back();
            }
            SymInfo symInfo = (SymInfo)upTbl.get(scope.freevars.elementAt(i));
            this.code.iconst(symInfo.env_index);
            this.code.invokevirtual(this.getclosure);
            this.code.aastore();
        }
        this.code.aload(tmp);
        this.code.freeLocal(tmp);
        return true;
    }

    public Object visitFunctionDef(FunctionDef node) throws Exception {
        String name = this.getName(node.name);
        this.setline(node);
        this.code.new_(this.code.pool.Class("org/python/core/PyFunction"));
        this.code.dup();
        this.loadFrame();
        if (this.mrefs.f_globals == 0) {
            this.mrefs.f_globals = this.code.pool.Fieldref("org/python/core/PyFrame", "f_globals", "Lorg/python/core/PyObject;");
        }
        this.code.getfield(this.mrefs.f_globals);
        ScopeInfo scope = this.module.getScopeInfo(node);
        this.makeArray(scope.ac.getDefaults());
        scope.setup_closure();
        scope.dump();
        this.module.PyCode(new Suite(node.body, node), name, true, this.className, false, false, node.beginLine, scope, this.cflags).get(this.code);
        this.getDocString(node.body);
        if (!this.makeClosure(scope)) {
            if (this.mrefs.PyFunction_init == 0) {
                this.mrefs.PyFunction_init = this.code.pool.Methodref("org/python/core/PyFunction", "<init>", "(Lorg/python/core/PyObject;[Lorg/python/core/PyObject;Lorg/python/core/PyCode;Lorg/python/core/PyObject;)V");
            }
            this.code.invokespecial(this.mrefs.PyFunction_init);
        } else {
            if (this.mrefs.PyFunction_closure_init == 0) {
                this.mrefs.PyFunction_closure_init = this.code.pool.Methodref("org/python/core/PyFunction", "<init>", "(Lorg/python/core/PyObject;[Lorg/python/core/PyObject;Lorg/python/core/PyCode;Lorg/python/core/PyObject;[Lorg/python/core/PyObject;)V");
            }
            this.code.invokespecial(this.mrefs.PyFunction_closure_init);
        }
        this.set(new Name(node.name, 2, node));
        return null;
    }

    public Object visitExpr(Expr node) throws Exception {
        this.setline(node);
        this.visit(node.value);
        if (this.print_results) {
            if (this.mrefs.printResult == 0) {
                this.mrefs.printResult = this.code.pool.Methodref("org/python/core/Py", "printResult", "(Lorg/python/core/PyObject;)V");
            }
            this.code.invokestatic(this.mrefs.printResult);
        } else {
            this.code.pop();
        }
        return null;
    }

    public Object visitAssign(Assign node) throws Exception {
        this.setline(node);
        this.visit(node.value);
        if (node.targets.length == 1) {
            this.set(node.targets[0]);
            return null;
        }
        int tmp = this.storeTop();
        for (int i = node.targets.length - 1; i >= 0; --i) {
            this.set(node.targets[i], tmp);
        }
        this.code.freeLocal(tmp);
        return null;
    }

    public Object visitPrint(Print node) throws Exception {
        int printlnv;
        int println;
        int printcomma;
        this.setline(node);
        int tmp = -1;
        if (node.dest != null) {
            this.visit(node.dest);
            tmp = this.storeTop();
            if (this.mrefs.print4 == 0) {
                this.mrefs.print4 = this.pool.Methodref("org/python/core/Py", "printComma", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;)V");
            }
            printcomma = this.mrefs.print4;
            if (this.mrefs.print5 == 0) {
                this.mrefs.print5 = this.pool.Methodref("org/python/core/Py", "println", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;)V");
            }
            println = this.mrefs.print5;
            if (this.mrefs.print6 == 0) {
                this.mrefs.print6 = this.pool.Methodref("org/python/core/Py", "printlnv", "(Lorg/python/core/PyObject;)V");
            }
            printlnv = this.mrefs.print6;
        } else {
            if (this.mrefs.print1 == 0) {
                this.mrefs.print1 = this.pool.Methodref("org/python/core/Py", "printComma", "(Lorg/python/core/PyObject;)V");
            }
            printcomma = this.mrefs.print1;
            if (this.mrefs.print2 == 0) {
                this.mrefs.print2 = this.pool.Methodref("org/python/core/Py", "println", "(Lorg/python/core/PyObject;)V");
            }
            println = this.mrefs.print2;
            if (this.mrefs.print3 == 0) {
                this.mrefs.print3 = this.pool.Methodref("org/python/core/Py", "println", "()V");
            }
            printlnv = this.mrefs.print3;
        }
        if (node.values == null || node.values.length == 0) {
            if (node.dest != null) {
                this.code.aload(tmp);
            }
            this.code.invokestatic(printlnv);
        } else {
            for (int i = 0; i < node.values.length; ++i) {
                if (node.dest != null) {
                    this.code.aload(tmp);
                }
                this.visit(node.values[i]);
                if (node.nl && i == node.values.length - 1) {
                    this.code.invokestatic(println);
                    continue;
                }
                this.code.invokestatic(printcomma);
            }
        }
        if (node.dest != null) {
            this.code.freeLocal(tmp);
        }
        return null;
    }

    public Object visitDelete(Delete node) throws Exception {
        this.setline(node);
        this.traverse(node);
        return null;
    }

    public Object visitPass(Pass node) throws Exception {
        this.setline(node);
        return null;
    }

    public Object visitBreak(Break node) throws Exception {
        if (this.breakLabels.empty()) {
            throw new ParseException("'break' outside loop", node);
        }
        this.doFinallysDownTo(this.bcfLevel);
        this.code.goto_((Label)this.breakLabels.peek());
        return null;
    }

    public Object visitContinue(Continue node) throws Exception {
        if (this.continueLabels.empty()) {
            throw new ParseException("'continue' not properly in loop", node);
        }
        this.doFinallysDownTo(this.bcfLevel);
        this.code.goto_((Label)this.continueLabels.peek());
        return Exit;
    }

    public Object visitYield(Yield node) throws Exception {
        this.setline(node);
        if (!this.fast_locals) {
            throw new ParseException("'yield' outside function", node);
        }
        if (this.inFinallyBody()) {
            throw new ParseException("'yield' not allowed in a 'try' block with a 'finally' clause", node);
        }
        this.saveLocals();
        this.visit(node.value);
        this.setLastI(++this.yield_count);
        this.code.areturn();
        Label restart = this.code.getLabel();
        this.yields.addElement(restart);
        restart.setPosition();
        this.restoreLocals();
        return null;
    }

    private boolean inFinallyBody() {
        for (int i = 0; i < this.exceptionHandlers.size(); ++i) {
            ExceptionHandler handler = (ExceptionHandler)this.exceptionHandlers.elementAt(i);
            if (!handler.isFinallyHandler()) continue;
            return true;
        }
        return false;
    }

    private void restoreLocals() throws Exception {
        this.endExceptionHandlers();
        Vector v = this.code.getActiveLocals();
        this.loadFrame();
        if (this.mrefs.f_savedlocals == 0) {
            this.mrefs.f_savedlocals = this.code.pool.Fieldref("org/python/core/PyFrame", "f_savedlocals", "[Ljava/lang/Object;");
        }
        this.code.getfield(this.mrefs.f_savedlocals);
        int locals = this.code.getLocal("[java/lang/Object");
        this.code.astore(locals);
        for (int i = 0; i < v.size(); ++i) {
            String type = (String)v.elementAt(i);
            if (type == null) continue;
            this.code.aload(locals);
            this.code.iconst(i);
            this.code.aaload();
            this.code.checkcast(this.code.pool.Class(type));
            this.code.astore(i);
        }
        this.code.freeLocal(locals);
        this.restartExceptionHandlers();
    }

    private void endExceptionHandlers() {
        Label end = this.code.getLabelAtPosition();
        for (int i = 0; i < this.exceptionHandlers.size(); ++i) {
            ExceptionHandler handler = (ExceptionHandler)this.exceptionHandlers.elementAt(i);
            handler.exceptionEnds.addElement(end);
        }
    }

    private void restartExceptionHandlers() {
        Label start = this.code.getLabelAtPosition();
        for (int i = 0; i < this.exceptionHandlers.size(); ++i) {
            ExceptionHandler handler = (ExceptionHandler)this.exceptionHandlers.elementAt(i);
            handler.exceptionStarts.addElement(start);
        }
    }

    private void saveLocals() throws Exception {
        Vector v = this.code.getActiveLocals();
        this.code.iconst(v.size());
        this.code.anewarray(this.code.pool.Class("java/lang/Object"));
        int locals = this.code.getLocal("[java/lang/Object");
        this.code.astore(locals);
        for (int i = 0; i < v.size(); ++i) {
            String type = (String)v.elementAt(i);
            if (type == null) continue;
            this.code.aload(locals);
            this.code.iconst(i);
            if (i == 2222) {
                this.code.aconst_null();
            } else {
                this.code.aload(i);
            }
            this.code.aastore();
        }
        if (this.mrefs.f_savedlocals == 0) {
            this.mrefs.f_savedlocals = this.code.pool.Fieldref("org/python/core/PyFrame", "f_savedlocals", "[Ljava/lang/Object;");
        }
        this.loadFrame();
        this.code.aload(locals);
        this.code.putfield(this.mrefs.f_savedlocals);
        this.code.freeLocal(locals);
    }

    public Object visitReturn(Return node) throws Exception {
        return this.visitReturn(node, false);
    }

    public Object visitReturn(Return node, boolean inEval) throws Exception {
        this.setline(node);
        if (!inEval && !this.fast_locals) {
            throw new ParseException("'return' outside function", node);
        }
        int tmp = 0;
        if (node.value != null) {
            if (this.my_scope.generator) {
                throw new ParseException("'return' with argument inside generator", node);
            }
            this.visit(node.value);
            tmp = this.code.getReturnLocal();
            this.code.astore(tmp);
        }
        this.doFinallysDownTo(0);
        this.setLastI(-1);
        if (node.value != null) {
            this.code.aload(tmp);
        } else {
            this.getNone();
        }
        this.code.areturn();
        return Exit;
    }

    public Object visitRaise(Raise node) throws Exception {
        this.setline(node);
        this.traverse(node);
        if (node.type == null) {
            if (this.mrefs.makeException0 == 0) {
                this.mrefs.makeException0 = this.code.pool.Methodref("org/python/core/Py", "makeException", "()Lorg/python/core/PyException;");
            }
            this.code.invokestatic(this.mrefs.makeException0);
        } else if (node.inst == null) {
            if (this.mrefs.makeException1 == 0) {
                this.mrefs.makeException1 = this.code.pool.Methodref("org/python/core/Py", "makeException", "(Lorg/python/core/PyObject;)Lorg/python/core/PyException;");
            }
            this.code.invokestatic(this.mrefs.makeException1);
        } else if (node.tback == null) {
            if (this.mrefs.makeException2 == 0) {
                this.mrefs.makeException2 = this.code.pool.Methodref("org/python/core/Py", "makeException", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;)Lorg/python/core/PyException;");
            }
            this.code.invokestatic(this.mrefs.makeException2);
        } else {
            if (this.mrefs.makeException3 == 0) {
                this.mrefs.makeException3 = this.code.pool.Methodref("org/python/core/Py", "makeException", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;)Lorg/python/core/PyException;");
            }
            this.code.invokestatic(this.mrefs.makeException3);
        }
        this.code.athrow();
        return Exit;
    }

    public Object visitImport(Import node) throws Exception {
        this.setline(node);
        for (int i = 0; i < node.names.length; ++i) {
            String name;
            String asname = null;
            if (node.names[i].asname != null) {
                name = node.names[i].name;
                asname = node.names[i].asname;
                this.code.ldc(name);
                this.loadFrame();
                if (this.mrefs.importOneAs == 0) {
                    this.mrefs.importOneAs = this.code.pool.Methodref("org/python/core/imp", "importOneAs", "(Ljava/lang/String;Lorg/python/core/PyFrame;)Lorg/python/core/PyObject;");
                }
                this.code.invokestatic(this.mrefs.importOneAs);
            } else {
                name = node.names[i].name;
                asname = name;
                if (asname.indexOf(46) > 0) {
                    asname = asname.substring(0, asname.indexOf(46));
                }
                this.code.ldc(name);
                this.loadFrame();
                if (this.mrefs.importOne == 0) {
                    this.mrefs.importOne = this.code.pool.Methodref("org/python/core/imp", "importOne", "(Ljava/lang/String;Lorg/python/core/PyFrame;)Lorg/python/core/PyObject;");
                }
                this.code.invokestatic(this.mrefs.importOne);
            }
            this.set(new Name(asname, 2, node));
        }
        return null;
    }

    public Object visitImportFrom(ImportFrom node) throws Exception {
        Future.checkFromFuture(node);
        this.setline(node);
        this.code.ldc(node.module);
        if (node.names.length > 0) {
            String[] names = new String[node.names.length];
            String[] asnames = new String[node.names.length];
            for (int i = 0; i < node.names.length; ++i) {
                names[i] = node.names[i].name;
                asnames[i] = node.names[i].asname;
                if (asnames[i] != null) continue;
                asnames[i] = names[i];
            }
            CodeCompiler.makeStrings(this.code, names, names.length);
            this.loadFrame();
            if (this.mrefs.importFrom == 0) {
                this.mrefs.importFrom = this.code.pool.Methodref("org/python/core/imp", "importFrom", "(Ljava/lang/String;[Ljava/lang/String;Lorg/python/core/PyFrame;)[Lorg/python/core/PyObject;");
            }
            this.code.invokestatic(this.mrefs.importFrom);
            int tmp = this.storeTop();
            for (int i = 0; i < node.names.length; ++i) {
                this.code.aload(tmp);
                this.code.iconst(i);
                this.code.aaload();
                this.set(new Name(asnames[i], 2, node));
            }
            this.code.freeLocal(tmp);
        } else {
            this.loadFrame();
            if (this.mrefs.importAll == 0) {
                this.mrefs.importAll = this.code.pool.Methodref("org/python/core/imp", "importAll", "(Ljava/lang/String;Lorg/python/core/PyFrame;)V");
            }
            this.code.invokestatic(this.mrefs.importAll);
        }
        return null;
    }

    public Object visitGlobal(Global node) throws Exception {
        return null;
    }

    public Object visitExec(Exec node) throws Exception {
        this.setline(node);
        this.visit(node.body);
        if (node.globals != null) {
            this.visit(node.globals);
        } else {
            this.code.aconst_null();
        }
        if (node.locals != null) {
            this.visit(node.locals);
        } else {
            this.code.aconst_null();
        }
        if (this.mrefs.exec == 0) {
            this.mrefs.exec = this.code.pool.Methodref("org/python/core/Py", "exec", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;)V");
        }
        this.code.invokestatic(this.mrefs.exec);
        return null;
    }

    public Object visitAssert(Assert node) throws Exception {
        this.setline(node);
        Label end_of_assert = this.code.getLabel();
        this.loadFrame();
        this.emitGetGlobal("__debug__");
        if (this.mrefs.nonzero == 0) {
            this.mrefs.nonzero = this.code.pool.Methodref("org/python/core/PyObject", "__nonzero__", "()Z");
        }
        this.code.invokevirtual(this.mrefs.nonzero);
        this.code.ifeq(end_of_assert);
        this.visit(node.test);
        this.code.invokevirtual(this.mrefs.nonzero);
        this.code.ifne(end_of_assert);
        if (this.mrefs.asserttype == 0) {
            this.mrefs.asserttype = this.code.pool.Fieldref("org/python/core/Py", "AssertionError", "Lorg/python/core/PyObject;");
        }
        this.code.getstatic(this.mrefs.asserttype);
        if (node.msg != null) {
            this.visit(node.msg);
        } else {
            this.getNone();
        }
        if (this.mrefs.makeException2 == 0) {
            this.mrefs.makeException2 = this.code.pool.Methodref("org/python/core/Py", "makeException", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;)Lorg/python/core/PyException;");
        }
        this.code.invokestatic(this.mrefs.makeException2);
        this.code.athrow();
        end_of_assert.setPosition();
        return null;
    }

    public Object doTest(Label end_of_if, If node, int index) throws Exception {
        Label end_of_suite = this.code.getLabel();
        this.setline(node.test);
        this.visit(node.test);
        if (this.mrefs.nonzero == 0) {
            this.mrefs.nonzero = this.code.pool.Methodref("org/python/core/PyObject", "__nonzero__", "()Z");
        }
        this.code.invokevirtual(this.mrefs.nonzero);
        this.code.ifeq(end_of_suite);
        Object exit = this.suite(node.body);
        if (end_of_if != null && exit == null) {
            this.code.goto_(end_of_if);
        }
        end_of_suite.setPosition();
        if (node.orelse != null) {
            return this.suite(node.orelse) != null ? exit : null;
        }
        return null;
    }

    public Object visitIf(If node) throws Exception {
        Label end_of_if = null;
        if (node.orelse != null) {
            end_of_if = this.code.getLabel();
        }
        Object exit = this.doTest(end_of_if, node, 0);
        if (end_of_if != null) {
            end_of_if.setPosition();
        }
        return exit;
    }

    public int beginLoop() {
        this.continueLabels.push(this.code.getLabel());
        this.breakLabels.push(this.code.getLabel());
        int savebcf = this.bcfLevel;
        this.bcfLevel = this.exceptionHandlers.size();
        return savebcf;
    }

    public void finishLoop(int savebcf) {
        this.continueLabels.pop();
        this.breakLabels.pop();
        this.bcfLevel = savebcf;
    }

    public Object visitWhile(While node) throws Exception {
        int savebcf = this.beginLoop();
        Label continue_loop = (Label)this.continueLabels.peek();
        Label break_loop = (Label)this.breakLabels.peek();
        Label start_loop = this.code.getLabel();
        this.code.goto_(continue_loop);
        start_loop.setPosition();
        this.suite(node.body);
        continue_loop.setPosition();
        this.setline(node);
        this.visit(node.test);
        if (this.mrefs.nonzero == 0) {
            this.mrefs.nonzero = this.code.pool.Methodref("org/python/core/PyObject", "__nonzero__", "()Z");
        }
        this.code.invokevirtual(this.mrefs.nonzero);
        this.code.ifne(start_loop);
        this.finishLoop(savebcf);
        if (node.orelse != null) {
            this.suite(node.orelse);
        }
        break_loop.setPosition();
        return null;
    }

    public Object visitFor(For node) throws Exception {
        int savebcf = this.beginLoop();
        Label continue_loop = (Label)this.continueLabels.peek();
        Label break_loop = (Label)this.breakLabels.peek();
        Label start_loop = this.code.getLabel();
        Label next_loop = this.code.getLabel();
        int iter_tmp = this.code.getLocal("org/python/core/PyObject");
        int expr_tmp = this.code.getLocal("org/python/core/PyObject");
        this.setline(node);
        this.visit(node.iter);
        if (this.mrefs.iter == 0) {
            this.mrefs.iter = this.code.pool.Methodref("org/python/core/PyObject", "__iter__", "()Lorg/python/core/PyObject;");
        }
        this.code.invokevirtual(this.mrefs.iter);
        this.code.astore(iter_tmp);
        this.code.goto_(next_loop);
        start_loop.setPosition();
        this.set(node.target, expr_tmp);
        this.suite(node.body);
        continue_loop.setPosition();
        next_loop.setPosition();
        this.setline(node);
        this.code.aload(iter_tmp);
        if (this.mrefs.iternext == 0) {
            this.mrefs.iternext = this.code.pool.Methodref("org/python/core/PyObject", "__iternext__", "()Lorg/python/core/PyObject;");
        }
        this.code.invokevirtual(this.mrefs.iternext);
        this.code.astore(expr_tmp);
        this.code.aload(expr_tmp);
        this.code.ifnonnull(start_loop);
        this.finishLoop(savebcf);
        if (node.orelse != null) {
            this.suite(node.orelse);
        }
        break_loop.setPosition();
        this.code.freeLocal(iter_tmp);
        this.code.freeLocal(expr_tmp);
        return null;
    }

    public void exceptionTest(int exc, Label end_of_exceptions, TryExcept node, int index) throws Exception {
        for (int i = 0; i < node.handlers.length; ++i) {
            excepthandlerType handler = node.handlers[i];
            Label end_of_self = this.code.getLabel();
            if (handler.type != null) {
                this.code.aload(exc);
                this.visit(handler.type);
                if (this.mrefs.match_exception == 0) {
                    this.mrefs.match_exception = this.code.pool.Methodref("org/python/core/Py", "matchException", "(Lorg/python/core/PyException;Lorg/python/core/PyObject;)Z");
                }
                this.code.invokestatic(this.mrefs.match_exception);
                this.code.ifeq(end_of_self);
            } else if (i != node.handlers.length - 1) {
                throw new ParseException("bare except must be last except clause", handler.type);
            }
            if (handler.name != null) {
                this.code.aload(exc);
                this.code.getfield(this.code.pool.Fieldref("org/python/core/PyException", "value", "Lorg/python/core/PyObject;"));
                this.set(handler.name);
            }
            this.suite(handler.body);
            this.code.goto_(end_of_exceptions);
            end_of_self.setPosition();
        }
        this.code.aload(exc);
        this.code.athrow();
    }

    public Object visitTryFinally(TryFinally node) throws Exception {
        Label start = this.code.getLabel();
        Label end = this.code.getLabel();
        Label handlerStart = this.code.getLabel();
        Label finallyEnd = this.code.getLabel();
        ExceptionHandler inFinally = new ExceptionHandler(node);
        this.exceptionHandlers.push(inFinally);
        int excLocal = this.code.getLocal("java/lang/Throwable");
        this.code.aconst_null();
        this.code.astore(excLocal);
        start.setPosition();
        inFinally.exceptionStarts.addElement(start);
        Object ret = this.suite(node.body);
        end.setPosition();
        inFinally.exceptionEnds.addElement(end);
        inFinally.bodyDone = true;
        this.exceptionHandlers.pop();
        if (ret == NoExit) {
            this.inlineFinally(inFinally);
            this.code.goto_(finallyEnd);
        }
        handlerStart.setPosition();
        this.code.stack = 1;
        this.code.astore(excLocal);
        this.code.aload(excLocal);
        this.loadFrame();
        if (this.mrefs.add_traceback == 0) {
            this.mrefs.add_traceback = this.code.pool.Methodref("org/python/core/Py", "addTraceback", "(Ljava/lang/Throwable;Lorg/python/core/PyFrame;)V");
        }
        this.code.invokestatic(this.mrefs.add_traceback);
        this.inlineFinally(inFinally);
        this.code.aload(excLocal);
        this.code.checkcast(this.code.pool.Class("java/lang/Throwable"));
        this.code.athrow();
        finallyEnd.setPosition();
        this.code.freeLocal(excLocal);
        inFinally.addExceptionHandlers(handlerStart);
        return null;
    }

    private void inlineFinally(ExceptionHandler handler) throws Exception {
        if (!handler.bodyDone) {
            handler.exceptionEnds.addElement(this.code.getLabelAtPosition());
        }
        if (handler.isFinallyHandler()) {
            this.suite(handler.node.finalbody);
        }
    }

    private void reenterProtectedBody(ExceptionHandler handler) throws Exception {
        handler.exceptionStarts.addElement(this.code.getLabelAtPosition());
    }

    private void doFinallysDownTo(int level) throws Exception {
        ExceptionHandler handler;
        Stack<ExceptionHandler> poppedHandlers = new Stack<ExceptionHandler>();
        while (this.exceptionHandlers.size() > level) {
            handler = (ExceptionHandler)this.exceptionHandlers.pop();
            this.inlineFinally(handler);
            poppedHandlers.push(handler);
        }
        while (poppedHandlers.size() > 0) {
            handler = (ExceptionHandler)poppedHandlers.pop();
            this.reenterProtectedBody(handler);
            this.exceptionHandlers.push(handler);
        }
    }

    public Object visitTryExcept(TryExcept node) throws Exception {
        Label start = this.code.getLabel();
        Label end = this.code.getLabel();
        Label handler_start = this.code.getLabel();
        Label handler_end = this.code.getLabel();
        ExceptionHandler handler = new ExceptionHandler();
        start.setPosition();
        handler.exceptionStarts.addElement(start);
        this.exceptionHandlers.push(handler);
        Object exit = this.suite(node.body);
        this.exceptionHandlers.pop();
        end.setPosition();
        handler.exceptionEnds.addElement(end);
        if (exit == null) {
            this.code.goto_(handler_end);
        }
        handler_start.setPosition();
        this.code.stack = 1;
        this.loadFrame();
        if (this.mrefs.set_exception == 0) {
            this.mrefs.set_exception = this.code.pool.Methodref("org/python/core/Py", "setException", "(Ljava/lang/Throwable;Lorg/python/core/PyFrame;)Lorg/python/core/PyException;");
        }
        this.code.invokestatic(this.mrefs.set_exception);
        int exc = this.code.getFinallyLocal("java/lang/Throwable");
        this.code.astore(exc);
        if (node.orelse == null) {
            this.exceptionTest(exc, handler_end, node, 1);
            handler_end.setPosition();
        } else {
            Label else_end = this.code.getLabel();
            this.exceptionTest(exc, else_end, node, 1);
            handler_end.setPosition();
            this.suite(node.orelse);
            else_end.setPosition();
        }
        this.code.freeFinallyLocal(exc);
        handler.addExceptionHandlers(handler_start);
        return null;
    }

    public Object visitSuite(Suite node) throws Exception {
        return this.suite(node.body);
    }

    public Object suite(stmtType[] stmts) throws Exception {
        int n = stmts.length;
        for (int i = 0; i < n; ++i) {
            Object exit = this.visit(stmts[i]);
            if (exit == null) continue;
            return Exit;
        }
        return null;
    }

    public Object visitBoolOp(BoolOp node) throws Exception {
        Label end = this.code.getLabel();
        this.visit(node.values[0]);
        for (int i = 1; i < node.values.length; ++i) {
            this.code.dup();
            if (this.mrefs.nonzero == 0) {
                this.mrefs.nonzero = this.code.pool.Methodref("org/python/core/PyObject", "__nonzero__", "()Z");
            }
            this.code.invokevirtual(this.mrefs.nonzero);
            switch (node.op) {
                case 2: {
                    this.code.ifne(end);
                    break;
                }
                case 1: {
                    this.code.ifeq(end);
                }
            }
            this.code.pop();
            this.visit(node.values[i]);
        }
        end.setPosition();
        return null;
    }

    public Object visitCompare(Compare node) throws Exception {
        int tmp1 = this.code.getLocal("org/python/core/PyObject");
        int tmp2 = this.code.getLocal("org/python/core/PyObject");
        if (this.mrefs.nonzero == 0) {
            this.mrefs.nonzero = this.code.pool.Methodref("org/python/core/PyObject", "__nonzero__", "()Z");
        }
        Label end = this.code.getLabel();
        this.visit(node.left);
        int n = node.ops.length;
        for (int i = 0; i < n - 1; ++i) {
            this.visit(node.comparators[i]);
            this.code.dup();
            this.code.astore(tmp1);
            this.code.invokevirtual(this.make_cmpop(node.ops[i]));
            this.code.dup();
            this.code.astore(tmp2);
            this.code.invokevirtual(this.mrefs.nonzero);
            this.code.ifeq(end);
            this.code.aload(tmp1);
        }
        this.visit(node.comparators[n - 1]);
        this.code.invokevirtual(this.make_cmpop(node.ops[n - 1]));
        if (n > 1) {
            this.code.astore(tmp2);
            end.setPosition();
            this.code.aload(tmp2);
        }
        this.code.freeLocal(tmp1);
        this.code.freeLocal(tmp2);
        return null;
    }

    public int make_cmpop(int op) throws Exception {
        if (this.compare_ops[op] == 0) {
            String name = null;
            switch (op) {
                case 1: {
                    name = "_eq";
                    break;
                }
                case 2: {
                    name = "_ne";
                    break;
                }
                case 3: {
                    name = "_lt";
                    break;
                }
                case 4: {
                    name = "_le";
                    break;
                }
                case 5: {
                    name = "_gt";
                    break;
                }
                case 6: {
                    name = "_ge";
                    break;
                }
                case 7: {
                    name = "_is";
                    break;
                }
                case 8: {
                    name = "_isnot";
                    break;
                }
                case 9: {
                    name = "_in";
                    break;
                }
                case 10: {
                    name = "_notin";
                }
            }
            this.compare_ops[op] = this.code.pool.Methodref("org/python/core/PyObject", name, "(Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
        }
        return this.compare_ops[op];
    }

    public int make_binop(int op) throws Exception {
        if (this.bin_ops[op] == 0) {
            String name = bin_methods[op];
            if (op == 4 && this.module.getFutures().areDivisionOn()) {
                name = "_truediv";
            }
            this.bin_ops[op] = this.code.pool.Methodref("org/python/core/PyObject", name, "(Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
        }
        return this.bin_ops[op];
    }

    public Object visitBinOp(BinOp node) throws Exception {
        this.visit(node.left);
        this.visit(node.right);
        this.code.invokevirtual(this.make_binop(node.op));
        return null;
    }

    public int make_unaryop(int op) throws Exception {
        if (this.unary_ops[op] == 0) {
            String name = unary_methods[op];
            this.unary_ops[op] = this.code.pool.Methodref("org/python/core/PyObject", name, "()Lorg/python/core/PyObject;");
        }
        return this.unary_ops[op];
    }

    public Object visitUnaryOp(UnaryOp node) throws Exception {
        this.visit(node.operand);
        this.code.invokevirtual(this.make_unaryop(node.op));
        return null;
    }

    public int make_augbinop(int op) throws Exception {
        if (this.augbin_ops[op] == 0) {
            String name = aug_methods[op];
            if (op == 4 && this.module.getFutures().areDivisionOn()) {
                name = "__itruediv__";
            }
            this.augbin_ops[op] = this.code.pool.Methodref("org/python/core/PyObject", name, "(Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
        }
        return this.augbin_ops[op];
    }

    public Object visitAugAssign(AugAssign node) throws Exception {
        this.visit(node.value);
        int tmp = this.storeTop();
        this.augmode = 1;
        this.visit(node.target);
        this.code.aload(tmp);
        this.code.invokevirtual(this.make_augbinop(node.op));
        this.code.freeLocal(tmp);
        this.temporary = this.storeTop();
        this.augmode = 2;
        this.visit(node.target);
        this.code.freeLocal(this.temporary);
        return null;
    }

    public static void makeStrings(Code c, String[] names, int n) throws IOException {
        c.iconst(n);
        c.anewarray(c.pool.Class("java/lang/String"));
        int strings = c.getLocal("[java/lang/String");
        c.astore(strings);
        for (int i = 0; i < n; ++i) {
            c.aload(strings);
            c.iconst(i);
            c.ldc(names[i]);
            c.aastore();
        }
        c.aload(strings);
        c.freeLocal(strings);
    }

    public Object Invoke(Attribute node, SimpleNode[] values) throws Exception {
        String name = this.getName(node.attr);
        this.visit(node.value);
        this.code.ldc(name);
        switch (values.length) {
            case 0: {
                if (this.mrefs.invokea0 == 0) {
                    this.mrefs.invokea0 = this.code.pool.Methodref("org/python/core/PyObject", "invoke", "(Ljava/lang/String;)Lorg/python/core/PyObject;");
                }
                this.code.invokevirtual(this.mrefs.invokea0);
                break;
            }
            case 1: {
                if (this.mrefs.invokea1 == 0) {
                    this.mrefs.invokea1 = this.code.pool.Methodref("org/python/core/PyObject", "invoke", "(Ljava/lang/String;Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
                }
                this.visit(values[0]);
                this.code.invokevirtual(this.mrefs.invokea1);
                break;
            }
            case 2: {
                if (this.mrefs.invokea2 == 0) {
                    this.mrefs.invokea2 = this.code.pool.Methodref("org/python/core/PyObject", "invoke", "(Ljava/lang/String;Lorg/python/core/PyObject;Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
                }
                this.visit(values[0]);
                this.visit(values[1]);
                this.code.invokevirtual(this.mrefs.invokea2);
                break;
            }
            default: {
                this.makeArray(values);
                if (this.mrefs.invoke2 == 0) {
                    this.mrefs.invoke2 = this.code.pool.Methodref("org/python/core/PyObject", "invoke", "(Ljava/lang/String;[Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
                }
                this.code.invokevirtual(this.mrefs.invoke2);
            }
        }
        return null;
    }

    public Object visitCall(Call node) throws Exception {
        int i;
        String[] keys = new String[node.keywords.length];
        SimpleNode[] values = new exprType[node.args.length + keys.length];
        for (i = 0; i < node.args.length; ++i) {
            values[i] = node.args[i];
        }
        for (i = 0; i < node.keywords.length; ++i) {
            keys[i] = node.keywords[i].arg;
            values[node.args.length + i] = node.keywords[i].value;
        }
        if ((node.keywords == null || node.keywords.length == 0) && node.starargs == null && node.kwargs == null && node.func instanceof Attribute) {
            return this.Invoke((Attribute)node.func, values);
        }
        this.visit(node.func);
        if (node.starargs != null || node.kwargs != null) {
            this.makeArray(values);
            CodeCompiler.makeStrings(this.code, keys, keys.length);
            if (node.starargs == null) {
                this.code.aconst_null();
            } else {
                this.visit(node.starargs);
            }
            if (node.kwargs == null) {
                this.code.aconst_null();
            } else {
                this.visit(node.kwargs);
            }
            if (this.mrefs.callextra == 0) {
                this.mrefs.callextra = this.code.pool.Methodref("org/python/core/PyObject", "_callextra", "([Lorg/python/core/PyObject;[Ljava/lang/String;Lorg/python/core/PyObject;Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
            }
            this.code.invokevirtual(this.mrefs.callextra);
        } else if (keys.length > 0) {
            this.makeArray(values);
            CodeCompiler.makeStrings(this.code, keys, keys.length);
            if (this.mrefs.call1 == 0) {
                this.mrefs.call1 = this.code.pool.Methodref("org/python/core/PyObject", "__call__", "([Lorg/python/core/PyObject;[Ljava/lang/String;)Lorg/python/core/PyObject;");
            }
            this.code.invokevirtual(this.mrefs.call1);
        } else {
            switch (values.length) {
                case 0: {
                    if (this.mrefs.calla0 == 0) {
                        this.mrefs.calla0 = this.code.pool.Methodref("org/python/core/PyObject", "__call__", "()Lorg/python/core/PyObject;");
                    }
                    this.code.invokevirtual(this.mrefs.calla0);
                    break;
                }
                case 1: {
                    if (this.mrefs.calla1 == 0) {
                        this.mrefs.calla1 = this.code.pool.Methodref("org/python/core/PyObject", "__call__", "(Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
                    }
                    this.visit(values[0]);
                    this.code.invokevirtual(this.mrefs.calla1);
                    break;
                }
                case 2: {
                    if (this.mrefs.calla2 == 0) {
                        this.mrefs.calla2 = this.code.pool.Methodref("org/python/core/PyObject", "__call__", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
                    }
                    this.visit(values[0]);
                    this.visit(values[1]);
                    this.code.invokevirtual(this.mrefs.calla2);
                    break;
                }
                case 3: {
                    if (this.mrefs.calla3 == 0) {
                        this.mrefs.calla3 = this.code.pool.Methodref("org/python/core/PyObject", "__call__", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
                    }
                    this.visit(values[0]);
                    this.visit(values[1]);
                    this.visit(values[2]);
                    this.code.invokevirtual(this.mrefs.calla3);
                    break;
                }
                case 4: {
                    if (this.mrefs.calla4 == 0) {
                        this.mrefs.calla4 = this.code.pool.Methodref("org/python/core/PyObject", "__call__", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
                    }
                    this.visit(values[0]);
                    this.visit(values[1]);
                    this.visit(values[2]);
                    this.visit(values[3]);
                    this.code.invokevirtual(this.mrefs.calla4);
                    break;
                }
                default: {
                    this.makeArray(values);
                    if (this.mrefs.call2 == 0) {
                        this.mrefs.call2 = this.code.pool.Methodref("org/python/core/PyObject", "__call__", "([Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
                    }
                    this.code.invokevirtual(this.mrefs.call2);
                }
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public Object Slice(Subscript node, Slice slice) throws Exception {
        ctx = node.ctx;
        if (ctx != 5) ** GOTO lbl-1000
        if (this.augmode == 2) {
            this.restoreAugTmps(node, 4);
            ctx = 2;
        } else lbl-1000:
        // 2 sources

        {
            this.visit(node.value);
            if (slice.lower != null) {
                this.visit(slice.lower);
            } else {
                this.code.aconst_null();
            }
            if (slice.upper != null) {
                this.visit(slice.upper);
            } else {
                this.code.aconst_null();
            }
            if (slice.step != null) {
                this.visit(slice.step);
            } else {
                this.code.aconst_null();
            }
            if (node.ctx == 5) {
                if (this.augmode == 1) {
                    this.saveAugTmps(node, 4);
                    ctx = 1;
                }
            }
        }
        switch (ctx) {
            case 3: {
                if (this.mrefs.delslice == 0) {
                    this.mrefs.delslice = this.code.pool.Methodref("org/python/core/PyObject", "__delslice__", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;)V");
                }
                this.code.invokevirtual(this.mrefs.delslice);
                return null;
            }
            case 1: {
                if (this.mrefs.getslice == 0) {
                    this.mrefs.getslice = this.code.pool.Methodref("org/python/core/PyObject", "__getslice__", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
                }
                this.code.invokevirtual(this.mrefs.getslice);
                return null;
            }
            case 2: {
                this.code.aload(this.temporary);
                if (this.mrefs.setslice == 0) {
                    this.mrefs.setslice = this.code.pool.Methodref("org/python/core/PyObject", "__setslice__", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;)V");
                }
                this.code.invokevirtual(this.mrefs.setslice);
                return null;
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public Object visitSubscript(Subscript node) throws Exception {
        if (node.slice instanceof Slice) {
            return this.Slice(node, (Slice)node.slice);
        }
        ctx = node.ctx;
        if (node.ctx != 5) ** GOTO lbl-1000
        if (this.augmode == 2) {
            this.restoreAugTmps(node, 2);
            ctx = 2;
        } else lbl-1000:
        // 2 sources

        {
            this.visit(node.value);
            this.visit(node.slice);
            if (node.ctx == 5) {
                if (this.augmode == 1) {
                    this.saveAugTmps(node, 2);
                    ctx = 1;
                }
            }
        }
        switch (ctx) {
            case 3: {
                if (this.mrefs.delitem == 0) {
                    this.mrefs.delitem = this.code.pool.Methodref("org/python/core/PyObject", "__delitem__", "(Lorg/python/core/PyObject;)V");
                }
                this.code.invokevirtual(this.mrefs.delitem);
                return null;
            }
            case 1: {
                if (this.mrefs.getitem == 0) {
                    this.mrefs.getitem = this.code.pool.Methodref("org/python/core/PyObject", "__getitem__", "(Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
                }
                this.code.invokevirtual(this.mrefs.getitem);
                return null;
            }
            case 2: {
                this.code.aload(this.temporary);
                if (this.mrefs.setitem == 0) {
                    this.mrefs.setitem = this.code.pool.Methodref("org/python/core/PyObject", "__setitem__", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;)V");
                }
                this.code.invokevirtual(this.mrefs.setitem);
                return null;
            }
        }
        return null;
    }

    public Object visitIndex(Index node) throws Exception {
        this.traverse(node);
        return null;
    }

    public Object visitExtSlice(ExtSlice node) throws Exception {
        this.code.new_(this.code.pool.Class("org/python/core/PyTuple"));
        this.code.dup();
        this.makeArray(node.dims);
        if (this.mrefs.PyTuple_init == 0) {
            this.mrefs.PyTuple_init = this.code.pool.Methodref("org/python/core/PyTuple", "<init>", "([Lorg/python/core/PyObject;)V");
        }
        this.code.invokespecial(this.mrefs.PyTuple_init);
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public Object visitAttribute(Attribute node) throws Exception {
        ctx = node.ctx;
        if (node.ctx != 5) ** GOTO lbl-1000
        if (this.augmode == 2) {
            this.restoreAugTmps(node, 2);
            ctx = 2;
        } else lbl-1000:
        // 2 sources

        {
            this.visit(node.value);
            this.code.ldc(this.getName(node.attr));
            if (node.ctx == 5) {
                if (this.augmode == 1) {
                    this.saveAugTmps(node, 2);
                    ctx = 1;
                }
            }
        }
        switch (ctx) {
            case 3: {
                if (this.mrefs.delattr == 0) {
                    this.mrefs.delattr = this.code.pool.Methodref("org/python/core/PyObject", "__delattr__", "(Ljava/lang/String;)V");
                }
                this.code.invokevirtual(this.mrefs.delattr);
                return null;
            }
            case 1: {
                if (this.mrefs.getattr == 0) {
                    this.mrefs.getattr = this.code.pool.Methodref("org/python/core/PyObject", "__getattr__", "(Ljava/lang/String;)Lorg/python/core/PyObject;");
                }
                this.code.invokevirtual(this.mrefs.getattr);
                return null;
            }
            case 2: {
                this.code.aload(this.temporary);
                if (this.mrefs.setattr == 0) {
                    this.mrefs.setattr = this.code.pool.Methodref("org/python/core/PyObject", "__setattr__", "(Ljava/lang/String;Lorg/python/core/PyObject;)V");
                }
                this.code.invokevirtual(this.mrefs.setattr);
                return null;
            }
        }
        return null;
    }

    public Object seqSet(exprType[] nodes) throws Exception {
        if (this.mrefs.unpackSequence == 0) {
            this.mrefs.unpackSequence = this.code.pool.Methodref("org/python/core/Py", "unpackSequence", "(Lorg/python/core/PyObject;I)[Lorg/python/core/PyObject;");
        }
        this.code.aload(this.temporary);
        this.code.iconst(nodes.length);
        this.code.invokestatic(this.mrefs.unpackSequence);
        int tmp = this.code.getLocal("[org/python/core/PyObject");
        this.code.astore(tmp);
        for (int i = 0; i < nodes.length; ++i) {
            this.code.aload(tmp);
            this.code.iconst(i);
            this.code.aaload();
            this.set(nodes[i]);
        }
        this.code.freeLocal(tmp);
        return null;
    }

    public Object seqDel(exprType[] nodes) throws Exception {
        for (int i = 0; i < nodes.length; ++i) {
            this.visit(nodes[i]);
        }
        return null;
    }

    public Object visitTuple(Tuple node) throws Exception {
        if (node.ctx == 2) {
            return this.seqSet(node.elts);
        }
        if (node.ctx == 3) {
            return this.seqDel(node.elts);
        }
        this.code.new_(this.code.pool.Class("org/python/core/PyTuple"));
        this.code.dup();
        this.makeArray(node.elts);
        if (this.mrefs.PyTuple_init == 0) {
            this.mrefs.PyTuple_init = this.code.pool.Methodref("org/python/core/PyTuple", "<init>", "([Lorg/python/core/PyObject;)V");
        }
        this.code.invokespecial(this.mrefs.PyTuple_init);
        return null;
    }

    public Object visitList(List node) throws Exception {
        if (node.ctx == 2) {
            return this.seqSet(node.elts);
        }
        if (node.ctx == 3) {
            return this.seqDel(node.elts);
        }
        this.code.new_(this.code.pool.Class("org/python/core/PyList"));
        this.code.dup();
        this.makeArray(node.elts);
        if (this.mrefs.PyList_init == 0) {
            this.mrefs.PyList_init = this.code.pool.Methodref("org/python/core/PyList", "<init>", "([Lorg/python/core/PyObject;)V");
        }
        this.code.invokespecial(this.mrefs.PyList_init);
        return null;
    }

    public Object visitListComp(ListComp node) throws Exception {
        this.code.new_(this.code.pool.Class("org/python/core/PyList"));
        this.code.dup();
        if (this.mrefs.PyList_init2 == 0) {
            this.mrefs.PyList_init2 = this.code.pool.Methodref("org/python/core/PyList", "<init>", "()V");
        }
        this.code.invokespecial(this.mrefs.PyList_init2);
        this.code.dup();
        this.code.ldc("append");
        if (this.mrefs.getattr == 0) {
            this.mrefs.getattr = this.code.pool.Methodref("org/python/core/PyObject", "__getattr__", "(Ljava/lang/String;)Lorg/python/core/PyObject;");
        }
        this.code.invokevirtual(this.mrefs.getattr);
        String tmp_append = "_[" + ++this.list_comprehension_count + "]";
        this.set(new Name(tmp_append, 2, node));
        stmtType n = new Expr(new Call(new Name(tmp_append, 1, node), new exprType[]{node.elt}, new keywordType[0], null, null, node), node);
        for (int i = node.generators.length - 1; i >= 0; --i) {
            listcompType lc = node.generators[i];
            for (int j = lc.ifs.length - 1; j >= 0; --j) {
                n = new If(lc.ifs[j], new stmtType[]{n}, null, lc.ifs[j]);
            }
            n = new For(lc.target, lc.iter, new stmtType[]{n}, null, lc);
        }
        this.visit(n);
        this.visit(new Delete(new exprType[]{new Name(tmp_append, 3)}));
        return null;
    }

    public Object visitDict(Dict node) throws Exception {
        this.code.new_(this.code.pool.Class("org/python/core/PyDictionary"));
        this.code.dup();
        SimpleNode[] elts = new SimpleNode[node.keys.length * 2];
        for (int i = 0; i < node.keys.length; ++i) {
            elts[i * 2] = node.keys[i];
            elts[i * 2 + 1] = node.values[i];
        }
        this.makeArray(elts);
        if (this.mrefs.PyDictionary_init == 0) {
            this.mrefs.PyDictionary_init = this.code.pool.Methodref("org/python/core/PyDictionary", "<init>", "([Lorg/python/core/PyObject;)V");
        }
        this.code.invokespecial(this.mrefs.PyDictionary_init);
        return null;
    }

    public Object visitRepr(Repr node) throws Exception {
        this.visit(node.value);
        this.code.invokevirtual("org/python/core/PyObject", "__repr__", "()Lorg/python/core/PyString;");
        return null;
    }

    public Object visitLambda(Lambda node) throws Exception {
        String name = "<lambda>";
        Suite retSuite = new Suite(new stmtType[]{new Return(node.body, node)}, node);
        this.setline(node);
        this.code.new_(this.code.pool.Class("org/python/core/PyFunction"));
        this.code.dup();
        this.loadFrame();
        if (this.mrefs.f_globals == 0) {
            this.mrefs.f_globals = this.code.pool.Fieldref("org/python/core/PyFrame", "f_globals", "Lorg/python/core/PyObject;");
        }
        this.code.getfield(this.mrefs.f_globals);
        ScopeInfo scope = this.module.getScopeInfo(node);
        this.makeArray(scope.ac.getDefaults());
        scope.setup_closure();
        scope.dump();
        this.module.PyCode(retSuite, name, true, this.className, false, false, node.beginLine, scope, this.cflags).get(this.code);
        if (!this.makeClosure(scope)) {
            if (this.mrefs.PyFunction_init1 == 0) {
                this.mrefs.PyFunction_init1 = this.code.pool.Methodref("org/python/core/PyFunction", "<init>", "(Lorg/python/core/PyObject;[Lorg/python/core/PyObject;Lorg/python/core/PyCode;)V");
            }
            this.code.invokespecial(this.mrefs.PyFunction_init1);
        } else {
            if (this.mrefs.PyFunction_closure_init1 == 0) {
                this.mrefs.PyFunction_closure_init1 = this.code.pool.Methodref("org/python/core/PyFunction", "<init>", "(Lorg/python/core/PyObject;[Lorg/python/core/PyObject;Lorg/python/core/PyCode;[Lorg/python/core/PyObject;)V");
            }
            this.code.invokespecial(this.mrefs.PyFunction_closure_init1);
        }
        return null;
    }

    public Object visitEllipsis(Ellipsis node) throws Exception {
        if (this.mrefs.Ellipsis == 0) {
            this.mrefs.Ellipsis = this.code.pool.Fieldref("org/python/core/Py", "Ellipsis", "Lorg/python/core/PyObject;");
        }
        this.code.getstatic(this.mrefs.Ellipsis);
        return null;
    }

    public Object visitSlice(Slice node) throws Exception {
        this.code.new_(this.code.pool.Class("org/python/core/PySlice"));
        this.code.dup();
        if (node.lower == null) {
            this.getNone();
        } else {
            this.visit(node.lower);
        }
        if (node.upper == null) {
            this.getNone();
        } else {
            this.visit(node.upper);
        }
        if (node.step == null) {
            this.getNone();
        } else {
            this.visit(node.step);
        }
        if (this.mrefs.PySlice_init == 0) {
            this.mrefs.PySlice_init = this.code.pool.Methodref("org/python/core/PySlice", "<init>", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;)V");
        }
        this.code.invokespecial(this.mrefs.PySlice_init);
        return null;
    }

    public Object visitClassDef(ClassDef node) throws Exception {
        this.setline(node);
        String name = this.getName(node.name);
        this.code.ldc(name);
        this.makeArray(node.bases);
        ScopeInfo scope = this.module.getScopeInfo(node);
        scope.setup_closure();
        scope.dump();
        this.module.PyCode(new Suite(node.body, node), name, false, name, true, false, node.beginLine, scope, this.cflags).get(this.code);
        this.getDocString(node.body);
        if (!this.makeClosure(scope)) {
            if (this.mrefs.makeClass == 0) {
                this.mrefs.makeClass = this.code.pool.Methodref("org/python/core/Py", "makeClass", "(Ljava/lang/String;[Lorg/python/core/PyObject;Lorg/python/core/PyCode;Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
            }
            this.code.invokestatic(this.mrefs.makeClass);
        } else {
            if (this.mrefs.makeClass_closure == 0) {
                this.mrefs.makeClass_closure = this.code.pool.Methodref("org/python/core/Py", "makeClass", "(Ljava/lang/String;[Lorg/python/core/PyObject;Lorg/python/core/PyCode;Lorg/python/core/PyObject;[Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
            }
            this.code.invokestatic(this.mrefs.makeClass_closure);
        }
        this.set(new Name(node.name, 2, node));
        return null;
    }

    public Object visitNum(Num node) throws Exception {
        if (node.n instanceof PyInteger) {
            this.module.PyInteger(((PyInteger)node.n).getValue()).get(this.code);
        } else if (node.n instanceof PyLong) {
            this.module.PyLong(((PyObject)node.n).__str__().toString()).get(this.code);
        } else if (node.n instanceof PyFloat) {
            this.module.PyFloat(((PyFloat)node.n).getValue()).get(this.code);
        } else if (node.n instanceof PyComplex) {
            this.module.PyComplex(((PyComplex)node.n).imag).get(this.code);
        }
        return null;
    }

    private String getName(String name) {
        if (this.className != null && name.startsWith("__") && !name.endsWith("__")) {
            int i = 0;
            while (this.className.charAt(i) == '_') {
                ++i;
            }
            return "_" + this.className.substring(i) + name;
        }
        return name;
    }

    void emitGetGlobal(String name) throws Exception {
        this.code.ldc(name);
        if (this.mrefs.getglobal == 0) {
            this.mrefs.getglobal = this.code.pool.Methodref("org/python/core/PyFrame", "getglobal", "(Ljava/lang/String;)Lorg/python/core/PyObject;");
        }
        this.code.invokevirtual(this.mrefs.getglobal);
    }

    public Object visitName(Name node) throws Exception {
        String name = this.fast_locals ? node.id : this.getName(node.id);
        SymInfo syminf = (SymInfo)this.tbl.get(name);
        int ctx = node.ctx;
        if (ctx == 5) {
            ctx = this.augmode;
        }
        switch (ctx) {
            case 1: {
                this.loadFrame();
                if (syminf != null) {
                    int flags = syminf.flags;
                    if ((flags & 0x42) != 0 || this.optimizeGlobals && (flags & 0x31) == 0) {
                        this.emitGetGlobal(name);
                        return null;
                    }
                    if (this.fast_locals) {
                        if ((flags & 0x10) != 0) {
                            this.code.iconst(syminf.env_index);
                            if (this.mrefs.getderef == 0) {
                                this.mrefs.getderef = this.code.pool.Methodref("org/python/core/PyFrame", "getderef", "(I)Lorg/python/core/PyObject;");
                            }
                            this.code.invokevirtual(this.mrefs.getderef);
                            return null;
                        }
                        if ((flags & 1) != 0) {
                            this.code.iconst(syminf.locals_index);
                            if (this.mrefs.getlocal2 == 0) {
                                this.mrefs.getlocal2 = this.code.pool.Methodref("org/python/core/PyFrame", "getlocal", "(I)Lorg/python/core/PyObject;");
                            }
                            this.code.invokevirtual(this.mrefs.getlocal2);
                            return null;
                        }
                    }
                    if ((flags & 0x20) != 0 && (flags & 1) == 0) {
                        this.code.iconst(syminf.env_index);
                        if (this.mrefs.getderef == 0) {
                            this.mrefs.getderef = this.code.pool.Methodref("org/python/core/PyFrame", "getderef", "(I)Lorg/python/core/PyObject;");
                        }
                        this.code.invokevirtual(this.mrefs.getderef);
                        return null;
                    }
                }
                this.code.ldc(name);
                if (this.mrefs.getlocal1 == 0) {
                    this.mrefs.getlocal1 = this.code.pool.Methodref("org/python/core/PyFrame", "getname", "(Ljava/lang/String;)Lorg/python/core/PyObject;");
                }
                this.code.invokevirtual(this.mrefs.getlocal1);
                return null;
            }
            case 2: {
                this.loadFrame();
                if (syminf != null && (syminf.flags & 0x42) != 0) {
                    this.code.ldc(name);
                    this.code.aload(this.temporary);
                    if (this.mrefs.setglobal == 0) {
                        this.mrefs.setglobal = this.code.pool.Methodref("org/python/core/PyFrame", "setglobal", "(Ljava/lang/String;Lorg/python/core/PyObject;)V");
                    }
                    this.code.invokevirtual(this.mrefs.setglobal);
                } else if (!this.fast_locals) {
                    this.code.ldc(name);
                    this.code.aload(this.temporary);
                    if (this.mrefs.setlocal1 == 0) {
                        this.mrefs.setlocal1 = this.code.pool.Methodref("org/python/core/PyFrame", "setlocal", "(Ljava/lang/String;Lorg/python/core/PyObject;)V");
                    }
                    this.code.invokevirtual(this.mrefs.setlocal1);
                } else {
                    if (syminf == null) {
                        System.err.println("internal compiler error: " + node);
                    }
                    if ((syminf.flags & 0x10) != 0) {
                        this.code.iconst(syminf.env_index);
                        this.code.aload(this.temporary);
                        if (this.mrefs.setderef == 0) {
                            this.mrefs.setderef = this.code.pool.Methodref("org/python/core/PyFrame", "setderef", "(ILorg/python/core/PyObject;)V");
                        }
                        this.code.invokevirtual(this.mrefs.setderef);
                    } else {
                        this.code.iconst(syminf.locals_index);
                        this.code.aload(this.temporary);
                        if (this.mrefs.setlocal2 == 0) {
                            this.mrefs.setlocal2 = this.code.pool.Methodref("org/python/core/PyFrame", "setlocal", "(ILorg/python/core/PyObject;)V");
                        }
                        this.code.invokevirtual(this.mrefs.setlocal2);
                    }
                }
                return null;
            }
            case 3: {
                this.loadFrame();
                if (syminf != null && (syminf.flags & 0x42) != 0) {
                    this.code.ldc(name);
                    if (this.mrefs.delglobal == 0) {
                        this.mrefs.delglobal = this.code.pool.Methodref("org/python/core/PyFrame", "delglobal", "(Ljava/lang/String;)V");
                    }
                    this.code.invokevirtual(this.mrefs.delglobal);
                } else if (!this.fast_locals) {
                    this.code.ldc(name);
                    if (this.mrefs.dellocal1 == 0) {
                        this.mrefs.dellocal1 = this.code.pool.Methodref("org/python/core/PyFrame", "dellocal", "(Ljava/lang/String;)V");
                    }
                    this.code.invokevirtual(this.mrefs.dellocal1);
                } else {
                    if (syminf == null) {
                        System.err.println("internal compiler error: " + node);
                    }
                    if ((syminf.flags & 0x10) != 0) {
                        this.module.error("can not delete variable '" + name + "' referenced in nested scope", true, node);
                    }
                    this.code.iconst(syminf.locals_index);
                    if (this.mrefs.dellocal2 == 0) {
                        this.mrefs.dellocal2 = this.code.pool.Methodref("org/python/core/PyFrame", "dellocal", "(I)V");
                    }
                    this.code.invokevirtual(this.mrefs.dellocal2);
                }
                return null;
            }
        }
        return null;
    }

    public Object visitUnicode(Unicode node) throws Exception {
        String s = node.s;
        if (s.length() > Short.MAX_VALUE) {
            throw new ParseException("string constant too large (more than 32767 characters)", node);
        }
        this.module.PyUnicode(s).get(this.code);
        return null;
    }

    public Object visitStr(Str node) throws Exception {
        String s = node.s;
        if (s.length() > Short.MAX_VALUE) {
            throw new ParseException("string constant too large (more than 32767 characters)", node);
        }
        this.module.PyString(s).get(this.code);
        return null;
    }

    protected Object unhandled_node(SimpleNode node) throws Exception {
        throw new Exception("Unhandled node " + node);
    }

    class ExceptionHandler {
        public Vector exceptionStarts = new Vector();
        public Vector exceptionEnds = new Vector();
        public boolean bodyDone = false;
        public TryFinally node = null;

        public ExceptionHandler() {
        }

        public ExceptionHandler(TryFinally n) {
            this.node = n;
        }

        public boolean isFinallyHandler() {
            return this.node != null;
        }

        public void addExceptionHandlers(Label handlerStart) throws Exception {
            int throwable = CodeCompiler.this.code.pool.Class("java/lang/Throwable");
            for (int i = 0; i < this.exceptionStarts.size(); ++i) {
                Label start = (Label)this.exceptionStarts.elementAt(i);
                Label end = (Label)this.exceptionEnds.elementAt(i);
                if (start.getPosition() == end.getPosition()) continue;
                CodeCompiler.this.code.addExceptionHandler((Label)this.exceptionStarts.elementAt(i), (Label)this.exceptionEnds.elementAt(i), handlerStart, throwable);
            }
        }
    }
}

