/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.properties;

import com.install4j.runtime.beans.actions.properties.LineSeparator;
import com.install4j.runtime.beans.actions.properties.PropertiesFileEncoding;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.jetbrains.annotations.NotNull;

public class PropertiesFileParameters {
    private PropertiesFileEncoding encoding;
    private Charset charset;
    private LineSeparator detectedLineSeparator = null;

    public PropertiesFileParameters(PropertiesFileEncoding encoding) {
        this(encoding, null);
    }

    public PropertiesFileParameters(PropertiesFileEncoding encoding, String charsetName) {
        this.encoding = encoding;
        charsetName = encoding.getCharsetName(charsetName);
        this.charset = Charset.forName(charsetName);
    }

    public Charset getCharset() {
        return this.charset;
    }

    public LineSeparator getDetectedLineSeparator() {
        return this.detectedLineSeparator;
    }

    public BufferedReader createReader(InputStream inputStream) throws UnsupportedEncodingException {
        return new BufferedReader(new InputStreamReader(inputStream, this.getCharset()){
            boolean r;
            {
                this.r = false;
            }

            @Override
            public int read(@NotNull char[] cbuf, int offset, int length) throws IOException {
                int read = super.read(cbuf, offset, length);
                if (PropertiesFileParameters.this.detectedLineSeparator == null) {
                    for (int i = 0; i < read; ++i) {
                        char c = cbuf[offset + i];
                        if (c == '\r') {
                            this.r = true;
                            continue;
                        }
                        if (c == '\n') {
                            if (this.r) {
                                PropertiesFileParameters.this.detectedLineSeparator = LineSeparator.WINDOWS;
                                break;
                            }
                            PropertiesFileParameters.this.detectedLineSeparator = LineSeparator.UNIX;
                            break;
                        }
                        this.r = false;
                    }
                }
                return read;
            }
        });
    }

    public CharsetEncoder createEncoderForEscapingCheck() {
        if (this.encoding == PropertiesFileEncoding.JAVA_PROPERTIES) {
            return null;
        }
        return this.charset.newEncoder();
    }
}

