/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.properties;

import com.install4j.runtime.beans.actions.properties.PropertiesFileEncoding;
import com.install4j.runtime.beans.actions.properties.PropertiesFileHelper;
import com.install4j.runtime.beans.actions.properties.PropertiesFileParameters;
import com.install4j.runtime.beans.actions.properties.PropertiesWriteParameters;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.CharsetEncoder;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class TextProperties
extends LinkedHashMap<String, String> {
    private String header;
    private Map<String, String> prefixes = new HashMap<String, String>();

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public Map<String, String> getPrefixes() {
        return this.prefixes;
    }

    public String getPrefix(String key) {
        return this.prefixes.get(key);
    }

    public void setPrefix(String key, String prefix) {
        if (prefix != null) {
            this.prefixes.put(key, prefix);
        } else {
            this.prefixes.remove(key);
        }
    }

    public void write(File file, PropertiesWriteParameters propertiesWriteParameters) throws IOException {
        this.write(new FileOutputStream(file), propertiesWriteParameters);
    }

    public void write(OutputStream outputStream, PropertiesWriteParameters propertiesWriteParameters) throws IOException {
        BufferedWriter writer = propertiesWriteParameters.createWriter(outputStream);
        this.write(writer, propertiesWriteParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Writer writer, PropertiesWriteParameters propertiesWriteParameters) throws IOException {
        BufferedWriter bufferedWriter = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
        CharsetEncoder encoder = propertiesWriteParameters.createEncoderForEscapingCheck();
        if (this.header != null) {
            PropertiesFileHelper.writeComments(this.header, bufferedWriter, encoder);
        }
        try {
            for (Map.Entry entry : this.entrySet()) {
                String rawKey = (String)entry.getKey();
                String key = PropertiesFileHelper.escapeForPropertyFile(rawKey, true, encoder, false);
                String value = PropertiesFileHelper.escapeForPropertyFile((String)entry.getValue(), false, encoder, false);
                String prefix = this.prefixes.get(rawKey);
                if (prefix != null) {
                    PropertiesFileHelper.writeComments(prefix, bufferedWriter, encoder);
                }
                bufferedWriter.write(key + "=" + value);
                bufferedWriter.newLine();
            }
        }
        finally {
            bufferedWriter.close();
        }
    }

    public void read(File file, PropertiesFileParameters propertiesFileParameters) throws IOException {
        this.read(new FileInputStream(file), propertiesFileParameters);
    }

    public void read(InputStream inputStream, PropertiesFileParameters propertiesFileParameters) throws IOException {
        this.read(propertiesFileParameters.createReader(inputStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(Reader reader) throws IOException {
        StringBuilder prefix = null;
        try (BufferedReader bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                char c;
                int keyLength;
                String trimmedLine = line.trim();
                if (trimmedLine.isEmpty() || trimmedLine.startsWith("#")) {
                    if (prefix == null) {
                        prefix = new StringBuilder();
                    } else {
                        prefix.append("\n");
                    }
                    prefix.append(line);
                    continue;
                }
                int lineLength = line.length();
                boolean precedingBackslash = false;
                int valueStart = lineLength;
                boolean hasSeparator = false;
                for (keyLength = 0; keyLength < lineLength; ++keyLength) {
                    c = line.charAt(keyLength);
                    if (!(c != '=' && c != ':' || precedingBackslash)) {
                        valueStart = keyLength + 1;
                        hasSeparator = true;
                        break;
                    }
                    if (!(c != ' ' && c != '\t' && c != '\f' || precedingBackslash)) {
                        valueStart = keyLength + 1;
                        break;
                    }
                    precedingBackslash = c == '\\' ? !precedingBackslash : false;
                }
                while (valueStart < lineLength) {
                    c = line.charAt(valueStart);
                    if (c != ' ' && c != '\t' && c != '\f') {
                        if (hasSeparator || c != '=' && c != ':') break;
                        hasSeparator = true;
                    }
                    ++valueStart;
                }
                String key = PropertiesFileHelper.unescapeFromPropertiesFile(line.substring(0, keyLength));
                String value = PropertiesFileHelper.unescapeFromPropertiesFile(line.substring(valueStart, lineLength));
                this.put(key, value);
                if (prefix == null) continue;
                this.prefixes.put(key, prefix.toString());
                prefix = null;
            }
        }
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> map) {
        super.putAll(map);
        if (map instanceof TextProperties) {
            TextProperties textProperties = (TextProperties)map;
            if (textProperties.getHeader() != null) {
                this.setHeader(textProperties.getHeader());
            }
            this.prefixes.putAll(textProperties.getPrefixes());
        }
    }

    @Override
    public String remove(Object key) {
        String remove = (String)super.remove(key);
        this.prefixes.remove(key);
        return remove;
    }

    public String convertToUtf8String() throws IOException {
        StringWriter writer = new StringWriter();
        this.write(writer, new PropertiesWriteParameters(PropertiesFileEncoding.UTF8));
        return writer.toString();
    }

    public String convertToPropertiesString() throws IOException {
        StringWriter writer = new StringWriter();
        this.write(writer, new PropertiesWriteParameters(PropertiesFileEncoding.JAVA_PROPERTIES));
        return writer.toString();
    }
}

