/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.Util;
import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.formcomponents.SystemFormComponent;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.CompilerVariableHelper;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.util.DisplayTextArea;
import com.install4j.runtime.util.ToolTipHelpLabel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class UpdateAlertComponent
extends SystemFormComponent {
    public static final String FORM_VARIABLE_WELCOME_MESSAGE = "welcomeMessage";
    private boolean updateCheck = true;
    private ScriptProperty selectionScript;
    private JRadioButton rdoInstallUpdate;
    private JRadioButton rdoInstallNew;
    private ButtonGroup bgrInstall;
    private ToolTipHelpLabel helpLabel;

    public boolean isUpdateCheck() {
        return this.updateCheck;
    }

    public void setUpdateCheck(boolean updateCheck) {
        this.updateCheck = updateCheck;
    }

    public ScriptProperty getSelectionScript() {
        return this.selectionScript;
    }

    public void setSelectionScript(ScriptProperty selectionScript) {
        this.selectionScript = selectionScript;
    }

    @Override
    public boolean isFillCenterHorizontal() {
        return true;
    }

    @Override
    public JComponent createCenterComponent() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        gc.gridx = 0;
        gc.anchor = 23;
        gc.fill = 2;
        gc.weightx = 1.0;
        DisplayTextArea dtxa = new DisplayTextArea();
        Context context = this.getContext();
        dtxa.setText("\n" + context.getMessage("PreviousInstallationLabel"));
        panel.add((Component)dtxa, gc);
        gc.fill = 0;
        ++gc.gridy;
        ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    UpdateAlertComponent.this.executeSelectionScript();
                }
            }
        };
        this.rdoInstallUpdate = new JRadioButton(context.getMessage("RadioUpdateInstallation"), true);
        this.rdoInstallUpdate.setOpaque(false);
        this.rdoInstallUpdate.addItemListener(listener);
        this.rdoInstallNew = new JRadioButton(context.getMessage("RadioNewInstallation"));
        this.rdoInstallNew.setOpaque(false);
        this.rdoInstallNew.addItemListener(listener);
        this.bgrInstall = new ButtonGroup();
        this.bgrInstall.add(this.rdoInstallUpdate);
        this.bgrInstall.add(this.rdoInstallNew);
        this.helpLabel = new ToolTipHelpLabel("");
        gc.fill = 0;
        gc.insets.top = 5;
        Box box = new Box(2);
        box.add(this.rdoInstallUpdate);
        box.add(this.helpLabel);
        panel.add((Component)box, gc);
        gc.insets.top = 0;
        ++gc.gridy;
        panel.add((Component)this.rdoInstallNew, gc);
        ++gc.gridy;
        return panel;
    }

    public void update() {
        this.helpLabel.setToolTipText(this.getContext().getInstallationDirectory().getPath());
    }

    public boolean isUpdate() {
        return this.rdoInstallUpdate.isSelected();
    }

    @Override
    public void formWillActivate() {
        super.formWillActivate();
        Context context = this.getContext();
        if (this.getFormEnvironment().isDesignTime()) {
            this.setVisible(true);
        } else if (this.updateCheck && this.isUpdateInstallation()) {
            this.update();
            boolean writableInstallationDirectory = InstallerUtil.checkWritableInstallationDirectory(context.getInstallationDirectory(), false);
            this.setVisible(writableInstallationDirectory);
        } else {
            this.setVisible(false);
        }
        this.getFormEnvironment().setFormVariable(FORM_VARIABLE_WELCOME_MESSAGE, Messages.format(UpdateAlertComponent.replaceVariables(context.getMessage(this.isVisible() ? "ConsoleWelcomeLabel" : "WelcomeLabel3")), context.getApplicationName()));
    }

    @Override
    public void formActivated() {
        super.formActivated();
        if (this.isVisible()) {
            this.executeSelectionScript();
        }
    }

    private void executeSelectionScript() {
        try {
            this.getContext().runScript(this.selectionScript, this, this.rdoInstallUpdate.isSelected());
        }
        catch (Exception e) {
            Util.printAnnotatedStackTrace(e);
            Logger.getInstance().log(e);
        }
    }

    private boolean isUpdateInstallation() {
        Context context = this.getContext();
        return context instanceof InstallerContext && ((InstallerContext)context).isUpdateInstallation();
    }

    @Override
    public boolean checkCompleted() {
        if (!this.getContext().isUnattended() && !this.getContext().isConsole() && this.isVisible()) {
            this.getContext().setVariable("sys.confirmedUpdateInstallation", this.isUpdate());
        }
        return super.checkCompleted();
    }

    @Override
    public boolean handleConsole(Console console) throws UserCanceledException {
        if (this.updateCheck && this.isUpdateInstallation()) {
            int result;
            Context context = this.getContext();
            String previousLocationText = "";
            if (CompilerVariableHelper.getCompilerExtensionVariable(this.getContext(), "consoleShowPreviousInstallation", false)) {
                previousLocationText = "\n(" + this.getContext().getInstallationDirectory().getPath() + ")";
            }
            context.setVariable("sys.confirmedUpdateInstallation", (result = console.askOption(context.getMessage("PreviousInstallationLabel") + previousLocationText, new String[]{context.getMessage("RadioUpdateInstallation"), context.getMessage("RadioNewInstallation")}, null, 0, false, true)) == 0);
        }
        return true;
    }
}

