/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.apiimpl;

import com.install4j.api.Util;
import com.install4j.runtime.installer.platform.unix.Execution;
import com.install4j.runtime.installer.platform.win32.Misc;
import com.install4j.runtime.util.internal.ReflectionUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class SystemInfoImpl {
    private static long physicalMemoryCache = -1L;

    public static long getFreeDiskSpace(File file) {
        block7: {
            for (file = file.getAbsoluteFile(); file != null && !file.exists(); file = file.getParentFile()) {
            }
            if (file != null) {
                try {
                    if (Util.isWindows()) {
                        return Misc.getFreeDiskSpace(file);
                    }
                    if (!Util.isMacOS() && !Util.isLinux()) break block7;
                    StringBuffer outputBuffer = new StringBuffer();
                    if (!Execution.executeAndWait(new String[]{"df", "-k", file.getAbsolutePath()}, outputBuffer)) break block7;
                    String output = outputBuffer.toString().trim();
                    StringTokenizer tokLines = new StringTokenizer(output, "\n");
                    tokLines.nextToken();
                    String line = tokLines.nextToken();
                    StringTokenizer tokValues = new StringTokenizer(line, " \t\f");
                    try {
                        tokValues.nextToken();
                        tokValues.nextToken();
                        tokValues.nextToken();
                    }
                    catch (NoSuchElementException el) {
                        line = tokLines.nextToken();
                        tokValues = new StringTokenizer(line, " \t\f");
                        tokValues.nextToken();
                        tokValues.nextToken();
                    }
                    return Long.parseLong(tokValues.nextToken()) * 1024L;
                }
                catch (Exception e) {
                    System.err.println("Could not determine disk space: " + e.getMessage());
                }
            }
        }
        return -1L;
    }

    public static long getPhysicalMemory() {
        if (physicalMemoryCache == -1L) {
            physicalMemoryCache = SystemInfoImpl.initPhysicalMemory();
        }
        return physicalMemoryCache;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static long initPhysicalMemory() {
        try {
            OperatingSystemMXBean mbean = ManagementFactory.getOperatingSystemMXBean();
            Method physicalMemMethod = mbean.getClass().getMethod("getTotalPhysicalMemorySize", new Class[0]);
            ReflectionUtil.setAccessible(physicalMemMethod);
            Object ret = physicalMemMethod.invoke((Object)mbean, new Object[0]);
            if (ret instanceof Long) {
                return (Long)ret;
            }
        }
        catch (Throwable mbean) {
            // empty catch block
        }
        try {
            if (Util.isWindows()) {
                return Misc.getPhysicalMemory();
            }
            if (Util.isMacOS()) {
                long val = SystemInfoImpl.getSysctlResult("hw.memsize");
                if (val != 0L) return val;
                return SystemInfoImpl.getSysctlResult("hw.physmem");
            }
            if (!Util.isLinux()) return 0L;
            try (BufferedReader reader = new BufferedReader(new FileReader("/proc/meminfo"));){
                String output = reader.readLine();
                String outputStart = "MemTotal: ";
                while (output != null) {
                    if ((output = output.trim()).startsWith(outputStart) && output.length() > outputStart.length() + 2) {
                        output = output.substring(outputStart.length(), output.length() - 2).trim();
                        long l = Long.parseLong(output) * 1024L;
                        return l;
                    }
                    output = reader.readLine();
                }
                return 0L;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0L;
    }

    private static long getSysctlResult(String valueName) throws IOException {
        long val = 0L;
        try {
            String outputStart;
            String output;
            StringBuffer outputBuffer = new StringBuffer();
            if (Execution.executeAndWait(new String[]{"sysctl", valueName}, outputBuffer) && (output = outputBuffer.toString().trim()).startsWith(outputStart = valueName + ": ")) {
                val = Long.parseLong(output.substring(outputStart.length()));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return val;
    }

    public static void main(String[] args) {
        System.out.println(SystemInfoImpl.getPhysicalMemory());
    }
}

