/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.win32;

import com.install4j.runtime.util.internal.ReflectionUtil;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Window;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Objects;

public class WinGuiHelper {
    private static Method getHwndMethod;
    private static Field peerField;

    public static synchronized long getHwnd(Window window) throws HeadlessException {
        if (window != null) {
            if (GraphicsEnvironment.isHeadless()) {
                throw new HeadlessException("No native windows when headless");
            }
            try {
                Object componentPeer;
                if (peerField != null) {
                    componentPeer = peerField.get(window);
                } else {
                    try {
                        componentPeer = window.getPeer();
                    }
                    catch (Throwable t) {
                        peerField = Component.class.getDeclaredField("peer");
                        ReflectionUtil.setAccessible(peerField);
                        componentPeer = peerField.get(window);
                    }
                }
                if (componentPeer != null) {
                    if (getHwndMethod == null) {
                        getHwndMethod = componentPeer.getClass().getMethod("getHWnd", new Class[0]);
                        if (Objects.equals(getHwndMethod.getReturnType(), Long.TYPE)) {
                            ReflectionUtil.setAccessible(getHwndMethod);
                        } else {
                            getHwndMethod = null;
                        }
                    }
                    if (getHwndMethod != null) {
                        return (Long)getHwndMethod.invoke(componentPeer, new Object[0]);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return 0L;
    }
}

