/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.launcher.integration.gui;

import com.install4j.api.launcher.SplashScreen;
import com.install4j.runtime.launcher.integration.gui.AwtAndFxWindowChecker;
import com.install4j.runtime.launcher.integration.gui.SwtWindowChecker;

public abstract class WindowChecker
extends Thread {
    public static final String PROPNAME_SWT = "install4j.swt";
    public static final String PROPNAME_SPLASH_AUTO_HIDE = "install4j.splashAutoHide";
    private Runnable runnable;

    public static void initSplashAutoHide() {
        if (Boolean.getBoolean(PROPNAME_SPLASH_AUTO_HIDE)) {
            WindowChecker.onFirstWindowShown(new Runnable(){

                @Override
                public void run() {
                    try {
                        SplashScreen.hide();
                    }
                    catch (SplashScreen.ConnectionException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    public static void onFirstWindowShown(Runnable runnable) {
        if (Boolean.getBoolean(PROPNAME_SWT) && WindowChecker.isSwtPresent()) {
            new SwtWindowChecker(runnable).start();
        } else {
            new AwtAndFxWindowChecker(runnable).start();
        }
    }

    private static boolean isSwtPresent() {
        try {
            Class.forName("org.eclipse.swt.widgets.Display");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected WindowChecker(Runnable runnable) {
        super("install4j: window checker");
        this.runnable = runnable;
        this.setDaemon(true);
    }

    @Override
    public void run() {
        boolean execute = false;
        while (!execute) {
            try {
                WindowChecker.sleep(200L);
                execute = this.checkExecute();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.runnable.run();
    }

    protected abstract boolean checkExecute();
}

