/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.util;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.ImageObserver;
import java.net.URL;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;

public class RetinaIcon
extends ImageIcon {
    private Image disabledImage;
    private ImageIcon lowResImageIcon;

    public RetinaIcon(URL url, ImageIcon lowResImageIcon) {
        super(url);
        this.init(lowResImageIcon);
    }

    public RetinaIcon(String fileName, ImageIcon lowResImageIcon) {
        super(fileName);
        this.init(lowResImageIcon);
    }

    private void init(ImageIcon lowResImageIcon) {
        this.lowResImageIcon = lowResImageIcon;
    }

    @Override
    public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
        ImageObserver observer = this.getImageObserver();
        if (observer == null) {
            observer = c;
        }
        Image image = super.getImage();
        int width = image.getWidth(observer);
        int height = image.getHeight(observer);
        Graphics2D g2d = (Graphics2D)g.create(x, y, width, height);
        if (!c.isEnabled()) {
            if (this.disabledImage == null) {
                this.disabledImage = GrayFilter.createDisabledImage(image);
            }
            image = this.disabledImage;
        }
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.scale(0.5, 0.5);
        g2d.drawImage(image, 0, 0, null);
        g2d.scale(2.0, 2.0);
    }

    @Override
    public Image getImage() {
        return this.lowResImageIcon.getImage();
    }

    @Override
    public int getIconWidth() {
        return super.getIconWidth() / 2;
    }

    @Override
    public int getIconHeight() {
        return super.getIconHeight() / 2;
    }
}

