/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.iosp.hdf5;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Dimension;
import ucar.nc2.internal.iosp.hdf5.H5headerNew;
import ucar.nc2.iosp.hdf5.BTree2;
import ucar.nc2.iosp.hdf5.FractalHeap;
import ucar.nc2.iosp.hdf5.MemTracker;
import ucar.unidata.io.RandomAccessFile;

public class H5objects {
    private static Logger log = LoggerFactory.getLogger(H5objects.class);
    private static boolean debugEnum;
    private static boolean debugVlen;
    private static boolean debug1;
    private static boolean debugDetail;
    private static boolean debugPos;
    private static boolean debugHeap;
    private static boolean debugV;
    private static boolean debugGroupBtree;
    private static boolean debugDataBtree;
    private static boolean debugBtree2;
    private static boolean debugContinueMessage;
    private static boolean debugTracker;
    private static boolean debugSoftLink;
    private static boolean debugHardLink;
    private static boolean debugSymbolTable;
    private static boolean warnings;
    private static boolean debugReference;
    private static boolean debugRegionReference;
    private static boolean debugCreationOrder;
    private static boolean debugStructure;
    private static boolean debugDimensionScales;
    private final H5headerNew header;
    private final RandomAccessFile raf;
    private final PrintWriter debugOut;
    private final MemTracker memTracker;
    private final Map<Long, GlobalHeap> heapMap = new HashMap<Long, GlobalHeap>();
    private static final String[] filterName;
    private Map<Long, H5Group> hashGroups = new HashMap<Long, H5Group>();

    H5objects(H5headerNew header, PrintWriter debugOut, MemTracker memTracker) {
        this.header = header;
        this.raf = header.getRandomAccessFile();
        this.debugOut = debugOut;
        this.memTracker = memTracker;
    }

    H5Group readRootSymbolTable(long pos) throws IOException {
        SymbolTableEntry rootEntry = new SymbolTableEntry(pos);
        long rootObjectAddress = rootEntry.getObjectAddress();
        DataObjectFacade f = new DataObjectFacade(null, "", rootObjectAddress);
        return new H5Group(f);
    }

    H5Group readRootObject(long rootObjectAddress) throws IOException {
        DataObjectFacade f = new DataObjectFacade(null, "", rootObjectAddress);
        return new H5Group(f);
    }

    H5Group readH5Group(DataObjectFacade facade) throws IOException {
        return new H5Group(facade);
    }

    DataObject readDataObject(long address, String who) throws IOException {
        return new DataObject(address, who);
    }

    private DataObject getSharedDataObject(MessageType mtype) throws IOException {
        DataObject dobj;
        byte sharedVersion = this.raf.readByte();
        byte sharedType = this.raf.readByte();
        if (sharedVersion == 1) {
            this.raf.skipBytes(6);
        }
        if (sharedVersion == 3 && sharedType == 1) {
            long heapId = this.raf.readLong();
            if (debug1) {
                log.debug("     Shared Message " + sharedVersion + " type=" + sharedType + " heapId = " + heapId);
            }
            if (debugPos) {
                log.debug("  --> Shared Message reposition to =" + this.raf.getFilePointer());
            }
            throw new UnsupportedOperationException("****SHARED MESSAGE type = " + mtype + " heapId = " + heapId);
        }
        long address = this.header.readOffset();
        if (debug1) {
            log.debug("     Shared Message " + sharedVersion + " type=" + sharedType + " address = " + address);
        }
        if (null == (dobj = this.header.getDataObject(address, null))) {
            throw new IllegalStateException("cant find data object at" + address);
        }
        if (mtype == MessageType.Datatype) {
            return dobj;
        }
        throw new UnsupportedOperationException("****SHARED MESSAGE type = " + mtype);
    }

    private void readGroupNew(H5Group group, MessageGroupNew groupNewMessage, DataObject dobj) throws IOException {
        if (debug1) {
            log.debug("\n--> GroupNew read <{}>", (Object)group.displayName);
        }
        if (groupNewMessage.fractalHeapAddress >= 0L) {
            long btreeAddress;
            FractalHeap fractalHeap = new FractalHeap(this.header, group.displayName, groupNewMessage.fractalHeapAddress, this.memTracker);
            long l = btreeAddress = groupNewMessage.v2BtreeAddressCreationOrder >= 0L ? groupNewMessage.v2BtreeAddressCreationOrder : groupNewMessage.v2BtreeAddress;
            if (btreeAddress < 0L) {
                throw new IllegalStateException("no valid btree for GroupNew with Fractal Heap");
            }
            BTree2 btree = new BTree2(this.header, group.displayName, btreeAddress);
            block4: for (BTree2.Entry2 e : btree.entryList) {
                byte[] heapId;
                switch (btree.btreeType) {
                    case 5: {
                        heapId = ((BTree2.Record5)e.record).getHeapId();
                        break;
                    }
                    case 6: {
                        heapId = ((BTree2.Record6)e.record).getHeapId();
                        break;
                    }
                    default: {
                        continue block4;
                    }
                }
                FractalHeap.DHeapId fractalHeapId = fractalHeap.getFractalHeapId(heapId);
                long pos = fractalHeapId.getPos();
                if (pos < 0L) continue;
                this.raf.seek(pos);
                MessageLink linkMessage = new MessageLink();
                linkMessage.read();
                if (debugBtree2) {
                    log.debug("    linkMessage={}", (Object)linkMessage);
                }
                group.nestedObjects.add(new DataObjectFacade(group, linkMessage.linkName, linkMessage.linkAddress));
            }
        } else {
            for (HeaderMessage mess : dobj.messages) {
                if (mess.mtype != MessageType.Link) continue;
                MessageLink linkMessage = (MessageLink)mess.messData;
                if (linkMessage.linkType != 0) continue;
                group.nestedObjects.add(new DataObjectFacade(group, linkMessage.linkName, linkMessage.linkAddress));
            }
        }
        if (debug1) {
            log.debug("<-- end GroupNew read <" + group.displayName + ">");
        }
    }

    private void readGroupOld(H5Group group, long btreeAddress, long nameHeapAddress) throws IOException {
        this.hashGroups.put(btreeAddress, group);
        if (debug1) {
            log.debug("\n--> GroupOld read <" + group.displayName + ">");
        }
        LocalHeap nameHeap = new LocalHeap(group, nameHeapAddress);
        GroupBTree btree = new GroupBTree(group.displayName, btreeAddress);
        for (SymbolTableEntry s2 : btree.getSymbolTableEntries()) {
            String sname = nameHeap.getString((int)s2.getNameOffset());
            if (debugSoftLink) {
                log.debug("\n   Symbol name={}", (Object)sname);
            }
            if (s2.cacheType == 2) {
                String linkName = nameHeap.getString(s2.linkOffset);
                if (debugSoftLink) {
                    log.debug("   Symbolic link name=" + linkName + " symbolName=" + sname);
                }
                group.nestedObjects.add(new DataObjectFacade(group, sname, linkName));
                continue;
            }
            group.nestedObjects.add(new DataObjectFacade(group, sname, s2.getObjectAddress()));
        }
        if (debug1) {
            log.debug("<-- end GroupOld read <" + group.displayName + ">");
        }
    }

    Array getHeapDataArray(long globalHeapIdAddress, DataType dataType, int endian) throws IOException, InvalidRangeException {
        HeapIdentifier heapId = new HeapIdentifier(globalHeapIdAddress);
        if (debugHeap) {
            log.debug(" heapId= {}", (Object)heapId);
        }
        return this.getHeapDataArray(heapId, dataType, endian);
    }

    private Array getHeapDataArray(HeapIdentifier heapId, DataType dataType, int endian) throws IOException, InvalidRangeException {
        GlobalHeap.HeapObject ho = heapId.getHeapObject();
        if (ho == null) {
            throw new InvalidRangeException("Illegal Heap address, HeapObject = " + heapId);
        }
        if (debugHeap) {
            log.debug(" HeapObject= {}", (Object)ho);
        }
        if (endian >= 0) {
            this.raf.order(endian);
        }
        if (DataType.FLOAT == dataType) {
            float[] pa = new float[heapId.nelems];
            this.raf.seek(ho.dataPos);
            this.raf.readFloat(pa, 0, pa.length);
            return Array.factory(dataType, new int[]{pa.length}, (Object)pa);
        }
        if (DataType.DOUBLE == dataType) {
            double[] pa = new double[heapId.nelems];
            this.raf.seek(ho.dataPos);
            this.raf.readDouble(pa, 0, pa.length);
            return Array.factory(dataType, new int[]{pa.length}, (Object)pa);
        }
        if (dataType.getPrimitiveClassType() == Byte.TYPE) {
            byte[] pa = new byte[heapId.nelems];
            this.raf.seek(ho.dataPos);
            this.raf.readFully(pa, 0, pa.length);
            return Array.factory(dataType, new int[]{pa.length}, (Object)pa);
        }
        if (dataType.getPrimitiveClassType() == Short.TYPE) {
            short[] pa = new short[heapId.nelems];
            this.raf.seek(ho.dataPos);
            this.raf.readShort(pa, 0, pa.length);
            return Array.factory(dataType, new int[]{pa.length}, (Object)pa);
        }
        if (dataType.getPrimitiveClassType() == Integer.TYPE) {
            int[] pa = new int[heapId.nelems];
            this.raf.seek(ho.dataPos);
            this.raf.readInt(pa, 0, pa.length);
            return Array.factory(dataType, new int[]{pa.length}, (Object)pa);
        }
        if (dataType.getPrimitiveClassType() == Long.TYPE) {
            long[] pa = new long[heapId.nelems];
            this.raf.seek(ho.dataPos);
            this.raf.readLong(pa, 0, pa.length);
            return Array.factory(dataType, new int[]{pa.length}, (Object)pa);
        }
        throw new UnsupportedOperationException("getHeapDataAsArray dataType=" + (Object)((Object)dataType));
    }

    HeapIdentifier readHeapIdentifier(long globalHeapIdAddress) throws IOException {
        return new HeapIdentifier(globalHeapIdAddress);
    }

    HeapIdentifier readHeapIdentifier(ByteBuffer bb, int pos) throws IOException {
        return new HeapIdentifier(bb, pos);
    }

    private String readString(RandomAccessFile raf) throws IOException {
        long filePos = raf.getFilePointer();
        int count = 0;
        while (raf.readByte() != 0) {
            ++count;
        }
        raf.seek(filePos);
        String result = raf.readString(count);
        raf.readByte();
        return result;
    }

    private String readString8(RandomAccessFile raf) throws IOException {
        long filePos = raf.getFilePointer();
        int count = 0;
        while (raf.readByte() != 0) {
            ++count;
        }
        raf.seek(filePos);
        byte[] s2 = new byte[count];
        raf.readFully(s2);
        ++count;
        count += this.padding(count, 8);
        raf.seek(filePos + (long)count);
        return new String(s2, StandardCharsets.UTF_8);
    }

    private String readStringFixedLength(int size) throws IOException {
        return this.raf.readString(size);
    }

    private long readVariableSizeMax(int maxNumber) throws IOException {
        int size = this.header.getNumBytesFromMax(maxNumber);
        return this.header.readVariableSizeUnsigned(size);
    }

    private long readVariableSizeFactor(int sizeFactor) throws IOException {
        int size = (int)Math.pow(2.0, sizeFactor);
        return this.header.readVariableSizeUnsigned(size);
    }

    private int padding(int nbytes, int multipleOf) {
        int pad = nbytes % multipleOf;
        if (pad != 0) {
            pad = multipleOf - pad;
        }
        return pad;
    }

    private int makeUnsignedIntFromBytes(byte upper, byte lower) {
        return DataType.unsignedByteToShort(upper) * 256 + DataType.unsignedByteToShort(lower);
    }

    private void dump(String head, long filePos, int nbytes, boolean count) throws IOException {
        if (this.debugOut == null) {
            return;
        }
        long savePos = this.raf.getFilePointer();
        if (filePos >= 0L) {
            this.raf.seek(filePos);
        }
        byte[] mess = new byte[nbytes];
        this.raf.readFully(mess);
        H5objects.printBytes(head, mess, nbytes, false, this.debugOut);
        this.raf.seek(savePos);
    }

    private static void printBytes(String head, byte[] buff, int n, boolean count, PrintWriter ps) {
        ps.print(head + " == ");
        for (int i = 0; i < n; ++i) {
            int ub;
            int b = buff[i];
            int n2 = ub = b < 0 ? b + 256 : b;
            if (count) {
                ps.print(i + ":");
            }
            ps.print(ub);
            if (!count) {
                ps.print("(");
                ps.print(b);
                ps.print(")");
            }
            ps.print(" ");
        }
        ps.println();
    }

    static {
        warnings = true;
        filterName = new String[]{"", "deflate", "shuffle", "fletcher32", "szip", "nbit", "scaleoffset"};
    }

    class LocalHeap {
        H5Group group;
        int size;
        long freelistOffset;
        long dataAddress;
        byte[] heap;
        byte version;

        LocalHeap(H5Group group, long address) throws IOException {
            String magic;
            this.group = group;
            H5objects.this.raf.order(1);
            H5objects.this.raf.seek(H5objects.this.header.getFileOffset(address));
            if (debugDetail) {
                log.debug("-- readLocalHeap position={}", (Object)H5objects.this.raf.getFilePointer());
            }
            if (!(magic = H5objects.this.raf.readString(4)).equals("HEAP")) {
                throw new IllegalStateException(magic + " should equal HEAP");
            }
            this.version = H5objects.this.raf.readByte();
            H5objects.this.raf.skipBytes(3);
            this.size = (int)H5objects.this.header.readLength();
            this.freelistOffset = H5objects.this.header.readLength();
            this.dataAddress = H5objects.this.header.readOffset();
            if (debugDetail) {
                log.debug(" version=" + this.version + " size=" + this.size + " freelistOffset=" + this.freelistOffset + " heap starts at dataAddress=" + this.dataAddress);
            }
            if (debugPos) {
                log.debug("    *now at position={}", (Object)H5objects.this.raf.getFilePointer());
            }
            H5objects.this.raf.seek(H5objects.this.header.getFileOffset(this.dataAddress));
            this.heap = new byte[this.size];
            H5objects.this.raf.readFully(this.heap);
            if (debugDetail) {
                log.debug("-- endLocalHeap position={}", (Object)H5objects.this.raf.getFilePointer());
            }
            int hsize = 8 + 2 * ((H5objects)H5objects.this).header.sizeLengths + ((H5objects)H5objects.this).header.sizeOffsets;
            if (debugTracker) {
                H5objects.this.memTracker.addByLen("Group LocalHeap (" + group.displayName + ")", address, hsize);
            }
            if (debugTracker) {
                H5objects.this.memTracker.addByLen("Group LocalHeapData (" + group.displayName + ")", this.dataAddress, this.size);
            }
        }

        public String getString(int offset) {
            int count = 0;
            while (this.heap[offset + count] != 0) {
                ++count;
            }
            return new String(this.heap, offset, count, StandardCharsets.UTF_8);
        }
    }

    class GlobalHeap {
        private byte version;
        private int sizeBytes;
        private Map<Short, HeapObject> hos = new HashMap<Short, HeapObject>();

        GlobalHeap(long address) throws IOException {
            H5objects.this.raf.order(1);
            H5objects.this.raf.seek(H5objects.this.header.getFileOffset(address));
            String magic = H5objects.this.raf.readString(4);
            if (!magic.equals("GCOL")) {
                throw new IllegalStateException(magic + " should equal GCOL");
            }
            this.version = H5objects.this.raf.readByte();
            H5objects.this.raf.skipBytes(3);
            this.sizeBytes = H5objects.this.raf.readInt();
            if (debugDetail) {
                log.debug("-- readGlobalHeap address=" + address + " version= " + this.version + " size = " + this.sizeBytes);
            }
            H5objects.this.raf.skipBytes(4);
            int count = 0;
            int countBytes = 0;
            do {
                long startPos = H5objects.this.raf.getFilePointer();
                HeapObject o = new HeapObject();
                o.id = H5objects.this.raf.readShort();
                if (o.id == 0) break;
                o.refCount = H5objects.this.raf.readShort();
                H5objects.this.raf.skipBytes(4);
                o.dataSize = H5objects.this.header.readLength();
                o.dataPos = H5objects.this.raf.getFilePointer();
                int dsize = (int)o.dataSize + H5objects.this.padding((int)o.dataSize, 8);
                if (o.dataSize < 0L || (countBytes += dsize + 16) < 0 || countBytes > this.sizeBytes) break;
                if (debugDetail) {
                    log.debug("   HeapObject  position=" + startPos + " id=" + o.id + " refCount= " + o.refCount + " dataSize = " + o.dataSize + " dataPos = " + o.dataPos + " count= " + count + " countBytes= " + countBytes);
                }
                H5objects.this.raf.skipBytes(dsize);
                this.hos.put(o.id, o);
                ++count;
            } while (countBytes + 16 < this.sizeBytes);
            if (debugDetail) {
                log.debug("-- endGlobalHeap position=" + H5objects.this.raf.getFilePointer());
            }
            if (debugTracker) {
                H5objects.this.memTracker.addByLen("GlobalHeap", address, this.sizeBytes);
            }
        }

        HeapObject getHeapObject(short id) {
            return this.hos.get(id);
        }

        class HeapObject {
            short id;
            short refCount;
            long dataSize;
            long dataPos;

            HeapObject() {
            }

            public String toString() {
                return "id=" + this.id + ", refCount=" + this.refCount + ", dataSize=" + this.dataSize + ", dataPos=" + this.dataPos;
            }
        }
    }

    class RegionReference {
        private long heapAddress;
        private int index;

        RegionReference(long filePos) throws IOException {
            H5objects.this.raf.order(1);
            H5objects.this.raf.seek(filePos);
            this.heapAddress = H5objects.this.header.readOffset();
            this.index = H5objects.this.raf.readInt();
            GlobalHeap gheap = (GlobalHeap)H5objects.this.heapMap.get(this.heapAddress);
            if (null == gheap) {
                gheap = new GlobalHeap(this.heapAddress);
                H5objects.this.heapMap.put(this.heapAddress, gheap);
            }
            GlobalHeap.HeapObject want = gheap.getHeapObject((short)this.index);
            if (debugRegionReference) {
                log.debug(" found ho={}", (Object)want);
            }
            H5objects.this.raf.seek(want.dataPos);
            long objId = H5objects.this.raf.readLong();
            DataObject ndo = H5objects.this.header.getDataObject(objId, null);
            if (debugRegionReference) {
                log.debug(" objId=" + objId + " DataObject= " + ndo);
            }
            if (null == ndo) {
                throw new IllegalStateException("cant find data object at" + objId);
            }
        }
    }

    class HeapIdentifier {
        final int nelems;
        private final long heapAddress;
        private final int index;

        HeapIdentifier(long address) throws IOException {
            H5objects.this.raf.order(1);
            H5objects.this.raf.seek(address);
            this.nelems = H5objects.this.raf.readInt();
            this.heapAddress = H5objects.this.header.readOffset();
            this.index = H5objects.this.raf.readInt();
            if (debugDetail) {
                log.debug("   read HeapIdentifier address=" + address + this);
            }
            if (debugHeap) {
                H5objects.this.dump("heapIdentifier", H5objects.this.header.getFileOffset(address), 16, true);
            }
        }

        HeapIdentifier(ByteBuffer bb, int pos) {
            bb.order(ByteOrder.LITTLE_ENDIAN);
            bb.position(pos);
            this.nelems = bb.getInt();
            this.heapAddress = ((H5objects)H5objects.this).header.isOffsetLong ? bb.getLong() : (long)bb.getInt();
            this.index = bb.getInt();
            if (debugDetail) {
                log.debug("   read HeapIdentifier from ByteBuffer={}", (Object)this);
            }
        }

        public String toString() {
            return " nelems=" + this.nelems + " heapAddress=" + this.heapAddress + " index=" + this.index;
        }

        public boolean isEmpty() {
            return this.heapAddress == 0L;
        }

        GlobalHeap.HeapObject getHeapObject() throws IOException {
            GlobalHeap.HeapObject ho;
            if (this.isEmpty()) {
                return null;
            }
            GlobalHeap gheap = (GlobalHeap)H5objects.this.heapMap.get(this.heapAddress);
            if (null == gheap) {
                gheap = new GlobalHeap(this.heapAddress);
                H5objects.this.heapMap.put(this.heapAddress, gheap);
            }
            if ((ho = gheap.getHeapObject((short)this.index)) == null) {
                throw new IllegalStateException("cant find HeapObject");
            }
            return ho;
        }
    }

    class SymbolTableEntry {
        long nameOffset;
        long objectHeaderAddress;
        long btreeAddress;
        long nameHeapAddress;
        int cacheType;
        int linkOffset;
        long posData;
        boolean isSymbolicLink;

        SymbolTableEntry(long filePos) throws IOException {
            H5objects.this.raf.seek(filePos);
            if (debugSymbolTable) {
                log.debug("--> readSymbolTableEntry position={}", (Object)H5objects.this.raf.getFilePointer());
            }
            this.nameOffset = H5objects.this.header.readOffset();
            this.objectHeaderAddress = H5objects.this.header.readOffset();
            this.cacheType = H5objects.this.raf.readInt();
            H5objects.this.raf.skipBytes(4);
            if (debugSymbolTable) {
                log.debug(" nameOffset={} objectHeaderAddress={} cacheType={}", this.nameOffset, this.objectHeaderAddress, this.cacheType);
            }
            this.posData = H5objects.this.raf.getFilePointer();
            if (debugSymbolTable) {
                H5objects.this.dump("Group Entry scratch pad", this.posData, 16, false);
            }
            if (this.cacheType == 1) {
                this.btreeAddress = H5objects.this.header.readOffset();
                this.nameHeapAddress = H5objects.this.header.readOffset();
                if (debugSymbolTable) {
                    log.debug("btreeAddress={} nameHeadAddress={}", (Object)this.btreeAddress, (Object)this.nameHeapAddress);
                }
            }
            if (this.cacheType == 2) {
                this.linkOffset = H5objects.this.raf.readInt();
                if (debugSymbolTable) {
                    log.debug("WARNING Symbolic Link linkOffset={}", (Object)this.linkOffset);
                }
                this.isSymbolicLink = true;
            }
            if (debugSymbolTable) {
                log.debug("<-- end readSymbolTableEntry position={}", (Object)H5objects.this.raf.getFilePointer());
            }
            if (debugTracker) {
                H5objects.this.memTracker.add("SymbolTableEntry", filePos, this.posData + 16L);
            }
        }

        public int getSize() {
            return H5objects.this.header.isOffsetLong() ? 40 : 32;
        }

        long getObjectAddress() {
            return this.objectHeaderAddress;
        }

        long getNameOffset() {
            return this.nameOffset;
        }

        public String toString() {
            return "SymbolTableEntry{nameOffset=" + this.nameOffset + ", objectHeaderAddress=" + this.objectHeaderAddress + ", btreeAddress=" + this.btreeAddress + ", nameHeapAddress=" + this.nameHeapAddress + ", cacheType=" + this.cacheType + ", linkOffset=" + this.linkOffset + ", posData=" + this.posData + ", isSymbolicLink=" + this.isSymbolicLink + '}';
        }
    }

    class GroupBTree {
        protected String owner;
        protected int wantType;
        private List<SymbolTableEntry> sentries = new ArrayList<SymbolTableEntry>();

        GroupBTree(String owner, long address) throws IOException {
            this.owner = owner;
            ArrayList<Entry> entryList = new ArrayList<Entry>();
            this.readAllEntries(address, entryList);
            for (Entry e : entryList) {
                GroupNode node = new GroupNode(e.address);
                this.sentries.addAll(node.getSymbols());
            }
        }

        List<SymbolTableEntry> getSymbolTableEntries() {
            return this.sentries;
        }

        void readAllEntries(long address, List<Entry> entryList) throws IOException {
            String magic;
            H5objects.this.raf.seek(H5objects.this.header.getFileOffset(address));
            if (debugGroupBtree) {
                log.debug("\n--> GroupBTree read tree at position={}", (Object)H5objects.this.raf.getFilePointer());
            }
            if (!(magic = H5objects.this.raf.readString(4)).equals("TREE")) {
                throw new IllegalStateException("BtreeGroup doesnt start with TREE");
            }
            byte type = H5objects.this.raf.readByte();
            byte level = H5objects.this.raf.readByte();
            int nentries = H5objects.this.raf.readShort();
            if (debugGroupBtree) {
                log.debug("    type=" + type + " level=" + level + " nentries=" + nentries);
            }
            if (type != this.wantType) {
                throw new IllegalStateException("BtreeGroup must be type " + this.wantType);
            }
            long size = 8 + 2 * ((H5objects)H5objects.this).header.sizeOffsets + nentries * (((H5objects)H5objects.this).header.sizeOffsets + ((H5objects)H5objects.this).header.sizeLengths);
            if (debugTracker) {
                H5objects.this.memTracker.addByLen("Group BTree (" + this.owner + ")", address, size);
            }
            long leftAddress = H5objects.this.header.readOffset();
            long rightAddress = H5objects.this.header.readOffset();
            if (debugGroupBtree) {
                log.debug("    leftAddress=" + leftAddress + " " + Long.toHexString(leftAddress) + " rightAddress=" + rightAddress + " " + Long.toHexString(rightAddress));
            }
            ArrayList<Entry> myEntries = new ArrayList<Entry>();
            for (int i = 0; i < nentries; ++i) {
                myEntries.add(new Entry());
            }
            if (level == 0) {
                entryList.addAll(myEntries);
            } else {
                for (Entry entry : myEntries) {
                    if (debugDataBtree) {
                        log.debug("  nonzero node entry at =" + entry.address);
                    }
                    this.readAllEntries(entry.address, entryList);
                }
            }
        }

        class GroupNode {
            long address;
            byte version;
            short nentries;
            List<SymbolTableEntry> symbols = new ArrayList<SymbolTableEntry>();

            GroupNode(long address) throws IOException {
                String magic;
                this.address = address;
                H5objects.this.raf.seek(H5objects.this.header.getFileOffset(address));
                if (debugDetail) {
                    log.debug("--Group Node position={}", (Object)H5objects.this.raf.getFilePointer());
                }
                if (!(magic = H5objects.this.raf.readString(4)).equals("SNOD")) {
                    throw new IllegalStateException(magic + " should equal SNOD");
                }
                this.version = H5objects.this.raf.readByte();
                H5objects.this.raf.readByte();
                this.nentries = H5objects.this.raf.readShort();
                if (debugDetail) {
                    log.debug("   version={} nentries={}", (Object)this.version, (Object)this.nentries);
                }
                long posEntry = H5objects.this.raf.getFilePointer();
                for (int i = 0; i < this.nentries; ++i) {
                    SymbolTableEntry entry = new SymbolTableEntry(posEntry);
                    posEntry += (long)entry.getSize();
                    if (entry.objectHeaderAddress != 0L) {
                        if (debug1) {
                            log.debug("   add {}", (Object)entry);
                        }
                        this.symbols.add(entry);
                        continue;
                    }
                    if (!debug1) continue;
                    log.debug("   BAD objectHeaderAddress==0 !! {}", (Object)entry);
                }
                if (debugDetail) {
                    log.debug("-- Group Node end position={}", (Object)H5objects.this.raf.getFilePointer());
                }
                long size = 8 + this.nentries * 40;
                if (debugTracker) {
                    H5objects.this.memTracker.addByLen("Group BtreeNode (" + GroupBTree.this.owner + ")", address, size);
                }
            }

            List<SymbolTableEntry> getSymbols() {
                return this.symbols;
            }
        }

        class Entry {
            long key;
            long address;

            Entry() throws IOException {
                this.key = H5objects.this.header.readLength();
                this.address = H5objects.this.header.readOffset();
                if (debugGroupBtree) {
                    log.debug("     GroupEntry key={} address={}", (Object)this.key, (Object)this.address);
                }
            }
        }
    }

    class MessageObjectReferenceCount
    implements Named {
        int refCount;

        MessageObjectReferenceCount() {
        }

        void read() throws IOException {
            byte version = H5objects.this.raf.readByte();
            this.refCount = H5objects.this.raf.readInt();
            if (debug1) {
                log.debug("   ObjectReferenceCount={}", (Object)this.refCount);
            }
        }

        @Override
        public String getName() {
            return Integer.toString(this.refCount);
        }
    }

    class MessageContinue
    implements Named {
        long offset;
        long length;

        MessageContinue() {
        }

        void read() throws IOException {
            this.offset = H5objects.this.header.readOffset();
            this.length = H5objects.this.header.readLength();
            if (debug1) {
                log.debug("   Continue offset=" + this.offset + " length=" + this.length);
            }
        }

        @Override
        public String getName() {
            return "";
        }
    }

    class MessageLastModifiedOld
    implements Named {
        String datemod;

        MessageLastModifiedOld() {
        }

        void read() throws IOException {
            this.datemod = H5objects.this.raf.readString(14);
            if (debug1) {
                log.debug("   MessageLastModifiedOld={}", (Object)this.datemod);
            }
        }

        public String toString() {
            return this.datemod;
        }

        @Override
        public String getName() {
            return this.toString();
        }
    }

    class MessageLastModified
    implements Named {
        byte version;
        int secs;

        MessageLastModified() {
        }

        void read() throws IOException {
            this.version = H5objects.this.raf.readByte();
            H5objects.this.raf.skipBytes(3);
            this.secs = H5objects.this.raf.readInt();
        }

        public String toString() {
            return new Date((long)this.secs * 1000L).toString();
        }

        @Override
        public String getName() {
            return this.toString();
        }
    }

    class MessageComment
    implements Named {
        String comment;

        MessageComment() {
        }

        void read() throws IOException {
            this.comment = H5objects.this.readString(H5objects.this.raf);
        }

        public String toString() {
            return this.comment;
        }

        @Override
        public String getName() {
            return this.comment;
        }
    }

    class MessageAttributeInfo
    implements Named {
        byte flags;
        short maxCreationIndex = (short)-1;
        long fractalHeapAddress = -2L;
        long v2BtreeAddress = -2L;
        long v2BtreeAddressCreationOrder = -2L;

        MessageAttributeInfo() {
        }

        @Override
        public String getName() {
            long btreeAddress = this.v2BtreeAddressCreationOrder > 0L ? this.v2BtreeAddressCreationOrder : this.v2BtreeAddress;
            return Long.toString(btreeAddress);
        }

        public String toString() {
            Formatter f = new Formatter();
            f.format("   MessageAttributeInfo ", new Object[0]);
            if ((this.flags & 1) != 0) {
                f.format(" maxCreationIndex=" + this.maxCreationIndex, new Object[0]);
            }
            f.format(" fractalHeapAddress=%d v2BtreeAddress=%d", this.fractalHeapAddress, this.v2BtreeAddress);
            if ((this.flags & 2) != 0) {
                f.format(" v2BtreeAddressCreationOrder=%d", this.v2BtreeAddressCreationOrder);
            }
            this.showFractalHeap(f);
            return f.toString();
        }

        void showFractalHeap(Formatter f) {
            long btreeAddress;
            long l = btreeAddress = this.v2BtreeAddressCreationOrder > 0L ? this.v2BtreeAddressCreationOrder : this.v2BtreeAddress;
            if (this.fractalHeapAddress > 0L && btreeAddress > 0L) {
                try {
                    FractalHeap fractalHeap = new FractalHeap(H5objects.this.header, "", this.fractalHeapAddress, H5objects.this.memTracker);
                    fractalHeap.showDetails(f);
                    f.format(" Btree:%n", new Object[0]);
                    f.format("  type n m  offset size pos       attName%n", new Object[0]);
                    BTree2 btree = new BTree2(H5objects.this.header, "", btreeAddress);
                    block6: for (BTree2.Entry2 e : btree.entryList) {
                        byte[] heapId;
                        switch (btree.btreeType) {
                            case 8: {
                                heapId = ((BTree2.Record8)e.record).getHeapId();
                                break;
                            }
                            case 9: {
                                heapId = ((BTree2.Record9)e.record).getHeapId();
                                break;
                            }
                            default: {
                                f.format(" unknown btreetype %d%n", btree.btreeType);
                                continue block6;
                            }
                        }
                        FractalHeap.DHeapId dh = fractalHeap.getFractalHeapId(heapId);
                        dh.show(f);
                        if (dh.getPos() > 0L) {
                            MessageAttribute attMessage = new MessageAttribute();
                            attMessage.read(dh.getPos());
                            f.format(" %-30s", this.trunc(attMessage.getName(), 30));
                        }
                        f.format(" heapId=:%s%n", Arrays.toString(heapId));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        String trunc(String s2, int max) {
            if (s2 == null) {
                return null;
            }
            if (s2.length() < max) {
                return s2;
            }
            return s2.substring(0, max);
        }

        void read() throws IOException {
            if (debugPos) {
                log.debug("   *MessageAttributeInfo start pos= {}", (Object)H5objects.this.raf.getFilePointer());
            }
            byte version = H5objects.this.raf.readByte();
            byte flags = H5objects.this.raf.readByte();
            if ((flags & 1) != 0) {
                this.maxCreationIndex = H5objects.this.raf.readShort();
            }
            this.fractalHeapAddress = H5objects.this.header.readOffset();
            this.v2BtreeAddress = H5objects.this.header.readOffset();
            if ((flags & 2) != 0) {
                this.v2BtreeAddressCreationOrder = H5objects.this.header.readOffset();
            }
            if (debug1) {
                log.debug("   MessageAttributeInfo version= " + version + " flags = " + flags + this);
            }
        }
    }

    public class MessageAttribute
    implements Named {
        byte version;
        String name;
        MessageDatatype mdt;
        MessageDataspace mds;
        long dataPos;

        public MessageAttribute() {
            this.mdt = new MessageDatatype();
            this.mds = new MessageDataspace();
        }

        public byte getVersion() {
            return this.version;
        }

        public MessageDatatype getMdt() {
            return this.mdt;
        }

        public MessageDataspace getMds() {
            return this.mds;
        }

        public long getDataPosAbsolute() {
            return this.dataPos;
        }

        public String toString() {
            StringBuilder sbuff = new StringBuilder();
            sbuff.append("   Name= ").append(this.name);
            sbuff.append(" dataPos = ").append(this.dataPos);
            if (this.mdt != null) {
                sbuff.append("\n mdt=");
                sbuff.append(this.mdt);
            }
            if (this.mds != null) {
                sbuff.append("\n mds=");
                sbuff.append(this.mds);
            }
            return sbuff.toString();
        }

        @Override
        public String getName() {
            return this.name;
        }

        boolean read(long pos) throws IOException {
            boolean isShared;
            short spaceSize;
            short typeSize;
            short nameSize;
            H5objects.this.raf.seek(pos);
            if (debugPos) {
                log.debug("   *MessageAttribute start pos= {}", (Object)H5objects.this.raf.getFilePointer());
            }
            byte flags = 0;
            byte encoding = 0;
            this.version = H5objects.this.raf.readByte();
            if (this.version == 1) {
                H5objects.this.raf.read();
                nameSize = H5objects.this.raf.readShort();
                typeSize = H5objects.this.raf.readShort();
                spaceSize = H5objects.this.raf.readShort();
            } else if (this.version == 2 || this.version == 3) {
                flags = H5objects.this.raf.readByte();
                nameSize = H5objects.this.raf.readShort();
                typeSize = H5objects.this.raf.readShort();
                spaceSize = H5objects.this.raf.readShort();
                if (this.version == 3) {
                    encoding = H5objects.this.raf.readByte();
                }
            } else if (this.version == 72) {
                flags = H5objects.this.raf.readByte();
                nameSize = H5objects.this.raf.readShort();
                typeSize = H5objects.this.raf.readShort();
                spaceSize = H5objects.this.raf.readShort();
                log.error("HDF5 MessageAttribute found bad version " + this.version + " at filePos " + H5objects.this.raf.getFilePointer());
            } else {
                log.error("bad version " + this.version + " at filePos " + H5objects.this.raf.getFilePointer());
                return false;
            }
            long filePos = H5objects.this.raf.getFilePointer();
            this.name = H5objects.this.readString(H5objects.this.raf);
            if (this.version == 1) {
                nameSize = (short)(nameSize + H5objects.this.padding(nameSize, 8));
            }
            H5objects.this.raf.seek(filePos + (long)nameSize);
            if (debug1) {
                log.debug("   MessageAttribute version= " + this.version + " flags = " + Integer.toBinaryString(flags) + " nameSize = " + nameSize + " typeSize=" + typeSize + " spaceSize= " + spaceSize + " name= " + this.name);
            }
            filePos = H5objects.this.raf.getFilePointer();
            if (debugPos) {
                log.debug("   *MessageAttribute before mdt pos= {}", (Object)filePos);
            }
            boolean bl = isShared = (flags & 1) != 0;
            if (isShared) {
                this.mdt = ((H5objects)H5objects.this).getSharedDataObject((MessageType)MessageType.Datatype).mdt;
                if (debug1) {
                    log.debug("    MessageDatatype: {}", (Object)this.mdt);
                }
            } else {
                this.mdt.read(this.name);
                if (this.version == 1) {
                    typeSize = (short)(typeSize + H5objects.this.padding(typeSize, 8));
                }
            }
            H5objects.this.raf.seek(filePos + (long)typeSize);
            filePos = H5objects.this.raf.getFilePointer();
            if (debugPos) {
                log.debug("   *MessageAttribute before mds = {}", (Object)filePos);
            }
            this.mds.read();
            if (this.version == 1) {
                spaceSize = (short)(spaceSize + H5objects.this.padding(spaceSize, 8));
            }
            H5objects.this.raf.seek(filePos + (long)spaceSize);
            this.dataPos = H5objects.this.raf.getFilePointer();
            if (debug1) {
                log.debug("   *MessageAttribute dataPos= {}", (Object)this.dataPos);
            }
            return true;
        }
    }

    class Filter {
        short id;
        short flags;
        String name;
        short nValues;
        int[] data;

        Filter(byte version) throws IOException {
            this.id = H5objects.this.raf.readShort();
            short nameSize = version > 1 && this.id < 256 ? (short)0 : H5objects.this.raf.readShort();
            this.flags = H5objects.this.raf.readShort();
            this.nValues = H5objects.this.raf.readShort();
            this.name = version == 1 ? (nameSize > 0 ? H5objects.this.readString8(H5objects.this.raf) : this.getFilterName(this.id)) : (nameSize > 0 ? H5objects.this.readStringFixedLength(nameSize) : this.getFilterName(this.id));
            this.data = new int[this.nValues];
            for (int i = 0; i < this.nValues; ++i) {
                this.data[i] = H5objects.this.raf.readInt();
            }
            if (version == 1 && (this.nValues & 1) != 0) {
                H5objects.this.raf.skipBytes(4);
            }
            if (debug1) {
                log.debug("{}", (Object)this);
            }
        }

        String getFilterName(int id) {
            return id < filterName.length ? filterName[id] : "StandardFilter " + id;
        }

        public String toString() {
            StringBuilder sbuff = new StringBuilder();
            sbuff.append("   Filter id= ").append(this.id).append(" flags = ").append(this.flags).append(" nValues=").append(this.nValues).append(" name= ").append(this.name).append(" data = ");
            for (int i = 0; i < this.nValues; ++i) {
                sbuff.append(this.data[i]).append(" ");
            }
            return sbuff.toString();
        }
    }

    class MessageFilter
    implements Named {
        Filter[] filters;

        MessageFilter() {
        }

        void read() throws IOException {
            byte version = H5objects.this.raf.readByte();
            int nfilters = H5objects.this.raf.readByte();
            if (version == 1) {
                H5objects.this.raf.skipBytes(6);
            }
            this.filters = new Filter[nfilters];
            for (int i = 0; i < nfilters; ++i) {
                this.filters[i] = new Filter(version);
            }
            if (debug1) {
                log.debug("   MessageFilter version=" + version + this);
            }
        }

        public Filter[] getFilters() {
            return this.filters;
        }

        public String toString() {
            StringBuilder sbuff = new StringBuilder();
            sbuff.append("   MessageFilter filters=\n");
            for (Filter f : this.filters) {
                sbuff.append(" ").append(f).append("\n");
            }
            return sbuff.toString();
        }

        @Override
        public String getName() {
            StringBuilder sbuff = new StringBuilder();
            for (Filter f : this.filters) {
                sbuff.append(f.name).append(", ");
            }
            return sbuff.toString();
        }
    }

    class MessageLayout
    implements Named {
        byte type;
        long dataAddress = -1L;
        long contiguousSize;
        int[] chunkSize;
        int dataSize;

        MessageLayout() {
        }

        public String toString() {
            StringBuilder sbuff = new StringBuilder();
            sbuff.append(" type= ").append(this.type).append(" (");
            switch (this.type) {
                case 0: {
                    sbuff.append("compact");
                    break;
                }
                case 1: {
                    sbuff.append("contiguous");
                    break;
                }
                case 2: {
                    sbuff.append("chunked");
                    break;
                }
                default: {
                    sbuff.append("unknown type= ").append(this.type);
                }
            }
            sbuff.append(")");
            if (this.chunkSize != null) {
                sbuff.append(" storageSize = (");
                for (int i = 0; i < this.chunkSize.length; ++i) {
                    if (i > 0) {
                        sbuff.append(",");
                    }
                    sbuff.append(this.chunkSize[i]);
                }
                sbuff.append(")");
            }
            sbuff.append(" dataSize=").append(this.dataSize);
            sbuff.append(" dataAddress=").append(this.dataAddress);
            return sbuff.toString();
        }

        @Override
        public String getName() {
            StringBuilder sbuff = new StringBuilder();
            switch (this.type) {
                case 0: {
                    sbuff.append("compact");
                    break;
                }
                case 1: {
                    sbuff.append("contiguous");
                    break;
                }
                case 2: {
                    sbuff.append("chunked");
                    break;
                }
                default: {
                    sbuff.append("unknown type= ").append(this.type);
                }
            }
            if (this.chunkSize != null) {
                sbuff.append(" chunk = (");
                for (int i = 0; i < this.chunkSize.length; ++i) {
                    if (i > 0) {
                        sbuff.append(",");
                    }
                    sbuff.append(this.chunkSize[i]);
                }
                sbuff.append(")");
            }
            return sbuff.toString();
        }

        void read() throws IOException {
            byte version = H5objects.this.raf.readByte();
            if (version < 3) {
                boolean isCompact;
                int ndims = H5objects.this.raf.readByte();
                this.type = H5objects.this.raf.readByte();
                H5objects.this.raf.skipBytes(5);
                boolean bl = isCompact = this.type == 0;
                if (!isCompact) {
                    this.dataAddress = H5objects.this.header.readOffset();
                }
                this.chunkSize = new int[ndims];
                for (int i = 0; i < ndims; ++i) {
                    this.chunkSize[i] = H5objects.this.raf.readInt();
                }
                if (isCompact) {
                    this.dataSize = H5objects.this.raf.readInt();
                    this.dataAddress = H5objects.this.raf.getFilePointer();
                }
            } else {
                this.type = H5objects.this.raf.readByte();
                if (this.type == 0) {
                    this.dataSize = H5objects.this.raf.readShort();
                    this.dataAddress = H5objects.this.raf.getFilePointer();
                } else if (this.type == 1) {
                    this.dataAddress = H5objects.this.header.readOffset();
                    this.contiguousSize = H5objects.this.header.readLength();
                } else if (this.type == 2) {
                    int ndims = H5objects.this.raf.readByte();
                    this.dataAddress = H5objects.this.header.readOffset();
                    this.chunkSize = new int[ndims];
                    for (int i = 0; i < ndims; ++i) {
                        this.chunkSize[i] = H5objects.this.raf.readInt();
                    }
                }
            }
            if (debug1) {
                log.debug("   StorageLayout version= " + version + this);
            }
        }
    }

    class MessageFillValue
    implements Named {
        byte version;
        byte spaceAllocateTime;
        byte fillWriteTime;
        int size;
        byte[] value;
        boolean hasFillValue;
        byte flags;

        MessageFillValue() {
        }

        void read() throws IOException {
            this.version = H5objects.this.raf.readByte();
            if (this.version < 3) {
                this.spaceAllocateTime = H5objects.this.raf.readByte();
                this.fillWriteTime = H5objects.this.raf.readByte();
                this.hasFillValue = H5objects.this.raf.readByte() != 0;
            } else {
                this.flags = H5objects.this.raf.readByte();
                this.spaceAllocateTime = (byte)(this.flags & 3);
                this.fillWriteTime = (byte)(this.flags >> 2 & 3);
                boolean bl = this.hasFillValue = (this.flags & 0x20) != 0;
            }
            if (this.hasFillValue) {
                this.size = H5objects.this.raf.readInt();
                if (this.size > 0) {
                    this.value = new byte[this.size];
                    H5objects.this.raf.readFully(this.value);
                    this.hasFillValue = true;
                } else {
                    this.hasFillValue = false;
                }
            }
            if (debug1) {
                log.debug("{}", (Object)this);
            }
        }

        public String toString() {
            StringBuilder sbuff = new StringBuilder();
            sbuff.append("   FillValue version= ").append(this.version).append(" spaceAllocateTime = ").append(this.spaceAllocateTime).append(" fillWriteTime=").append(this.fillWriteTime).append(" hasFillValue= ").append(this.hasFillValue);
            sbuff.append("\n size = ").append(this.size).append(" value=");
            for (int i = 0; i < this.size; ++i) {
                sbuff.append(" ").append(this.value[i]);
            }
            return sbuff.toString();
        }

        @Override
        public String getName() {
            StringBuilder sbuff = new StringBuilder();
            for (int i = 0; i < this.size; ++i) {
                sbuff.append(" ").append(this.value[i]);
            }
            return sbuff.toString();
        }
    }

    class MessageFillValueOld
    implements Named {
        byte[] value;
        int size;

        MessageFillValueOld() {
        }

        void read() throws IOException {
            this.size = H5objects.this.raf.readInt();
            this.value = new byte[this.size];
            H5objects.this.raf.readFully(this.value);
            if (debug1) {
                log.debug("{}", (Object)this);
            }
        }

        public String toString() {
            StringBuilder sbuff = new StringBuilder();
            sbuff.append("   FillValueOld size= ").append(this.size).append(" value=");
            for (int i = 0; i < this.size; ++i) {
                sbuff.append(" ").append(this.value[i]);
            }
            return sbuff.toString();
        }

        @Override
        public String getName() {
            StringBuilder sbuff = new StringBuilder();
            for (int i = 0; i < this.size; ++i) {
                sbuff.append(" ").append(this.value[i]);
            }
            return sbuff.toString();
        }
    }

    class StructureMember {
        String name;
        int offset;
        byte dims;
        MessageDatatype mdt;

        StructureMember(int version, int byteSize) throws IOException {
            if (debugPos) {
                log.debug("   *StructureMember now at position={}", (Object)H5objects.this.raf.getFilePointer());
            }
            this.name = H5objects.this.readString(H5objects.this.raf);
            if (version < 3) {
                H5objects.this.raf.skipBytes(H5objects.this.padding(this.name.length() + 1, 8));
                this.offset = H5objects.this.raf.readInt();
            } else {
                this.offset = (int)H5objects.this.readVariableSizeMax(byteSize);
            }
            if (debug1) {
                log.debug("   Member name=" + this.name + " offset= " + this.offset);
            }
            if (version == 1) {
                this.dims = H5objects.this.raf.readByte();
                H5objects.this.raf.skipBytes(3);
                H5objects.this.raf.skipBytes(24);
            }
            this.mdt = new MessageDatatype();
            this.mdt.read(this.name);
            if (debugDetail) {
                log.debug("   ***End Member name={}", (Object)this.name);
            }
        }

        public String toString() {
            return "StructureMember{name='" + this.name + '\'' + ", offset=" + this.offset + ", dims=" + this.dims + ", mdt=" + this.mdt + '}';
        }
    }

    public class MessageDatatype
    implements Named {
        int type;
        int version;
        byte[] flags = new byte[3];
        int byteSize;
        int endian;
        boolean isOK = true;
        boolean unsigned;
        DataType timeType;
        String opaque_desc;
        List<StructureMember> members;
        int referenceType;
        Map<Integer, String> map;
        String enumTypeName;
        MessageDatatype base;
        boolean isVString;
        boolean isVlen;
        int[] dim;

        public String toString() {
            Formatter f = new Formatter();
            f.format(" datatype= %d", this.type);
            f.format(" byteSize= %d", this.byteSize);
            DataType dtype = H5objects.this.header.getNCtype(this.type, this.byteSize, this.unsigned);
            f.format(" NCtype= %s %s", new Object[]{dtype, this.unsigned ? "(unsigned)" : ""});
            f.format(" flags= ", new Object[0]);
            for (int i = 0; i < 3; ++i) {
                f.format(" %d", this.flags[i]);
            }
            f.format(" endian= %s", this.endian == 0 ? "BIG" : "LITTLE");
            if (this.type == 2) {
                f.format(" timeType= %s", new Object[]{this.timeType});
            } else if (this.type == 6) {
                f.format("%n  members%n", new Object[0]);
                for (StructureMember mm3 : this.members) {
                    f.format("   %s%n", mm3);
                }
            } else if (this.type == 7) {
                f.format(" referenceType= %s", this.referenceType);
            } else if (this.type == 8) {
                f.format(" enumTypeName= %s", this.enumTypeName);
            } else if (this.type == 9) {
                f.format(" isVString= %s", this.isVString);
                f.format(" isVlen= %s", this.isVlen);
            }
            if (this.type == 8 || this.type == 9 || this.type == 10) {
                f.format(" parent base= {%s}", this.base);
            }
            return f.toString();
        }

        @Override
        public String getName() {
            DataType dtype = H5objects.this.header.getNCtype(this.type, this.byteSize, this.unsigned);
            if (dtype != null) {
                return (Object)((Object)dtype) + " size= " + this.byteSize;
            }
            return "type=" + this.type + " size= " + this.byteSize;
        }

        public String getType() {
            DataType dtype = H5objects.this.header.getNCtype(this.type, this.byteSize, this.unsigned);
            if (dtype != null) {
                return dtype.toString();
            }
            return "type=" + this.type + " size= " + this.byteSize;
        }

        void read(String objectName) throws IOException {
            if (debugPos) {
                log.debug("   *MessageDatatype start pos= {}", (Object)H5objects.this.raf.getFilePointer());
            }
            byte tandv = H5objects.this.raf.readByte();
            this.type = tandv & 0xF;
            this.version = (tandv & 0xF0) >> 4;
            H5objects.this.raf.readFully(this.flags);
            this.byteSize = H5objects.this.raf.readInt();
            int n = this.endian = (this.flags[0] & 1) == 0 ? 1 : 0;
            if (debug1) {
                log.debug("   Datatype type=" + this.type + " version= " + this.version + " flags = " + this.flags[0] + " " + this.flags[1] + " " + this.flags[2] + " byteSize=" + this.byteSize + " byteOrder=" + (this.endian == 0 ? "BIG" : "LITTLE"));
            }
            if (this.type == 0) {
                this.unsigned = (this.flags[0] & 8) == 0;
                short bitOffset = H5objects.this.raf.readShort();
                short bitPrecision = H5objects.this.raf.readShort();
                if (debug1) {
                    log.debug("   type 0 (fixed point): bitOffset= " + bitOffset + " bitPrecision= " + bitPrecision + " unsigned= " + this.unsigned);
                }
                this.isOK = bitOffset == 0 && bitPrecision % 8 == 0;
            } else if (this.type == 1) {
                short bitOffset = H5objects.this.raf.readShort();
                short bitPrecision = H5objects.this.raf.readShort();
                byte expLocation = H5objects.this.raf.readByte();
                byte expSize = H5objects.this.raf.readByte();
                byte manLocation = H5objects.this.raf.readByte();
                byte manSize = H5objects.this.raf.readByte();
                int expBias = H5objects.this.raf.readInt();
                if (debug1) {
                    log.debug("   type 1 (floating point): bitOffset= " + bitOffset + " bitPrecision= " + bitPrecision + " expLocation= " + expLocation + " expSize= " + expSize + " manLocation= " + manLocation + " manSize= " + manSize + " expBias= " + expBias);
                }
            } else if (this.type == 2) {
                short bitPrecision = H5objects.this.raf.readShort();
                if (bitPrecision == 16) {
                    this.timeType = DataType.SHORT;
                } else if (bitPrecision == 32) {
                    this.timeType = DataType.INT;
                } else if (bitPrecision == 64) {
                    this.timeType = DataType.LONG;
                }
                if (debug1) {
                    log.debug("   type 2 (time): bitPrecision= " + bitPrecision + " timeType = " + (Object)((Object)this.timeType));
                }
            } else if (this.type == 3) {
                int ptype = this.flags[0] & 0xF;
                if (debug1) {
                    log.debug("   type 3 (String): pad type= " + ptype);
                }
            } else if (this.type == 4) {
                short bitOffset = H5objects.this.raf.readShort();
                short bitPrecision = H5objects.this.raf.readShort();
                if (debug1) {
                    log.debug("   type 4 (bit field): bitOffset= " + bitOffset + " bitPrecision= " + bitPrecision);
                }
            } else if (this.type == 5) {
                byte len = this.flags[0];
                String string = this.opaque_desc = len > 0 ? H5objects.this.readString(H5objects.this.raf).trim() : null;
                if (debug1) {
                    log.debug("   type 5 (opaque): len= " + len + " desc= " + this.opaque_desc);
                }
            } else if (this.type == 6) {
                int nmembers = H5objects.this.makeUnsignedIntFromBytes(this.flags[1], this.flags[0]);
                if (debug1) {
                    log.debug("   --type 6(compound): nmembers={}", (Object)nmembers);
                }
                this.members = new ArrayList<StructureMember>();
                for (int i = 0; i < nmembers; ++i) {
                    this.members.add(new StructureMember(this.version, this.byteSize));
                }
                if (debugDetail) {
                    log.debug("   --done with compound type");
                }
            } else if (this.type == 7) {
                this.referenceType = this.flags[0] & 0xF;
                if (debug1 || debugReference) {
                    log.debug("   --type 7(reference): type= {}", (Object)this.referenceType);
                }
            } else if (this.type == 8) {
                int i;
                int nmembers = H5objects.this.makeUnsignedIntFromBytes(this.flags[1], this.flags[0]);
                boolean saveDebugDetail = debugDetail;
                if (debug1 || debugEnum) {
                    log.debug("   --type 8(enums): nmembers={}", (Object)nmembers);
                    debugDetail = true;
                }
                this.base = new MessageDatatype();
                this.base.read(objectName);
                debugDetail = saveDebugDetail;
                String[] enumName = new String[nmembers];
                for (int i2 = 0; i2 < nmembers; ++i2) {
                    enumName[i2] = this.version < 3 ? H5objects.this.readString8(H5objects.this.raf) : H5objects.this.readString(H5objects.this.raf);
                }
                if (this.base.endian >= 0) {
                    H5objects.this.raf.order(this.base.endian);
                }
                int[] enumValue = new int[nmembers];
                for (i = 0; i < nmembers; ++i) {
                    enumValue[i] = (int)H5objects.this.header.readVariableSizeUnsigned(this.base.byteSize);
                }
                H5objects.this.raf.order(1);
                this.enumTypeName = objectName;
                this.map = new TreeMap<Integer, String>();
                for (i = 0; i < nmembers; ++i) {
                    this.map.put(enumValue[i], enumName[i]);
                }
                if (debugEnum) {
                    for (i = 0; i < nmembers; ++i) {
                        log.debug("   " + enumValue[i] + "=" + enumName[i]);
                    }
                }
            } else if (this.type == 9) {
                boolean bl = this.isVString = (this.flags[0] & 0xF) == 1;
                if (!this.isVString) {
                    this.isVlen = true;
                }
                if (debug1) {
                    log.debug("   type 9(variable length): type= {}", (Object)(this.isVString ? "string" : "sequence of type:"));
                }
                this.base = new MessageDatatype();
                this.base.read(objectName);
            } else if (this.type == 10) {
                if (debug1) {
                    H5objects.this.debugOut.print("   type 10(array) lengths= ");
                }
                int ndims = H5objects.this.raf.readByte();
                if (this.version < 3) {
                    H5objects.this.raf.skipBytes(3);
                }
                this.dim = new int[ndims];
                for (int i = 0; i < ndims; ++i) {
                    this.dim[i] = H5objects.this.raf.readInt();
                    if (!debug1) continue;
                    H5objects.this.debugOut.print(" " + this.dim[i]);
                }
                if (this.version < 3) {
                    int[] pdim = new int[ndims];
                    for (int i = 0; i < ndims; ++i) {
                        pdim[i] = H5objects.this.raf.readInt();
                    }
                }
                if (debug1) {
                    log.debug("");
                }
                this.base = new MessageDatatype();
                this.base.read(objectName);
            } else if (warnings) {
                log.warn(" WARNING not dealing with type= {}", (Object)this.type);
            }
        }

        int getBaseType() {
            return this.base != null ? this.base.getBaseType() : this.type;
        }

        int getBaseSize() {
            return this.base != null ? this.base.getBaseSize() : this.byteSize;
        }

        byte[] getFlags() {
            return this.base != null ? this.base.getFlags() : this.flags;
        }

        boolean isVlen() {
            return this.type == 10 ? this.base.isVlen() : this.isVlen;
        }

        boolean isVString() {
            return this.type == 10 ? this.base.isVString() : this.isVString;
        }
    }

    class MessageLink
    implements Named {
        byte version;
        byte flags;
        byte encoding;
        byte linkType;
        long creationOrder;
        String linkName;
        String link;
        long linkAddress;

        MessageLink() {
        }

        public String toString() {
            StringBuilder sbuff = new StringBuilder();
            sbuff.append("   MessageLink ");
            sbuff.append(" name=").append(this.linkName).append(" type=").append(this.linkType);
            if (this.linkType == 0) {
                sbuff.append(" linkAddress=" + this.linkAddress);
            } else {
                sbuff.append(" link=").append(this.link);
            }
            if ((this.flags & 4) != 0) {
                sbuff.append(" creationOrder=" + this.creationOrder);
            }
            if ((this.flags & 0x10) != 0) {
                sbuff.append(" encoding=" + this.encoding);
            }
            return sbuff.toString();
        }

        void read() throws IOException {
            if (debugPos) {
                log.debug("   *MessageLink start pos= {}", (Object)H5objects.this.raf.getFilePointer());
            }
            this.version = H5objects.this.raf.readByte();
            this.flags = H5objects.this.raf.readByte();
            if ((this.flags & 8) != 0) {
                this.linkType = H5objects.this.raf.readByte();
            }
            if ((this.flags & 4) != 0) {
                this.creationOrder = H5objects.this.raf.readLong();
            }
            if ((this.flags & 0x10) != 0) {
                this.encoding = H5objects.this.raf.readByte();
            }
            int linkNameLength = (int)H5objects.this.readVariableSizeFactor(this.flags & 3);
            this.linkName = H5objects.this.readStringFixedLength(linkNameLength);
            if (this.linkType == 0) {
                this.linkAddress = H5objects.this.header.readOffset();
            } else if (this.linkType == 1) {
                short len = H5objects.this.raf.readShort();
                this.link = H5objects.this.readStringFixedLength(len);
            } else if (this.linkType == 64) {
                short len = H5objects.this.raf.readShort();
                this.link = H5objects.this.readStringFixedLength(len);
            }
            if (debug1) {
                log.debug("   MessageLink version= " + this.version + " flags = " + Integer.toBinaryString(this.flags) + this);
            }
        }

        @Override
        public String getName() {
            return this.linkName;
        }
    }

    class MessageGroupInfo
    implements Named {
        byte flags;
        short maxCompactValue = (short)-1;
        short minDenseValue = (short)-1;
        short estNumEntries = (short)-1;
        short estLengthEntryName = (short)-1;

        MessageGroupInfo() {
        }

        public String toString() {
            StringBuilder sbuff = new StringBuilder();
            sbuff.append("   MessageGroupInfo ");
            if ((this.flags & 1) != 0) {
                sbuff.append(" maxCompactValue=").append(this.maxCompactValue).append(" minDenseValue=").append(this.minDenseValue);
            }
            if ((this.flags & 2) != 0) {
                sbuff.append(" estNumEntries=").append(this.estNumEntries).append(" estLengthEntryName=").append(this.estLengthEntryName);
            }
            return sbuff.toString();
        }

        void read() throws IOException {
            if (debugPos) {
                log.debug("   *MessageGroupInfo start pos= " + H5objects.this.raf.getFilePointer());
            }
            byte version = H5objects.this.raf.readByte();
            this.flags = H5objects.this.raf.readByte();
            if ((this.flags & 1) != 0) {
                this.maxCompactValue = H5objects.this.raf.readShort();
                this.minDenseValue = H5objects.this.raf.readShort();
            }
            if ((this.flags & 2) != 0) {
                this.estNumEntries = H5objects.this.raf.readShort();
                this.estLengthEntryName = H5objects.this.raf.readShort();
            }
            if (debug1) {
                log.debug("   MessageGroupInfo version= " + version + " flags = " + this.flags + this);
            }
        }

        @Override
        public String getName() {
            return "";
        }
    }

    class MessageGroupNew
    implements Named {
        long maxCreationIndex = -2L;
        long fractalHeapAddress;
        long v2BtreeAddress;
        long v2BtreeAddressCreationOrder = -2L;

        MessageGroupNew() {
        }

        public String toString() {
            Formatter f = new Formatter();
            f.format("   GroupNew fractalHeapAddress=%d v2BtreeAddress=%d ", this.fractalHeapAddress, this.v2BtreeAddress);
            if (this.v2BtreeAddressCreationOrder > -2L) {
                f.format(" v2BtreeAddressCreationOrder=%d ", this.v2BtreeAddressCreationOrder);
            }
            if (this.maxCreationIndex > -2L) {
                f.format(" maxCreationIndex=%d", this.maxCreationIndex);
            }
            f.format(" %n%n", new Object[0]);
            if (this.fractalHeapAddress > 0L) {
                try {
                    f.format("%n%n", new Object[0]);
                    FractalHeap fractalHeap = new FractalHeap(H5objects.this.header, "", this.fractalHeapAddress, H5objects.this.memTracker);
                    fractalHeap.showDetails(f);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return f.toString();
        }

        void read() throws IOException {
            if (debugPos) {
                log.debug("   *MessageGroupNew start pos= " + H5objects.this.raf.getFilePointer());
            }
            byte version = H5objects.this.raf.readByte();
            byte flags = H5objects.this.raf.readByte();
            if ((flags & 1) != 0) {
                this.maxCreationIndex = H5objects.this.raf.readLong();
            }
            this.fractalHeapAddress = H5objects.this.header.readOffset();
            this.v2BtreeAddress = H5objects.this.header.readOffset();
            if ((flags & 2) != 0) {
                this.v2BtreeAddressCreationOrder = H5objects.this.header.readOffset();
            }
            if (debug1) {
                log.debug("   MessageGroupNew version= " + version + " flags = " + flags + this);
            }
        }

        @Override
        public String getName() {
            return Long.toString(this.fractalHeapAddress);
        }
    }

    class MessageGroup
    implements Named {
        long btreeAddress;
        long nameHeapAddress;

        MessageGroup() {
        }

        void read() throws IOException {
            this.btreeAddress = H5objects.this.header.readOffset();
            this.nameHeapAddress = H5objects.this.header.readOffset();
            if (debug1) {
                log.debug("   Group btreeAddress=" + this.btreeAddress + " nameHeapAddress=" + this.nameHeapAddress);
            }
        }

        public String toString() {
            return " btreeAddress=" + this.btreeAddress + " nameHeapAddress=" + this.nameHeapAddress;
        }

        @Override
        public String getName() {
            return Long.toString(this.btreeAddress);
        }
    }

    public class MessageDataspace
    implements Named {
        byte ndims;
        byte flags;
        byte type;
        int[] dimLength;
        int[] maxLength;

        @Override
        public String getName() {
            StringBuilder sbuff = new StringBuilder();
            sbuff.append("(");
            for (int size : this.dimLength) {
                sbuff.append(size).append(",");
            }
            sbuff.append(")");
            return sbuff.toString();
        }

        public String toString() {
            Formatter sbuff = new Formatter();
            sbuff.format(" ndims=%d flags=%x type=%d ", this.ndims, this.flags, this.type);
            if (this.dimLength != null) {
                sbuff.format(" length=(", new Object[0]);
                for (int size : this.dimLength) {
                    sbuff.format("%d,", size);
                }
                sbuff.format(") ", new Object[0]);
            }
            if (this.maxLength != null) {
                sbuff.format("max=(", new Object[0]);
                for (int aMaxLength : this.maxLength) {
                    sbuff.format("%d,", aMaxLength);
                }
                sbuff.format(")", new Object[0]);
            }
            return sbuff.toString();
        }

        void read() throws IOException {
            int i;
            byte version;
            if (debugPos) {
                log.debug("   *MessageSimpleDataspace start pos= " + H5objects.this.raf.getFilePointer());
            }
            if ((version = H5objects.this.raf.readByte()) == 1) {
                this.ndims = H5objects.this.raf.readByte();
                this.flags = H5objects.this.raf.readByte();
                this.type = (byte)(this.ndims != 0 ? 1 : 0);
                H5objects.this.raf.skipBytes(5);
            } else if (version == 2) {
                this.ndims = H5objects.this.raf.readByte();
                this.flags = H5objects.this.raf.readByte();
                this.type = H5objects.this.raf.readByte();
            } else {
                throw new IllegalStateException("MessageDataspace: unknown version= " + version);
            }
            if (debug1) {
                log.debug("   SimpleDataspace version= " + version + " flags=" + Integer.toBinaryString(this.flags) + " ndims=" + this.ndims + " type=" + this.type);
            }
            this.dimLength = new int[this.ndims];
            for (int i2 = 0; i2 < this.ndims; ++i2) {
                this.dimLength[i2] = (int)H5objects.this.header.readLength();
            }
            boolean hasMax = (this.flags & 1) != 0;
            this.maxLength = new int[this.ndims];
            if (hasMax) {
                for (i = 0; i < this.ndims; ++i) {
                    this.maxLength[i] = (int)H5objects.this.header.readLength();
                }
            } else {
                System.arraycopy(this.dimLength, 0, this.maxLength, 0, this.ndims);
            }
            if (debug1) {
                for (i = 0; i < this.ndims; ++i) {
                    log.debug("    dim length = " + this.dimLength[i] + " max = " + this.maxLength[i]);
                }
            }
        }
    }

    static interface Named {
        public String getName();
    }

    public class HeaderMessage
    implements Comparable<HeaderMessage> {
        long start;
        byte headerMessageFlags;
        int size;
        short type;
        short header_length;
        Named messData;
        MessageType mtype;
        short creationOrder = (short)-1;

        public MessageType getMtype() {
            return this.mtype;
        }

        public String getName() {
            return this.messData.getName();
        }

        public int getSize() {
            return this.size;
        }

        public short getType() {
            return this.type;
        }

        public byte getFlags() {
            return this.headerMessageFlags;
        }

        public long getStart() {
            return this.start;
        }

        int read(long filePos, int version, boolean creationOrderPresent, String objectName) throws IOException {
            this.start = filePos;
            H5objects.this.raf.seek(filePos);
            if (debugPos) {
                log.debug("  --> Message Header starts at =" + H5objects.this.raf.getFilePointer());
            }
            if (version == 1) {
                this.type = H5objects.this.raf.readShort();
                this.size = DataType.unsignedShortToInt(H5objects.this.raf.readShort());
                this.headerMessageFlags = H5objects.this.raf.readByte();
                H5objects.this.raf.skipBytes(3);
                this.header_length = (short)8;
            } else {
                this.type = H5objects.this.raf.readByte();
                this.size = DataType.unsignedShortToInt(H5objects.this.raf.readShort());
                this.headerMessageFlags = H5objects.this.raf.readByte();
                this.header_length = (short)4;
                if (creationOrderPresent) {
                    this.creationOrder = H5objects.this.raf.readShort();
                    this.header_length = (short)(this.header_length + 2);
                }
            }
            this.mtype = MessageType.getType(this.type);
            if (debug1) {
                log.debug("  -->" + this.mtype + " messageSize=" + this.size + " flags = " + Integer.toBinaryString(this.headerMessageFlags));
                if (creationOrderPresent && debugCreationOrder) {
                    log.debug("     creationOrder = " + this.creationOrder);
                }
            }
            if (debugPos) {
                log.debug("  --> Message Data starts at=" + H5objects.this.raf.getFilePointer());
            }
            if ((this.headerMessageFlags & 2) != 0) {
                this.messData = ((H5objects)H5objects.this).getSharedDataObject((MessageType)this.mtype).mdt;
                return this.header_length + this.size;
            }
            if (this.mtype != MessageType.NIL) {
                if (this.mtype == MessageType.SimpleDataspace) {
                    MessageDataspace data = new MessageDataspace();
                    data.read();
                    this.messData = data;
                } else if (this.mtype == MessageType.GroupNew) {
                    MessageGroupNew data = new MessageGroupNew();
                    data.read();
                    this.messData = data;
                } else if (this.mtype == MessageType.Datatype) {
                    MessageDatatype data = new MessageDatatype();
                    data.read(objectName);
                    this.messData = data;
                } else if (this.mtype == MessageType.FillValueOld) {
                    MessageFillValueOld data = new MessageFillValueOld();
                    data.read();
                    this.messData = data;
                } else if (this.mtype == MessageType.FillValue) {
                    MessageFillValue data = new MessageFillValue();
                    data.read();
                    this.messData = data;
                } else if (this.mtype == MessageType.Link) {
                    MessageLink data = new MessageLink();
                    data.read();
                    this.messData = data;
                } else if (this.mtype == MessageType.Layout) {
                    MessageLayout data = new MessageLayout();
                    data.read();
                    this.messData = data;
                } else if (this.mtype == MessageType.GroupInfo) {
                    MessageGroupInfo data = new MessageGroupInfo();
                    data.read();
                    this.messData = data;
                } else if (this.mtype == MessageType.FilterPipeline) {
                    MessageFilter data = new MessageFilter();
                    data.read();
                    this.messData = data;
                } else if (this.mtype == MessageType.Attribute) {
                    MessageAttribute data = new MessageAttribute();
                    data.read(H5objects.this.raf.getFilePointer());
                    this.messData = data;
                } else if (this.mtype == MessageType.Comment) {
                    MessageComment data = new MessageComment();
                    data.read();
                    this.messData = data;
                } else if (this.mtype == MessageType.LastModifiedOld) {
                    MessageLastModifiedOld data = new MessageLastModifiedOld();
                    data.read();
                    this.messData = data;
                } else if (this.mtype == MessageType.ObjectHeaderContinuation) {
                    MessageContinue data = new MessageContinue();
                    data.read();
                    this.messData = data;
                } else if (this.mtype == MessageType.Group) {
                    MessageGroup data = new MessageGroup();
                    data.read();
                    this.messData = data;
                } else if (this.mtype == MessageType.LastModified) {
                    MessageLastModified data = new MessageLastModified();
                    data.read();
                    this.messData = data;
                } else if (this.mtype == MessageType.AttributeInfo) {
                    MessageAttributeInfo data = new MessageAttributeInfo();
                    data.read();
                    this.messData = data;
                } else if (this.mtype == MessageType.ObjectReferenceCount) {
                    MessageObjectReferenceCount data = new MessageObjectReferenceCount();
                    data.read();
                    this.messData = data;
                } else {
                    log.debug("****UNPROCESSED MESSAGE type = " + this.mtype + " raw = " + this.type);
                    log.warn("SKIP UNPROCESSED MESSAGE type = " + this.mtype + " raw = " + this.type);
                }
            }
            return this.header_length + this.size;
        }

        @Override
        public int compareTo(HeaderMessage o) {
            return Short.compare(this.type, o.type);
        }

        public String toString() {
            return "message type = " + this.mtype + "; " + this.messData;
        }

        public void showFractalHeap(Formatter f) {
            if (this.mtype != MessageType.AttributeInfo) {
                f.format("No fractal heap", new Object[0]);
                return;
            }
            MessageAttributeInfo info = (MessageAttributeInfo)this.messData;
            info.showFractalHeap(f);
        }

        public void showCompression(Formatter f) {
            if (this.mtype != MessageType.AttributeInfo) {
                f.format("No fractal heap", new Object[0]);
                return;
            }
            MessageAttributeInfo info = (MessageAttributeInfo)this.messData;
            info.showFractalHeap(f);
        }
    }

    public static class MessageType {
        private static int MAX_MESSAGE = 23;
        private static Map<String, MessageType> hash = new HashMap<String, MessageType>(10);
        private static MessageType[] mess = new MessageType[MAX_MESSAGE];
        public static final MessageType NIL = new MessageType("NIL", 0);
        public static final MessageType SimpleDataspace = new MessageType("SimpleDataspace", 1);
        public static final MessageType GroupNew = new MessageType("GroupNew", 2);
        public static final MessageType Datatype = new MessageType("Datatype", 3);
        public static final MessageType FillValueOld = new MessageType("FillValueOld", 4);
        public static final MessageType FillValue = new MessageType("FillValue", 5);
        public static final MessageType Link = new MessageType("Link", 6);
        public static final MessageType ExternalDataFiles = new MessageType("ExternalDataFiles", 7);
        public static final MessageType Layout = new MessageType("Layout", 8);
        public static final MessageType GroupInfo = new MessageType("GroupInfo", 10);
        public static final MessageType FilterPipeline = new MessageType("FilterPipeline", 11);
        public static final MessageType Attribute = new MessageType("Attribute", 12);
        public static final MessageType Comment = new MessageType("Comment", 13);
        public static final MessageType LastModifiedOld = new MessageType("LastModifiedOld", 14);
        public static final MessageType SharedObject = new MessageType("SharedObject", 15);
        public static final MessageType ObjectHeaderContinuation = new MessageType("ObjectHeaderContinuation", 16);
        public static final MessageType Group = new MessageType("Group", 17);
        public static final MessageType LastModified = new MessageType("LastModified", 18);
        public static final MessageType AttributeInfo = new MessageType("AttributeInfo", 21);
        public static final MessageType ObjectReferenceCount = new MessageType("ObjectReferenceCount", 22);
        private String name;
        private int num;

        private MessageType(String name, int num) {
            this.name = name;
            this.num = num;
            hash.put(name, this);
            MessageType.mess[num] = this;
        }

        public static MessageType getType(String name) {
            if (name == null) {
                return null;
            }
            return hash.get(name);
        }

        public static MessageType getType(int num) {
            if (num < 0 || num >= MAX_MESSAGE) {
                return null;
            }
            return mess[num];
        }

        public String toString() {
            return this.name + "(" + this.num + ")";
        }

        public int getNum() {
            return this.num;
        }
    }

    public class DataObject
    implements Named {
        long address;
        String who;
        List<HeaderMessage> messages = new ArrayList<HeaderMessage>();
        List<MessageAttribute> attributes = new ArrayList<MessageAttribute>();
        MessageGroup groupMessage;
        MessageGroupNew groupNewMessage;
        MessageDatatype mdt;
        MessageDataspace mds;
        MessageLayout msl;
        MessageFilter mfp;
        byte version;

        public long getAddress() {
            return this.address;
        }

        @Override
        public String getName() {
            return this.who;
        }

        public List<HeaderMessage> getMessages() {
            ArrayList<HeaderMessage> result = new ArrayList<HeaderMessage>(100);
            for (HeaderMessage m3 : this.messages) {
                if (m3.messData instanceof MessageAttribute) continue;
                result.add(m3);
            }
            return result;
        }

        public List<MessageAttribute> getAttributes() {
            return this.attributes;
        }

        public void show(Formatter f) {
            if (this.mdt != null) {
                f.format("%s ", this.mdt.getType());
            }
            f.format("%s", this.getName());
            if (this.mds != null) {
                f.format("(", new Object[0]);
                for (int len : this.mds.dimLength) {
                    f.format("%d,", len);
                }
                f.format(");%n", new Object[0]);
            }
            f.format("%n", new Object[0]);
        }

        private DataObject(long address, String who) throws IOException {
            this.address = address;
            this.who = who;
            if (debug1) {
                log.debug("\n--> DataObject.read parsing <" + who + "> object ID/address=" + address);
            }
            if (debugPos) {
                log.debug("      DataObject.read now at position=" + H5objects.this.raf.getFilePointer() + " for <" + who + "> reposition to " + H5objects.this.header.getFileOffset(address));
            }
            H5objects.this.raf.seek(H5objects.this.header.getFileOffset(address));
            this.version = H5objects.this.raf.readByte();
            if (this.version == 1) {
                H5objects.this.raf.readByte();
                short nmess = H5objects.this.raf.readShort();
                if (debugDetail) {
                    log.debug(" version=" + this.version + " nmess=" + nmess);
                }
                int referenceCount = H5objects.this.raf.readInt();
                int headerSize = H5objects.this.raf.readInt();
                if (debugDetail) {
                    log.debug(" referenceCount=" + referenceCount + " headerSize=" + headerSize);
                }
                H5objects.this.raf.skipBytes(4);
                long posMess = H5objects.this.raf.getFilePointer();
                int count = this.readMessagesVersion1(posMess, nmess, Integer.MAX_VALUE, this.who);
                if (debugContinueMessage) {
                    log.debug(" nmessages read = {}", (Object)count);
                }
                if (debugPos) {
                    log.debug("<--done reading messages for <" + who + ">; position=" + H5objects.this.raf.getFilePointer());
                }
                if (debugTracker) {
                    H5objects.this.memTracker.addByLen("Object " + who, H5objects.this.header.getFileOffset(address), headerSize + 16);
                }
            } else {
                String magic = H5objects.this.raf.readString(3);
                if (!magic.equals("HDR")) {
                    throw new IllegalStateException("DataObject doesnt start with OHDR");
                }
                this.version = H5objects.this.raf.readByte();
                byte flags = H5objects.this.raf.readByte();
                if (debugDetail) {
                    log.debug(" version=" + this.version + " flags=" + Integer.toBinaryString(flags));
                }
                if ((flags >> 5 & 1) == 1) {
                    int accessTime = H5objects.this.raf.readInt();
                    int modTime = H5objects.this.raf.readInt();
                    int changeTime = H5objects.this.raf.readInt();
                    int n = H5objects.this.raf.readInt();
                }
                if ((flags >> 4 & 1) == 1) {
                    short maxCompactAttributes = H5objects.this.raf.readShort();
                    short s2 = H5objects.this.raf.readShort();
                }
                long sizeOfChunk = H5objects.this.readVariableSizeFactor(flags & 3);
                if (debugDetail) {
                    log.debug(" sizeOfChunk=" + sizeOfChunk);
                }
                long posMess = H5objects.this.raf.getFilePointer();
                int count = this.readMessagesVersion2(posMess, sizeOfChunk, (flags & 4) != 0, this.who);
                if (debugContinueMessage) {
                    log.debug(" nmessages read = {}", (Object)count);
                }
                if (debugPos) {
                    log.debug("<--done reading messages for <" + who + ">; position=" + H5objects.this.raf.getFilePointer());
                }
            }
            for (HeaderMessage mess : this.messages) {
                if (debugTracker) {
                    H5objects.this.memTracker.addByLen("Message (" + who + ") " + mess.mtype, mess.start, mess.size + 8);
                }
                if (mess.mtype == MessageType.Group) {
                    this.groupMessage = (MessageGroup)mess.messData;
                    continue;
                }
                if (mess.mtype == MessageType.GroupNew) {
                    this.groupNewMessage = (MessageGroupNew)mess.messData;
                    continue;
                }
                if (mess.mtype == MessageType.SimpleDataspace) {
                    this.mds = (MessageDataspace)mess.messData;
                    continue;
                }
                if (mess.mtype == MessageType.Datatype) {
                    this.mdt = (MessageDatatype)mess.messData;
                    continue;
                }
                if (mess.mtype == MessageType.Layout) {
                    this.msl = (MessageLayout)mess.messData;
                    continue;
                }
                if (mess.mtype == MessageType.FilterPipeline) {
                    this.mfp = (MessageFilter)mess.messData;
                    continue;
                }
                if (mess.mtype == MessageType.Attribute) {
                    this.attributes.add((MessageAttribute)mess.messData);
                    continue;
                }
                if (mess.mtype != MessageType.AttributeInfo) continue;
                this.processAttributeInfoMessage((MessageAttributeInfo)mess.messData, this.attributes);
            }
            if (debug1) {
                log.debug("<-- end DataObject {}", (Object)who);
            }
        }

        private void processAttributeInfoMessage(MessageAttributeInfo attInfo, List<MessageAttribute> list) throws IOException {
            long btreeAddress;
            long l = btreeAddress = attInfo.v2BtreeAddressCreationOrder > 0L ? attInfo.v2BtreeAddressCreationOrder : attInfo.v2BtreeAddress;
            if (btreeAddress < 0L || attInfo.fractalHeapAddress < 0L) {
                return;
            }
            BTree2 btree = new BTree2(H5objects.this.header, this.who, btreeAddress);
            FractalHeap fractalHeap = new FractalHeap(H5objects.this.header, this.who, attInfo.fractalHeapAddress, H5objects.this.memTracker);
            block4: for (BTree2.Entry2 e : btree.entryList) {
                FractalHeap.DHeapId fractalHeapId;
                long pos;
                byte[] heapId;
                switch (btree.btreeType) {
                    case 8: {
                        heapId = ((BTree2.Record8)e.record).getHeapId();
                        break;
                    }
                    case 9: {
                        heapId = ((BTree2.Record9)e.record).getHeapId();
                        break;
                    }
                    default: {
                        continue block4;
                    }
                }
                if ((pos = (fractalHeapId = fractalHeap.getFractalHeapId(heapId)).getPos()) <= 0L) continue;
                MessageAttribute attMessage = new MessageAttribute();
                if (attMessage.read(pos)) {
                    list.add(attMessage);
                }
                if (!debugBtree2) continue;
                log.debug("    attMessage={}", (Object)attMessage);
            }
        }

        private int readMessagesVersion1(long pos, int maxMess, int maxBytes, String objectName) throws IOException {
            if (debugContinueMessage) {
                log.debug(" readMessages start at =" + pos + " maxMess= " + maxMess + " maxBytes= " + maxBytes);
            }
            int count = 0;
            int bytesRead = 0;
            while (count < maxMess && bytesRead < maxBytes) {
                HeaderMessage mess = new HeaderMessage();
                int n = mess.read(pos, 1, false, objectName);
                pos += (long)n;
                bytesRead += n;
                ++count;
                if (debugContinueMessage) {
                    log.debug("   count=" + count + " bytesRead=" + bytesRead);
                }
                if (mess.mtype == MessageType.ObjectHeaderContinuation) {
                    MessageContinue c = (MessageContinue)mess.messData;
                    if (debugContinueMessage) {
                        log.debug(" ---ObjectHeaderContinuation--- ");
                    }
                    count += this.readMessagesVersion1(H5objects.this.header.getFileOffset(c.offset), maxMess - count, (int)c.length, objectName);
                    if (!debugContinueMessage) continue;
                    log.debug(" ---ObjectHeaderContinuation return --- ");
                    continue;
                }
                if (mess.mtype == MessageType.NIL) continue;
                this.messages.add(mess);
            }
            return count;
        }

        private int readMessagesVersion2(long filePos, long maxBytes, boolean creationOrderPresent, String objectName) throws IOException {
            if (debugContinueMessage) {
                H5objects.this.debugOut.println(" readMessages2 starts at =" + filePos + " maxBytes= " + maxBytes);
            }
            maxBytes -= 3L;
            int count = 0;
            int bytesRead = 0;
            while ((long)bytesRead < maxBytes) {
                HeaderMessage mess = new HeaderMessage();
                int n = mess.read(filePos, 2, creationOrderPresent, objectName);
                filePos += (long)n;
                bytesRead += n;
                ++count;
                if (debugContinueMessage) {
                    H5objects.this.debugOut.println("   mess size=" + n + " bytesRead=" + bytesRead + " maxBytes=" + maxBytes);
                }
                if (mess.mtype == MessageType.ObjectHeaderContinuation) {
                    MessageContinue c = (MessageContinue)mess.messData;
                    long continuationBlockFilePos = H5objects.this.header.getFileOffset(c.offset);
                    if (debugContinueMessage) {
                        H5objects.this.debugOut.println(" ---ObjectHeaderContinuation filePos= " + continuationBlockFilePos);
                    }
                    H5objects.this.raf.seek(continuationBlockFilePos);
                    String sig = H5objects.this.readStringFixedLength(4);
                    if (!sig.equals("OCHK")) {
                        throw new IllegalStateException(" ObjectHeaderContinuation Missing signature");
                    }
                    count += this.readMessagesVersion2(continuationBlockFilePos + 4L, (int)c.length - 8, creationOrderPresent, objectName);
                    if (debugContinueMessage) {
                        H5objects.this.debugOut.println(" ---ObjectHeaderContinuation return --- ");
                    }
                    if (!debugContinueMessage) continue;
                    H5objects.this.debugOut.println("   continuationMessages =" + count + " bytesRead=" + bytesRead + " maxBytes=" + maxBytes);
                    continue;
                }
                if (mess.mtype == MessageType.NIL) continue;
                this.messages.add(mess);
            }
            return count;
        }
    }

    class H5Group {
        H5Group parent;
        String name;
        String displayName;
        DataObjectFacade facade;
        List<DataObjectFacade> nestedObjects = new ArrayList<DataObjectFacade>();
        Map<String, Dimension> dimMap = new HashMap<String, Dimension>();
        List<Dimension> dimList = new ArrayList<Dimension>();

        private H5Group(DataObjectFacade facade) throws IOException {
            this.facade = facade;
            this.parent = facade.parent;
            this.name = facade.name;
            String string = this.displayName = this.name.isEmpty() ? "root" : this.name;
            if (facade.dobj.groupMessage != null) {
                if (debugHardLink) {
                    log.debug("HO look for group address = {}", (Object)facade.dobj.groupMessage.btreeAddress);
                }
                if (null != (facade.group = (H5Group)H5objects.this.hashGroups.get(facade.dobj.groupMessage.btreeAddress))) {
                    if (debugHardLink) {
                        log.debug("WARNING hard link to group = {}", (Object)facade.group.getName());
                    }
                    if (this.parent.isChildOf(facade.group)) {
                        if (debugHardLink) {
                            log.debug("ERROR hard link to group create a loop = {}", (Object)facade.group.getName());
                        }
                        log.debug("Remove hard link to group that creates a loop = {}", (Object)facade.group.getName());
                        facade.group = null;
                        return;
                    }
                }
                H5objects.this.readGroupOld(this, facade.dobj.groupMessage.btreeAddress, facade.dobj.groupMessage.nameHeapAddress);
            } else if (facade.dobj.groupNewMessage != null) {
                H5objects.this.readGroupNew(this, facade.dobj.groupNewMessage, facade.dobj);
            } else {
                throw new IllegalStateException("H5Group needs group messages " + facade.getName());
            }
            facade.group = this;
        }

        String getName() {
            return this.parent == null ? this.name : this.parent.getName() + "/" + this.name;
        }

        boolean isChildOf(H5Group that) {
            if (this.parent == null) {
                return false;
            }
            if (this.parent == that) {
                return true;
            }
            return this.parent.isChildOf(that);
        }

        public String toString() {
            return this.displayName;
        }
    }

    class DataObjectFacade {
        H5Group parent;
        String name;
        String displayName;
        DataObject dobj;
        boolean isGroup;
        boolean isVariable;
        boolean isTypedef;
        boolean is2DCoordinate;
        boolean hasNetcdfDimensions;
        H5Group group;
        String dimList;
        String linkName;

        DataObjectFacade(H5Group parent, String name, String linkName) {
            this.parent = parent;
            this.name = name;
            this.linkName = linkName;
        }

        DataObjectFacade(H5Group parent, String name, long address) throws IOException {
            this.parent = parent;
            this.name = name;
            this.displayName = name.isEmpty() ? "root" : name;
            this.dobj = H5objects.this.header.getDataObject(address, this.displayName);
            H5objects.this.header.addSymlinkMap(this.getName(), this);
            if (this.dobj.groupMessage != null || this.dobj.groupNewMessage != null) {
                this.isGroup = true;
            } else if (this.dobj.mdt != null && this.dobj.msl != null) {
                this.isVariable = true;
            } else if (this.dobj.mdt != null) {
                this.isTypedef = true;
            } else if (warnings) {
                log.warn("WARNING Unknown DataObjectFacade = {}", (Object)this);
            }
        }

        String getName() {
            return this.parent == null ? this.name : this.parent.getName() + "/" + this.name;
        }

        public String toString() {
            StringBuilder sbuff = new StringBuilder();
            sbuff.append(this.getName());
            if (this.dobj == null) {
                sbuff.append(" dobj is NULL! ");
            } else {
                sbuff.append(" id= ").append(this.dobj.address);
                sbuff.append(" messages= ");
                for (HeaderMessage message : this.dobj.messages) {
                    sbuff.append("\n  ").append(message);
                }
            }
            return sbuff.toString();
        }
    }
}

