/* Copyright (C) 2019 Chris Piker, Jeremy Faden
 * 
 * This package, org.autoplot.dfc, is part Autoplot <autoplot.org>.  It provides an
 * interface to the Das2 Federated Catalog (DFC) system.
 *
 * Autoplot is open source
 */

package org.autoplot.fdc;

import java.awt.Image;
import java.awt.Window;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSourceEditorPanel;
import org.autoplot.datasource.URISplit;
import org.das2.catalog.DasNode;
import org.das2.catalog.DasNodeFactory;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

/**
 *
 * @author cwp
 */
public class FedCatSourceEditorPanel extends javax.swing.JPanel 
	implements DataSourceEditorPanel {

	private static final Logger LOGGER = Logger.getLogger("apdss.dc");
	
	private DasNode nodeCur;
	private String sCurUri;
	private ImageIcon iconSiteDefault;
	private FedCatTreeModel catModel;

	/**
	 * Creates new form FedCatSourceEditorPanel
	 */
	public FedCatSourceEditorPanel()
	{
		// Manually scale the default imageIcon for the catalog site display
		// for now this just defaults to a das2 logo, but should load site logos in the
		// future	
		String sDefaultIcon = "/org/das2/catalog/das2_circle.png";
		URL urlIcon = getClass().getResource(sDefaultIcon);
		ImageIcon imageIcon = new ImageIcon(urlIcon);
		Image image = imageIcon.getImage(); 
		Image newimg = image.getScaledInstance(60, 60,  java.awt.Image.SCALE_SMOOTH);
		iconSiteDefault = new ImageIcon(newimg);  // transform it back

		initComponents();
	}

	/**
	 * This method is called from within the constructor to initialize the form. WARNING:
	 * Do NOT modify this code. The content of this method is always regenerated by the
	 * Form Editor.
	 */
	@SuppressWarnings("unchecked")
   // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
   private void initComponents() {
      java.awt.GridBagConstraints gridBagConstraints;

      btnGroupRoot = new javax.swing.ButtonGroup();
      splitPane = new javax.swing.JSplitPane();
      pnlCatalog = new javax.swing.JPanel();
      pnlWhichCat = new javax.swing.JPanel();
      jLabel1 = new javax.swing.JLabel();
      btnMainTree = new javax.swing.JRadioButton();
      btnTestTree = new javax.swing.JRadioButton();
      btnCustomTree = new javax.swing.JRadioButton();
      txtCustomUrl = new javax.swing.JTextField();
      scrPaneCatalog = new javax.swing.JScrollPane();
      treeControl = new javax.swing.JTree();
      lblSiteImage = new javax.swing.JLabel();
      pnlSource = new javax.swing.JPanel();
      lblSrcPath = new javax.swing.JLabel();
      pnlQueryCtrl = new javax.swing.JScrollPane();
      jTextArea1 = new javax.swing.JTextArea();

      setLayout(new java.awt.GridBagLayout());

      splitPane.setDividerLocation(200);
      splitPane.setOrientation(javax.swing.JSplitPane.VERTICAL_SPLIT);
      splitPane.setResizeWeight(0.5);
      splitPane.setMinimumSize(new java.awt.Dimension(100, 100));

      pnlCatalog.setFocusable(false);
      pnlCatalog.setMinimumSize(new java.awt.Dimension(200, 60));
      pnlCatalog.setPreferredSize(new java.awt.Dimension(500, 200));
      pnlCatalog.setLayout(new java.awt.GridBagLayout());

      jLabel1.setText("Catalog:");

      btnGroupRoot.add(btnMainTree);
      btnMainTree.setSelected(true);
      btnMainTree.setText("Main");
      btnMainTree.setNextFocusableComponent(btnTestTree);
      btnMainTree.setRequestFocusEnabled(false);
      btnMainTree.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            btnMainTreeActionPerformed(evt);
         }
      });

      btnGroupRoot.add(btnTestTree);
      btnTestTree.setText("Test");
      btnTestTree.setNextFocusableComponent(btnCustomTree);

      btnGroupRoot.add(btnCustomTree);
      btnCustomTree.setText("Custom");
      btnCustomTree.setNextFocusableComponent(txtCustomUrl);
      btnCustomTree.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            btnCustomTreeActionPerformed(evt);
         }
      });

      txtCustomUrl.setNextFocusableComponent(treeControl);
      txtCustomUrl.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            txtCustomUrlActionPerformed(evt);
         }
      });

      javax.swing.GroupLayout pnlWhichCatLayout = new javax.swing.GroupLayout(pnlWhichCat);
      pnlWhichCat.setLayout(pnlWhichCatLayout);
      pnlWhichCatLayout.setHorizontalGroup(
         pnlWhichCatLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
         .addGroup(pnlWhichCatLayout.createSequentialGroup()
            .addContainerGap()
            .addComponent(jLabel1)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(btnMainTree)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
            .addComponent(btnTestTree)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
            .addComponent(btnCustomTree)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(txtCustomUrl, javax.swing.GroupLayout.DEFAULT_SIZE, 441, Short.MAX_VALUE)
            .addContainerGap())
      );
      pnlWhichCatLayout.setVerticalGroup(
         pnlWhichCatLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
         .addGroup(pnlWhichCatLayout.createSequentialGroup()
            .addContainerGap()
            .addGroup(pnlWhichCatLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
               .addComponent(jLabel1)
               .addComponent(btnMainTree)
               .addComponent(btnTestTree)
               .addComponent(btnCustomTree)
               .addComponent(txtCustomUrl, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
            .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
      );

      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 0;
      gridBagConstraints.gridy = 0;
      gridBagConstraints.gridwidth = 2;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints.ipadx = 278;
      gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
      gridBagConstraints.weightx = 1.0;
      gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
      pnlCatalog.add(pnlWhichCat, gridBagConstraints);

      javax.swing.tree.DefaultMutableTreeNode treeNode1 = new javax.swing.tree.DefaultMutableTreeNode("Reading Catalog ...");
      treeControl.setModel(new javax.swing.tree.DefaultTreeModel(treeNode1));
      treeControl.setNextFocusableComponent(pnlSource);
      scrPaneCatalog.setViewportView(treeControl);

      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 0;
      gridBagConstraints.gridy = 1;
      gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
      gridBagConstraints.ipadx = 4;
      gridBagConstraints.ipady = 4;
      gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
      gridBagConstraints.weightx = 1.0;
      gridBagConstraints.weighty = 1.0;
      gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
      pnlCatalog.add(scrPaneCatalog, gridBagConstraints);

      lblSiteImage.setIcon(iconSiteDefault);
      lblSiteImage.setFocusable(false);
      lblSiteImage.setMaximumSize(new java.awt.Dimension(72, 72));
      lblSiteImage.setPreferredSize(new java.awt.Dimension(72, 72));
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 1;
      gridBagConstraints.gridy = 1;
      gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
      gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 0);
      pnlCatalog.add(lblSiteImage, gridBagConstraints);

      splitPane.setLeftComponent(pnlCatalog);

      pnlSource.setMinimumSize(new java.awt.Dimension(200, 40));
      pnlSource.setPreferredSize(new java.awt.Dimension(500, 200));
      pnlSource.setLayout(new java.awt.GridBagLayout());

      lblSrcPath.setFont(new java.awt.Font("Dialog", 0, 12)); // NOI18N
      lblSrcPath.setText("<html>tag:das2.org,2012:<b>site:/uiowa/juno/wav/survey</b>");
      lblSrcPath.setFocusable(false);
      lblSrcPath.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 0;
      gridBagConstraints.gridy = 0;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints.weightx = 1.0;
      gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
      pnlSource.add(lblSrcPath, gridBagConstraints);

      jTextArea1.setColumns(20);
      jTextArea1.setRows(5);
      jTextArea1.setTabSize(3);
      jTextArea1.setMinimumSize(new java.awt.Dimension(150, 180));
      pnlQueryCtrl.setViewportView(jTextArea1);

      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 0;
      gridBagConstraints.gridy = 1;
      gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
      gridBagConstraints.weightx = 1.0;
      gridBagConstraints.weighty = 1.0;
      gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
      pnlSource.add(pnlQueryCtrl, gridBagConstraints);

      splitPane.setRightComponent(pnlSource);

      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 0;
      gridBagConstraints.gridy = 0;
      gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
      gridBagConstraints.ipadx = 2;
      gridBagConstraints.ipady = 2;
      gridBagConstraints.weightx = 1.0;
      gridBagConstraints.weighty = 1.0;
      gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
      add(splitPane, gridBagConstraints);
   }// </editor-fold>//GEN-END:initComponents

   private void btnMainTreeActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_btnMainTreeActionPerformed
   {//GEN-HEADEREND:event_btnMainTreeActionPerformed
      // TODO add your handling code here:
   }//GEN-LAST:event_btnMainTreeActionPerformed

   private void btnCustomTreeActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_btnCustomTreeActionPerformed
   {//GEN-HEADEREND:event_btnCustomTreeActionPerformed
      // TODO add your handling code here:
   }//GEN-LAST:event_btnCustomTreeActionPerformed

   private void txtCustomUrlActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_txtCustomUrlActionPerformed
   {//GEN-HEADEREND:event_txtCustomUrlActionPerformed
      // TODO add your handling code here:
   }//GEN-LAST:event_txtCustomUrlActionPerformed


   // Variables declaration - do not modify//GEN-BEGIN:variables
   private javax.swing.JRadioButton btnCustomTree;
   private javax.swing.ButtonGroup btnGroupRoot;
   private javax.swing.JRadioButton btnMainTree;
   private javax.swing.JRadioButton btnTestTree;
   private javax.swing.JLabel jLabel1;
   private javax.swing.JTextArea jTextArea1;
   private javax.swing.JLabel lblSiteImage;
   private javax.swing.JLabel lblSrcPath;
   private javax.swing.JPanel pnlCatalog;
   private javax.swing.JScrollPane pnlQueryCtrl;
   private javax.swing.JPanel pnlSource;
   private javax.swing.JPanel pnlWhichCat;
   private javax.swing.JScrollPane scrPaneCatalog;
   private javax.swing.JSplitPane splitPane;
   private javax.swing.JTree treeControl;
   private javax.swing.JTextField txtCustomUrl;
   // End of variables declaration//GEN-END:variables

	// I think I am here because the data source factory rejected the given URL, so now
	// I, the GUI, am asked to deal with it.
	@Override
	public boolean reject(String sFullUri) throws Exception
	{
		// We know how to deal with an empty resource URL, just pull the root nodes
		if(sFullUri.equals("vap+dc:")) return false;
				
		URISplit split = URISplit.parse(sFullUri);
		
		// The split function above will represent the node url as a file item so pull that
		String sCatPath = split.file;
		
		// If this starts with a known das top-branch catalog, or one of it's convienence
		// strings, we can resolve it to something
		if((sCatPath.startsWith(DasNodeFactory.defaultDataPath())) ||
			sCatPath.startsWith("site:") || sCatPath.startsWith("test:") ) return false;
			
		// FIXME:  For regular filesystem URLs I don't know if this URL is bad unless I
		// download the object and inspect it.  But there is no progress monitor here
		// so I'm probably not supposed to do that.  Not sure what to do and so have just
		// copied in code from CdfDataSourceEditoryPanel. --cwp 2019-11-10
		if( split.resourceUri==null) return true;
        
		FileSystem fs = FileSystem.create( 
			DataSetURI.getWebURL( DataSetURI.toUri(split.path) ).toURI()
		);
		return fs.isDirectory( split.file.substring(split.path.length()) );
	}

	
	/** Gather any node definitions that will be needed for the dialog box
	 * 
	 * URI examples that we may have to edit:
	 * 
	 *   vap+dc:tag:das2.org,2012:test:/swri/mars_express/aspera3/els?radius=2,3
	 *   vap+dc:site:/uiowa/juno/survey/wav/das2?band=LFRL&time=2017-01-01,2017-01-02,60
	 *   vap+dc:http://random.site.edu/~person/mysource.json?some_key=some_value
	 * 
	 * @param sFullUri The full Autoplot URI, examples above
	 * @param parent   The window parent, in case we need to pop a dlg with a cancel button
	 * @param mon      A progress monitor
	 * @return true, since at present there is no way to cancel
	 * @throws Exception 
	 */
	@Override
	public boolean prepare(String sFullUri, Window parent, ProgressMonitor mon) 
		throws Exception
	{
		sCurUri = sFullUri;  // Save off the full uri as a sanity check in setURI to make
		                     // sure I've prepared for the right thing
		
		String sNodeUrl = DasNodeFactory.defaultDataPath();
		URISplit split = URISplit.parse(sFullUri);
		if(! sFullUri.equals("vap+dc:")) sNodeUrl = split.file;
		
		
		// Try to get a node definition, this version will fail if there is a system 
		// that selects das2 catalog node definitions using HTTP GET parameters, as these
		// will be interpreted as data select parameters.
		nodeCur = DasNodeFactory.getNearestNode(sNodeUrl, mon, false /*don't force reload ?*/);
		
		// Decide if the catalog pane will be turned on or not.  It is turned on
		// for anything that can have children.  Furthermore decide which of the 
		// radio buttons will be selected.
		if(nodeCur.isDir()){
			pnlCatalog.setVisible(true);
			
			// If the root of this node is not the one and only global root, then
			// it's a detached node
			DasNode theRoot = DasNodeFactory.getNode(null, mon, false);
			
			if(nodeCur.getRoot() != theRoot){
				btnCustomTree.setSelected(true);
				txtCustomUrl.setText(split.surl);
			}
			else{
				txtCustomUrl.setEnabled(false);
				String sPath = nodeCur.path();
				btnMainTree.setSelected(sPath.startsWith(DasNodeFactory.defaultDataPath()));
				btnTestTree.setSelected(sPath.startsWith(DasNodeFactory.defaultTestPath()));
			}
			
			// Directory nodes need a tree model, start it at this node's root
			catModel = new FedCatTreeModel(nodeCur.getRoot());
			treeControl.setModel(catModel);
		}
		
		// Source nodes that are detached don't need the catalog display
		if(nodeCur.isSrc()){
			if(nodeCur.isRoot()){ 
				// Detached source node, no need for catalog panel or path display
				pnlCatalog.setVisible(false);
				lblSrcPath.setText("");
				lblSrcPath.setVisible(false);
			}
			else{
				lblSrcPath.setText(nodeCur.path());
				lblSrcPath.setVisible(true);
				
				// This source is attached to something, fill in the tree up to it's root.
				catModel = new FedCatTreeModel(nodeCur.getRoot());
				treeControl.setModel(catModel);
			}
		}
		
		return true;
	}

	/** Provides a starting full URI to the editor and trigger a runnable to show the
	 * editor GUI.
	 * 
	 * In general both the catalog panel and the source options panel are displayed
	 * together, however if this is a standalone root of type source, that has no 
	 * parents, then only the source controls are displayed
	 * @param sFullUri
	 */
	@Override
	public void setURI(String sFullUri)
	{
		assert sFullUri.equals(sCurUri) : "URI changed after prepare";
		
		boolean bDebugRestStop = true;
		//Map<String,String> parts = FedCatSourceFactory.splitDasCatUri(sFullUri);
		
		
		
		
		 
	}

	@Override
	public void markProblems(List<String> problems)
	{
		// TODO: Add and problems with the URL you wish to specify.  For now,
		// we surely have no problems ;) 
	}

	@Override
	public JPanel getPanel()
	{
		return this;
	}

	@Override
	public String getURI()
	{
		throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
	}
}
