
/*
 * BinaryDataSourceFormatEditorPanel.java
 *
 * Created on Jul 18, 2011, 4:43:42 PM
 */
package org.autoplot.wav;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JPanel;
import org.das2.datum.LoggerManager;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.DataSourceFormatEditorPanel;

/**
 *
 * @author jbf
 */
public class WavDataSourceFormatEditorPanel extends javax.swing.JPanel implements DataSourceFormatEditorPanel {

    private static final Logger logger= LoggerManager.getLogger("apdss.wav");
    
    /** Creates new form BinaryDataSourceFormatEditorPanel */
    public WavDataSourceFormatEditorPanel() {
        initComponents();
    }

    String file;

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        scaleCB = new javax.swing.JCheckBox();
        jComboBox1 = new javax.swing.JComboBox<>();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        timeScaleTF = new javax.swing.JTextField();
        timetagsCheckbox = new javax.swing.JCheckBox();

        scaleCB.setText("Scale data to utilize full dynamic range");

        jComboBox1.setModel(new javax.swing.DefaultComboBoxModel<>(new String[] { "short: 16 bit signed numbers", "ushort: 16 bit usigned numbers", "int: 32 bit signed numbers", "int24: 24 bit signed numbers" }));

        jLabel1.setText("Data Type:");

        jLabel2.setText("Time scale (2.0 is twice as fast):");

        timeScaleTF.setText("1.0");
        timeScaleTF.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                timeScaleTFActionPerformed(evt);
            }
        });

        timetagsCheckbox.setText("Writing timing metadata as well.");
        timetagsCheckbox.setToolTipText("<html>Write another file next to the file, which shows the DEPEND_0 (Time) offset at indeces.  The file (...ttag.txt) will contain one line per contiguous data chunk.");

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                        .add(scaleCB)
                        .add(layout.createSequentialGroup()
                            .add(jLabel1)
                            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                            .add(jComboBox1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 264, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                        .add(layout.createSequentialGroup()
                            .add(jLabel2)
                            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                            .add(timeScaleTF)))
                    .add(timetagsCheckbox))
                .addContainerGap(21, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(scaleCB)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jComboBox1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel1))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel2)
                    .add(timeScaleTF, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(timetagsCheckbox)
                .addContainerGap(180, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void timeScaleTFActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_timeScaleTFActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_timeScaleTFActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox<String> jComboBox1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JCheckBox scaleCB;
    private javax.swing.JTextField timeScaleTF;
    private javax.swing.JCheckBox timetagsCheckbox;
    // End of variables declaration//GEN-END:variables

    @Override
    public JPanel getPanel() {
        return this;
    }

    private String getParam( Map<String,String> args, String name, String defl ) {
        String s= args.get(name);
        if ( s==null ) {
            return defl;
        } else {
            return s;
        }
    }
    @Override
    public void setURI(String uri) {
        URISplit split= URISplit.parse(uri);
        Map<String,String> args= URISplit.parseParams(split.params);

        String s;
        s= getParam( args,"scale","T");
        scaleCB.setSelected( s.equals("T") );

        s= getParam( args,"timeScale","1.0");
        timeScaleTF.setText(s);
        
        s= getParam( args,"type","short");
        switch (s) {
            case "short":
                jComboBox1.setSelectedIndex(0);
                break;
            case "ushort":
                jComboBox1.setSelectedIndex(1);
                break;
            case "int":
                jComboBox1.setSelectedIndex(2);
                break;
            case "int32":
                jComboBox1.setSelectedIndex(3);
                break;
            default:
                break;
        }
        
        s= getParam( args, "timetags", "F" );
        timetagsCheckbox.setSelected( s.equals("T") );

        file= split.file;
    }

    @Override
    public String getURI() {
        String result= file;
        Map<String,String> args= new HashMap();

        if ( !scaleCB.isSelected() ) {
            args.put( "scale", "F" );
        } 
        
        if ( timetagsCheckbox.isSelected() ) {
            args.put( "timetags", "T" );
        }

        double ts;
        try {
            ts= Double.parseDouble( timeScaleTF.getText() );
            args.put( "timeScale", String.valueOf(ts) );
        } catch ( NumberFormatException ex ) {
            logger.warning("unable to parse timeScale");
        }

        String s;
        if ( jComboBox1.getSelectedIndex()>0 ) {
            s= (String)jComboBox1.getSelectedItem();
            int i= s.indexOf(":");
            s= s.substring(0,i);
            args.put( "type",s );
        }
        
        String params= URISplit.formatParams(args);
        if ( result==null ) result= "file:///";
        URISplit ss= URISplit.parse(result);

        if ( params.length()>0 ) {
            ss.params= params;
        }
        return URISplit.format( ss );

    }

}
