/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.misc;

import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.misc.AbstractPrivilegesAction;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;

public class RequestPrivilegesAction
extends AbstractPrivilegesAction {
    private boolean obtainIfAdminWin = true;
    private boolean obtainIfNormalWin = false;
    private boolean failIfNotObtainedWin = true;
    private boolean obtainIfAdminMac = false;
    private boolean obtainIfNormalMac = false;
    private boolean failIfNotObtainedMac = true;
    private boolean failIfNotRootUnix = false;
    private boolean updateInstallationDirectory = true;

    public boolean isObtainIfAdminWin() {
        return this.obtainIfAdminWin;
    }

    public void setObtainIfAdminWin(boolean obtainIfAdminWin) {
        this.obtainIfAdminWin = obtainIfAdminWin;
    }

    public boolean isObtainIfNormalWin() {
        return this.obtainIfNormalWin;
    }

    public void setObtainIfNormalWin(boolean obtainIfNormalWin) {
        this.obtainIfNormalWin = obtainIfNormalWin;
    }

    public boolean isFailIfNotObtainedWin() {
        return this.failIfNotObtainedWin;
    }

    public void setFailIfNotObtainedWin(boolean failIfNotObtainedWin) {
        this.failIfNotObtainedWin = failIfNotObtainedWin;
    }

    public boolean isObtainIfAdminMac() {
        return this.obtainIfAdminMac;
    }

    public void setObtainIfAdminMac(boolean obtainIfAdminMac) {
        this.obtainIfAdminMac = obtainIfAdminMac;
    }

    public boolean isObtainIfNormalMac() {
        return this.obtainIfNormalMac;
    }

    public void setObtainIfNormalMac(boolean obtainIfNormalMac) {
        this.obtainIfNormalMac = obtainIfNormalMac;
    }

    public boolean isFailIfNotObtainedMac() {
        return this.failIfNotObtainedMac;
    }

    public void setFailIfNotObtainedMac(boolean failIfNotObtainedMac) {
        this.failIfNotObtainedMac = failIfNotObtainedMac;
    }

    public boolean isFailIfNotRootUnix() {
        return this.failIfNotRootUnix;
    }

    public void setFailIfNotRootUnix(boolean failIfNotRootUnix) {
        this.failIfNotRootUnix = failIfNotRootUnix;
    }

    public boolean isUpdateInstallationDirectory() {
        return this.updateInstallationDirectory;
    }

    public void setUpdateInstallationDirectory(boolean updateInstallationDirectory) {
        this.updateInstallationDirectory = updateInstallationDirectory;
    }

    @Override
    public boolean execute(Context context) throws UserCanceledException {
        boolean success = this.requestRights(context);
        if (context instanceof InstallerContext) {
            boolean sufficientRights = HelperCommunication.getInstance().hasElevatedHelper();
            if (!sufficientRights && !(sufficientRights = Util.hasFullAdminRights()) && Util.isMacOS() && !this.isObtainIfAdminMac() && Util.isAdminGroup()) {
                sufficientRights = InstallerConfig.canInstallTo(InstallerConfig.getInstallationDirWithSingleBundle(context.getInstallationDirectory()));
            }
            if (!sufficientRights && !context.getBooleanVariable("sys.resolveUserSpecificInstallationDir")) {
                context.setVariable("sys.resolveUserSpecificInstallationDir", true);
                if (this.isUpdateInstallationDirectory() && !InstallerConfig.canInstallTo(InstallerConfig.getInstallationDirWithSingleBundle(context.getInstallationDirectory()))) {
                    InstallerContext installerContext = (InstallerContext)context;
                    installerContext.setInstallationDirectory(context.getDefaultInstallationDirectory());
                }
            }
        }
        return success;
    }

    private boolean requestRights(Context context) throws UserCanceledException {
        if (Util.isWindows()) {
            return this.executeOnWindows(context);
        }
        if (Util.isMacOS()) {
            return this.executeOnMac(context);
        }
        if (this.failIfNotRootUnix && !Util.hasFullAdminRights()) {
            this.showFailureMessage(context);
            return false;
        }
        return true;
    }

    private boolean executeOnMac(Context context) throws UserCanceledException {
        boolean success = true;
        if (Util.isAdminGroup()) {
            if (this.obtainIfAdminMac) {
                success = Util.hasFullAdminRights() || this.startOnMac(context);
            }
        } else if (this.obtainIfNormalMac) {
            success = this.startOnMac(context);
        }
        if (!success && this.failIfNotObtainedMac) {
            this.showFailureMessage(context);
        }
        return success;
    }

    private boolean executeOnWindows(Context context) throws UserCanceledException {
        boolean success = true;
        if (Util.isAdminGroup()) {
            if (this.obtainIfAdminWin) {
                success = Util.hasFullAdminRights() || this.startOnWindows(context);
            }
        } else if (this.obtainIfNormalWin) {
            success = this.startOnWindows(context);
        }
        if (!success && this.failIfNotObtainedWin) {
            this.showFailureMessage(context);
        }
        return success;
    }

    public boolean isAllRequested() {
        return this.obtainIfAdminWin && this.obtainIfNormalWin && this.obtainIfAdminMac && this.obtainIfNormalMac;
    }

    public void setAllRequested() {
        this.obtainIfAdminWin = true;
        this.obtainIfNormalWin = true;
        this.obtainIfAdminMac = true;
        this.obtainIfNormalMac = true;
        this.failIfNotObtainedWin = true;
        this.failIfNotObtainedMac = true;
        this.failIfNotRootUnix = true;
    }
}

