/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.xml;

import com.install4j.api.beans.ExternalFile;
import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.xml.AbstractModifyMultipleXmlFilesAction;
import com.install4j.runtime.beans.actions.xml.FragmentInsertMode;
import com.install4j.runtime.beans.actions.xml.FragmentSource;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.XmlHelper;
import java.io.File;
import java.io.IOException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InsertXmlFragmentAction
extends AbstractModifyMultipleXmlFilesAction {
    private String xpathExpression;
    private FragmentSource fragmentSource = FragmentSource.DIRECT;
    private String fragmentText = "";
    private ExternalFile fragmentFile;
    private FragmentInsertMode fragmentInsertMode = FragmentInsertMode.FIRST_CHILD;

    public String getXpathExpression() {
        return InsertXmlFragmentAction.replaceVariables(this.xpathExpression);
    }

    public void setXpathExpression(String xpathExpression) {
        this.xpathExpression = xpathExpression;
    }

    public FragmentSource getFragmentSource() {
        return this.fragmentSource;
    }

    public void setFragmentSource(FragmentSource fragmentSource) {
        this.fragmentSource = fragmentSource;
    }

    public String getFragmentText() {
        return InsertXmlFragmentAction.replaceVariables(this.fragmentText);
    }

    public void setFragmentText(String fragmentText) {
        this.fragmentText = fragmentText;
    }

    public FragmentInsertMode getFragmentInsertMode() {
        return this.fragmentInsertMode;
    }

    public void setFragmentFile(ExternalFile fragmentFile) {
        this.fragmentFile = fragmentFile;
    }

    public void setFragmentInsertMode(FragmentInsertMode fragmentInsertMode) {
        this.fragmentInsertMode = fragmentInsertMode;
    }

    public ExternalFile getFragmentFile() {
        return this.fragmentFile;
    }

    @Override
    protected boolean fileMustExist() {
        return true;
    }

    @Override
    protected boolean modifyFile(File file, Context context) throws IOException, UserCanceledException {
        Document document = this.parseFile(file);
        NodeList nodeList = this.applyXpath(document, this.getXpathExpression());
        if (nodeList == null) {
            return false;
        }
        DocumentFragment documentFragment = this.createDocumentFragment(context, document);
        if (documentFragment == null) {
            return false;
        }
        if (!this.modifyDocument(documentFragment, nodeList)) {
            return false;
        }
        XmlHelper.writeFile(file, document);
        return true;
    }

    private boolean modifyDocument(DocumentFragment documentFragment, NodeList nodeList) {
        block7: for (int i = 0; i < nodeList.getLength(); ++i) {
            DocumentFragment fragmentCopy = (DocumentFragment)documentFragment.cloneNode(true);
            Node node = nodeList.item(i);
            switch (this.fragmentInsertMode) {
                case FIRST_CHILD: {
                    node.insertBefore(fragmentCopy, node.getFirstChild());
                    continue block7;
                }
                case LAST_CHILD: {
                    node.appendChild(fragmentCopy);
                    continue block7;
                }
                case BEFORE: {
                    node.getParentNode().insertBefore(fragmentCopy, node);
                    continue block7;
                }
                case AFTER: {
                    Node nextSibling = node.getNextSibling();
                    if (nextSibling == null) {
                        node.getParentNode().appendChild(fragmentCopy);
                        continue block7;
                    }
                    node.getParentNode().insertBefore(fragmentCopy, nextSibling);
                    continue block7;
                }
                case REPLACE: {
                    node.getParentNode().replaceChild(fragmentCopy, node);
                    continue block7;
                }
                default: {
                    throw new RuntimeException(this.fragmentInsertMode.name());
                }
            }
        }
        return true;
    }

    private DocumentFragment createDocumentFragment(Context context, Document targetDocument) throws IOException {
        Document document = this.createFragmentDocument(context);
        if (document == null) {
            return null;
        }
        DocumentFragment documentFragment = document.createDocumentFragment();
        Element rootElement = document.getDocumentElement();
        while (rootElement.hasChildNodes()) {
            documentFragment.appendChild(rootElement.getFirstChild());
        }
        return (DocumentFragment)targetDocument.importNode(documentFragment, true);
    }

    private Document createFragmentDocument(Context context) throws IOException {
        switch (this.fragmentSource) {
            case DIRECT: {
                return this.createDirectFragmentDocument();
            }
            case FILE: {
                return this.createFileFragmentDocument(context);
            }
        }
        throw new RuntimeException(this.fragmentSource.name());
    }

    private Document createDirectFragmentDocument() throws IOException {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<root>");
        buffer.append(this.getFragmentText());
        buffer.append("</root>");
        return XmlHelper.parseString(buffer.toString(), false, false);
    }

    private Document createFileFragmentDocument(Context context) throws IOException {
        File file = context.getExternalFile(this.getFragmentFile(), false);
        if (!file.exists()) {
            Logger.getInstance().log(this, "Fragment file " + file + " does not exist", false);
            return null;
        }
        return XmlHelper.parseFile(file, false, false);
    }
}

