/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.beans.ExternalFile;
import com.install4j.runtime.beans.formcomponents.AbstractLabelComponent;
import com.install4j.runtime.beans.formcomponents.FontStyle;
import com.install4j.runtime.beans.formcomponents.FontType;
import com.install4j.runtime.installer.frontend.GUIHelper;
import java.awt.Color;
import java.awt.Font;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractLabelWithIconComponent
extends AbstractLabelComponent {
    private ExternalFile labelIconFile = null;
    private int iconTextGap = 4;
    private JLabel label;

    public ExternalFile getLabelIconFile() {
        return this.labelIconFile;
    }

    public void setLabelIconFile(ExternalFile labelIconFile) {
        this.labelIconFile = labelIconFile;
    }

    public int getIconTextGap() {
        return this.iconTextGap;
    }

    public void setIconTextGap(int iconTextGap) {
        this.iconTextGap = iconTextGap;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.getLabelText().trim().length() > 0) {
            this.initializeLabel(this.label);
        }
    }

    protected JLabel createLabel() {
        this.label = this.createLabel(this.labelIconFile, this.iconTextGap, this.getLabelColor(), this.getLabelFont(), this.getLabelFontType(), this.getLabelFontStyle(), this.getLabelFontSizePercent());
        return this.label;
    }

    protected JLabel createLabel(ExternalFile labelIconFile, int iconTextGap, Color labelColor, Font labelFont, FontType fontType, FontStyle fontStyle, int fontSizePercent) {
        final JLabel label = new JLabel();
        if (labelIconFile != null) {
            GUIHelper.withIcon(labelIconFile, this.getContext(), new GUIHelper.IconConsumer<Object>(){

                @Override
                public Object call(@NotNull ImageIcon icon) {
                    label.setIcon(icon);
                    return null;
                }
            });
        }
        label.setIconTextGap(iconTextGap);
        this.applyLabelColorAndFont(labelColor, labelFont, fontType, fontStyle, fontSizePercent, label);
        if (this.getLabelText().trim().length() > 0) {
            this.initializeLabel(label);
        }
        return label;
    }

    protected void initializeLabel(JLabel label) {
        String labelText = this.getLabelText();
        this.getFormEnvironment().bindTextWithVariables(labelText, label);
    }

    protected JLabel getLabel() {
        return this.label;
    }
}

