/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper;

import com.install4j.api.events.EventType;
import com.install4j.runtime.installer.helper.LoggerImpl;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.impl.HelperLoggerImpl;
import com.install4j.runtime.util.LauncherLogger;
import java.util.Arrays;
import java.util.List;

public abstract class Logger {
    private static final Logger NULL_INSTANCE = new Logger(){

        @Override
        public void log(Throwable e) {
        }

        @Override
        public void log(Object source, String text, boolean success) {
        }
    };
    private static final Logger SYSTEM_ERR_INSTANCE = new Logger(){

        @Override
        public void log(Throwable e) {
            e.printStackTrace();
        }

        @Override
        public void log(Object source, String text, boolean success) {
            System.err.println(text);
        }
    };
    public static final List LOGGED_EVENT_TYPES = Arrays.asList(EventType.BEFORE_EXECUTE_ACTION, EventType.AFTER_EXECUTE_ACTION, EventType.BEFORE_ROLLBACK_ACTION, EventType.AFTER_ROLLBACK_ACTION, EventType.BEFORE_INSTALL_FILE, EventType.BEFORE_DOWNLOAD, EventType.SHOW_SCREEN, EventType.FINISHED, EventType.CANCELED, EventType.VARIABLE_CHANGED);
    public static final List LOGGED_EVENT_TYPES_FAILURE_ONLY = Arrays.asList(EventType.AFTER_INSTALL_FILE, EventType.AFTER_DOWNLOAD);
    public static final LauncherLogger LAUNCHER_LOGGER = new LauncherLogger(){

        @Override
        public void info(String str) {
            Logger.getInstance().info(null, str);
        }

        @Override
        public void error(String str) {
            Logger.getInstance().error(null, str);
        }

        @Override
        public void error(Throwable throwable) {
            Logger.getInstance().log(throwable);
        }
    };
    private static Logger instance;
    public static final String KEEP_LOGFILE_PROP = "install4j.keepLog";
    public static final String ALTERNATIVE_LOGFILE = "install4j.alternativeLogfile";
    public static final String APPEND_LOG_PROP = "install4j.appendLog";
    public static final String LOGTOSTDERR_FILE_PROP = "install4j.logToStderr";
    public static final String LOG_ENCODING_PROP = "install4j.logEncoding";

    public static Logger getInstance() {
        if (instance == null) {
            instance = HelperCommunication.getInstance().isElevatedHelper() ? new HelperLoggerImpl() : new LoggerImpl();
        }
        return instance;
    }

    public static Logger getExistingInstance() {
        return instance == null ? NULL_INSTANCE : instance;
    }

    public static Logger getDebugInstance() {
        return instance == null ? SYSTEM_ERR_INSTANCE : instance;
    }

    public abstract void log(Throwable var1);

    public abstract void log(Object var1, String var2, boolean var3);

    public void error(Object source, String text) {
        this.log(source, text, false);
    }

    public void info(Object source, String text) {
        this.log(source, text, true);
    }

    public static LoggerImpl getImpl() {
        HelperCommunication.helperUnsupported();
        return (LoggerImpl)Logger.getInstance();
    }

    public static String getUninstallPreviousLogFileName(int logFileIndex) {
        return "uninstallPrevious" + (logFileIndex == 0 ? "" : "." + (logFileIndex + 1)) + ".log";
    }
}

