/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper;

import com.ejt.framework.util.XMLEnum;
import com.install4j.runtime.installer.helper.Logger;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlHelper {
    private static Transformer stringTransformer;

    private XmlHelper() {
    }

    public static Document createDocument() throws IOException {
        try {
            return XmlHelper.createDocumentBuilderFactory().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw XmlHelper.createIoException(e);
        }
    }

    public static Document parseFile(File file) throws IOException {
        return XmlHelper.parseFile(file, false, false);
    }

    public static Document parseFile(File file, boolean validating, boolean downloadExternalEntities) throws IOException {
        return XmlHelper.parse(new InputSource(file.toURI().toASCIIString()), validating, downloadExternalEntities);
    }

    public static Document parse(byte[] data) throws IOException {
        return XmlHelper.parse(new InputSource(new ByteArrayInputStream(data)), false, false);
    }

    private static Document parse(InputSource inputSource, boolean validating, boolean downloadExternalEntities) throws IOException {
        DocumentBuilder documentBuilder;
        DocumentBuilderFactory documentBuilderFactory = XmlHelper.createDocumentBuilderFactory();
        documentBuilderFactory.setValidating(validating);
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw XmlHelper.createIoException(e);
        }
        if (validating) {
            documentBuilder.setErrorHandler(new ErrorHandler(){

                @Override
                public void error(SAXParseException exception) throws SAXException {
                    XmlHelper.log(exception);
                }

                @Override
                public void fatalError(SAXParseException exception) throws SAXException {
                    XmlHelper.log(exception);
                }

                @Override
                public void warning(SAXParseException exception) throws SAXException {
                }
            });
        }
        if (!downloadExternalEntities) {
            documentBuilder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    if (systemId.startsWith("http:/") || systemId.startsWith("https:/")) {
                        return new InputSource(new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>"));
                    }
                    return null;
                }
            });
        }
        try {
            return documentBuilder.parse(inputSource);
        }
        catch (SAXException e) {
            throw XmlHelper.createIoException(e);
        }
    }

    public static Document parseString(String string, boolean validating, boolean downloadExternalEntities) throws IOException {
        return XmlHelper.parse(new InputSource(new StringReader(string)), validating, downloadExternalEntities);
    }

    public static TransformerFactory createTransformerFactory() {
        try {
            return TransformerFactory.newInstance("com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl", null);
        }
        catch (Throwable t) {
            return TransformerFactory.newInstance();
        }
    }

    public static DocumentBuilderFactory createDocumentBuilderFactory() {
        try {
            return DocumentBuilderFactory.newInstance("com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl", null);
        }
        catch (Throwable t) {
            return DocumentBuilderFactory.newInstance();
        }
    }

    public static void writeFile(File file, Document doc) throws IOException {
        try {
            XmlHelper.writeFile(file, doc, XmlHelper.createTransformerFactory().newTransformer());
        }
        catch (TransformerException e) {
            throw XmlHelper.createIoException(e);
        }
    }

    public static void writeFile(File file, Document doc, Transformer transformer) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        XmlHelper.writeToStream(doc, transformer, fos);
    }

    public static byte[] getBytes(Document doc) throws IOException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            XmlHelper.writeToStream(doc, XmlHelper.createTransformerFactory().newTransformer(), out);
            return out.toByteArray();
        }
        catch (TransformerException e) {
            throw XmlHelper.createIoException(e);
        }
    }

    private static void writeToStream(Document doc, Transformer transformer, OutputStream out) throws IOException {
        transformer.setErrorListener(new ErrorListener(){

            @Override
            public void error(TransformerException exception) throws TransformerException {
                XmlHelper.log(exception);
            }

            @Override
            public void fatalError(TransformerException exception) throws TransformerException {
                XmlHelper.log(exception);
            }

            @Override
            public void warning(TransformerException exception) throws TransformerException {
            }
        });
        transformer.setOutputProperty("indent", "yes");
        DocumentType docType = doc.getDoctype();
        if (docType != null && docType.getSystemId() != null) {
            transformer.setOutputProperty("doctype-system", docType.getSystemId());
            String publicId = docType.getPublicId();
            if (publicId != null && publicId.trim().length() > 0) {
                transformer.setOutputProperty("doctype-public", publicId);
            }
        }
        try {
            transformer.transform(new DOMSource(doc), new StreamResult(out));
        }
        catch (TransformerException e) {
            throw XmlHelper.createIoException(e);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static String getString(Element element) throws IOException {
        StringWriter writer = new StringWriter();
        try {
            if (stringTransformer == null) {
                stringTransformer = XmlHelper.createTransformerFactory().newTransformer();
                stringTransformer.setOutputProperty("indent", "no");
                stringTransformer.setOutputProperty("omit-xml-declaration", "yes");
                stringTransformer.setOutputProperty("encoding", "UTF-8");
            }
            stringTransformer.transform(new DOMSource(element), new StreamResult(writer));
            return writer.toString();
        }
        catch (TransformerException e) {
            throw XmlHelper.createIoException(e);
        }
    }

    public static Element findChild(Element element, String elementName) {
        NodeList nodeList = element.getChildNodes();
        int nodeListLength = nodeList.getLength();
        if (nodeListLength == 0) {
            return null;
        }
        for (int i = 0; i < nodeListLength; ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element childElement = (Element)node;
            if (elementName != null && !childElement.getTagName().equals(elementName)) continue;
            return childElement;
        }
        return null;
    }

    public static Iterable<Element> childElements(Element parentElement) {
        if (parentElement == null) {
            return Collections.emptyList();
        }
        NodeList nodeList = parentElement.getChildNodes();
        int nodeListLength = nodeList.getLength();
        ArrayList<Element> childElements = new ArrayList<Element>(nodeListLength);
        for (int i = 0; i < nodeListLength; ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            childElements.add((Element)node);
        }
        return childElements;
    }

    public static String readAttribute(Element element, String attributeName, String defaultValue) {
        if (!element.hasAttribute(attributeName)) {
            attributeName = attributeName.toUpperCase();
        }
        if (element.hasAttribute(attributeName)) {
            return element.getAttribute(attributeName);
        }
        return defaultValue;
    }

    public static String readFileAttribute(Element element, String attributeName, String defaultValue) {
        if (!element.hasAttribute(attributeName)) {
            attributeName = attributeName.toUpperCase();
        }
        if (element.hasAttribute(attributeName)) {
            return element.getAttribute(attributeName).replace('\\', File.separatorChar).replace('/', File.separatorChar);
        }
        return defaultValue;
    }

    public static boolean readAttribute(Element element, String attributeName, boolean defaultValue) {
        if (!element.hasAttribute(attributeName)) {
            attributeName = attributeName.toUpperCase();
        }
        if (element.hasAttribute(attributeName)) {
            return Boolean.parseBoolean(element.getAttribute(attributeName));
        }
        return defaultValue;
    }

    public static int readAttribute(Element element, String attributeName, int defaultValue) {
        if (!element.hasAttribute(attributeName)) {
            attributeName = attributeName.toUpperCase();
        }
        if (element.hasAttribute(attributeName)) {
            return Integer.parseInt(element.getAttribute(attributeName));
        }
        return defaultValue;
    }

    public static long readAttribute(Element element, String attributeName, long defaultValue) {
        if (!element.hasAttribute(attributeName)) {
            attributeName = attributeName.toUpperCase();
        }
        if (element.hasAttribute(attributeName)) {
            return Long.parseLong(element.getAttribute(attributeName));
        }
        return defaultValue;
    }

    public static Color readAttribute(Element element, String attributeName, Color defaultValue) {
        if (!element.hasAttribute(attributeName)) {
            attributeName = attributeName.toUpperCase();
        }
        if (element.hasAttribute(attributeName)) {
            String value = element.getAttribute(attributeName);
            if (value.length() > 0) {
                return new Color(Integer.parseInt(value));
            }
            return null;
        }
        return defaultValue;
    }

    public static <E extends Enum> E readAttribute(Element element, String attributeName, E defaultValue) {
        String value = element.getAttribute(attributeName);
        if (value == null || value.trim().length() == 0) {
            return defaultValue;
        }
        for (Enum xmlEnum : ((XMLEnum)((Object)defaultValue)).getXMLEnums()) {
            if (!Objects.equals(((XMLEnum)((Object)xmlEnum)).getXMLValue(), value)) continue;
            return (E)xmlEnum;
        }
        return defaultValue;
    }

    public static String getTextValue(Element childElement) {
        if (childElement == null) {
            return "";
        }
        Node textNode = childElement.getFirstChild();
        return textNode == null ? "" : textNode.getNodeValue();
    }

    private static IOException createIoException(Exception e) {
        IOException ioException = new IOException();
        ioException.initCause(e);
        return ioException;
    }

    private static void log(Exception exception) {
        Logger.getInstance().error(null, exception.getMessage());
    }

    public static NodeList getNodeList(Document doc, String xpathExpression) {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        try {
            XPathExpression expression = xpath.compile(xpathExpression);
            return (NodeList)expression.evaluate(doc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            Logger.getInstance().log(e);
            return null;
        }
    }

    public static interface XmlElementVisitor {
        public void visit(Element var1);
    }
}

