/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.util.Properties;
import java.util.StringTokenizer;
import org.python.core.PackageManager;
import org.python.core.PyJavaClass;
import org.python.core.PySystemState;

public abstract class InternalTables {
    private static InternalTables tryImpl(String id) {
        try {
            if (id.indexOf(46) < 0) {
                boolean glue = true;
                boolean front = true;
                if (id.charAt(0) == '>') {
                    id = id.substring(1);
                    front = false;
                } else if (id.charAt(id.length() - 1) == '>') {
                    id = id.substring(0, id.length() - 1);
                } else if (!Character.isLowerCase(id.charAt(0))) {
                    glue = false;
                }
                if (glue) {
                    StringBuffer buf = new StringBuffer("org.python.core.");
                    if (!front) {
                        buf.append("InternalTables");
                    }
                    if (Character.isLowerCase(id.charAt(0))) {
                        buf.append(Character.toUpperCase(id.charAt(0)));
                        buf.append(id.substring(1));
                    } else {
                        buf.append(id);
                    }
                    if (front) {
                        buf.append("InternalTables");
                    }
                    id = buf.toString();
                }
            }
            return (InternalTables)Class.forName(id).newInstance();
        }
        catch (Throwable e) {
            return null;
        }
    }

    static InternalTables createInternalTables() {
        String version;
        Properties registry = PySystemState.registry;
        if (registry == null) {
            throw new IllegalStateException("Jython interpreter state not initialized. You need to call PySystemState.initialize or PythonInterpreter.initialize.");
        }
        String cands = registry.getProperty("python.options.internalTablesImpl");
        cands = cands == null ? ((version = System.getProperty("java.version")).compareTo("1.2") >= 0 ? ">2:>1" : ">1") : cands + ":>2:>1";
        StringTokenizer candEnum = new StringTokenizer(cands, ":");
        while (candEnum.hasMoreTokens()) {
            InternalTables tbl = InternalTables.tryImpl(candEnum.nextToken().trim());
            if (tbl == null) continue;
            return tbl;
        }
        return null;
    }

    protected abstract boolean queryCanonical(String var1);

    protected abstract PyJavaClass getCanonical(Class var1);

    protected abstract PyJavaClass getLazyCanonical(String var1);

    protected abstract void putCanonical(Class var1, PyJavaClass var2);

    protected abstract void putLazyCanonical(String var1, PyJavaClass var2);

    protected abstract Class getAdapterClass(Class var1);

    protected abstract void putAdapterClass(Class var1, Class var2);

    protected abstract Object getAdapter(Object var1, String var2);

    protected abstract void putAdapter(Object var1, String var2, Object var3);

    public boolean _doesSomeAutoUnload() {
        return false;
    }

    public void _forceCleanup() {
    }

    public abstract void _beginCanonical();

    public abstract void _beginLazyCanonical();

    public abstract void _beginOverAdapterClasses();

    public abstract void _beginOverAdapters();

    public abstract Object _next();

    public abstract void _flushCurrent();

    public abstract void _flush(PyJavaClass var1);

    public static class _LazyRep {
        public String name;
        public PackageManager mgr;

        _LazyRep(String name, PackageManager mgr) {
            this.name = name;
            this.mgr = mgr;
        }
    }
}

