/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import org.python.core.AbstractArray;
import org.python.core.ArgParser;
import org.python.core.ByteSwapper;
import org.python.core.Py;
import org.python.core.PyArrayDerived;
import org.python.core.PyBuiltinFunction;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyException;
import org.python.core.PyFile;
import org.python.core.PyGetSetDescr;
import org.python.core.PyIgnoreMethodTag;
import org.python.core.PyInteger;
import org.python.core.PyJavaClass;
import org.python.core.PyList;
import org.python.core.PyMethodDescr;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyString;
import org.python.core.PyType;

public class PyArray
extends PySequence
implements Cloneable {
    public static final String exposed_name = "array";
    public static final Class exposed_base = PyObject.class;
    private Object data;
    private Class type;
    private String typecode;
    private ArrayDelegate delegate;

    public static void typeSetup(PyObject dict, PyType.Newstyle marker) {
        class Exposed___ne__
        extends PyBuiltinMethodNarrow {
            Exposed___ne__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___ne__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyArray)this.self).seq___ne__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__ne__", (PyObject)new PyMethodDescr("__ne__", PyArray.class, 1, 1, new Exposed___ne__(null, null)));
        class Exposed___eq__
        extends PyBuiltinMethodNarrow {
            Exposed___eq__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___eq__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyArray)this.self).seq___eq__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__eq__", (PyObject)new PyMethodDescr("__eq__", PyArray.class, 1, 1, new Exposed___eq__(null, null)));
        class Exposed___lt__
        extends PyBuiltinMethodNarrow {
            Exposed___lt__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___lt__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyArray)this.self).seq___lt__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__lt__", (PyObject)new PyMethodDescr("__lt__", PyArray.class, 1, 1, new Exposed___lt__(null, null)));
        class Exposed___le__
        extends PyBuiltinMethodNarrow {
            Exposed___le__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___le__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyArray)this.self).seq___le__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__le__", (PyObject)new PyMethodDescr("__le__", PyArray.class, 1, 1, new Exposed___le__(null, null)));
        class Exposed___gt__
        extends PyBuiltinMethodNarrow {
            Exposed___gt__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___gt__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyArray)this.self).seq___gt__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__gt__", (PyObject)new PyMethodDescr("__gt__", PyArray.class, 1, 1, new Exposed___gt__(null, null)));
        class Exposed___ge__
        extends PyBuiltinMethodNarrow {
            Exposed___ge__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___ge__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyArray)this.self).seq___ge__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__ge__", (PyObject)new PyMethodDescr("__ge__", PyArray.class, 1, 1, new Exposed___ge__(null, null)));
        class Exposed___getitem__
        extends PyBuiltinMethodNarrow {
            Exposed___getitem__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___getitem__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyArray)this.self).seq___finditem__(arg0);
                if (ret == null) {
                    throw Py.IndexError("index out of range: " + arg0);
                }
                return ret;
            }
        }
        dict.__setitem__("__getitem__", (PyObject)new PyMethodDescr("__getitem__", PyArray.class, 1, 1, new Exposed___getitem__(null, null)));
        class Exposed___contains__
        extends PyBuiltinMethodNarrow {
            Exposed___contains__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___contains__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                return Py.newBoolean(((PyArray)this.self).object___contains__(arg0));
            }
        }
        dict.__setitem__("__contains__", (PyObject)new PyMethodDescr("__contains__", PyArray.class, 1, 1, new Exposed___contains__(null, null)));
        class Exposed___delitem__
        extends PyBuiltinMethodNarrow {
            Exposed___delitem__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___delitem__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                ((PyArray)this.self).seq___delitem__(arg0);
                return Py.None;
            }
        }
        dict.__setitem__("__delitem__", (PyObject)new PyMethodDescr("__delitem__", PyArray.class, 1, 1, new Exposed___delitem__(null, null)));
        class Exposed___setitem__
        extends PyBuiltinMethodNarrow {
            Exposed___setitem__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___setitem__(self, this.info);
            }

            public PyObject __call__(PyObject arg0, PyObject arg1) {
                ((PyArray)this.self).seq___setitem__(arg0, arg1);
                return Py.None;
            }
        }
        dict.__setitem__("__setitem__", (PyObject)new PyMethodDescr("__setitem__", PyArray.class, 2, 2, new Exposed___setitem__(null, null)));
        class Exposed___nonzero__
        extends PyBuiltinMethodNarrow {
            Exposed___nonzero__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___nonzero__(self, this.info);
            }

            public PyObject __call__() {
                return Py.newBoolean(((PyArray)this.self).seq___nonzero__());
            }
        }
        dict.__setitem__("__nonzero__", (PyObject)new PyMethodDescr("__nonzero__", PyArray.class, 0, 0, new Exposed___nonzero__(null, null)));
        class Exposed___getslice__
        extends PyBuiltinMethodNarrow {
            Exposed___getslice__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___getslice__(self, this.info);
            }

            public PyObject __call__(PyObject arg0, PyObject arg1, PyObject arg2) {
                return ((PyArray)this.self).seq___getslice__(arg0, arg1, arg2);
            }

            public PyObject __call__(PyObject arg0, PyObject arg1) {
                return ((PyArray)this.self).seq___getslice__(arg0, arg1);
            }
        }
        dict.__setitem__("__getslice__", (PyObject)new PyMethodDescr("__getslice__", PyArray.class, 2, 3, new Exposed___getslice__(null, null)));
        class Exposed___delslice__
        extends PyBuiltinMethodNarrow {
            Exposed___delslice__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___delslice__(self, this.info);
            }

            public PyObject __call__(PyObject arg0, PyObject arg1, PyObject arg2) {
                ((PyArray)this.self).seq___delslice__(arg0, arg1, arg2);
                return Py.None;
            }
        }
        dict.__setitem__("__delslice__", (PyObject)new PyMethodDescr("__delslice__", PyArray.class, 3, 3, new Exposed___delslice__(null, null)));
        class Exposed___setslice__
        extends PyBuiltinMethodNarrow {
            Exposed___setslice__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___setslice__(self, this.info);
            }

            public PyObject __call__(PyObject arg0, PyObject arg1, PyObject arg2, PyObject arg3) {
                ((PyArray)this.self).seq___setslice__(arg0, arg1, arg2, arg3);
                return Py.None;
            }

            public PyObject __call__(PyObject arg0, PyObject arg1, PyObject arg2) {
                ((PyArray)this.self).seq___setslice__(arg0, arg1, arg2);
                return Py.None;
            }
        }
        dict.__setitem__("__setslice__", (PyObject)new PyMethodDescr("__setslice__", PyArray.class, 3, 4, new Exposed___setslice__(null, null)));
        dict.__setitem__("itemsize", (PyObject)new PyGetSetDescr("itemsize", PyArray.class, "getItemsize", null, null));
        dict.__setitem__("typecode", (PyObject)new PyGetSetDescr("typecode", PyArray.class, "getTypecode", null, null));
        class Exposed_append
        extends PyBuiltinMethodNarrow {
            Exposed_append(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed_append(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                ((PyArray)this.self).array_append(arg0);
                return Py.None;
            }
        }
        dict.__setitem__("append", (PyObject)new PyMethodDescr("append", PyArray.class, 1, 1, new Exposed_append(null, null)));
        class Exposed_byteswap
        extends PyBuiltinMethodNarrow {
            Exposed_byteswap(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed_byteswap(self, this.info);
            }

            public PyObject __call__() {
                ((PyArray)this.self).array_byteswap();
                return Py.None;
            }
        }
        dict.__setitem__("byteswap", (PyObject)new PyMethodDescr("byteswap", PyArray.class, 0, 0, new Exposed_byteswap(null, null)));
        class Exposed_count
        extends PyBuiltinMethodNarrow {
            Exposed_count(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed_count(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                return Py.newInteger(((PyArray)this.self).array_count(arg0));
            }
        }
        dict.__setitem__("count", (PyObject)new PyMethodDescr("count", PyArray.class, 1, 1, new Exposed_count(null, null)));
        class Exposed_extend
        extends PyBuiltinMethodNarrow {
            Exposed_extend(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed_extend(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                ((PyArray)this.self).array_extend(arg0);
                return Py.None;
            }
        }
        dict.__setitem__("extend", (PyObject)new PyMethodDescr("extend", PyArray.class, 1, 1, new Exposed_extend(null, null)));
        class Exposed_fromfile
        extends PyBuiltinMethodNarrow {
            Exposed_fromfile(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed_fromfile(self, this.info);
            }

            public PyObject __call__(PyObject arg0, PyObject arg1) {
                try {
                    ((PyArray)this.self).array_fromfile(arg0, arg1.asInt(1));
                    return Py.None;
                }
                catch (PyObject.ConversionException e) {
                    String msg;
                    switch (e.index) {
                        case 1: {
                            msg = "expected an integer";
                            break;
                        }
                        default: {
                            msg = "xxx";
                        }
                    }
                    throw Py.TypeError(msg);
                }
            }
        }
        dict.__setitem__("fromfile", (PyObject)new PyMethodDescr("fromfile", PyArray.class, 2, 2, new Exposed_fromfile(null, null)));
        class Exposed_fromlist
        extends PyBuiltinMethodNarrow {
            Exposed_fromlist(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed_fromlist(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                ((PyArray)this.self).array_fromlist(arg0);
                return Py.None;
            }
        }
        dict.__setitem__("fromlist", (PyObject)new PyMethodDescr("fromlist", PyArray.class, 1, 1, new Exposed_fromlist(null, null)));
        class Exposed_index
        extends PyBuiltinMethodNarrow {
            Exposed_index(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed_index(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                return Py.newInteger(((PyArray)this.self).array_index(arg0));
            }
        }
        dict.__setitem__("index", (PyObject)new PyMethodDescr("index", PyArray.class, 1, 1, new Exposed_index(null, null)));
        class Exposed_insert
        extends PyBuiltinMethodNarrow {
            Exposed_insert(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed_insert(self, this.info);
            }

            public PyObject __call__(PyObject arg0, PyObject arg1) {
                try {
                    ((PyArray)this.self).array_insert(arg0.asInt(0), arg1);
                    return Py.None;
                }
                catch (PyObject.ConversionException e) {
                    String msg;
                    switch (e.index) {
                        case 0: {
                            msg = "expected an integer";
                            break;
                        }
                        default: {
                            msg = "xxx";
                        }
                    }
                    throw Py.TypeError(msg);
                }
            }
        }
        dict.__setitem__("insert", (PyObject)new PyMethodDescr("insert", PyArray.class, 2, 2, new Exposed_insert(null, null)));
        class Exposed_pop
        extends PyBuiltinMethodNarrow {
            Exposed_pop(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed_pop(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                try {
                    return ((PyArray)this.self).array_pop(arg0.asInt(0));
                }
                catch (PyObject.ConversionException e) {
                    String msg;
                    switch (e.index) {
                        case 0: {
                            msg = "expected an integer";
                            break;
                        }
                        default: {
                            msg = "xxx";
                        }
                    }
                    throw Py.TypeError(msg);
                }
            }

            public PyObject __call__() {
                return ((PyArray)this.self).array_pop();
            }
        }
        dict.__setitem__("pop", (PyObject)new PyMethodDescr("pop", PyArray.class, 0, 1, new Exposed_pop(null, null)));
        class Exposed_remove
        extends PyBuiltinMethodNarrow {
            Exposed_remove(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed_remove(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                ((PyArray)this.self).array_remove(arg0);
                return Py.None;
            }
        }
        dict.__setitem__("remove", (PyObject)new PyMethodDescr("remove", PyArray.class, 1, 1, new Exposed_remove(null, null)));
        class Exposed_reverse
        extends PyBuiltinMethodNarrow {
            Exposed_reverse(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed_reverse(self, this.info);
            }

            public PyObject __call__() {
                ((PyArray)this.self).array_reverse();
                return Py.None;
            }
        }
        dict.__setitem__("reverse", (PyObject)new PyMethodDescr("reverse", PyArray.class, 0, 0, new Exposed_reverse(null, null)));
        class Exposed_tofile
        extends PyBuiltinMethodNarrow {
            Exposed_tofile(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed_tofile(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                ((PyArray)this.self).array_tofile(arg0);
                return Py.None;
            }
        }
        dict.__setitem__("tofile", (PyObject)new PyMethodDescr("tofile", PyArray.class, 1, 1, new Exposed_tofile(null, null)));
        class Exposed_tolist
        extends PyBuiltinMethodNarrow {
            Exposed_tolist(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed_tolist(self, this.info);
            }

            public PyObject __call__() {
                return ((PyArray)this.self).array_tolist();
            }
        }
        dict.__setitem__("tolist", (PyObject)new PyMethodDescr("tolist", PyArray.class, 0, 0, new Exposed_tolist(null, null)));
        class Exposed_tostring
        extends PyBuiltinMethodNarrow {
            Exposed_tostring(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed_tostring(self, this.info);
            }

            public PyObject __call__() {
                return ((PyArray)this.self).array_tostring();
            }
        }
        dict.__setitem__("tostring", (PyObject)new PyMethodDescr("tostring", PyArray.class, 0, 0, new Exposed_tostring(null, null)));
        class Exposed_write
        extends PyBuiltinMethodNarrow {
            Exposed_write(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed_write(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                ((PyArray)this.self).array_write(arg0);
                return Py.None;
            }
        }
        dict.__setitem__("write", (PyObject)new PyMethodDescr("write", PyArray.class, 1, 1, new Exposed_write(null, null)));
        class Exposed___init__
        extends PyBuiltinMethod {
            Exposed___init__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___init__(self, this.info);
            }

            public PyObject __call__(PyObject[] args) {
                return this.__call__(args, Py.NoKeywords);
            }

            public PyObject __call__(PyObject[] args, String[] keywords) {
                ((PyArray)this.self).array_init(args, keywords);
                return Py.None;
            }
        }
        dict.__setitem__("__init__", (PyObject)new PyMethodDescr("__init__", PyArray.class, -1, -1, new Exposed___init__(null, null)));
        dict.__setitem__("__new__", (PyObject)new PyNewWrapper(PyArray.class, "__new__", -1, -1){

            public PyObject new_impl(boolean init, PyType subtype, PyObject[] args, String[] keywords) {
                PyArray newobj;
                if (this.for_type == subtype) {
                    newobj = new PyArray();
                    if (init) {
                        newobj.array_init(args, keywords);
                    }
                } else {
                    newobj = new PyArrayDerived(subtype);
                }
                return newobj;
            }
        });
    }

    private PyArray() {
    }

    public PyArray(PyType type) {
        super(type);
    }

    public PyArray(PyArray toCopy) {
        this.data = toCopy.delegate.copyArray();
        this.delegate = new ArrayDelegate(this);
        this.type = toCopy.type;
    }

    public PyArray(Class type, Object data) {
        this.type = type;
        this.data = data;
        this.delegate = new ArrayDelegate(this);
    }

    public PyArray(Class type, int n) {
        this(type, Array.newInstance(type, n));
    }

    private void array_init(PyObject[] args, String[] kwds) {
        ArgParser ap = new ArgParser(exposed_name, args, kwds, new String[]{"typecode", "seq"}, 1);
        PyObject obj = ap.getPyObject(0);
        if (obj instanceof PyString) {
            String code = obj.toString();
            if (code.length() != 1) {
                throw Py.ValueError("typecode must be in [zcbhilfd]");
            }
            this.type = PyArray.char2class(code.charAt(0));
            this.typecode = code;
        } else if (obj instanceof PyJavaClass) {
            this.type = ((PyJavaClass)obj).proxyClass;
            this.typecode = this.type.getName();
        }
        this.data = Array.newInstance(this.type, 0);
        this.delegate = new ArrayDelegate(this);
        PyObject seq = ap.getPyObject(1, null);
        if (seq == null) {
            return;
        }
        this.extendInternal(seq);
    }

    public static PyArray zeros(int n, char typecode) {
        PyArray array = PyArray.zeros(n, PyArray.char2class(typecode));
        array.typecode = "" + typecode;
        return array;
    }

    public static PyArray zeros(int n, Class ctype) {
        PyArray array = new PyArray(ctype, n);
        array.typecode = ctype.getName();
        return array;
    }

    public static PyArray array(PyObject seq, char typecode) {
        PyArray array = PyArray.array(seq, PyArray.char2class(typecode));
        array.typecode = "" + typecode;
        return array;
    }

    public static PyArray array(PyObject init, Class ctype) {
        PyArray array = new PyArray(ctype, 0);
        array.typecode = ctype.getName();
        array.extendInternal(init);
        return array;
    }

    public PyObject __add__(PyObject other) {
        PyArray otherArr = null;
        if (!(other instanceof PyArray)) {
            throw Py.TypeError("can only append another array to an array");
        }
        otherArr = (PyArray)other;
        if (!otherArr.type.equals(this.type)) {
            throw Py.TypeError("can only append arrays of the same type, expected '" + this.type + ", found " + otherArr.type);
        }
        PyArray ret = new PyArray(this);
        ret.delegate.appendArray(otherArr.delegate.copyArray());
        return ret;
    }

    public PyObject __findattr__(String name) {
        if ("typecode".equals(name)) {
            return new PyString(this.getTypecode());
        }
        return super.__findattr__(name);
    }

    public int __len__() {
        return this.delegate.getSize();
    }

    public PyString __repr__() {
        StringBuffer buf = new StringBuffer(128);
        buf.append("array(").append(PyArray.class2char(this.type)).append(",[");
        for (int i = 0; i < this.__len__() - 1; ++i) {
            buf.append(this.pyget(i).__repr__().toString());
            buf.append(", ");
        }
        if (this.__len__() > 0) {
            buf.append(this.pyget(this.__len__() - 1).__repr__().toString());
        }
        buf.append("]) ");
        return new PyString(buf.toString());
    }

    public Object __tojava__(Class c) {
        if (c == Object.class || c.isArray() && c.getComponentType().isAssignableFrom(this.type)) {
            return this.data;
        }
        if (c.isInstance(this)) {
            return this;
        }
        return Py.NoConversion;
    }

    public void array_append(PyObject value) {
        this.append(value);
    }

    public void append(PyObject value) {
        int afterLast = this.delegate.getSize();
        this.delegate.makeInsertSpace(afterLast);
        try {
            this.set(afterLast, value);
        }
        catch (PyException e) {
            this.delegate.setSize(afterLast);
            throw new PyException(e.type, e.value);
        }
    }

    public void array_byteswap() {
        this.byteswap();
    }

    public void byteswap() {
        if (this.getItemsize() == 0) {
            throw Py.RuntimeError("don't know how to byteswap this array type");
        }
        ByteSwapper.swap(this.data);
    }

    public Object clone() {
        return new PyArray(this);
    }

    public static Class char2class(char type) throws PyIgnoreMethodTag {
        switch (type) {
            case 'z': {
                return Boolean.TYPE;
            }
            case 'c': {
                return Character.TYPE;
            }
            case 'b': {
                return Byte.TYPE;
            }
            case 'h': {
                return Short.TYPE;
            }
            case 'i': {
                return Integer.TYPE;
            }
            case 'l': {
                return Long.TYPE;
            }
            case 'f': {
                return Float.TYPE;
            }
            case 'd': {
                return Double.TYPE;
            }
        }
        throw Py.ValueError("typecode must be in [zcbhilfd]");
    }

    private static String class2char(Class cls) {
        if (cls.equals(Boolean.TYPE)) {
            return "'z'";
        }
        if (cls.equals(Character.TYPE)) {
            return "'c'";
        }
        if (cls.equals(Byte.TYPE)) {
            return "'b'";
        }
        if (cls.equals(Short.TYPE)) {
            return "'h'";
        }
        if (cls.equals(Integer.TYPE)) {
            return "'i'";
        }
        if (cls.equals(Long.TYPE)) {
            return "'l'";
        }
        if (cls.equals(Float.TYPE)) {
            return "'f'";
        }
        if (cls.equals(Double.TYPE)) {
            return "'d'";
        }
        return cls.getName();
    }

    public int array_count(PyObject value) {
        int iCount = 0;
        for (int i = 0; i < this.delegate.getSize(); ++i) {
            if (!value.equals(Py.java2py(Array.get(this.data, i)))) continue;
            ++iCount;
        }
        return iCount;
    }

    public PyInteger count(PyObject value) {
        return Py.newInteger(this.array_count(value));
    }

    protected void del(int i) {
        this.delegate.remove(i);
    }

    protected void delRange(int start, int stop, int step) {
        if (step > 0 && stop < start) {
            stop = start;
        }
        if (step == 1) {
            this.delegate.remove(start, stop);
        } else {
            int n = PyArray.sliceLength(start, stop, step);
            int i = start;
            for (int j = 0; j < n; ++j) {
                this.delegate.remove(i);
                i += step;
            }
        }
    }

    public void array_extend(PyObject iterable) {
        this.extendInternal(iterable);
    }

    public void extend(PyObject iterable) {
        this.extendInternal(iterable);
    }

    private void extendInternal(PyObject iterable) {
        if (iterable instanceof PyString) {
            this.fromstring(((PyString)iterable).toString());
        } else if (iterable instanceof PyArray) {
            PyArray source = (PyArray)iterable;
            if (!source.type.equals(this.type)) {
                throw Py.TypeError("can only extend with an array of the same kind");
            }
            this.delegate.appendArray(source.delegate.copyArray());
        } else {
            this.extendInternalIter(iterable);
        }
    }

    private void extendInternalIter(PyObject iterable) {
        PyObject iter = iterable.__iter__();
        PyObject item = null;
        if (iterable.__findattr__("__len__") == null) {
            int i = 0;
            while ((item = iter.__iternext__()) != null) {
                this.append(item);
                ++i;
            }
        } else {
            int last = this.delegate.getSize();
            this.delegate.ensureCapacity(last + iterable.__len__());
            int i = last;
            while ((item = iter.__iternext__()) != null) {
                this.set(i, item);
                ++this.delegate.size;
                ++i;
            }
        }
    }

    private void array_fromfile(PyObject f, int count) {
        this.fromfile(f, count);
    }

    public void fromfile(PyObject f, int count) {
        if (!(f instanceof PyFile)) {
            throw Py.TypeError("arg1 must be open file");
        }
        PyFile file = (PyFile)f;
        if (file.mode.indexOf("r") == -1) {
            throw Py.TypeError("file needs to be in read mode");
        }
        int readbytes = count * this.getItemsize();
        String buffer = file.read(readbytes).toString();
        this.fromstring(buffer);
        if (buffer.length() < readbytes) {
            int readcount = buffer.length() / this.getItemsize();
            throw Py.EOFError("not enough items in file. " + Integer.toString(count) + " requested, " + Integer.toString(readcount) + " actually read");
        }
    }

    public void array_fromlist(PyObject obj) {
        this.fromlist(obj);
    }

    public void fromlist(PyObject obj) {
        if (!(obj instanceof PyList)) {
            throw Py.TypeError("expected list argument");
        }
        int size = this.delegate.getSize();
        try {
            this.extendInternalIter(obj);
        }
        catch (PyException e) {
            this.delegate.setSize(size);
            throw new PyException(e.type, e.value);
        }
    }

    private int fromStream(InputStream is) throws IOException, EOFException {
        return this.fromStream(is, is.available() / this.getItemsize());
    }

    private int fromStream(InputStream is, int count) throws IOException, EOFException {
        int origsize;
        DataInputStream dis = new DataInputStream(is);
        int index = origsize = this.delegate.getSize();
        this.delegate.ensureCapacity(index + count);
        if (this.type.isPrimitive()) {
            if (this.type == Boolean.TYPE) {
                int i = 0;
                while (i < count) {
                    Array.setBoolean(this.data, index, dis.readBoolean());
                    ++this.delegate.size;
                    ++i;
                    ++index;
                }
            } else if (this.type == Byte.TYPE) {
                int i = 0;
                while (i < count) {
                    Array.setByte(this.data, index, dis.readByte());
                    ++this.delegate.size;
                    ++i;
                    ++index;
                }
            } else if (this.type == Character.TYPE) {
                int i = 0;
                while (i < count) {
                    Array.setChar(this.data, index, (char)dis.readByte());
                    ++this.delegate.size;
                    ++i;
                    ++index;
                }
            } else if (this.type == Integer.TYPE) {
                int i = 0;
                while (i < count) {
                    Array.setInt(this.data, index, dis.readInt());
                    ++this.delegate.size;
                    ++i;
                    ++index;
                }
            } else if (this.type == Short.TYPE) {
                int i = 0;
                while (i < count) {
                    Array.setShort(this.data, index, dis.readShort());
                    ++this.delegate.size;
                    ++i;
                    ++index;
                }
            } else if (this.type == Long.TYPE) {
                int i = 0;
                while (i < count) {
                    Array.setLong(this.data, index, dis.readLong());
                    ++this.delegate.size;
                    ++i;
                    ++index;
                }
            } else if (this.type == Float.TYPE) {
                int i = 0;
                while (i < count) {
                    Array.setFloat(this.data, index, dis.readFloat());
                    ++this.delegate.size;
                    ++i;
                    ++index;
                }
            } else if (this.type == Double.TYPE) {
                int i = 0;
                while (i < count) {
                    Array.setDouble(this.data, index, dis.readDouble());
                    ++this.delegate.size;
                    ++i;
                    ++index;
                }
            }
        }
        dis.close();
        return index - origsize;
    }

    public void fromstring(String input) {
        int itemsize = this.getItemsize();
        int strlen = input.length();
        if (strlen % itemsize != 0) {
            throw Py.ValueError("string length not a multiple of item size");
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(PyString.to_bytes(input));
        int origsize = this.delegate.getSize();
        try {
            this.fromStream(bis);
        }
        catch (EOFException e) {
            throw Py.EOFError("not enough items in string");
        }
        catch (IOException e) {
            this.delegate.setSize(origsize);
            throw Py.IOError(e);
        }
    }

    protected PyObject pyget(int i) {
        return Py.java2py(Array.get(this.data, i));
    }

    public Object getArray() throws PyIgnoreMethodTag {
        return this.delegate.copyArray();
    }

    public int getItemsize() {
        if (this.type.isPrimitive()) {
            if (this.type == Boolean.TYPE) {
                return 1;
            }
            if (this.type == Byte.TYPE) {
                return 1;
            }
            if (this.type == Character.TYPE) {
                return 1;
            }
            if (this.type == Short.TYPE) {
                return 2;
            }
            if (this.type == Integer.TYPE) {
                return 4;
            }
            if (this.type == Long.TYPE) {
                return 8;
            }
            if (this.type == Float.TYPE) {
                return 4;
            }
            if (this.type == Double.TYPE) {
                return 8;
            }
        }
        return 0;
    }

    protected PyObject getslice(int start, int stop, int step) {
        if (step > 0 && stop < start) {
            stop = start;
        }
        int n = PyArray.sliceLength(start, stop, step);
        PyArray ret = new PyArray(this.type, n);
        if (step == 1) {
            System.arraycopy(this.data, start, ret.data, 0, n);
            return ret;
        }
        int i = start;
        for (int j = 0; j < n; ++j) {
            Array.set(ret.data, j, Array.get(this.data, i));
            i += step;
        }
        return ret;
    }

    public String getTypecode() throws PyIgnoreMethodTag {
        return this.typecode;
    }

    public int array_index(PyObject value) {
        int index = this.indexInternal(value);
        if (index != -1) {
            return index;
        }
        throw Py.ValueError("array.index(" + value + "): " + value + " not found in array");
    }

    public PyObject index(PyObject value) {
        return Py.newInteger(this.array_index(value));
    }

    private int indexInternal(PyObject value) {
        for (int i = 0; i < this.delegate.getSize(); ++i) {
            if (!value.equals(Py.java2py(Array.get(this.data, i)))) continue;
            return i;
        }
        return -1;
    }

    public void array_insert(int index, PyObject value) {
        this.insert(index, value);
    }

    public void insert(int index, PyObject value) {
        this.delegate.makeInsertSpace(index);
        Array.set(this.data, index, Py.tojava(value, this.type));
    }

    public PyObject array_pop() {
        return this.pop();
    }

    public PyObject array_pop(int i) {
        return this.pop(i);
    }

    public PyObject pop() {
        return this.pop(-1);
    }

    public PyObject pop(int index) {
        index = index < 0 ? this.delegate.getSize() + index : index;
        PyObject ret = Py.java2py(Array.get(this.data, index));
        this.delegate.remove(index);
        return ret;
    }

    public void array_remove(PyObject value) {
        this.remove(value);
    }

    public void remove(PyObject value) {
        int index = this.indexInternal(value);
        if (index != -1) {
            this.delegate.remove(index);
            return;
        }
        throw Py.ValueError("array.remove(" + value + "): " + value + " not found in array");
    }

    protected PyObject repeat(int count) {
        Object arraycopy = this.delegate.copyArray();
        PyArray ret = new PyArray(this.type, 0);
        for (int i = 0; i < count; ++i) {
            ret.delegate.appendArray(arraycopy);
        }
        return ret;
    }

    public void array_reverse() {
        this.reverse();
    }

    public void reverse() {
        Object array = Array.newInstance(this.type, Array.getLength(this.data));
        int lastIndex = this.delegate.getSize() - 1;
        for (int i = 0; i <= lastIndex; ++i) {
            Array.set(array, lastIndex - i, Array.get(this.data, i));
        }
        this.data = array;
    }

    protected void set(int i, PyObject value) {
        Object o;
        if (this.type == Byte.TYPE) {
            long val;
            try {
                val = (Long)value.__tojava__(Long.TYPE);
            }
            catch (ClassCastException e) {
                throw Py.TypeError("Type not compatible with array type");
            }
            if (val < -128L) {
                throw Py.OverflowError("value too small for " + this.type.getName());
            }
            if (val > 127L) {
                throw Py.OverflowError("value too large for " + this.type.getName());
            }
        } else if (this.type == Short.TYPE) {
            long val;
            try {
                val = (Long)value.__tojava__(Long.TYPE);
            }
            catch (ClassCastException e) {
                throw Py.TypeError("Type not compatible with array type");
            }
            if (val < -32768L) {
                throw Py.OverflowError("value too small for " + this.type.getName());
            }
            if (val > 32767L) {
                throw Py.OverflowError("value too large for " + this.type.getName());
            }
        } else if (this.type == Integer.TYPE) {
            long val;
            try {
                val = (Long)value.__tojava__(Long.TYPE);
            }
            catch (ClassCastException e) {
                throw Py.TypeError("Type not compatible with array type");
            }
            if (val < Integer.MIN_VALUE) {
                throw Py.OverflowError("value too small for " + this.type.getName());
            }
            if (val > Integer.MAX_VALUE) {
                throw Py.OverflowError("value too large for " + this.type.getName());
            }
        } else if (this.type == Long.TYPE) {
            Object o2;
            try {
                o2 = value.__tojava__(Long.TYPE);
            }
            catch (ClassCastException e) {
                throw Py.TypeError("Type not compatible with array type");
            }
            if (o2 == Py.NoConversion) {
                throw Py.OverflowError("value out of range for long");
            }
        }
        if ((o = Py.tojava(value, this.type)) == Py.NoConversion) {
            throw Py.TypeError("Type not compatible with array type");
        }
        Array.set(this.data, i, o);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setslice(int start, int stop, int step, PyObject value) {
        if (this.type == Character.TYPE && value instanceof PyString) {
            char[] chars = null;
            if (step != 1) {
                throw Py.ValueError("invalid bounds for setting from string");
            }
            chars = value.toString().toCharArray();
            int insertSpace = chars.length - (stop - start);
            if (insertSpace > 0) {
                this.delegate.makeInsertSpace(start, insertSpace);
            } else if (insertSpace < 0) {
                this.delegate.remove(start, -insertSpace + start - 1);
            }
            this.delegate.replaceSubArray(chars, start);
            return;
        }
        if (value instanceof PyString && this.type == Byte.TYPE) {
            byte[] chars = ((PyString)value).toBytes();
            if (chars.length != stop - start || step != 1) throw Py.ValueError("invalid bounds for setting from string");
            System.arraycopy(chars, 0, this.data, start, chars.length);
            return;
        }
        if (!(value instanceof PyArray)) return;
        PyArray array = (PyArray)value;
        int insertSpace = array.delegate.getSize() - (stop - start);
        Object arrayCopy = array.delegate.copyArray();
        if (insertSpace > 0) {
            this.delegate.makeInsertSpace(start, insertSpace);
        } else if (insertSpace < 0) {
            this.delegate.remove(start, -insertSpace + start - 1);
        }
        try {
            this.delegate.replaceSubArray(arrayCopy, start);
            return;
        }
        catch (IllegalArgumentException e) {
            throw Py.TypeError("Slice typecode '" + array.typecode + "' is not compatible with this array (typecode '" + this.typecode + "')");
        }
    }

    public void array_tofile(PyObject f) {
        this.tofile(f);
    }

    public void array_write(PyObject f) {
        this.tofile(f);
    }

    public void tofile(PyObject f) {
        if (!(f instanceof PyFile)) {
            throw Py.TypeError("arg must be open file");
        }
        PyFile file = (PyFile)f;
        if (file.mode.indexOf("w") == -1 && file.mode.indexOf("a") == -1) {
            throw Py.TypeError("file needs to be in write or append mode");
        }
        file.write(this.tostring());
    }

    public PyObject array_tolist() {
        return this.tolist();
    }

    public PyObject tolist() {
        PyList list = new PyList();
        for (int i = 0; i < this.delegate.getSize(); ++i) {
            list.append(Py.java2py(Array.get(this.data, i)));
        }
        return list;
    }

    private int toStream(OutputStream os2) throws IOException {
        DataOutputStream dos;
        block8: {
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block9: {
                                        dos = new DataOutputStream(os2);
                                        if (!this.type.isPrimitive()) break block8;
                                        if (this.type != Boolean.TYPE) break block9;
                                        for (int i = 0; i < this.delegate.getSize(); ++i) {
                                            dos.writeBoolean(Array.getBoolean(this.data, i));
                                        }
                                        break block8;
                                    }
                                    if (this.type != Byte.TYPE) break block10;
                                    for (int i = 0; i < this.delegate.getSize(); ++i) {
                                        dos.writeByte(Array.getByte(this.data, i));
                                    }
                                    break block8;
                                }
                                if (this.type != Character.TYPE) break block11;
                                for (int i = 0; i < this.delegate.getSize(); ++i) {
                                    dos.writeByte((byte)Array.getChar(this.data, i));
                                }
                                break block8;
                            }
                            if (this.type != Integer.TYPE) break block12;
                            for (int i = 0; i < this.delegate.getSize(); ++i) {
                                dos.writeInt(Array.getInt(this.data, i));
                            }
                            break block8;
                        }
                        if (this.type != Short.TYPE) break block13;
                        for (int i = 0; i < this.delegate.getSize(); ++i) {
                            dos.writeShort(Array.getShort(this.data, i));
                        }
                        break block8;
                    }
                    if (this.type != Long.TYPE) break block14;
                    for (int i = 0; i < this.delegate.getSize(); ++i) {
                        dos.writeLong(Array.getLong(this.data, i));
                    }
                    break block8;
                }
                if (this.type != Float.TYPE) break block15;
                for (int i = 0; i < this.delegate.getSize(); ++i) {
                    dos.writeFloat(Array.getFloat(this.data, i));
                }
                break block8;
            }
            if (this.type != Double.TYPE) break block8;
            for (int i = 0; i < this.delegate.getSize(); ++i) {
                dos.writeDouble(Array.getDouble(this.data, i));
            }
        }
        return dos.size();
    }

    public PyObject array_tostring() {
        return new PyString(this.tostring());
    }

    public String tostring() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            this.toStream(bos);
        }
        catch (IOException e) {
            throw Py.IOError(e);
        }
        return PyString.from_bytes(bos.toByteArray());
    }

    private class ArrayDelegate
    extends AbstractArray {
        final PyArray pyArray;

        private ArrayDelegate(PyArray pyArray2) {
            super(pyArray2.data == null ? 0 : Array.getLength(pyArray2.data));
            this.pyArray = pyArray2;
        }

        protected Object getArray() {
            return this.pyArray.data;
        }

        protected void setArray(Object array) {
            this.pyArray.data = array;
        }

        protected void makeInsertSpace(int index) {
            super.makeInsertSpace(index, 1);
        }

        protected void makeInsertSpace(int index, int length) {
            super.makeInsertSpace(index, length);
        }

        public void remove(int index) {
            super.remove(index);
        }
    }
}

