/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.Serializable;
import org.python.core.ArgParser;
import org.python.core.Options;
import org.python.core.Py;
import org.python.core.PyBuiltinFunction;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyComplex;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyIgnoreMethodTag;
import org.python.core.PyIntegerDerived;
import org.python.core.PyLong;
import org.python.core.PyMethodDescr;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;

public class PyInteger
extends PyObject {
    public static final String exposed_name = "int";
    private static final PyType INTTYPE = PyType.fromClass(PyInteger.class);
    private int value;

    public static void typeSetup(PyObject dict, PyType.Newstyle marker) {
        class Exposed___abs__
        extends PyBuiltinMethodNarrow {
            Exposed___abs__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___abs__(self, this.info);
            }

            public PyObject __call__() {
                return ((PyInteger)this.self).int___abs__();
            }
        }
        dict.__setitem__("__abs__", (PyObject)new PyMethodDescr("__abs__", PyInteger.class, 0, 0, new Exposed___abs__(null, null)));
        class Exposed___float__
        extends PyBuiltinMethodNarrow {
            Exposed___float__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___float__(self, this.info);
            }

            public PyObject __call__() {
                return ((PyInteger)this.self).int___float__();
            }
        }
        dict.__setitem__("__float__", (PyObject)new PyMethodDescr("__float__", PyInteger.class, 0, 0, new Exposed___float__(null, null)));
        class Exposed___hex__
        extends PyBuiltinMethodNarrow {
            Exposed___hex__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___hex__(self, this.info);
            }

            public PyObject __call__() {
                return ((PyInteger)this.self).int___hex__();
            }
        }
        dict.__setitem__("__hex__", (PyObject)new PyMethodDescr("__hex__", PyInteger.class, 0, 0, new Exposed___hex__(null, null)));
        class Exposed___int__
        extends PyBuiltinMethodNarrow {
            Exposed___int__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___int__(self, this.info);
            }

            public PyObject __call__() {
                return ((PyInteger)this.self).int___int__();
            }
        }
        dict.__setitem__("__int__", (PyObject)new PyMethodDescr("__int__", PyInteger.class, 0, 0, new Exposed___int__(null, null)));
        class Exposed___invert__
        extends PyBuiltinMethodNarrow {
            Exposed___invert__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___invert__(self, this.info);
            }

            public PyObject __call__() {
                return ((PyInteger)this.self).int___invert__();
            }
        }
        dict.__setitem__("__invert__", (PyObject)new PyMethodDescr("__invert__", PyInteger.class, 0, 0, new Exposed___invert__(null, null)));
        class Exposed___long__
        extends PyBuiltinMethodNarrow {
            Exposed___long__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___long__(self, this.info);
            }

            public PyObject __call__() {
                return ((PyInteger)this.self).int___long__();
            }
        }
        dict.__setitem__("__long__", (PyObject)new PyMethodDescr("__long__", PyInteger.class, 0, 0, new Exposed___long__(null, null)));
        class Exposed___neg__
        extends PyBuiltinMethodNarrow {
            Exposed___neg__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___neg__(self, this.info);
            }

            public PyObject __call__() {
                return ((PyInteger)this.self).int___neg__();
            }
        }
        dict.__setitem__("__neg__", (PyObject)new PyMethodDescr("__neg__", PyInteger.class, 0, 0, new Exposed___neg__(null, null)));
        class Exposed___oct__
        extends PyBuiltinMethodNarrow {
            Exposed___oct__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___oct__(self, this.info);
            }

            public PyObject __call__() {
                return ((PyInteger)this.self).int___oct__();
            }
        }
        dict.__setitem__("__oct__", (PyObject)new PyMethodDescr("__oct__", PyInteger.class, 0, 0, new Exposed___oct__(null, null)));
        class Exposed___pos__
        extends PyBuiltinMethodNarrow {
            Exposed___pos__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___pos__(self, this.info);
            }

            public PyObject __call__() {
                return ((PyInteger)this.self).int___pos__();
            }
        }
        dict.__setitem__("__pos__", (PyObject)new PyMethodDescr("__pos__", PyInteger.class, 0, 0, new Exposed___pos__(null, null)));
        class Exposed___add__
        extends PyBuiltinMethodNarrow {
            Exposed___add__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___add__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyInteger)this.self).int___add__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__add__", (PyObject)new PyMethodDescr("__add__", PyInteger.class, 1, 1, new Exposed___add__(null, null)));
        class Exposed___and__
        extends PyBuiltinMethodNarrow {
            Exposed___and__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___and__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyInteger)this.self).int___and__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__and__", (PyObject)new PyMethodDescr("__and__", PyInteger.class, 1, 1, new Exposed___and__(null, null)));
        class Exposed___div__
        extends PyBuiltinMethodNarrow {
            Exposed___div__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___div__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyInteger)this.self).int___div__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__div__", (PyObject)new PyMethodDescr("__div__", PyInteger.class, 1, 1, new Exposed___div__(null, null)));
        class Exposed___divmod__
        extends PyBuiltinMethodNarrow {
            Exposed___divmod__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___divmod__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyInteger)this.self).int___divmod__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__divmod__", (PyObject)new PyMethodDescr("__divmod__", PyInteger.class, 1, 1, new Exposed___divmod__(null, null)));
        class Exposed___floordiv__
        extends PyBuiltinMethodNarrow {
            Exposed___floordiv__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___floordiv__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyInteger)this.self).int___floordiv__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__floordiv__", (PyObject)new PyMethodDescr("__floordiv__", PyInteger.class, 1, 1, new Exposed___floordiv__(null, null)));
        class Exposed___lshift__
        extends PyBuiltinMethodNarrow {
            Exposed___lshift__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___lshift__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyInteger)this.self).int___lshift__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__lshift__", (PyObject)new PyMethodDescr("__lshift__", PyInteger.class, 1, 1, new Exposed___lshift__(null, null)));
        class Exposed___mod__
        extends PyBuiltinMethodNarrow {
            Exposed___mod__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___mod__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyInteger)this.self).int___mod__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__mod__", (PyObject)new PyMethodDescr("__mod__", PyInteger.class, 1, 1, new Exposed___mod__(null, null)));
        class Exposed___mul__
        extends PyBuiltinMethodNarrow {
            Exposed___mul__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___mul__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyInteger)this.self).int___mul__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__mul__", (PyObject)new PyMethodDescr("__mul__", PyInteger.class, 1, 1, new Exposed___mul__(null, null)));
        class Exposed___or__
        extends PyBuiltinMethodNarrow {
            Exposed___or__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___or__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyInteger)this.self).int___or__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__or__", (PyObject)new PyMethodDescr("__or__", PyInteger.class, 1, 1, new Exposed___or__(null, null)));
        class Exposed___radd__
        extends PyBuiltinMethodNarrow {
            Exposed___radd__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___radd__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyInteger)this.self).int___radd__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__radd__", (PyObject)new PyMethodDescr("__radd__", PyInteger.class, 1, 1, new Exposed___radd__(null, null)));
        class Exposed___rdiv__
        extends PyBuiltinMethodNarrow {
            Exposed___rdiv__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___rdiv__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyInteger)this.self).int___rdiv__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__rdiv__", (PyObject)new PyMethodDescr("__rdiv__", PyInteger.class, 1, 1, new Exposed___rdiv__(null, null)));
        class Exposed___rfloordiv__
        extends PyBuiltinMethodNarrow {
            Exposed___rfloordiv__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___rfloordiv__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyInteger)this.self).int___rfloordiv__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__rfloordiv__", (PyObject)new PyMethodDescr("__rfloordiv__", PyInteger.class, 1, 1, new Exposed___rfloordiv__(null, null)));
        class Exposed___rmod__
        extends PyBuiltinMethodNarrow {
            Exposed___rmod__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___rmod__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyInteger)this.self).int___rmod__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__rmod__", (PyObject)new PyMethodDescr("__rmod__", PyInteger.class, 1, 1, new Exposed___rmod__(null, null)));
        class Exposed___rmul__
        extends PyBuiltinMethodNarrow {
            Exposed___rmul__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___rmul__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyInteger)this.self).int___rmul__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__rmul__", (PyObject)new PyMethodDescr("__rmul__", PyInteger.class, 1, 1, new Exposed___rmul__(null, null)));
        class Exposed___rshift__
        extends PyBuiltinMethodNarrow {
            Exposed___rshift__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___rshift__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyInteger)this.self).int___rshift__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__rshift__", (PyObject)new PyMethodDescr("__rshift__", PyInteger.class, 1, 1, new Exposed___rshift__(null, null)));
        class Exposed___rsub__
        extends PyBuiltinMethodNarrow {
            Exposed___rsub__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___rsub__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyInteger)this.self).int___rsub__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__rsub__", (PyObject)new PyMethodDescr("__rsub__", PyInteger.class, 1, 1, new Exposed___rsub__(null, null)));
        class Exposed___rtruediv__
        extends PyBuiltinMethodNarrow {
            Exposed___rtruediv__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___rtruediv__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyInteger)this.self).int___rtruediv__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__rtruediv__", (PyObject)new PyMethodDescr("__rtruediv__", PyInteger.class, 1, 1, new Exposed___rtruediv__(null, null)));
        class Exposed___sub__
        extends PyBuiltinMethodNarrow {
            Exposed___sub__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___sub__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyInteger)this.self).int___sub__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__sub__", (PyObject)new PyMethodDescr("__sub__", PyInteger.class, 1, 1, new Exposed___sub__(null, null)));
        class Exposed___truediv__
        extends PyBuiltinMethodNarrow {
            Exposed___truediv__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___truediv__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyInteger)this.self).int___truediv__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__truediv__", (PyObject)new PyMethodDescr("__truediv__", PyInteger.class, 1, 1, new Exposed___truediv__(null, null)));
        class Exposed___xor__
        extends PyBuiltinMethodNarrow {
            Exposed___xor__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___xor__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyInteger)this.self).int___xor__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__xor__", (PyObject)new PyMethodDescr("__xor__", PyInteger.class, 1, 1, new Exposed___xor__(null, null)));
        class Exposed___rxor__
        extends PyBuiltinMethodNarrow {
            Exposed___rxor__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___rxor__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyInteger)this.self).int___rxor__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__rxor__", (PyObject)new PyMethodDescr("__rxor__", PyInteger.class, 1, 1, new Exposed___rxor__(null, null)));
        class Exposed___rrshift__
        extends PyBuiltinMethodNarrow {
            Exposed___rrshift__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___rrshift__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyInteger)this.self).int___rrshift__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__rrshift__", (PyObject)new PyMethodDescr("__rrshift__", PyInteger.class, 1, 1, new Exposed___rrshift__(null, null)));
        class Exposed___ror__
        extends PyBuiltinMethodNarrow {
            Exposed___ror__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___ror__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyInteger)this.self).int___ror__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__ror__", (PyObject)new PyMethodDescr("__ror__", PyInteger.class, 1, 1, new Exposed___ror__(null, null)));
        class Exposed___rand__
        extends PyBuiltinMethodNarrow {
            Exposed___rand__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___rand__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyInteger)this.self).int___rand__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__rand__", (PyObject)new PyMethodDescr("__rand__", PyInteger.class, 1, 1, new Exposed___rand__(null, null)));
        class Exposed___rpow__
        extends PyBuiltinMethodNarrow {
            Exposed___rpow__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___rpow__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyInteger)this.self).int___rpow__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__rpow__", (PyObject)new PyMethodDescr("__rpow__", PyInteger.class, 1, 1, new Exposed___rpow__(null, null)));
        class Exposed___rlshift__
        extends PyBuiltinMethodNarrow {
            Exposed___rlshift__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___rlshift__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyInteger)this.self).int___rlshift__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__rlshift__", (PyObject)new PyMethodDescr("__rlshift__", PyInteger.class, 1, 1, new Exposed___rlshift__(null, null)));
        class Exposed___rdivmod__
        extends PyBuiltinMethodNarrow {
            Exposed___rdivmod__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___rdivmod__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyInteger)this.self).int___rdivmod__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__rdivmod__", (PyObject)new PyMethodDescr("__rdivmod__", PyInteger.class, 1, 1, new Exposed___rdivmod__(null, null)));
        class Exposed___cmp__
        extends PyBuiltinMethodNarrow {
            Exposed___cmp__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___cmp__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                int ret = ((PyInteger)this.self).int___cmp__(arg0);
                if (ret == -2) {
                    throw Py.TypeError("int.__cmp__(x,y) requires y to be 'int', not a '" + arg0.getType().fastGetName() + "'");
                }
                return Py.newInteger(ret);
            }
        }
        dict.__setitem__("__cmp__", (PyObject)new PyMethodDescr("__cmp__", PyInteger.class, 1, 1, new Exposed___cmp__(null, null)));
        class Exposed___pow__
        extends PyBuiltinMethodNarrow {
            Exposed___pow__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___pow__(self, this.info);
            }

            public PyObject __call__(PyObject arg0, PyObject arg1) {
                PyObject ret = ((PyInteger)this.self).int___pow__(arg0, arg1);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyInteger)this.self).int___pow__(arg0, null);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__pow__", (PyObject)new PyMethodDescr("__pow__", PyInteger.class, 1, 2, new Exposed___pow__(null, null)));
        class Exposed___nonzero__
        extends PyBuiltinMethodNarrow {
            Exposed___nonzero__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___nonzero__(self, this.info);
            }

            public PyObject __call__() {
                return Py.newBoolean(((PyInteger)this.self).int___nonzero__());
            }
        }
        dict.__setitem__("__nonzero__", (PyObject)new PyMethodDescr("__nonzero__", PyInteger.class, 0, 0, new Exposed___nonzero__(null, null)));
        class Exposed___reduce__
        extends PyBuiltinMethodNarrow {
            Exposed___reduce__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___reduce__(self, this.info);
            }

            public PyObject __call__() {
                return ((PyInteger)this.self).int___reduce__();
            }
        }
        dict.__setitem__("__reduce__", (PyObject)new PyMethodDescr("__reduce__", PyInteger.class, 0, 0, new Exposed___reduce__(null, null)));
        class Exposed___repr__
        extends PyBuiltinMethodNarrow {
            Exposed___repr__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___repr__(self, this.info);
            }

            public PyObject __call__() {
                return new PyString(((PyInteger)this.self).int_toString());
            }
        }
        dict.__setitem__("__repr__", (PyObject)new PyMethodDescr("__repr__", PyInteger.class, 0, 0, new Exposed___repr__(null, null)));
        class Exposed___str__
        extends PyBuiltinMethodNarrow {
            Exposed___str__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___str__(self, this.info);
            }

            public PyObject __call__() {
                return new PyString(((PyInteger)this.self).int_toString());
            }
        }
        dict.__setitem__("__str__", (PyObject)new PyMethodDescr("__str__", PyInteger.class, 0, 0, new Exposed___str__(null, null)));
        class Exposed___hash__
        extends PyBuiltinMethodNarrow {
            Exposed___hash__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___hash__(self, this.info);
            }

            public PyObject __call__() {
                return Py.newInteger(((PyInteger)this.self).int_hashCode());
            }
        }
        dict.__setitem__("__hash__", (PyObject)new PyMethodDescr("__hash__", PyInteger.class, 0, 0, new Exposed___hash__(null, null)));
        dict.__setitem__("__new__", (PyObject)new PyNewWrapper(PyInteger.class, "__new__", -1, -1){

            public PyObject new_impl(boolean init, PyType subtype, PyObject[] args, String[] keywords) {
                return PyInteger.int_new(this, init, subtype, args, keywords);
            }
        });
    }

    public static PyObject int_new(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        ArgParser ap = new ArgParser(exposed_name, args, keywords, new String[]{"x", "base"}, 0);
        PyObject x = ap.getPyObject(0, null);
        int base = ap.getInt(1, -909);
        if (new_.for_type == subtype) {
            if (x == null) {
                return Py.Zero;
            }
            if (base == -909) {
                return PyInteger.asPyInteger(x);
            }
            if (!(x instanceof PyString)) {
                throw Py.TypeError("int: can't convert non-string with explicit base");
            }
            return Py.newInteger(((PyString)x).atoi(base));
        }
        if (x == null) {
            return new PyIntegerDerived(subtype, 0);
        }
        if (base == -909) {
            PyObject intOrLong = PyInteger.asPyInteger(x);
            if (intOrLong instanceof PyInteger) {
                return new PyIntegerDerived(subtype, ((PyInteger)intOrLong).getValue());
            }
            throw Py.OverflowError("long int too large to convert to int");
        }
        if (!(x instanceof PyString)) {
            throw Py.TypeError("int: can't convert non-string with explicit base");
        }
        return new PyIntegerDerived(subtype, ((PyString)x).atoi(base));
    }

    private static PyObject asPyInteger(PyObject x) {
        try {
            return x.__int__();
        }
        catch (PyException pye) {
            if (!Py.matchException(pye, Py.AttributeError)) {
                throw pye;
            }
            throw Py.TypeError("int() argument must be a string or a number");
        }
    }

    public PyInteger(PyType subType, int v) {
        super(subType);
        this.value = v;
    }

    public PyInteger(int v) {
        this(INTTYPE, v);
    }

    public int getValue() {
        return this.value;
    }

    public String safeRepr() throws PyIgnoreMethodTag {
        return "'int' object";
    }

    public String toString() {
        return this.int_toString();
    }

    final String int_toString() {
        return Integer.toString(this.getValue());
    }

    public int hashCode() {
        return this.int_hashCode();
    }

    final int int_hashCode() {
        return this.getValue();
    }

    private static void err_ovf(String msg) {
        block2: {
            try {
                Py.OverflowWarning(msg);
            }
            catch (PyException exc) {
                if (!Py.matchException(exc, Py.OverflowWarning)) break block2;
                throw Py.OverflowError(msg);
            }
        }
    }

    public boolean __nonzero__() {
        return this.int___nonzero__();
    }

    final boolean int___nonzero__() {
        return this.getValue() != 0;
    }

    public Object __tojava__(Class c) {
        if (c == Integer.TYPE || c == Number.class || c == Object.class || c == Integer.class || c == Serializable.class) {
            return new Integer(this.getValue());
        }
        if (c == Boolean.TYPE || c == Boolean.class) {
            return new Boolean(this.getValue() != 0);
        }
        if (c == Byte.TYPE || c == Byte.class) {
            return new Byte((byte)this.getValue());
        }
        if (c == Short.TYPE || c == Short.class) {
            return new Short((short)this.getValue());
        }
        if (c == Long.TYPE || c == Long.class) {
            return new Long(this.getValue());
        }
        if (c == Float.TYPE || c == Float.class) {
            return new Float(this.getValue());
        }
        if (c == Double.TYPE || c == Double.class) {
            return new Double(this.getValue());
        }
        return super.__tojava__(c);
    }

    public int __cmp__(PyObject other) {
        return this.int___cmp__(other);
    }

    final int int___cmp__(PyObject other) {
        if (!PyInteger.canCoerce(other)) {
            return -2;
        }
        int v = PyInteger.coerce(other);
        return this.getValue() < v ? -1 : (this.getValue() > v ? 1 : 0);
    }

    public Object __coerce_ex__(PyObject other) {
        if (other instanceof PyInteger) {
            return other;
        }
        return Py.None;
    }

    private static final boolean canCoerce(PyObject other) {
        return other instanceof PyInteger;
    }

    private static final int coerce(PyObject other) {
        if (other instanceof PyInteger) {
            return ((PyInteger)other).getValue();
        }
        throw Py.TypeError("xxx");
    }

    public PyObject __add__(PyObject right) {
        return this.int___add__(right);
    }

    final PyObject int___add__(PyObject right) {
        int b;
        if (!PyInteger.canCoerce(right)) {
            return null;
        }
        int rightv = PyInteger.coerce(right);
        int a = this.getValue();
        int x = a + (b = rightv);
        if ((x ^ a) >= 0 || (x ^ b) >= 0) {
            return Py.newInteger(x);
        }
        PyInteger.err_ovf("integer addition");
        return new PyLong((long)a + (long)b);
    }

    public PyObject __radd__(PyObject left) {
        return this.int___radd__(left);
    }

    final PyObject int___radd__(PyObject left) {
        return this.__add__(left);
    }

    private static PyObject _sub(int a, int b) {
        int x = a - b;
        if ((x ^ a) >= 0 || (x ^ ~b) >= 0) {
            return Py.newInteger(x);
        }
        PyInteger.err_ovf("integer subtraction");
        return new PyLong((long)a - (long)b);
    }

    public PyObject __sub__(PyObject right) {
        return this.int___sub__(right);
    }

    final PyObject int___sub__(PyObject right) {
        if (!PyInteger.canCoerce(right)) {
            return null;
        }
        return PyInteger._sub(this.getValue(), PyInteger.coerce(right));
    }

    public PyObject __rsub__(PyObject left) {
        return this.int___rsub__(left);
    }

    final PyObject int___rsub__(PyObject left) {
        if (!PyInteger.canCoerce(left)) {
            return null;
        }
        return PyInteger._sub(PyInteger.coerce(left), this.getValue());
    }

    public PyObject __mul__(PyObject right) {
        return this.int___mul__(right);
    }

    final PyObject int___mul__(PyObject right) {
        if (right instanceof PySequence) {
            return ((PySequence)right).repeat(this.getValue());
        }
        if (!PyInteger.canCoerce(right)) {
            return null;
        }
        int rightv = PyInteger.coerce(right);
        double x = this.getValue();
        if ((x *= (double)rightv) <= 2.147483647E9 && x >= -2.147483648E9) {
            return Py.newInteger((int)x);
        }
        PyInteger.err_ovf("integer multiplication");
        return this.__long__().__mul__(right);
    }

    public PyObject __rmul__(PyObject left) {
        return this.int___rmul__(left);
    }

    final PyObject int___rmul__(PyObject left) {
        return this.__mul__(left);
    }

    private static int divide(int x, int y) {
        int xdivy;
        int xmody;
        if (y == 0) {
            throw Py.ZeroDivisionError("integer division or modulo by zero");
        }
        if (y == -1 && x < 0 && x == -x) {
            PyInteger.err_ovf("integer division: " + x + " + " + y);
        }
        if ((xmody = x - (xdivy = x / y) * y) != 0 && (y ^ xmody) < 0) {
            xmody += y;
            --xdivy;
        }
        return xdivy;
    }

    public PyObject __div__(PyObject right) {
        return this.int___div__(right);
    }

    final PyObject int___div__(PyObject right) {
        if (!PyInteger.canCoerce(right)) {
            return null;
        }
        if (Options.divisionWarning > 0) {
            Py.warning(Py.DeprecationWarning, "classic int division");
        }
        return Py.newInteger(PyInteger.divide(this.getValue(), PyInteger.coerce(right)));
    }

    public PyObject __rdiv__(PyObject left) {
        return this.int___rdiv__(left);
    }

    final PyObject int___rdiv__(PyObject left) {
        if (!PyInteger.canCoerce(left)) {
            return null;
        }
        if (Options.divisionWarning > 0) {
            Py.warning(Py.DeprecationWarning, "classic int division");
        }
        return Py.newInteger(PyInteger.divide(PyInteger.coerce(left), this.getValue()));
    }

    public PyObject __floordiv__(PyObject right) {
        return this.int___floordiv__(right);
    }

    final PyObject int___floordiv__(PyObject right) {
        if (!PyInteger.canCoerce(right)) {
            return null;
        }
        return Py.newInteger(PyInteger.divide(this.getValue(), PyInteger.coerce(right)));
    }

    public PyObject __rfloordiv__(PyObject left) {
        return this.int___rfloordiv__(left);
    }

    final PyObject int___rfloordiv__(PyObject left) {
        if (!PyInteger.canCoerce(left)) {
            return null;
        }
        return Py.newInteger(PyInteger.divide(PyInteger.coerce(left), this.getValue()));
    }

    public PyObject __truediv__(PyObject right) {
        return this.int___truediv__(right);
    }

    final PyObject int___truediv__(PyObject right) {
        if (right instanceof PyInteger) {
            return this.__float__().__truediv__(right);
        }
        if (right instanceof PyLong) {
            return this.int___long__().__truediv__(right);
        }
        return null;
    }

    public PyObject __rtruediv__(PyObject left) {
        return this.int___rtruediv__(left);
    }

    final PyObject int___rtruediv__(PyObject left) {
        if (left instanceof PyInteger) {
            return left.__float__().__truediv__(this);
        }
        if (left instanceof PyLong) {
            return left.__truediv__(this.int___long__());
        }
        return null;
    }

    private static int modulo(int x, int y, int xdivy) {
        return x - xdivy * y;
    }

    public PyObject __mod__(PyObject right) {
        return this.int___mod__(right);
    }

    final PyObject int___mod__(PyObject right) {
        if (!PyInteger.canCoerce(right)) {
            return null;
        }
        int rightv = PyInteger.coerce(right);
        int v = this.getValue();
        return Py.newInteger(PyInteger.modulo(v, rightv, PyInteger.divide(v, rightv)));
    }

    public PyObject __rmod__(PyObject left) {
        return this.int___rmod__(left);
    }

    final PyObject int___rmod__(PyObject left) {
        if (!PyInteger.canCoerce(left)) {
            return null;
        }
        int leftv = PyInteger.coerce(left);
        int v = this.getValue();
        return Py.newInteger(PyInteger.modulo(leftv, v, PyInteger.divide(leftv, v)));
    }

    public PyObject __divmod__(PyObject right) {
        return this.int___divmod__(right);
    }

    final PyObject int___divmod__(PyObject right) {
        if (!PyInteger.canCoerce(right)) {
            return null;
        }
        int rightv = PyInteger.coerce(right);
        int v = this.getValue();
        int xdivy = PyInteger.divide(v, rightv);
        return new PyTuple(new PyObject[]{Py.newInteger(xdivy), Py.newInteger(PyInteger.modulo(v, rightv, xdivy))});
    }

    final PyObject int___rdivmod__(PyObject left) {
        if (!PyInteger.canCoerce(left)) {
            return null;
        }
        int leftv = PyInteger.coerce(left);
        int v = this.getValue();
        int xdivy = PyInteger.divide(leftv, v);
        return new PyTuple(new PyObject[]{Py.newInteger(xdivy), Py.newInteger(PyInteger.modulo(leftv, v, xdivy))});
    }

    public PyObject __pow__(PyObject right, PyObject modulo) {
        return this.int___pow__(right, modulo);
    }

    final PyObject int___pow__(PyObject right, PyObject modulo) {
        if (!PyInteger.canCoerce(right)) {
            return null;
        }
        if (modulo != null && !PyInteger.canCoerce(modulo)) {
            return null;
        }
        return PyInteger._pow(this.getValue(), PyInteger.coerce(right), modulo, this, right);
    }

    public PyObject __rpow__(PyObject left, PyObject modulo) {
        if (!PyInteger.canCoerce(left)) {
            return null;
        }
        if (modulo != null && !PyInteger.canCoerce(modulo)) {
            return null;
        }
        return PyInteger._pow(PyInteger.coerce(left), this.getValue(), modulo, left, this);
    }

    final PyObject int___rpow__(PyObject left) {
        return this.__rpow__(left, null);
    }

    private static PyObject _pow(int value, int pow, PyObject modulo, PyObject left, PyObject right) {
        int mod = 0;
        long tmp = value;
        boolean neg = false;
        if (tmp < 0L) {
            tmp = -tmp;
            neg = (pow & 1) != 0;
        }
        long result = 1L;
        if (pow < 0) {
            if (value != 0) {
                return left.__float__().__pow__(right, modulo);
            }
            throw Py.ZeroDivisionError("cannot raise 0 to a negative power");
        }
        if (modulo != null && (mod = PyInteger.coerce(modulo)) == 0) {
            throw Py.ValueError("pow(x, y, z) with z==0");
        }
        while (pow > 0) {
            if ((pow & 1) != 0) {
                result *= tmp;
                if (mod != 0) {
                    result %= (long)mod;
                }
                if (result > Integer.MAX_VALUE) {
                    PyInteger.err_ovf("integer exponentiation");
                    return left.__long__().__pow__(right, modulo);
                }
            }
            if ((pow >>= 1) == 0) break;
            tmp *= tmp;
            if (mod != 0) {
                tmp %= (long)mod;
            }
            if (tmp <= Integer.MAX_VALUE) continue;
            PyInteger.err_ovf("integer exponentiation");
            return left.__long__().__pow__(right, modulo);
        }
        int ret = (int)result;
        if (neg) {
            ret = -ret;
        }
        if (mod != 0) {
            ret = PyInteger.modulo(ret, mod, PyInteger.divide(ret, mod));
        }
        return Py.newInteger(ret);
    }

    public PyObject __lshift__(PyObject right) {
        return this.int___lshift__(right);
    }

    final PyObject int___lshift__(PyObject right) {
        if (!(right instanceof PyInteger)) {
            if (right instanceof PyLong) {
                return this.int___long__().__lshift__(right);
            }
            return null;
        }
        int rightv = ((PyInteger)right).getValue();
        if (rightv > 31) {
            return Py.newInteger(0);
        }
        if (rightv < 0) {
            throw Py.ValueError("negative shift count");
        }
        return Py.newInteger(this.getValue() << rightv);
    }

    final PyObject int___rlshift__(PyObject left) {
        if (!(left instanceof PyInteger)) {
            if (left instanceof PyLong) {
                return left.__rlshift__(this.int___long__());
            }
            return null;
        }
        int leftv = ((PyInteger)left).getValue();
        if (this.getValue() > 31) {
            return Py.newInteger(0);
        }
        if (this.getValue() < 0) {
            throw Py.ValueError("negative shift count");
        }
        return Py.newInteger(leftv << this.getValue());
    }

    public PyObject __rshift__(PyObject right) {
        return this.int___rshift__(right);
    }

    final PyObject int___rshift__(PyObject right) {
        if (!(right instanceof PyInteger)) {
            if (right instanceof PyLong) {
                return this.int___long__().__rshift__(right);
            }
            return null;
        }
        int rightv = ((PyInteger)right).getValue();
        if (rightv < 0) {
            throw Py.ValueError("negative shift count");
        }
        return Py.newInteger(this.getValue() >> rightv);
    }

    final PyObject int___rrshift__(PyObject left) {
        if (!(left instanceof PyInteger)) {
            if (left instanceof PyLong) {
                return left.__rshift__(this.int___long__());
            }
            return null;
        }
        int leftv = ((PyInteger)left).getValue();
        if (this.getValue() < 0) {
            throw Py.ValueError("negative shift count");
        }
        return Py.newInteger(leftv >> this.getValue());
    }

    public PyObject __and__(PyObject right) {
        return this.int___and__(right);
    }

    final PyObject int___and__(PyObject right) {
        if (!(right instanceof PyInteger)) {
            if (right instanceof PyLong) {
                return this.int___long__().__and__(right);
            }
            return null;
        }
        int rightv = ((PyInteger)right).getValue();
        return Py.newInteger(this.getValue() & rightv);
    }

    final PyObject int___rand__(PyObject left) {
        return this.int___and__(left);
    }

    public PyObject __xor__(PyObject right) {
        return this.int___xor__(right);
    }

    final PyObject int___xor__(PyObject right) {
        if (!(right instanceof PyInteger)) {
            if (right instanceof PyLong) {
                return this.int___long__().__xor__(right);
            }
            return null;
        }
        int rightv = ((PyInteger)right).getValue();
        return Py.newInteger(this.getValue() ^ rightv);
    }

    final PyObject int___rxor__(PyObject left) {
        if (!(left instanceof PyInteger)) {
            if (left instanceof PyLong) {
                return left.__rxor__(this.int___long__());
            }
            return null;
        }
        int leftv = ((PyInteger)left).getValue();
        return Py.newInteger(leftv ^ this.getValue());
    }

    public PyObject __or__(PyObject right) {
        return this.int___or__(right);
    }

    final PyObject int___or__(PyObject right) {
        if (!(right instanceof PyInteger)) {
            if (right instanceof PyLong) {
                return this.int___long__().__or__(right);
            }
            return null;
        }
        int rightv = ((PyInteger)right).getValue();
        return Py.newInteger(this.getValue() | rightv);
    }

    final PyObject int___ror__(PyObject left) {
        return this.int___or__(left);
    }

    public PyObject __neg__() {
        return this.int___neg__();
    }

    final PyObject int___neg__() {
        int x = -this.getValue();
        if (this.getValue() < 0 && x < 0) {
            PyInteger.err_ovf("integer negation");
        }
        return Py.newInteger(x);
    }

    public PyObject __pos__() {
        return this.int___pos__();
    }

    final PyObject int___pos__() {
        return Py.newInteger(this.getValue());
    }

    public PyObject __abs__() {
        return this.int___abs__();
    }

    final PyObject int___abs__() {
        if (this.getValue() >= 0) {
            return Py.newInteger(this.getValue());
        }
        return this.__neg__();
    }

    public PyObject __invert__() {
        return this.int___invert__();
    }

    final PyObject int___invert__() {
        return Py.newInteger(~this.getValue());
    }

    public PyObject __int__() {
        return this.int___int__();
    }

    final PyInteger int___int__() {
        return Py.newInteger(this.getValue());
    }

    public PyLong __long__() {
        return this.int___long__();
    }

    final PyLong int___long__() {
        return new PyLong(this.getValue());
    }

    public PyFloat __float__() {
        return this.int___float__();
    }

    final PyFloat int___float__() {
        return new PyFloat((double)this.getValue());
    }

    public PyComplex __complex__() {
        return new PyComplex(this.getValue(), 0.0);
    }

    public PyString __oct__() {
        return this.int___oct__();
    }

    final PyString int___oct__() {
        if (this.getValue() < 0) {
            return new PyString("0" + Long.toString(0x100000000L + (long)this.getValue(), 8));
        }
        if (this.getValue() > 0) {
            return new PyString("0" + Integer.toString(this.getValue(), 8));
        }
        return new PyString("0");
    }

    public PyString __hex__() {
        return this.int___hex__();
    }

    final PyString int___hex__() {
        if (this.getValue() < 0) {
            return new PyString("0x" + Long.toString(0x100000000L + (long)this.getValue(), 16));
        }
        return new PyString("0x" + Integer.toString(this.getValue(), 16));
    }

    public boolean isMappingType() {
        return false;
    }

    public boolean isSequenceType() {
        return false;
    }

    public long asLong(int index) throws PyObject.ConversionException {
        return this.getValue();
    }

    public int asInt(int index) throws PyObject.ConversionException {
        return this.getValue();
    }

    public PyObject __reduce__() {
        return this.int___reduce__();
    }

    final PyObject int___reduce__() {
        return new PyTuple(new PyObject[]{this.getType(), new PyTuple(new PyObject[]{Py.newInteger(this.getValue())})});
    }
}

