/*
 * Decompiled with CFR 0.152.
 */
package dods.servers.sql;

import dods.util.iniFile;
import gnu.getopt.Getopt;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class JDBCTest {
    public static String DDSFile;
    public static String ConstraintExpression;
    public static String sqlQuery;
    public static String iniFileName;
    private static boolean verboseOutput;
    private static PrintStream dOut;

    public JDBCTest() {
        iniFileName = "DODS.ini";
        sqlQuery = "SELECT * FROM *";
        dOut = System.out;
    }

    public static void main(String[] args) throws Exception {
        JDBCTest jdbct = new JDBCTest();
        try {
            if (JDBCTest.parse_options(args)) {
                System.out.println("-------------------------------------------");
                System.out.println(".ini File: " + iniFileName);
                System.out.println("SQL Query: " + sqlQuery);
                System.out.println("Attempting to Connect to DBMS.");
                Statement stmnt = JDBCTest.connect2DB();
                if (stmnt != null) {
                    System.out.println("Connected to database.");
                }
                System.out.println("Sending Query.");
                ResultSet rs = stmnt.executeQuery(sqlQuery);
                if (rs != null) {
                    System.out.println("Got ResultSet From DBMS.");
                }
                if (!JDBCTest.processResult(rs)) {
                    System.out.println("\n\n\nYour Query Produced No Matches in The Database.\n\n");
                }
                stmnt.close();
                System.out.println("-------------------------------------------");
            }
        }
        catch (Throwable e) {
            System.out.println("\n\nERROR of Type: " + e.getClass().getName() + "\n");
            System.out.println("Message:\n" + e.getMessage() + "\n");
            System.out.println("Stack Trace: ");
            e.printStackTrace(System.out);
            System.out.println("\n\n");
        }
        System.exit(0);
    }

    public static Statement connect2DB() throws SQLException, FileNotFoundException, IOException {
        Connection conn = null;
        Statement stmt = null;
        String jdbcDriver = "oracle.jdbc.driver.OracleDriver";
        String connectionURL = "jdbc:oracle:thin:@whsun4.wh.whoi.edu:1526:nefsc2";
        String uname = "";
        String password = "";
        iniFile inf = new iniFile(iniFileName);
        if (inf.setSection("JDBC")) {
            String tmp = null;
            tmp = inf.getProperty("driver");
            if (tmp != null) {
                jdbcDriver = tmp;
            }
            if ((tmp = inf.getProperty("connectionurl")) != null) {
                connectionURL = tmp;
            }
            if ((tmp = inf.getProperty("username")) != null) {
                uname = tmp;
            }
            if ((tmp = inf.getProperty("password")) != null) {
                password = tmp;
            }
        }
        dOut.println("Using JDBC Driver:    " + jdbcDriver);
        dOut.println("Using Connection URL: " + connectionURL);
        dOut.println("Using user:           " + uname);
        dOut.println("Using Password:       " + password);
        try {
            Class.forName(jdbcDriver);
        }
        catch (ClassNotFoundException e) {
            throw new SQLException("\n Cannot Load JDBC Driver Class: " + e.getMessage() + "\n Is the driver name spelled correctly?" + "\n Is the .class file or the jar file" + "\n containing the driver on the CLASSPATH ??\n\n");
        }
        System.out.println("Attempting to getConnection()");
        conn = DriverManager.getConnection(connectionURL, uname, password);
        System.out.println("Attempting to createStatement()");
        stmt = conn.createStatement();
        return stmt;
    }

    public static boolean processResult(ResultSet result) throws SQLException, IOException {
        ResultSetMetaData meta = result.getMetaData();
        int count = meta.getColumnCount();
        JDBCTest.printColumnNames(meta);
        int limit = 0;
        boolean done = false;
        while (result.next() && !done) {
            for (int c = 1; c <= count; ++c) {
                String tmp = result.getString(c);
                if (!verboseOutput) continue;
                if (tmp == null) {
                    dOut.println("null ");
                }
                dOut.print(tmp + "   ");
            }
            if (verboseOutput) {
                dOut.println("");
            }
            ++limit;
        }
        dOut.println("\nScanned " + limit + " rows...");
        return limit != 0;
    }

    public static void printColumnNames(ResultSetMetaData m) throws SQLException {
        int i;
        int count = m.getColumnCount();
        String metaStuff = "";
        for (int c = 1; c <= count; ++c) {
            String name = m.getColumnName(c);
            String type = m.getColumnTypeName(c);
            name = name == null ? "NULL  " : name + "(" + type + ")  ";
            metaStuff = metaStuff + name;
        }
        for (i = 0; i < metaStuff.length(); ++i) {
            dOut.print("-");
        }
        dOut.println("");
        dOut.println(metaStuff);
        for (i = 0; i < metaStuff.length(); ++i) {
            dOut.print("-");
        }
        dOut.println("");
    }

    public static boolean parse_options(String[] args) {
        int c;
        boolean retVal = true;
        Getopt g = new Getopt("JDBCTest", args, "q:i:v:h:");
        block6: while ((c = g.getopt()) != -1) {
            switch (c) {
                case 113: {
                    String arg = g.getOptarg();
                    dOut.print("SQL Query: " + (arg != null ? arg : "null") + "\n");
                    sqlQuery = arg;
                    continue block6;
                }
                case 118: {
                    verboseOutput = true;
                    String arg = g.getOptarg();
                    dOut.print("Verbose Output: ON\n");
                    continue block6;
                }
                case 105: {
                    String arg = g.getOptarg();
                    dOut.print("iniFile: \"" + (arg != null ? arg : "null") + "\"\n");
                    if (arg == null) continue block6;
                    iniFileName = arg;
                    continue block6;
                }
                case 104: {
                    String arg = g.getOptarg();
                }
            }
            System.out.println("*******************************************************************************************************************");
            System.out.println("Usage:");
            System.out.println("JDBCTest [-q \"SqlQuery\"] [-v] [-i iniFileName]");
            System.out.println("Where:");
            System.out.println("    -q \"SqlQuery\" = This option specifies the SQL query for the DBMS.");
            System.out.println("                      SqlQuery must be a correctly formatted SQL Query for the target database.");
            System.out.println("                      (It should be a SELECT statement.)");
            System.out.println("                      And it must be contained in quotes (\").");
            System.out.println("    -v = Turns on verbose mode. (This will show you all of the returned data");
            System.out.println("         from the DBMS.  Default: off");
            System.out.println("    -i iniFileName = The name of the .ini file containing all of the JDBC information.");
            System.out.println("         The file MUST BE in your home directory.");
            System.out.println("         Default: \"DODS.ini\"");
            System.out.println("");
            System.out.println("Examples:");
            System.out.println("    java dods.servers.sql.JDBCTest -q \"Select distinct instrument_id from drifter\"");
            System.out.println("    java dods.servers.sql.JDBCTest -v -q \"Select distinct instrument_id from drifter\"");
            System.out.println("    java dods.servers.sql.JDBCTest -v -i \"my.ini -q\" \"Select distinct instrument_id from drifter\"");
            System.out.println("*******************************************************************************************************************");
            retVal = false;
        }
        return retVal;
    }
}

