/*
 * Decompiled with CFR 0.152.
 */
package dods.servlet.jake;

import dods.dap.DAS;
import dods.dap.DConnect;
import dods.dap.DDS;
import dods.dap.DODSException;
import dods.dap.DataDDS;
import dods.servlet.jake.DispatchServlet;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DAPServlet
extends DispatchServlet {
    public void getDAS(HttpServletRequest req, HttpServletResponse res, String path, String ce) throws ServletException, IOException {
        ServletOutputStream out = res.getOutputStream();
        String docPath = this.getServletContext().getRealPath(path) + ".das";
        try {
            FileInputStream is = new FileInputStream(docPath);
            DAS das = new DAS();
            das.parse(is);
            das.print((OutputStream)out);
        }
        catch (FileNotFoundException e) {
            res.setHeader("Content-Description", "dods_error");
            DODSException de = new DODSException(1, "file not found: " + docPath);
            de.print((OutputStream)out);
        }
        catch (Exception e) {
            res.setHeader("Content-Description", "dods_error");
            DODSException de = new DODSException(0, e.getMessage());
            de.print((OutputStream)out);
        }
    }

    public void getDDS(HttpServletRequest req, HttpServletResponse res, String path, String ce) throws ServletException, IOException {
        ServletOutputStream out = res.getOutputStream();
        String docPath = this.getServletContext().getRealPath(path) + ".dds";
        try {
            FileInputStream is = new FileInputStream(docPath);
            DDS dds = new DDS();
            dds.parse(is);
            dds.print((OutputStream)out);
        }
        catch (FileNotFoundException e) {
            res.setHeader("Content-Description", "dods_error");
            DODSException de = new DODSException(1, "file not found: " + docPath);
            de.print((OutputStream)out);
        }
        catch (Exception e) {
            res.setHeader("Content-Description", "dods_error");
            DODSException de = new DODSException(0, e.getMessage());
            de.print((OutputStream)out);
        }
    }

    public void getData(HttpServletRequest req, HttpServletResponse res, String path, String ce, boolean compress) throws ServletException, IOException {
        ServletOutputStream out = res.getOutputStream();
        String docPath = this.getServletContext().getRealPath(path) + ".dods";
        try {
            DConnect con = new DConnect(docPath, true);
            DataDDS dds = con.getData(null);
            dds.externalize((OutputStream)out, compress, false);
        }
        catch (FileNotFoundException e) {
            res.setContentType("text/plain");
            res.setHeader("Content-Description", "dods_error");
            res.setHeader("Content-Encoding", "none");
            DODSException de = new DODSException(1, "file not found: " + docPath);
            de.print((OutputStream)out);
        }
        catch (Exception e) {
            res.setContentType("text/plain");
            res.setHeader("Content-Description", "dods_error");
            res.setHeader("Content-Encoding", "none");
            DODSException de = new DODSException(0, e.getMessage());
            de.print((OutputStream)out);
        }
    }
}

