/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.pds.objectAccess.example;

import gov.nasa.arc.pds.xml.generated.FileAreaObservational;
import gov.nasa.arc.pds.xml.generated.ProductObservational;
import gov.nasa.arc.pds.xml.generated.TableCharacter;
import gov.nasa.arc.pds.xml.generated.TableDelimited;
import gov.nasa.pds.label.object.FieldDescription;
import gov.nasa.pds.label.object.TableRecord;
import gov.nasa.pds.objectAccess.ExporterFactory;
import gov.nasa.pds.objectAccess.ObjectAccess;
import gov.nasa.pds.objectAccess.ParseException;
import gov.nasa.pds.objectAccess.TableReader;
import gov.nasa.pds.objectAccess.utility.Utility;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class ExtractTable {
    private static final String HELP_OPTION = "help";
    private static final String EXTRACT_ALL = "all";
    private static final String LIST_TABLES_OPTION = "list-tables";
    private static final String FIELDS_OPTION = "fields";
    private static final String INDEX_OPTION = "index";
    private static final String DATA_FILE_OPTION = "data-file";
    private static final String OUTPUT_FILE_OPTION = "output-file";
    private static final String CSV_OPTION = "csv";
    private static final String FIXED_WIDTH_OPTION = "fixed-width";
    private static final String FIELD_SEPARATOR_OPTION = "field-separator";
    private static final String QUOTE_CHARACTER_OPTION = "quote-character";
    private static final String PLATFORM_OPTION = "platform";
    private static final String UNIX_OPTION = "unix";
    private static final String WINDOWS_OPTION = "windows";
    private static final String PROGRAM_NAME = "pds4.tools.progname";
    private Options options = new Options();
    private boolean listTables;
    private boolean extractAll;
    private URL labelUrl;
    private File outputFile;
    private File dataFile;
    private PrintWriter out;
    private OutputFormat format;
    private String fieldSeparator;
    private String lineSeparator;
    private String quoteCharacter;
    private Pattern quoteCharacterPattern;
    private int tableIndex;
    private String[] requestedFields;

    public static void main(String[] args) {
        new ExtractTable().run(args);
    }

    public ExtractTable() {
        this.options.addOption("h", HELP_OPTION, false, "show help text");
        this.options.addOption("l", LIST_TABLES_OPTION, false, "list tables present in the product (overrides all but output file options)");
        Option tableIndex = new Option("n", INDEX_OPTION, true, "table index, if more than one table is present (1..N) (default is 1)");
        tableIndex.setArgName("NUMBER");
        this.options.addOption(tableIndex);
        Option dataFile = new Option("d", DATA_FILE_OPTION, true, "data file name, if more than one data file is present (default is the first one listed)");
        dataFile.setArgName("FILE");
        this.options.addOption(dataFile);
        Option fields = new Option("f", FIELDS_OPTION, true, "comma-separated list of field names or numbers (default is all fields)");
        fields.setArgName("FIELD_LIST");
        fields.setValueSeparator(',');
        this.options.addOption(fields);
        Option outputFile = new Option("o", OUTPUT_FILE_OPTION, true, "output file name (default is stdout)");
        outputFile.setArgName("FILE");
        this.options.addOption(outputFile);
        Option fieldSep = new Option("t", FIELD_SEPARATOR_OPTION, true, "output field separator (default is 1 space for fixed-width, or comma for CSV)");
        fieldSep.setArgName("SEP");
        this.options.addOption(fieldSep);
        this.options.addOption("c", CSV_OPTION, false, "output in CSV format");
        this.options.addOption("w", FIXED_WIDTH_OPTION, false, "output in fixed-width format (default)");
        Option quoteChar = new Option("q", QUOTE_CHARACTER_OPTION, true, "quote character (for CSV output)");
        quoteChar.setArgName("CHAR");
        this.options.addOption(quoteChar);
        this.options.addOption("W", WINDOWS_OPTION, false, "output using Windows line separator (CRLF)");
        this.options.addOption("U", UNIX_OPTION, false, "output using Unix line separator (LF)");
        this.options.addOption("P", PLATFORM_OPTION, false, "output using current platform line separator (default)");
        this.options.addOption("a", EXTRACT_ALL, false, "extract all tables");
    }

    private void run(String[] args) {
        this.parseArguments(args);
        if (this.outputFile != null) {
            try {
                this.out = new PrintWriter(new FileWriter(this.outputFile));
            }
            catch (IOException e) {
                System.err.println("Cannot open output file: " + e.getMessage());
                System.exit(1);
            }
        } else {
            this.out = new PrintWriter(new OutputStreamWriter(System.out));
        }
        try {
            Utility.openConnection(this.labelUrl.openConnection()).close();
        }
        catch (IOException io) {
            System.err.println("Cannot read label file " + this.labelUrl.toString());
            System.exit(1);
        }
        ObjectAccess objectAccess = null;
        ProductObservational product = null;
        URL parent = null;
        try {
            objectAccess = new ObjectAccess();
            product = objectAccess.getProduct(this.labelUrl, ProductObservational.class);
            parent = this.labelUrl.toURI().getPath().endsWith("/") ? this.labelUrl.toURI().resolve("..").toURL() : this.labelUrl.toURI().resolve(".").toURL();
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
        catch (MalformedURLException mu) {
            System.err.println(mu.getMessage());
            mu.printStackTrace();
            System.exit(1);
        }
        catch (URISyntaxException ue) {
            System.err.println(ue.getMessage());
            ue.printStackTrace();
            System.exit(1);
        }
        for (FileAreaObservational fileArea : product.getFileAreaObservationals()) {
            String fileName = fileArea.getFile().getFileName();
            URL dataFile = null;
            try {
                dataFile = new URL(parent, fileName);
            }
            catch (MalformedURLException mu) {
                mu.printStackTrace();
                System.exit(1);
            }
            if (this.listTables) {
                this.out.println("\nfile: " + dataFile.toString());
            }
            int currentIndex = 1;
            for (Object obj : objectAccess.getTableObjects(fileArea)) {
                TableType tableType = TableType.FIXED_BINARY;
                if (obj instanceof TableCharacter) {
                    tableType = TableType.FIXED_TEXT;
                } else if (obj instanceof TableDelimited) {
                    tableType = TableType.DELIMITED;
                }
                TableReader reader = null;
                try {
                    reader = ExporterFactory.getTableReader(obj, dataFile);
                }
                catch (Exception ex) {
                    System.err.println("Cannot create a table reader for the table: " + ex.getMessage());
                    ex.printStackTrace();
                    this.out.close();
                    return;
                }
                if (this.listTables) {
                    this.out.println("  table " + currentIndex + ": " + tableType.getReadableType());
                    this.listFields(reader.getFields());
                } else if (this.extractAll || currentIndex == this.tableIndex && (this.dataFile == null || this.dataFile.getName().equalsIgnoreCase(fileName))) {
                    this.extractTable(reader);
                    break;
                }
                ++currentIndex;
            }
            if (this.listTables || this.dataFile != null || this.extractAll) continue;
            break;
        }
        this.out.close();
    }

    private void listFields(FieldDescription[] fields) {
        int i = 0;
        for (FieldDescription field : fields) {
            this.out.println("    field " + ++i + ": " + field.getName() + " (" + field.getType().getXMLType() + ")");
        }
    }

    private void extractTable(TableReader reader) {
        FieldDescription[] fields = reader.getFields();
        int[] displayFields = this.getSelectedFields(fields);
        int[] fieldLengths = this.getFieldLengths(fields, displayFields);
        this.displayHeaders(fields, displayFields, fieldLengths);
        this.displayRows(reader, fields, displayFields, fieldLengths);
    }

    private int[] getSelectedFields(FieldDescription[] fields) {
        int[] displayFields;
        if (this.requestedFields == null) {
            displayFields = new int[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                displayFields[i] = i;
            }
        } else {
            displayFields = new int[this.requestedFields.length];
            for (int i = 0; i < this.requestedFields.length; ++i) {
                displayFields[i] = this.findField(this.requestedFields[i], fields);
            }
        }
        return displayFields;
    }

    private int findField(String nameOrIndex, FieldDescription[] fields) {
        try {
            return Integer.parseInt(nameOrIndex) - 1;
        }
        catch (NumberFormatException numberFormatException) {
            for (int i = 0; i < fields.length; ++i) {
                if (!nameOrIndex.equalsIgnoreCase(fields[i].getName())) continue;
                return i;
            }
            System.err.println("Requested field not present in table: " + nameOrIndex);
            System.exit(1);
            return -1;
        }
    }

    private int[] getFieldLengths(FieldDescription[] fields, int[] displayFields) {
        int[] fieldLengths = new int[displayFields.length];
        for (int i = 0; i < displayFields.length; ++i) {
            int fieldIndex = displayFields[i];
            fieldLengths[i] = this.format == OutputFormat.CSV ? 0 : Math.max(fields[fieldIndex].getName().length(), fields[fieldIndex].getLength());
        }
        return fieldLengths;
    }

    private void displayHeaders(FieldDescription[] fields, int[] displayFields, int[] fieldLengths) {
        for (int i = 0; i < displayFields.length; ++i) {
            if (i > 0) {
                this.out.append(this.fieldSeparator);
            }
            FieldDescription field = fields[displayFields[i]];
            this.displayJustified(field.getName(), fieldLengths[i], field.getType().isRightJustified());
        }
        this.out.append(this.lineSeparator);
    }

    private void displayRows(TableReader reader, FieldDescription[] fields, int[] displayFields, int[] fieldLengths) {
        try {
            TableRecord record;
            while ((record = reader.readNext()) != null) {
                for (int i = 0; i < displayFields.length; ++i) {
                    if (i > 0) {
                        this.out.append(this.fieldSeparator);
                    }
                    int index = displayFields[i];
                    FieldDescription field = fields[index];
                    this.displayJustified(record.getString(index + 1).trim(), fieldLengths[i], field.getType().isRightJustified());
                }
                this.out.append(this.lineSeparator);
            }
        }
        catch (IOException e) {
            System.err.println("Cannot read the next table record: " + e.getMessage());
            System.exit(1);
        }
    }

    private void displayJustified(String s, int length, boolean isRightJustified) {
        if (this.format == OutputFormat.CSV) {
            if (s.contains(this.quoteCharacter)) {
                Matcher matcher = this.quoteCharacterPattern.matcher(s);
                s = matcher.replaceAll(this.quoteCharacter + this.quoteCharacter);
            }
            if (s.trim().isEmpty() || s.contains(this.fieldSeparator)) {
                s = this.quoteCharacter + s + this.quoteCharacter;
            }
        }
        int padding = length - s.length();
        if (isRightJustified) {
            this.displayPadding(padding);
        }
        this.out.append(s);
        if (!isRightJustified) {
            this.displayPadding(padding);
        }
    }

    private void displayPadding(int n) {
        for (int i = 0; i < n; ++i) {
            this.out.append(' ');
        }
    }

    private void parseArguments(String[] args) {
        GnuParser parser = new GnuParser();
        CommandLine cmdLine = null;
        try {
            cmdLine = parser.parse(this.options, args);
        }
        catch (org.apache.commons.cli.ParseException e) {
            this.showHelp("Error parsing command-line options: " + e.getMessage(), 1);
        }
        if (cmdLine.hasOption(HELP_OPTION)) {
            this.showHelp(null, 0);
        }
        this.listTables = cmdLine.hasOption(LIST_TABLES_OPTION);
        this.extractAll = cmdLine.hasOption(EXTRACT_ALL);
        this.tableIndex = cmdLine.hasOption(INDEX_OPTION) ? Integer.parseInt(cmdLine.getOptionValue(INDEX_OPTION)) : 1;
        this.dataFile = cmdLine.hasOption(DATA_FILE_OPTION) ? new File(cmdLine.getOptionValue(DATA_FILE_OPTION)) : null;
        String[] files = cmdLine.getArgs();
        if (files.length == 0) {
            this.showHelp("A label file is required", 1);
        }
        try {
            this.labelUrl = new URL(files[0]);
        }
        catch (MalformedURLException u) {
            File file = new File(files[0]);
            file = file.getAbsoluteFile();
            try {
                this.labelUrl = file.toURI().toURL();
            }
            catch (MalformedURLException mu) {
                mu.printStackTrace();
                System.exit(1);
            }
        }
        this.format = cmdLine.hasOption(CSV_OPTION) ? OutputFormat.CSV : OutputFormat.FIXED_WIDTH;
        this.fieldSeparator = cmdLine.hasOption(FIELD_SEPARATOR_OPTION) ? cmdLine.getOptionValue(FIELD_SEPARATOR_OPTION) : (this.format == OutputFormat.FIXED_WIDTH ? " " : ",");
        this.quoteCharacter = cmdLine.hasOption(QUOTE_CHARACTER_OPTION) ? cmdLine.getOptionValue(QUOTE_CHARACTER_OPTION) : "\"";
        this.quoteCharacterPattern = Pattern.compile("\\Q" + this.quoteCharacter + "\\E");
        this.lineSeparator = cmdLine.hasOption(WINDOWS_OPTION) ? "\r\n" : (cmdLine.hasOption(UNIX_OPTION) ? "\n" : System.getProperty("line.separator"));
        this.requestedFields = !cmdLine.hasOption(FIELDS_OPTION) ? null : cmdLine.getOptionValue(FIELDS_OPTION).split(" *, *");
        this.outputFile = cmdLine.hasOption(OUTPUT_FILE_OPTION) ? new File(cmdLine.getOptionValue(OUTPUT_FILE_OPTION)) : null;
    }

    private void showHelp(String errorMessage, int exitCode) {
        if (errorMessage != null) {
            System.err.println(errorMessage);
            System.err.println();
        }
        String programName = this.getClass().getName();
        if (System.getProperty(PROGRAM_NAME) != null) {
            programName = System.getProperty(PROGRAM_NAME);
        }
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(programName + " [-f field,...] [-o outputfile] [options] labelfile", this.options);
        System.exit(exitCode);
    }

    private static enum OutputFormat {
        CSV,
        FIXED_WIDTH;

    }

    private static enum TableType {
        FIXED_BINARY("fixed-width binary table"),
        FIXED_TEXT("fixed-width character table"),
        DELIMITED("delimited table");

        private String readableType;

        private TableType(String readableType) {
            this.readableType = readableType;
        }

        public String getReadableType() {
            return this.readableType;
        }
    }
}

