/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * BinaryDataSourceFormatEditorPanel.java
 *
 * Created on Jul 18, 2011, 4:43:42 PM
 */
package org.autoplot.cdf;

import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.DataSourceFormatEditorPanel;

/**
 *
 * @author jbf
 */
public class CdfDataSourceFormatEditorPanel extends javax.swing.JPanel implements DataSourceFormatEditorPanel {

    /** Creates new form BinaryDataSourceFormatEditorPanel */
    public CdfDataSourceFormatEditorPanel() {
        initComponents();
    }

    String file;

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        typeComboBox = new javax.swing.JComboBox();
        insertCB = new javax.swing.JCheckBox();
        epochTimeTagsCB = new javax.swing.JCheckBox();
        bundleCB = new javax.swing.JCheckBox();
        majorityCB = new javax.swing.JCheckBox();

        setName("dataSourceFormatEditorPanel"); // NOI18N

        jLabel1.setText("Type:");

        typeComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "double", "float", "int4", "int2", "byte" }));

        insertCB.setText("Insert instead of overwriting existing cdf file, allowing skeleton to be used.");

        epochTimeTagsCB.setText("Use legacy Epoch timetags instead of TT2000");

        bundleCB.setText("Unpack bundled data into separate variables");

        majorityCB.setText("Use row majority (faster in some situations)");

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(jLabel1)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(typeComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 123, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(insertCB)
                    .add(epochTimeTagsCB)
                    .add(bundleCB)
                    .add(majorityCB))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel1)
                    .add(typeComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(insertCB)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(epochTimeTagsCB)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(bundleCB)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(majorityCB)
                .addContainerGap(154, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox bundleCB;
    private javax.swing.JCheckBox epochTimeTagsCB;
    private javax.swing.JCheckBox insertCB;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JCheckBox majorityCB;
    private javax.swing.JComboBox typeComboBox;
    // End of variables declaration//GEN-END:variables

    public JPanel getPanel() {
        return this;
    }

    private String getParam( Map<String,String> args, String name, String defl ) {
        String s= args.get(name);
        if ( s==null ) {
            return defl;
        } else {
            return s;
        }
    }
    public void setURI(String uri) {
        URISplit split= URISplit.parse(uri);
        Map<String,String> args= URISplit.parseParams(split.params);

        String s;
        s= getParam( args,"type","double");
        typeComboBox.setSelectedItem(s);
        
        s= getParam( args, "append", "F" );
        insertCB.setSelected(s.equals("T"));

        s= getParam( args, "timeType", "tt2000" );
        epochTimeTagsCB.setSelected(s.equals("epoch"));
        
        s= getParam( args, "bundle", "F" );
        bundleCB.setSelected(s.equals("T"));
        
        s= getParam( args, "marjority", "column" );
        majorityCB.setSelected(s.equals("row"));

        file= split.file;
    }

    public String getURI() {
        String result= file;
        Map<String,String> args= new HashMap();

        String s;
        s= (String) typeComboBox.getSelectedItem();
        if ( !s.equals("double") ) args.put( "type", s );

        if ( insertCB.isSelected() ) {
            args.put("append", "T");
        } else {
            args.remove("append");            
        }

        if ( epochTimeTagsCB.isSelected() ) {
            args.put("timeType", "epoch");
        } else {
            args.remove("timeType");            
        }
        
        if ( bundleCB.isSelected() ) {
            args.put("bundle", "T");
        } else {
            args.remove("bundle");
        }
        
        if ( majorityCB.isSelected() ) {
            args.put("majority", "row");
        } else {
            args.remove("majority");
        }
        
        String params= URISplit.formatParams(args);
        if ( result==null ) result= "file:///";
        URISplit ss= URISplit.parse(result);

        if ( params.length()>0 ) {
            ss.params= params;
        }
        return URISplit.format( ss );

    }

}
