/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.arc.pds.tools.container;

import gov.nasa.arc.pds.tools.container.BaseContainerInterface;
import gov.nasa.arc.pds.tools.util.FileUtils;
import java.io.File;
import java.io.Serializable;

public class FileMirror
implements Serializable,
BaseContainerInterface {
    private static final long serialVersionUID = 6829391263115726395L;
    protected final String name;
    protected final Boolean isDirectory;
    protected final String relativePath;
    protected final String parent;
    protected final long length;

    public FileMirror(File file, File root) {
        this.name = file.getName();
        this.isDirectory = file.isDirectory();
        this.relativePath = FileUtils.getRelativePath(root, file);
        this.parent = !this.relativePath.equals("") ? FileUtils.getRelativePath(root, file.getParentFile()) : null;
        this.length = file.length();
    }

    public String getName() {
        return this.name;
    }

    public Boolean isDirectory() {
        return this.isDirectory;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public String getParent() {
        return this.parent;
    }

    public long length() {
        return this.length;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        String className = "";
        if (obj != null) {
            className = obj.getClass().getName();
        }
        if (obj == null || !className.contains("FileMirror") && !className.contains("FileNode")) {
            return false;
        }
        FileMirror node = (FileMirror)obj;
        return this.relativePath.equals(node.getRelativePath()) && this.isDirectory.equals(node.isDirectory());
    }
}

