/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.pds.label.object;

import gov.nasa.pds.label.object.DataObject;
import gov.nasa.pds.label.object.FieldDescription;
import gov.nasa.pds.label.object.TableRecord;
import gov.nasa.pds.objectAccess.ExporterFactory;
import gov.nasa.pds.objectAccess.TableReader;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class TableObject
extends DataObject {
    private Object tableObject;
    private TableReader tableReader;

    public TableObject(File parentDir, gov.nasa.arc.pds.xml.generated.File fileObject, Object tableObject, long offset, long size) throws Exception {
        this(parentDir.toURI().toURL(), fileObject, tableObject, offset, size);
    }

    public TableObject(URL parentDir, gov.nasa.arc.pds.xml.generated.File fileObject, Object tableObject, long offset, long size) throws Exception {
        super(parentDir, fileObject, offset, size);
        this.tableObject = tableObject;
        this.tableReader = this.getTableReader();
    }

    private TableReader getTableReader() throws Exception {
        return ExporterFactory.getTableReader(this.tableObject, this.getDataFile());
    }

    public FieldDescription[] getFields() {
        return this.tableReader.getFields();
    }

    public TableRecord readNext() throws IOException {
        return this.tableReader.readNext();
    }

    public TableRecord getRecord(int index) throws IllegalArgumentException, IOException {
        return this.tableReader.getRecord(index);
    }
}

