/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.pds.objectAccess.array;

import gov.nasa.pds.objectAccess.array.DataTypeAdapter;
import gov.nasa.pds.objectAccess.array.IntegerAdapter;
import java.nio.ByteBuffer;

public class FloatAdapter
implements DataTypeAdapter {
    private IntegerAdapter valueAdapter;

    public FloatAdapter(boolean isBigEndian) {
        this.valueAdapter = new IntegerAdapter(4, isBigEndian, false);
    }

    @Override
    public int getInt(ByteBuffer buf) {
        return (int)this.getValue(buf);
    }

    @Override
    public long getLong(ByteBuffer buf) {
        return (long)this.getValue(buf);
    }

    @Override
    public double getDouble(ByteBuffer buf) {
        return this.getValue(buf);
    }

    private double getValue(ByteBuffer buf) {
        int bits = this.valueAdapter.getInt(buf);
        return Float.intBitsToFloat(bits);
    }
}

