/*
 * Deutscher Wetterdienst (DWD): Offenbach
 * Center: 78
 * Subcenter: 0
 * Parameter table version: 2
 */

TBLE2 dwd_002_params[] = {
{1, "pressure", "Pa", "PS"},
{2, "pressure reduced to MSL", "Pa", "PS_MSL"},
{3, "pressure tendency", "Pa/s", "P_TENDENCY"},
{4, "potential voreticity",    "K*(m**2)/(kg*s)", "POT_VORTIC"},
{5, "ICAO standard atmosphere reference height",   "m", "ICAO_SA_RH"},
{6, "geopotential", "(m**2)/(s**2)", "FI"},
{7, "geopotential height", "gpm", "GEOPOT_H"},
{8, "geometrical height", "m", "GEOMET_H"},
{9, "standard deviation of height", "m", "DEV_OF_H"},
{10, "total ozone", "Dobson Units", "TO3"},
{11, "temperature", "K", "T"},
{12, "virtual temperature", "K", "VIRT_TEMP"},
{13, "potential temperature", "K", "POT_TEMP"},
{14, "pseudo-adiabatic potential temperature", "K", "PSEUDO_POT"},
{15, "maximum temperature", "K", "TMAX"},
{16, "minimum temperature", "K", "TMIN"},
{17, "dew-point temperature", "K", "TD"},
{18, "dew-point depression (or deficit)", "K", "DEW_PNT_DE"},
{19, "laps rate", "K/m", "LAPSE_RATE"},
{20, "visibility", "m", "VISIBILITY"},
{21, "radar spectra (1)", "non-dim", "RADAR_SP_1"},
{22, "radar spectra (2)", "non-dim", "RADAR_SP_2"},
{23, "radar spectra (3)", "non-dim", "RADAR_SP_3"},
{24, "parcel lifted index (to 500 hPa)", "K", "PLI_TO_500"},
{25, "temperature anomaly", "K", "TEMP_ANOM"},
{26, "pressure anomaly", "Pa", "PRES_ANOM"},
{27, "geopotential height anomaly", "gpm", "GEOP_ANOM"},
{28, "wave spaectra(1)", "non-dim", "WAVE_SP_1"},
{29, "wave spaectra(2)", "non-dim", "WAVE_SP_2"},
{30, "wave spaectra(3)", "non-dim", "WAVE_SP_3"},
{31, "wind direction", "degree true", "WIND_DIR"},
{32, "wind speed", "m/s", "WIND_SPEED"},
{33, "u-component (zonal) of wind", "m/s", "U"},
{34, "v-component (merdional) of wind", "m/s", "V"},
{35, "stream function", "(m**2)/s", "STREAM_FUN"},
{36, "velocity potential", "(m**2)/s", "VEL_POTENT"},
{37, "Montgomery stream function", "(m**2)/(s**2)", "M_STREAM_F"},
{38, "sigma co-ordinate vertical velocity", "1/s", "SIGMA_VERT"},
{39, "vertical velocity", "Pa/s", "OMEGA"},
{40, "vertical velocity", "m/s", "VERT_VEL"},
{41, "absolute vorticity", "1/s", "ABS_VORTIC"},
{42, "absolute divergence", "1/s", "ABS_DIVERG"},
{43, "relative vorticity", "1/s", "REL_VORTIC"},
{44, "relative divergence", "1/s", "REL_DIVERG"},
{45, "vertical u-component shear", "1/s", "VERT_U_SHR"},
{46, "vertical v-component shear", "1/s", "VERT_V_SHR"},
{47, "direction of current", "degree true", "DIR_OF_CUR"},
{48, "speed of current", "m/s", "SPD_OF_CUR"},
{49, "u-component of current", "m/s", "CURRCOMP_U"},
{50, "v-component of current", "m/s", "CURRCOMP_V"},
{51, "specific humidity", "kg/kg", "QV"},
{52, "relative humidity", "%", "RELHUM"},
{53, "humidity mixing ratio", "kg/kg", "HUM_MIXRAT"},
{54, "total precipitable water", "kg/m**2", "TQV"},
{55, "vapor pressure", "Pa", "VAPOR_PRES"},
{56, "saturation deficit", "Pa", "SAT_DEFIC"},
{57, "evaporation", "kg/(m**2)", "EVAPORAT"},
{58, "total cloud ice content", "kg/m**2", "TQI"},
{59, "precipitation rate", "kg/((m**2)*s)", "PREC_RATE"},
{60, "thunderstorm probability", "%", "THUNDERST"},
{61, "total precipitation", "kg/(m**2)", "TOT_PREC"},
{62, "large scale precipitation", "kg/(m**2)", "LS_PRECIP"},
{63, "convective precipitation", "kg/(m**2)", "CONV_PREC"},
{64, "snowfall rate water equivalent", "kg/((m**2)*s)", "SNOWF_RATE"},
{65, "water equivalent of accumulated snow depth", "kg/(m**2)", "W_SNOW"},
{66, "snow depth", "m", "SNOW_DEPTH"},
{67, "mixed layer depth", "m", "MIX_LAY_DE"},
{68, "transient thermocline depth", "m", "TR_THERM_D"},
{69, "main thermocline depth", "m", "MA_THERM_D"},
{70, "main thermocline depth anomaly", "m", "M_THERM_DA"},
{71, "total cloud cover", "%", "CLCT"},
{72, "convective cloud cover", "%", "CLC_CON"},
{73, "low cloud cover", "%", "CLCL"},
{74, "medium cloud cover", "%", "CLCM"},
{75, "high cloud cover", "%", "CLCH"},
{76, "total cloud water content", "kg/m**2", "TQC"},
{77, "best lifted index (to 500 hPa)", "K", "BLI_TO_500"},
{78, "convective snow", "kg/(m**2)", "SNOW_CON"},
{79, "large scale snow", "kg/(m**2)", "SNOW_GSP"},
{80, "water temperature", "K", "WATER_TEMP"},
{81, "land cover (1=land, 0=sea)", "1", "FR_LAND"},
{82, "deviation of sea-level from mean", "m", "DEV_SEA_LE"},
{83, "surface roughness", "m", "Z0"},
{84, "albedo", "%", "ALB_RAD"},
{85, "soil temperature", "K", "T_SOIL"},
{86, "soil moisture content", "kg/(m**2)", "W_SOIL"},
{87, "vegetation (plant cover)", "%", "PLCOV"},
{88, "salinity", "kg/kg", "SALINITY"},
{89, "density", "kg/(m**3)", "DENSITY"},
{90, "water run-off", "kg/(m**2)", "RUNOFF"},
{91, "ice cover (1=ice, 0=no ice)", "proportion", "ICE_COVER"},
{92, "ice thickness", "m", "ICE_THICKN"},
{93, "direction of ice drift", "degree true", "DIR_ICE_DR"},
{94, "speed of ice drift", "m/s", "SP_ICE_DR"},
{95, "u-component of ice drift", "m/s", "ICE_DR_U"},
{96, "v-component of ice drift", "m/s", "ICE_DR_V"},
{97, "ice growth rate", "m/s", "ICE_GROWTH"},
{98, "ice divergence", "1/s", "ICE_DIVERG"},
{99, "snow melt", "kg/(m**2)", "SNOW_MELT"},
{100, "significant height of comb. wind waves and swell", "m", "WINWAV_SWE"},
{101, "direction of wind waves", "degree true", "DIR_OF_WAV"},
{102, "significant height of wind waves", "m", "HEI_OF_WAV"},
{103, "mean period of wind waves", "s", "MP_OF_WIWA"},
{104, "direction of swell", "degree true", "DIR_OF_SWE"},
{105, "significant height of swell", "m", "HEI_OF_SWE"},
{106, "mean period of swell", "s", "MP_OF_SWEL"},
{107, "primary wave direction", "degree true", "PR_WAVE_DI"},
{108, "primary wave period", "s", "PR_WAVE_PE"},
{109, "secondary wave direction", "degree true", "SE_WAVE_DI"},
{110, "secondary wave period", "s", "SE_WAVE_PE"},
{111, "net short-wave radiation (surface)", "W/(m**2)", "ASOB_S"},
{112, "net long-wave radiation (surface)", "W/(m**2)", "ATHB_S"},
{113, "net short-wave radiation (top of atmosphere)", "W/(m**2)", "ASOB_T"},
{114, "net long-wave radiation (top of atmosphere)", "W/(m**2)", "ATHB_T"},
{115, "long-wave radiation", "W/(m**2)", "L_W_RAD"},
{116, "short-wave radiation", "W/(m**2)", "S_W_RAD"},
{117, "global radiation", "W/(m**2)", "GLOBAL_RAD"},
{118, "brightness temperature",  "K", "BRIGHTN_T"},
{119, "radiance (with respect to wave number)",  "(W/m)*(s/r)", "RADIANCE_N"},
{120, "radiance (with respect to wave length)",  "(W/(m**3))*(s/r)", "RADIANCE_L"},
{121, "latent heat flux", "W/(m**2)", "ALHFL_S"},
{122, "sensible heat flux", "W/(m**2)", "ASHFL_S"},
{123, "boundary layer dissipation", "W/(m**2)", "BOUND_L_DI"},
{124, "momentum flux, u component", "N/(m**2)", "AUMFL_S"},
{125, "momentum flux, v component", "N/(m**2)", "AVMFL_S"},
{126, "wind mixing energy", "J", "WIND_MIX_E"},
{127, "image data", "none", "IMAGE_DATA"},
{129, "geopotential height (ECMF)", "gpm", "GEOPOT_H"},
{130, "temperature (ECMF)", "K", "TEMPERATUR"},
{131, "u-component of wind (ECMF)", "m/s", "WIND_COMPU"},
{132, "v-component of wind (ECMF)", "m/s", "WIND_COMPV"},
{139, "soil temperature (ECMF)", "K", "SOIL_TEMP"},
{142, "large scale precipitation (ECMF)", "kg/(m**2)", "LS_PRECIP"},
{143, "convective precipitation (ECMF)", "kg/(m**2)", "CONV_PREC"},
{144, "snowfall (ECMF)", "m of water equivalent", "SNOWFALL"},
{151, "pressure reduced to MSL (ECMF)", "Pa", "PRESSURE"},
{156, "geopotential height (ECMF)", "gpm", "GEOPOT_H"},
{157, "relative humidity (ECMF)", "%", "REL_HUMID"},
{164, "total cloud cover (ECMF)", "%", "CLOUD_COV"},
{165, "u-component of 10m-wind (ECMF)", "m/s", "10M_WIND_U"},
{166, "v-component of 10m-wind (ECMF)", "m/s", "10M_WIND_V"},
{167, "2m temperature (ECMF)", "K", "2M_TEMPER"},
{168, "2m due-point temperature (ECMF)", "K", "2M_DUE_P"},
{228, "total precipitation (ECMF)", "m", "TOTAL_PREC"},
{229, "seaway 01 (ECMF)", "none", "SEAWAY_01"},
{230, "seaway 02 (ECMF)", "none", "SEAWAY_02"},
{231, "seaway 03 (ECMF)", "none", "SEAWAY_03"},
{232, "seaway 04 (ECMF)", "none", "SEAWAY_04"},
{233, "seaway 05 (ECMF)", "none", "SEAWAY_05"},
{234, "seaway 06 (ECMF)", "none", "SEAWAY_06"},
{235, "seaway 07 (ECMF)", "none", "SEAWAY_07"},
{236, "seaway 08 (ECMF)", "none", "SEAWAY_08"},
{237, "seaway 09 (ECMF)", "none", "SEAWAY_09"},
{238, "seaway 10 (ECMF)", "none", "SEAWAY_10"},
{239, "seaway 11 (ECMF)", "none", "SEAWAY_11"},
};
