/* 
 * NOAA Forecast Systems Laboratory (FSL): Boulder, CO, USA
 * Center: 59
 * Subcenter: 0
 * Parameter table version: 0
 */ 

TBLE2 fsl0_params[] = {
{1, "Pressure", "Pa", "P"},
{2, "Pressure reduced to mean sea level", "Pa", "PMSL"},
{3, "Pressure tendency", "Pa/s", "PT"},
{4, "Potential vorticity", "Km**2/kg/s", "PVORT"},
{5, "ICAO Standard Atmosphere Reference Height", "m", "ICAHT"},
{6, "Geopotential", "m**2/s**2", "GP"},
{7, "Geopotential Height", "gpm", "GH"},
{8, "Geometric Height", "m", "GEH"},
{9, "Standard deviation of height", "m", "HGHTSD"},
{10, "Total ozone", "Dobson", "TOZO"},
{11, "Temperature", "K", "T"},
{12, "Virtual temperature", "K", "VT"},
{13, "Potential temperature", "K", "POT"},
{14, "Equivalent potential temperature", "K", "EPOT"},
{15, "Maximum temperature", "K", "MXT"},
{16, "Minimum temperature", "K", "MNT"},
{17, "Dew point temperature", "K", "DPT"},
{18, "Dew point depression", "K", "DPD"},
{19, "Lapse rate", "K/m", "LR"},
{20, "Visibility", "m", "VIS"},
{21, "Radar Spectra (1)", "undef", "RSP1"},
{22, "Radar Spectra (2)", "undef", "RSP2"},
{23, "Radar Spectra (3)", "undef", "RSP3"},
{24, "Parcel lifted index (to 500 hPa)", "K", "PLI"},
{25, "Temperature anomaly", "K", "TA"},
{26, "Pressure anomaly", "Pa", "PA"},
{27, "Geopotential height anomaly", "gpm", "GHA"},
{28, "Wave Spectra (1)", "undef", "WSP1"},
{29, "Wave Spectra (2)", "undef", "WSP2"},
{30, "Wave Spectra (3)", "undef", "WSP3"},
{31, "Wind direction (from which blowing)", "deg true", "WD"},
{32, "Wind speed", "m/s", "WS"},
{33, "u-component of wind", "m/s", "UW"},
{34, "v-component of wind", "m/s", "VW"},
{35, "Stream function", "m**2/s", "SF"},
{36, "Velocity potential", "m**2/s", "VPOT"},
{37, "Montgomery stream function", "m**2/s**2", "MSG"},
{38, "Sigma coordinate vertical velocity", "/s", "SVV"},
{39, "Pressure vertical velocity", "Pa/s", "PVV"},
{40, "Geometric vertical velocity", "m/s", "GVV"},
{41, "Absolute vorticity", "/s", "AV"},
{42, "Absolute divergence", "/s", "AD"},
{43, "Relative vorticity", "/s", "RV"},
{44, "Relative divergence", "/s", "RD"},
{45, "Vertical u-component shear", "/s", "VUCSH"},
{46, "Vertical v-component shear", "/s", "VVCSH"},
{47, "Direction of current", "deg true", "DIRC"},
{48, "Speed of current", "m/s", "SPC"},
{49, "u-component of current", "m/s", "UOGRD"},
{50, "v-component of current", "m/s", "VOGRD"},
{51, "Specific humidity", "kg/kg", "SH"},
{52, "Relative humidity", "%", "RH"},
{53, "Humidity mixing ratio", "kg/kg", "MIXR"},
{54, "Precipitable water", "kg/m**2", "PW"},
{55, "Vapor pressure", "Pa", "VAPP"},
{56, "Saturation deficit", "Pa", "SATD"},
{57, "Evaporation", "kg/m**2", "EVP"},
{58, "Cloud Ice", "kg/m**2", "CICE"},
{59, "Precipitation rate", "kg/m**2/s", "PR"},
{60, "Thunderstorm probability", "%", "THP"},
{61, "Total precipitation", "kg/m**2", "TP"},
{62, "Large scale precipitation", "kg/m**2", "LGSP"},
{63, "Convective precipitation", "kg/m**2", "CP"},
{64, "Snowfall rate water equivalent", "kg/m**2/s", "SRWEQ"},
{65, "Water equivalent of accumulated snow depth", "kg/m**2", "WEASD"},
{66, "Snow depth", "m", "SND"},
{67, "Mixed layer depth", "m", "MIXHT"},
{68, "Transient thermocline depth", "m", "TTHDP"},
{69, "Main thermocline depth", "m", "MTHD"},
{70, "Main thermocline anomaly", "m", "MTHA"},
{71, "Total cloud cover", "%", "TCC"},
{72, "Convective cloud cover", "%", "CCC"},
{73, "Low cloud cover", "%", "LCC"},
{74, "Medium cloud cover", "%", "MCC"},
{75, "High cloud cover", "%", "HCC"},
{76, "Cloud water", "kg/m**2", "CWAT"},
{77, "Best Lifted Index (to 500 hPa)", "K", "BLI"},
{78, "Convective snow", "kg/m**2", "SNOC"},
{79, "Large scale snow", "kg/m**2", "SNOL"},
{80, "Water temperature", "K", "WT"},
{81, "Land cover (land=1, sea=0)", "proportion", "LAND"},
{82, "Deviation of sea level from mean", "m", "DSLM"},
{83, "Surface roughness", "m", "SFCR"},
{84, "Albedo", "%", "ALBDO"},
{85, "Soil temperature", "K", "ST"},
{86, "Soil moisture content", "kg/m**2", "SMC"},
{87, "Vegetation", "%", "VEG"},
{88, "Salinity", "kg/kg", "SALTY"},
{89, "Density", "kg/m**3", "DEN"},
{90, "Water runoff", "kg/m**2", "WATR"},
{91, "Ice cover (ice=1, no ice=0)", "proportion", "ICEC"},
{92, "Ice thickness", "m", "ICETK"},
{93, "Direction of ice drift", "deg true", "DICED"},
{94, "Speed of ice drift", "m/s", "SICED"},
{95, "u-component of ice drift", "m/s", "UICE"},
{96, "v-component of ice drift", "m/s", "VICE"},
{97, "Ice growth rate", "m/s", "ICEG"},
{98, "Ice divergence", "/s", "ICED"},
{99, "Snow melt", "kg/m**2", "SNOM"},
{100, "Significant height of combined wind waves & swell", "m", "HTSGW"},
{101, "Direction of wind waves (from which)", "deg true", "WVDIR"},
{102, "Significant height of wind waves", "m", "WVHGT"},
{103, "Mean period of wind waves", "s", "WVPER"},
{104, "Direction of swell waves", "deg true", "SWDIR"},
{105, "Significant height of swell waves", "m", "SWELL"},
{106, "Mean period of swell waves", "s", "SWPER"},
{107, "Primary wave direction", "deg true", "DIRPW"},
{108, "Primary wave mean period", "s", "PERPW"},
{109, "Secondary wave direction", "deg true", "DIRSW"},
{110, "Secondary wave mean period", "s", "PERSW"},
{111, "Net short-wave radiation (surface)", "W/m**2", "NSWRS"},
{112, "Net long-wave radiation (surface)", "W/m**2", "NLRS"},
{113, "Net short-wave radiation (top of atmosphere)", "W/m**2", "NSWRT"},
{114, "Net long-wave radiation (top of atmosphere)", "W/m**2", "NLWRT"},
{115, "Long wave radiation flux", "W/m**2", "LWAVR"},
{116, "Short wave radiation flux", "W/m**2", "SWAVR"},
{117, "Global radiation flux", "W/m**2", "GRAD"},
{118, "Brightness temperature", "K", "BRTMP"},
{119, "Radiance (with respect to wave number)", "W/m/sr", "LWRAD"},
{120, "Radiance (with respect to wave length)", "W/m**3/sr", "SWRAD"},
{121, "Latent heat net flux", "W/m**2", "LHTFL"},
{122, "Sensible heat net flux", "W/m**2", "SHTFL"},
{123, "Boundary layer dissipation", "W/m**2", "BLYDP"},
{124, "Momentum flux, u component", "N/m**2", "UFLX"},
{125, "Momentum flux, v component", "N/m**2", "VFLX"},
{126, "Wind mixing energy", "J", "WMIXE"},
{127, "Image data", "undef", "IMGD"},
{128, "Mean sea level pressure", "Pa", "MSLP"},
{129, "MAPS mean sea level pressure", "Pa", "MMSP"},
{130, "ETA mean sea level pressure", "Pa", "EMSP"},
{131, "Surface lifted index", "K", "SLI"},
{132, "Best (4 layer) lifted index", "K", "BLI"},
{133, "K index", "K", "KI"},
{134, "Sweat index", "K", "SI"},
{135, "Horizontal moisture divergence", "kg/kg/s", "MCONV"},
{136, "Vertical speed shear", "1/s", "VSS"},
{137, "Pressure tendency - 3 hour", "Pa/s", "PT3"},
{138, "Brunt-Vaisala frequency (squared)", "1/s**2", "BVF2"},
{139, "Potential vorticity (density weighted)", "1/s/m", "PVMV"},
{140, "Categorical rain (yes=1, no=0)", "non-dim", "CRAIN"},
{141, "Categorical freezing rain (yes=1, no=0)", "non-dim", "CFRZR"},
{142, "Categorical ice pellets (yes=1, no=0)", "non-dim", "CICEP"},
{143, "Categorical snow (yes=1, no=0)", "non-dim", "CSNOW"},
{144, "Volumetric soil moisture content", "fraction", "SOILW"},
{145, "Potential evaporation rate", "W/m**2", "PEVPR"},
{146, "Cloud workfunction", "J/kg", "CWORK"},
{147, "Zonal flux of gravity wave stress", "N/m**2", "UGWD"},
{148, "Meridional flux of gravity wave stress", "N/m**2", "VGWD"},
{149, "Potential vorticity", "m**2/s/kg", "PV"},
{150, "Covariance between meridional and zonal wind", "m**2/kg**2", "COVMZ"},
{151, "Covariance between temperature and zonal wind", "K*m/s", "COVTZ"},
{152, "Covariance between temperature and merid. wind", "K*m/s", "COVTM"},
{153, "Cloud water", "Kg/kg", "CW"},
{154, "Ozone mixing ratio", "Kg/kg", "O3MR"},
{155, "Ground Heat flux", "W/m**2", "GFLUX"},
{156, "Convective inhibition", "J/kg", "CIN"},
{157, "Convective available potential energy", "J/kg", "CAPE"},
{158, "Turbulent kinetic energy", "J/kg", "TKE"},
{159, "Condensation pressure of parcel lifted from sfc", "Pa", "CONDP"},
{160, "Clear sky upward solar flux", "W/m**2", "CSUSF"},
{161, "Clear sky downward solar flux", "W/m**2", "CSDSF"},
{162, "Clear sky upward long wave flux", "W/m**2", "CSULF"},
{163, "Clear sky downward long wave flux", "W/m**2", "CSDLF"},
{164, "Cloud forcing net solar flux", "W/m**2", "CFNSF"},
{165, "Cloud forcing net long wave flux", "W/m**2", "CFNLF"},
{166, "Visible beam downward solar flux", "W/m**2", "VBDSF"},
{167, "Visible diffuse downward solar flux", "W/m**2", "VDDSF"},
{168, "Near IR beam downward solar flux", "W/m**2", "NBDSF"},
{169, "Near IR diffuse downward solar flux", "W/m**2", "NDDSF"},
{170, "Rain water mixing ratio", "Kg/Kg", "RWMR"},
{171, "Snow mixing ratio", "Kg/Kg", "SNMR"},
{172, "Momentum flux", "N/m**2", "MFLX"},
{173, "Mass point model surface", "non-dim", "LMH"},
{174, "Velocity point model surface", "non-dim", "LMV"},
{175, "Model layer number (from bottom up)", "non-dim", "MLYNO"},
{176, "Latitude", "deg", "NLAT"},
{177, "East longitude", "deg", "ELON"},
{178, "Ice mixing ratio", "Kg/Kg", "ICMR"},
{179, "Graupel mixing ratio", "Kg/Kg", "GRMR"},
{181, "x-gradient of log pressure", "1/m", "LPSX"},
{182, "y-gradient of log pressure", "1/m", "LPSY"},
{183, "x-gradient of height", "m/m", "JGTX"},
{184, "y-gradient of height", "m/m", "JGTY"},
{185, "Turbulence SIGMET/AIRMET", "non-dim", "TURB"},
{186, "Icing SIGMET/AIRMET", "non-dim", "ICNG"},
{187, "Lightning", "non-dim", "LTNG"},
{188, "Rate of Water drop from canopy to ground", "kg/m**2/s", "WDROP"},
{189, "Vitual potentail temperature", "K", "VPT"},
{190, "Helicity", "m**2/s**2", "HELI"},
{191, "Probability from ensemble", "numeric", "PROB"},
{192, "Probability from ensemble normalized to climate", "numeric", "PROBN"},
{193, "Probability of precipitation", "%", "POP"},
{194, "Probability of frozen precipitation", "%", "CPOFP"},
{195, "Probability of freezing precipitation", "%", "CPOZP"},
{196, "u-component of storm motion", "m/s", "USTM"},
{197, "v-component of storm motion", "m/s", "VSTM"},
{198, "Number conecntration for ice particles", "undef", "NCIP"},
{199, "Direct evaporation from bare soil", "W/m**2", "EVBS"},
{200, "Canopy water evaporation", "W/m**2", "EVCW"},
{201, "Ice-free water surface", "%", "ICWAT"},
{202, "Convective weather detection index", "non-dim", "CWDI"},
{203, "VAFTAD", "non-dim", "VAFTAD"},
{204, "Downward short wave radiation flux", "W/m**2", "DSWRF"},
{205, "Downward long wave radiation flux", "W/m**2", "DLWRF"},
{206, "Ulta violet index (1 hr integration at solar noon)", "J/m**2", "UVI"},
{207, "Moisture availability", "%", "MSTAV"},
{208, "Exchange coefficient", "kg/m**3/(m/s)", "SFEXC"},
{209, "Number of mixed layers next to surface", "integer", "MIXLY"},
{210, "Transpiration", "W/m**2", "TRANS"},
{211, "Upward short wave radiation flux", "W/m**2", "USWRF"},
{212, "Upward long wave radiation flux", "W/m**2", "ULWRF"},
{213, "Amount of non-convective cloud", "%", "CDLYR"},
{214, "Convective precipitation rate", "kg/m**2/s", "CPRAT"},
{215, "Temperature tendency by all physics", "K/s", "TTDIA"},
{216, "Temperature tendency by all radiation", "K/s", "TTRAD"},
{217, "Temperature tendency by non-radiation physics", "K/s", "TTPHY"},
{218, "Precipitation index(0.0-1.0)", "fraction", "PREIX"},
{219, "Std. dev. of IR temperature over 1x1 deg area", "K", "TSDID"},
{220, "Natural log of surface pressure", "In(kPa)", "NLGSP"},
{221, "Planetary boundary layer height", "m", "HPBL"},
{222, "5-wave geopotential height", "gpm", "WGH"},
{223, "Plant canopy surface water", "kg/m**2", "CNWAT"},
{224, "Soil type (as in Zobler)", "integer (0-9)", "SOTYP"},
{225, "Vegetation type (as in SiB)", "integer (0-9)", "VGTYP"},
{226, "Blackadar's mixing length scale", "m", "BMIXL"},
{227, "Asympotic mixing length scale", "m", "AMIXL"},
{228, "Potential evaporation", "kg/m**2", "PEVAP"},
{229, "Snow phase-change heat flux", "W/m**2", "SNOHF"},
{230, "5-wave geopotential height anomaly", "gpm", "WGH5A"},
{231, "Convective cloud mass flux", "Pa/s", "MFLUX"},
{232, "Downward total radiation flux", "W/m**2", "DTRF"},
{233, "Upward total radiation flux", "W/m**2", "UTRF"},
{234, "Baseflow-groundwater runoff", "kg/m**2", "BGRUN"},
{235, "Storm surface runoff", "kg/m**2", "SSRUN"},
{237, "Total ozone", "Kg/m**2", "OTOT"},
{238, "Snow cover percentage", "%", "SCP"},
{239, "Snow temperature", "K", "SNOWT"},
{240, "Covariance between temperature and vertical component of the wind.", "K*m/s", "COVTW"},
{241, "Large scale condensation heat rate", "K/s", "LRGHR"},
{242, "Deep convective heating rate", "K/s", "CNVHR"},
{243, "Deep convective moistening rate", "kg/kg/s", "CNVMR"},
{244, "Shallow convective heating rate", "K/s", "SHAHR"},
{245, "Shallow convective moistening rate", "kg/kg/s", "SHAMR"},
{246, "Vertical diffusion heating rate", "K/s", "VDFHR"},
{247, "Vertical diffusion zonal acceleration", "m/s", "VDFUA"},
{248, "Vertical diffusion meridional acceleration", "m/s**2", "VDFVA"},
{249, "Vertical diffusion moistening rate", "kg/kg/s", "VDFMR"},
{250, "Solar radiative heating rate", "K/s", "SWHR"},
{251, "Long wave radiative heating rate", "K/s", "LWHR"},
{252, "Drag coefficient", "non-dim", "CD"},
{253, "Friction velocity", "m/s", "FRICV"},
{254, "Richardson number", "non-dim", "RI"},
{255, "Wind Gust Speed", "m/s", "WGS"},
};
