/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.pds.objectAccess.table;

import gov.nasa.arc.pds.xml.generated.FieldDelimited;
import gov.nasa.arc.pds.xml.generated.GroupFieldDelimited;
import gov.nasa.arc.pds.xml.generated.TableDelimited;
import gov.nasa.pds.label.object.FieldDescription;
import gov.nasa.pds.label.object.FieldType;
import gov.nasa.pds.objectAccess.table.DelimiterType;
import gov.nasa.pds.objectAccess.table.TableAdapter;
import java.util.ArrayList;
import java.util.List;

public class TableDelimitedAdapter
implements TableAdapter {
    TableDelimited table;
    List<FieldDescription> fields;

    public TableDelimitedAdapter(TableDelimited table) {
        this.table = table;
        this.fields = new ArrayList<FieldDescription>();
        this.expandFields(table.getRecordDelimited().getFieldDelimitedsAndGroupFieldDelimiteds());
    }

    private void expandFields(List<Object> fields) {
        for (Object field : fields) {
            if (field instanceof FieldDelimited) {
                this.expandField((FieldDelimited)field);
                continue;
            }
            this.expandGroupField((GroupFieldDelimited)field);
        }
    }

    private void expandField(FieldDelimited field) {
        FieldDescription desc = new FieldDescription();
        desc.setName(field.getName());
        desc.setType(FieldType.getFieldType(field.getDataType()));
        if (field.getMaximumFieldLength() != null) {
            desc.setMaxLength(field.getMaximumFieldLength().getValue().intValueExact());
        }
        if (field.getFieldFormat() != null) {
            desc.setFieldFormat(field.getFieldFormat());
        }
        if (field.getFieldStatistics() != null) {
            if (field.getFieldStatistics().getMinimum() != null) {
                desc.setMinimum(field.getFieldStatistics().getMinimum());
            }
            if (field.getFieldStatistics().getMaximum() != null) {
                desc.setMaximum(field.getFieldStatistics().getMaximum());
            }
        }
        this.fields.add(desc);
    }

    private void expandGroupField(GroupFieldDelimited group) {
        for (int i = 0; i < group.getRepetitions().intValueExact(); ++i) {
            ArrayList<Object> fields = new ArrayList<Object>();
            for (Object field : group.getFieldDelimitedsAndGroupFieldDelimiteds()) {
                fields.add(field);
            }
            this.expandFields(fields);
        }
    }

    @Override
    public int getRecordCount() {
        return this.table.getRecords().intValueExact();
    }

    @Override
    public int getFieldCount() {
        return this.fields.size();
    }

    @Override
    public FieldDescription getField(int index) {
        return this.fields.get(index);
    }

    @Override
    public FieldDescription[] getFields() {
        return this.fields.toArray(new FieldDescription[this.fields.size()]);
    }

    @Override
    public long getOffset() {
        return this.table.getOffset().getValue().longValueExact();
    }

    @Override
    public int getRecordLength() {
        return 0;
    }

    public char getFieldDelimiter() {
        return DelimiterType.getDelimiterType(this.table.getFieldDelimiter()).getFieldDelimiter();
    }
}

