/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.ComponentSearcher;
import org.netbeans.jemmy.JemmyInputException;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.TreeDriver;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.JPopupMenuOperator;
import org.netbeans.jemmy.operators.JScrollPaneOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.jemmy.util.EmptyVisualizer;

public class JTreeOperator
extends JComponentOperator
implements Timeoutable,
Outputable {
    public static final String ROOT_DPROP = "Root";
    public static final String NODE_PREFIX_DPROP = "Node";
    public static final String SELECTION_FIRST_DPROP = "First selected";
    public static final String SELECTION_LAST_DPROP = "Last selected";
    private static final long WAIT_NODE_EXPANDED_TIMEOUT = 60000L;
    private static final long WAIT_NODE_COLLAPSED_TIMEOUT = 60000L;
    private static final long WAIT_AFTER_NODE_EXPANDED_TIMEOUT = 0L;
    private static final long WAIT_NEXT_NODE_TIMEOUT = 60000L;
    private static final long WAIT_NODE_VISIBLE_TIMEOUT = 60000L;
    private static final long BEFORE_EDIT_TIMEOUT = 1000L;
    private static final long WAIT_EDITING_TIMEOUT = 60000L;
    private TestOut output;
    private Timeouts timeouts;
    private TreeDriver driver = DriverManager.getTreeDriver(this.getClass());
    static /* synthetic */ Class class$javax$swing$JTree;

    public JTreeOperator(JTree b) {
        super(b);
    }

    public JTreeOperator(ContainerOperator cont, ComponentChooser chooser, int index) {
        this((JTree)cont.waitSubComponent(new JTreeFinder(chooser), index));
        this.copyEnvironment(cont);
    }

    public JTreeOperator(ContainerOperator cont, ComponentChooser chooser) {
        this(cont, chooser, 0);
    }

    public JTreeOperator(ContainerOperator cont, String text, int row, int index) {
        this((JTree)JTreeOperator.waitComponent(cont, (ComponentChooser)new JTreeByItemFinder(text, row, cont.getComparator()), index));
        this.copyEnvironment(cont);
    }

    public JTreeOperator(ContainerOperator cont, String text, int index) {
        this(cont, text, -1, index);
    }

    public JTreeOperator(ContainerOperator cont, String text) {
        this(cont, text, 0);
    }

    public JTreeOperator(ContainerOperator cont, int index) {
        this((JTree)JTreeOperator.waitComponent(cont, (ComponentChooser)new JTreeFinder(), index));
        this.copyEnvironment(cont);
    }

    public JTreeOperator(ContainerOperator cont) {
        this(cont, 0);
    }

    public static JTree findJTree(Container cont, ComponentChooser chooser, int index) {
        return (JTree)JTreeOperator.findComponent(cont, new JTreeFinder(chooser), index);
    }

    public static JTree findJTree(Container cont, ComponentChooser chooser) {
        return JTreeOperator.findJTree(cont, chooser, 0);
    }

    public static JTree findJTree(Container cont, String text, boolean ce, boolean ccs, int rowIndex, int index) {
        return JTreeOperator.findJTree(cont, new JTreeByItemFinder(text, rowIndex, new Operator.DefaultStringComparator(ce, ccs)), index);
    }

    public static JTree findJTree(Container cont, String text, boolean ce, boolean ccs, int rowIndex) {
        return JTreeOperator.findJTree(cont, text, ce, ccs, rowIndex, 0);
    }

    public static JTree waitJTree(Container cont, ComponentChooser chooser, int index) {
        return (JTree)JTreeOperator.waitComponent(cont, (ComponentChooser)new JTreeFinder(chooser), index);
    }

    public static JTree waitJTree(Container cont, ComponentChooser chooser) {
        return JTreeOperator.waitJTree(cont, chooser, 0);
    }

    public static JTree waitJTree(Container cont, String text, boolean ce, boolean ccs, int rowIndex, int index) {
        return JTreeOperator.waitJTree(cont, new JTreeByItemFinder(text, rowIndex, new Operator.DefaultStringComparator(ce, ccs)), index);
    }

    public static JTree waitJTree(Container cont, String text, boolean ce, boolean ccs, int rowIndex) {
        return JTreeOperator.waitJTree(cont, text, ce, ccs, rowIndex, 0);
    }

    public void setTimeouts(Timeouts times) {
        this.timeouts = times;
        super.setTimeouts(this.timeouts);
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public void setOutput(TestOut out) {
        this.output = out;
        super.setOutput(this.output.createErrorOutput());
    }

    public TestOut getOutput() {
        return this.output;
    }

    public void copyEnvironment(Operator anotherOperator) {
        super.copyEnvironment(anotherOperator);
        this.driver = (TreeDriver)DriverManager.getDriver("drivers.tree", this.getClass(), anotherOperator.getProperties());
    }

    public void doExpandPath(TreePath path) {
        if (path == null) {
            throw new NoSuchPathException();
        }
        this.output.printLine("Expanding \"" + path.getPathComponent(path.getPathCount() - 1).toString() + "\" node");
        this.output.printGolden("Expanding \"" + path.getPathComponent(path.getPathCount() - 1).toString() + "\" node");
        this.driver.expandItem(this, this.getRowForPath(path));
        this.waitExpanded(path);
    }

    public void doExpandRow(int row) {
        this.output.printLine("Expanding " + Integer.toString(row) + " row");
        this.output.printGolden("Expanding " + Integer.toString(row) + " row");
        this.driver.expandItem(this, row);
        this.waitExpanded(row);
    }

    public void doMakeVisible(TreePath path) {
        if (path == null) {
            throw new NoSuchPathException();
        }
        this.output.printLine("Making \"" + path.toString() + "\" path visible");
        this.output.printGolden("Making path visible");
        this.makeVisible(path);
        this.waitVisible(path);
    }

    public int getChildCount(Object node) {
        int result = 0;
        try {
            this.lockQueue();
            result = ((JTree)this.getSource()).getModel().getChildCount(node);
            this.unlockQueue();
        }
        catch (Exception e) {
            this.unlockAndThrow(e);
        }
        return result;
    }

    public Object[] getChildren(Object node) {
        Object[] result = null;
        try {
            this.lockQueue();
            TreeModel md = ((JTree)this.getSource()).getModel();
            result = new Object[md.getChildCount(node)];
            for (int i = 0; i < md.getChildCount(node); ++i) {
                result[i] = md.getChild(node, i);
            }
            this.unlockQueue();
        }
        catch (Exception e) {
            this.unlockAndThrow(e);
        }
        return result;
    }

    public Object getChild(final Object node, final int index) {
        Object result = null;
        try {
            result = this.runMapping(new Operator.MapAction("getChild"){

                public Object map() {
                    return ((JTree)JTreeOperator.this.getSource()).getModel().getChild(node, index);
                }
            });
        }
        catch (Exception e) {
            this.unlockAndThrow(e);
        }
        return result;
    }

    public int getChildCount(TreePath path) {
        if (path != null) {
            return this.getChildCount(path.getLastPathComponent());
        }
        throw new NoSuchPathException();
    }

    public TreePath getChildPath(TreePath path, int index) {
        if (path != null) {
            return path.pathByAddingChild(this.getChild(path.getLastPathComponent(), index));
        }
        throw new NoSuchPathException();
    }

    public TreePath[] getChildPaths(TreePath path) {
        if (path != null) {
            Object[] children = this.getChildren(path.getLastPathComponent());
            TreePath[] result = new TreePath[children.length];
            for (int i = 0; i < children.length; ++i) {
                result[i] = path.pathByAddingChild(children[i]);
            }
            return result;
        }
        throw new NoSuchPathException();
    }

    public Object getRoot() {
        Timeouts times = this.timeouts.cloneThis();
        times.setTimeout("Waiter.WaitingTime", this.timeouts.getTimeout("JTreeOperator.WaitNodeVisibleTimeout"));
        Waiter rootWaiter = new Waiter(new Waitable(){

            public Object actionProduced(Object obj) {
                Object root = JTreeOperator.this.getModel().getRoot();
                if (root == null || root.toString() == null || root.toString().equals("null")) {
                    return null;
                }
                return root;
            }

            public String getDescription() {
                return "Wait root node";
            }
        });
        rootWaiter.setTimeouts(times);
        rootWaiter.setOutput(this.output.createErrorOutput());
        try {
            return rootWaiter.waitAction(null);
        }
        catch (InterruptedException e) {
            this.output.printStackTrace(e);
            return null;
        }
    }

    public TreePath findPath(TreePathChooser chooser) {
        this.output.printLine("Search for a tree path " + chooser.getDescription());
        this.output.printGolden("Search for a tree path");
        TreePath rootPath = new TreePath(this.getRoot());
        if (chooser.checkPath(rootPath, 0)) {
            return rootPath;
        }
        Timeouts times = this.timeouts.cloneThis();
        times.setTimeout("Waiter.WaitingTime", this.timeouts.getTimeout("JTreeOperator.WaitNextNodeTimeout"));
        Waiter loadedWaiter = new Waiter(new Waitable(){
            TreePath currentPath;
            String requestedPath;

            public Object actionProduced(Object obj) {
                TreePath path;
                TreePathChooser chsr = (TreePathChooser)((Object[])obj)[0];
                this.requestedPath = chsr.getDescription();
                this.currentPath = path = (TreePath)((Object[])obj)[1];
                Object[] result = new Object[2];
                Object[] children = JTreeOperator.this.getChildren(path.getLastPathComponent());
                for (int j = 0; j < children.length; ++j) {
                    result[0] = path.pathByAddingChild(children[j]);
                    if (chsr.checkPath((TreePath)result[0], j)) {
                        result[1] = Boolean.TRUE;
                        return result;
                    }
                    if (!chsr.hasAsParent((TreePath)result[0], j)) continue;
                    result[1] = Boolean.FALSE;
                    return result;
                }
                return null;
            }

            public String getDescription() {
                return "Wait next node loaded under parent " + this.currentPath + " when requested was " + this.requestedPath;
            }
        });
        loadedWaiter.setTimeouts(times);
        loadedWaiter.setOutput(this.output.createErrorOutput());
        return this.findPathPrimitive(rootPath, chooser, loadedWaiter);
    }

    public int findRow(TreeRowChooser chooser, int index) {
        TreeModel model = this.getModel();
        int count = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!chooser.checkRow(this, i)) continue;
            if (count == index) {
                return i;
            }
            ++count;
        }
        return -1;
    }

    public int findRow(TreeRowChooser chooser) {
        return this.findRow(chooser, 0);
    }

    public int findRow(String item, Operator.StringComparator comparator, int index) {
        return this.findRow(new BySubStringTreeRowChooser(item, comparator), index);
    }

    public int findRow(String item, boolean ce, boolean cc, int index) {
        return this.findRow(item, new Operator.DefaultStringComparator(ce, cc), index);
    }

    public int findRow(String item, int index) {
        return this.findRow(item, this.getComparator(), index);
    }

    public int findRow(String item, Operator.StringComparator comparator) {
        return this.findRow(item, comparator, 0);
    }

    public int findRow(String item, boolean ce, boolean cc) {
        return this.findRow(item, ce, cc, 0);
    }

    public int findRow(String item) {
        return this.findRow(item, this.getComparator(), 0);
    }

    public int findRow(ComponentChooser chooser, int index) {
        return this.findRow(new ByRenderedComponentTreeRowChooser(chooser), index);
    }

    public int findRow(ComponentChooser chooser) {
        return this.findRow(chooser, 0);
    }

    public TreePath findPath(String[] names, int[] indexes, Operator.StringComparator comparator) {
        return this.findPath(new StringArrayPathChooser(names, indexes, comparator));
    }

    public TreePath findPath(String[] names, int[] indexes, boolean ce, boolean ccs) {
        return this.findPath(names, indexes, (Operator.StringComparator)new Operator.DefaultStringComparator(ce, ccs));
    }

    public TreePath findPath(String[] names, int[] indexes) {
        return this.findPath(names, indexes, this.getComparator());
    }

    public TreePath findPath(String[] names, Operator.StringComparator comparator) {
        int[] indexes = new int[]{};
        return this.findPath(names, indexes, comparator);
    }

    public TreePath findPath(String[] names, boolean ce, boolean ccs) {
        int[] indexes = new int[]{};
        return this.findPath(names, indexes, ce, ccs);
    }

    public TreePath findPath(String[] names) {
        int[] indexes = new int[]{};
        return this.findPath(names, indexes, this.getComparator());
    }

    public TreePath findPath(String path, String indexes, String delim, Operator.StringComparator comparator) {
        String[] indexStrings = this.parseString(indexes, delim);
        int[] indInts = new int[indexStrings.length];
        for (int i = 0; i < indexStrings.length; ++i) {
            indInts[i] = Integer.parseInt(indexStrings[i]);
        }
        return this.findPath(this.parseString(path, delim), indInts, comparator);
    }

    public TreePath findPath(String path, String indexes, String delim, boolean ce, boolean ccs) {
        return this.findPath(path, indexes, delim, new Operator.DefaultStringComparator(ce, ccs));
    }

    public TreePath findPath(String path, String indexes, String delim) {
        return this.findPath(path, indexes, delim, this.getComparator());
    }

    public TreePath findPath(String path, String delim, Operator.StringComparator comparator) {
        return this.findPath(this.parseString(path, delim), comparator);
    }

    public TreePath findPath(String path, Operator.StringComparator comparator) {
        return this.findPath(this.parseString(path), comparator);
    }

    public TreePath findPath(String path, String delim, boolean ce, boolean ccs) {
        return this.findPath(this.parseString(path, delim), ce, ccs);
    }

    public TreePath findPath(String path, String delim) {
        return this.findPath(this.parseString(path, delim));
    }

    public TreePath findPath(String path) {
        return this.findPath(this.parseString(path));
    }

    public void doCollapsePath(TreePath path) {
        if (path != null) {
            this.output.printLine("Collapsing \"" + path.toString() + "\" path");
            this.output.printGolden("Collapsing path");
            this.driver.collapseItem(this, this.getRowForPath(path));
            if (this.getVerification()) {
                this.waitCollapsed(path);
            }
        } else {
            throw new NoSuchPathException();
        }
    }

    public void doCollapseRow(int row) {
        this.output.printLine("Collapsing \"" + Integer.toString(row) + "\" row");
        this.output.printGolden("Collapsing path");
        this.driver.collapseItem(this, row);
        if (this.getVerification()) {
            this.waitCollapsed(row);
        }
    }

    public void selectPath(final TreePath path) {
        if (path != null) {
            this.output.printLine("Selecting \"" + path.toString() + "\" path");
            this.output.printGolden("Selecting path");
            this.scrollToPath(path);
            this.getQueueTool().invokeSmoothly(new QueueTool.QueueAction("Path selecting"){

                public Object launch() {
                    JTreeOperator.this.driver.selectItem(JTreeOperator.this, JTreeOperator.this.getRowForPath(path));
                    return null;
                }
            });
            if (this.getVerification()) {
                this.waitSelected(path);
            }
        } else {
            throw new NoSuchPathException();
        }
    }

    public void selectRow(int row) {
        this.output.printLine("Collapsing \"" + Integer.toString(row) + "\" row");
        this.output.printGolden("Collapsing path");
        this.driver.selectItem(this, row);
        if (this.getVerification()) {
            this.waitSelected(row);
        }
    }

    public void selectPaths(TreePath[] paths) {
        this.output.printLine("Selecting paths:");
        int[] rows = new int[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            this.output.printLine("    " + paths[i].toString());
            rows[i] = this.getRowForPath(paths[i]);
        }
        this.output.printGolden("Selecting paths");
        this.driver.selectItems(this, rows);
        if (this.getVerification()) {
            this.waitSelected(paths);
        }
    }

    public Point getPointToClick(TreePath path) {
        if (path != null) {
            Rectangle rect = this.getPathBounds(path);
            if (rect != null) {
                return new Point((int)(rect.getX() + rect.getWidth() / 2.0), (int)(rect.getY() + rect.getHeight() / 2.0));
            }
            throw new NoSuchPathException(path);
        }
        throw new NoSuchPathException();
    }

    public Point getPointToClick(int row) {
        Rectangle rect = this.getRowBounds(row);
        if (rect != null) {
            return new Point((int)(rect.getX() + rect.getWidth() / 2.0), (int)(rect.getY() + rect.getHeight() / 2.0));
        }
        throw new NoSuchPathException(row);
    }

    public void clickOnPath(TreePath path, int clickCount, int mouseButton, int modifiers) {
        if (path != null) {
            this.output.printLine("Click on \"" + path.toString() + "\" path");
            this.output.printGolden("Click on path");
            this.makeComponentVisible();
            if (path.getParentPath() != null) {
                this.expandPath(path.getParentPath());
            }
        } else {
            throw new NoSuchPathException();
        }
        this.makeVisible(path);
        this.scrollToPath(path);
        Point point = this.getPointToClick(path);
        this.clickMouse((int)point.getX(), (int)point.getY(), clickCount, mouseButton, modifiers);
    }

    public void clickOnPath(TreePath path, int clickCount, int mouseButton) {
        this.clickOnPath(path, clickCount, mouseButton, 0);
    }

    public void clickOnPath(TreePath path, int clickCount) {
        this.clickOnPath(path, clickCount, JTreeOperator.getDefaultMouseButton());
    }

    public void clickOnPath(TreePath path) {
        this.clickOnPath(path, 1);
    }

    public JPopupMenu callPopupOnPaths(TreePath[] paths, int mouseButton) {
        int i;
        if (paths.length == 1) {
            this.output.printLine("Call popup on \"" + paths[0].toString() + "\" path");
            this.output.printGolden("Call popup on path");
        } else {
            this.output.printLine("Call popup on some pathes:");
            for (i = 0; i < paths.length; ++i) {
                this.output.printLine("    " + paths[i].toString());
            }
            this.output.printGolden("Call popup on paths");
        }
        this.makeComponentVisible();
        for (i = 0; i < paths.length; ++i) {
            if (paths[i].getParentPath() == null) continue;
            this.expandPath(paths[i].getParentPath());
        }
        this.selectPaths(paths);
        this.scrollToPath(paths[paths.length - 1]);
        Point point = this.getPointToClick(paths[paths.length - 1]);
        return JPopupMenuOperator.callPopup(this, (int)point.getX(), (int)point.getY(), mouseButton);
    }

    public JPopupMenu callPopupOnPaths(TreePath[] paths) {
        return this.callPopupOnPaths(paths, JTreeOperator.getPopupMouseButton());
    }

    public JPopupMenu callPopupOnPath(TreePath path, int mouseButton) {
        if (path != null) {
            TreePath[] paths = new TreePath[]{path};
            return this.callPopupOnPaths(paths, mouseButton);
        }
        throw new NoSuchPathException();
    }

    public JPopupMenu callPopupOnPath(TreePath path) {
        return this.callPopupOnPath(path, JTreeOperator.getPopupMouseButton());
    }

    public void scrollToPath(TreePath path) {
        Rectangle rect;
        JScrollPaneOperator scroller;
        if (path != null) {
            this.output.printTrace("Scroll JTree to path \"" + path.toString() + "\"\n    : " + this.toStringSource());
            this.output.printGolden("Scroll JTree to path \"" + path.toString() + "\"");
            this.makeComponentVisible();
            JScrollPane scroll = (JScrollPane)this.getContainer(new JScrollPaneOperator.JScrollPaneFinder(ComponentSearcher.getTrueChooser("JScrollPane")));
            if (scroll == null) {
                return;
            }
            scroller = new JScrollPaneOperator(scroll);
            scroller.copyEnvironment(this);
            scroller.setVisualizer(new EmptyVisualizer());
            rect = this.getPathBounds(path);
            if (rect == null) {
                throw new NoSuchPathException(path);
            }
        } else {
            throw new NoSuchPathException();
        }
        scroller.scrollToComponentRectangle(this.getSource(), (int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
    }

    public void scrollToRow(int row) {
        this.scrollToPath(this.getPathForRow(row));
    }

    public void clickForEdit(TreePath path) {
        this.driver.startEditing(this, this.getRowForPath(path), this.timeouts.create("JTreeOperator.WaitEditingTimeout"));
    }

    public Component getRenderedComponent(TreePath path, boolean isSelected, boolean isExpanded, boolean cellHasFocus) {
        if (path != null) {
            return this.getCellRenderer().getTreeCellRendererComponent((JTree)this.getSource(), path.getLastPathComponent(), isSelected, isExpanded, this.getModel().isLeaf(path.getLastPathComponent()), this.getRowForPath(path), cellHasFocus);
        }
        throw new NoSuchPathException();
    }

    public Component getRenderedComponent(TreePath path) {
        return this.getRenderedComponent(path, this.isPathSelected(path), this.isExpanded(path), false);
    }

    public void changePathText(TreePath path, String newNodeText) {
        this.changePathObject(path, newNodeText);
    }

    public void changePathObject(TreePath path, Object newValue) {
        this.scrollToPath(path);
        this.driver.editItem(this, this.getRowForPath(path), newValue, this.timeouts.create("JTreeOperator.WaitEditingTimeout"));
    }

    public void waitExpanded(final TreePath path) {
        if (path == null) {
            throw new NoSuchPathException();
        }
        this.getOutput().printLine("Wait \"" + path.toString() + "\" path to be expanded in component \n    : " + this.toStringSource());
        this.getOutput().printGolden("Wait \"" + path.toString() + "\" path to be expanded");
        this.waitState(new ComponentChooser(){

            public boolean checkComponent(Component comp) {
                return JTreeOperator.this.isExpanded(path);
            }

            public String getDescription() {
                return "Has \"" + path.toString() + "\" path expanded";
            }
        });
    }

    public void waitExpanded(final int row) {
        this.getOutput().printLine("Wait " + Integer.toString(row) + "'th row to be expanded in component \n    : " + this.toStringSource());
        this.getOutput().printGolden("Wait " + Integer.toString(row) + "'th row to be expanded");
        this.waitState(new ComponentChooser(){

            public boolean checkComponent(Component comp) {
                return JTreeOperator.this.isExpanded(row);
            }

            public String getDescription() {
                return "Has " + Integer.toString(row) + "'th row expanded";
            }
        });
    }

    public void waitCollapsed(final TreePath path) {
        if (path == null) {
            throw new NoSuchPathException();
        }
        this.getOutput().printLine("Wait \"" + path.toString() + "\" path to be collapsed in component \n    : " + this.toStringSource());
        this.getOutput().printGolden("Wait \"" + path.toString() + "\" path to be collapsed");
        this.waitState(new ComponentChooser(){

            public boolean checkComponent(Component comp) {
                return JTreeOperator.this.isCollapsed(path);
            }

            public String getDescription() {
                return "Has \"" + path.toString() + "\" path collapsed";
            }
        });
    }

    public void waitCollapsed(final int row) {
        this.getOutput().printLine("Wait " + Integer.toString(row) + "'th row to be collapsed in component \n    : " + this.toStringSource());
        this.getOutput().printGolden("Wait " + Integer.toString(row) + "'th row to be collapsed");
        this.waitState(new ComponentChooser(){

            public boolean checkComponent(Component comp) {
                return JTreeOperator.this.isCollapsed(row);
            }

            public String getDescription() {
                return "Has " + Integer.toString(row) + "'th row collapsed";
            }
        });
    }

    public void waitVisible(final TreePath path) {
        if (path == null) {
            throw new NoSuchPathException();
        }
        this.getOutput().printLine("Wait \"" + path.toString() + "\" path to be visible in component \n    : " + this.toStringSource());
        this.getOutput().printGolden("Wait \"" + path.toString() + "\" path to be visible");
        this.waitState(new ComponentChooser(){

            public boolean checkComponent(Component comp) {
                return JTreeOperator.this.isVisible(path);
            }

            public String getDescription() {
                return "Has \"" + path.toString() + "\" path visible";
            }
        });
    }

    public void waitSelected(final TreePath[] paths) {
        this.getOutput().printLine("Wait right selection in component \n    : " + this.toStringSource());
        this.getOutput().printGolden("Wait right selection");
        this.waitState(new ComponentChooser(){

            public boolean checkComponent(Component comp) {
                TreePath[] rpaths = JTreeOperator.this.getSelectionModel().getSelectionPaths();
                if (rpaths != null) {
                    for (int i = 0; i < rpaths.length; ++i) {
                        if (rpaths[i].equals(paths[i])) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }

            public String getDescription() {
                return "Has right selection";
            }
        });
    }

    public void waitSelected(TreePath path) {
        this.waitSelected(new TreePath[]{path});
    }

    public void waitSelected(int[] rows) {
        TreePath[] paths = new TreePath[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            paths[i] = this.getPathForRow(rows[i]);
        }
        this.waitSelected(paths);
    }

    public void waitSelected(int row) {
        this.waitSelected(new int[]{row});
    }

    public void waitRow(String rowText, int row) {
        this.getOutput().printLine("Wait \"" + rowText + "\" text in " + Integer.toString(row) + "'th line in component \n    : " + this.toStringSource());
        this.getOutput().printGolden("Wait \"" + rowText + " \" text in " + Integer.toString(row) + "'th line");
        this.waitState(new JTreeByItemFinder(rowText, row, this.getComparator()));
    }

    public Object chooseSubnode(Object parent, String text, int index, Operator.StringComparator comparator) {
        int count = -1;
        TreeModel model = this.getModel();
        for (int i = 0; i < model.getChildCount(parent); ++i) {
            Object node = model.getChild(parent, i);
            if (!comparator.equals(node.toString(), text) || ++count != index) continue;
            return node;
        }
        return null;
    }

    public Object chooseSubnode(Object parent, String text, Operator.StringComparator comparator) {
        return this.chooseSubnode(parent, text, 0, comparator);
    }

    public Object chooseSubnode(Object parent, String text, int index) {
        return this.chooseSubnode(parent, text, index, this.getComparator());
    }

    public Object chooseSubnode(Object parent, String text) {
        return this.chooseSubnode(parent, text, 0, this.getComparator());
    }

    public Hashtable getDump() {
        Hashtable result = super.getDump();
        Object root = ((JTree)this.getSource()).getModel().getRoot();
        result.put(ROOT_DPROP, root.toString());
        this.addChildrenToDump(result, NODE_PREFIX_DPROP, root, new TreePath(root));
        int minSelection = ((JTree)this.getSource()).getMinSelectionRow();
        if (minSelection >= 0) {
            Object minObject = ((JTree)this.getSource()).getPathForRow(minSelection).getLastPathComponent();
            result.put(SELECTION_FIRST_DPROP, minObject.toString());
            int maxSelection = ((JTree)this.getSource()).getMaxSelectionRow();
            if (maxSelection > minSelection) {
                Object maxObject = ((JTree)this.getSource()).getPathForRow(maxSelection).getLastPathComponent();
                result.put(SELECTION_LAST_DPROP, maxObject.toString());
            }
        }
        return result;
    }

    public void addSelectionInterval(final int i, final int i1) {
        this.runMapping(new Operator.MapVoidAction("addSelectionInterval"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).addSelectionInterval(i, i1);
            }
        });
    }

    public void addSelectionPath(final TreePath treePath) {
        this.runMapping(new Operator.MapVoidAction("addSelectionPath"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).addSelectionPath(treePath);
            }
        });
    }

    public void addSelectionPaths(final TreePath[] treePath) {
        this.runMapping(new Operator.MapVoidAction("addSelectionPaths"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).addSelectionPaths(treePath);
            }
        });
    }

    public void addSelectionRow(final int i) {
        this.runMapping(new Operator.MapVoidAction("addSelectionRow"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).addSelectionRow(i);
            }
        });
    }

    public void addSelectionRows(final int[] i) {
        this.runMapping(new Operator.MapVoidAction("addSelectionRows"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).addSelectionRows(i);
            }
        });
    }

    public void addTreeExpansionListener(final TreeExpansionListener treeExpansionListener) {
        this.runMapping(new Operator.MapVoidAction("addTreeExpansionListener"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).addTreeExpansionListener(treeExpansionListener);
            }
        });
    }

    public void addTreeSelectionListener(final TreeSelectionListener treeSelectionListener) {
        this.runMapping(new Operator.MapVoidAction("addTreeSelectionListener"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).addTreeSelectionListener(treeSelectionListener);
            }
        });
    }

    public void addTreeWillExpandListener(final TreeWillExpandListener treeWillExpandListener) {
        this.runMapping(new Operator.MapVoidAction("addTreeWillExpandListener"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).addTreeWillExpandListener(treeWillExpandListener);
            }
        });
    }

    public void cancelEditing() {
        this.runMapping(new Operator.MapVoidAction("cancelEditing"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).cancelEditing();
            }
        });
    }

    public void clearSelection() {
        this.runMapping(new Operator.MapVoidAction("clearSelection"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).clearSelection();
            }
        });
    }

    public void collapsePath(final TreePath treePath) {
        this.runMapping(new Operator.MapVoidAction("collapsePath"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).collapsePath(treePath);
            }
        });
    }

    public void collapseRow(final int i) {
        this.runMapping(new Operator.MapVoidAction("collapseRow"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).collapseRow(i);
            }
        });
    }

    public String convertValueToText(final Object object, final boolean b, final boolean b1, final boolean b2, final int i, final boolean b3) {
        return (String)this.runMapping(new Operator.MapAction("convertValueToText"){

            public Object map() {
                return ((JTree)JTreeOperator.this.getSource()).convertValueToText(object, b, b1, b2, i, b3);
            }
        });
    }

    public void expandPath(final TreePath treePath) {
        this.runMapping(new Operator.MapVoidAction("expandPath"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).expandPath(treePath);
            }
        });
    }

    public void expandRow(final int i) {
        this.runMapping(new Operator.MapVoidAction("expandRow"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).expandRow(i);
            }
        });
    }

    public void fireTreeCollapsed(final TreePath treePath) {
        this.runMapping(new Operator.MapVoidAction("fireTreeCollapsed"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).fireTreeCollapsed(treePath);
            }
        });
    }

    public void fireTreeExpanded(final TreePath treePath) {
        this.runMapping(new Operator.MapVoidAction("fireTreeExpanded"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).fireTreeExpanded(treePath);
            }
        });
    }

    public void fireTreeWillCollapse(final TreePath treePath) {
        this.runMapping(new Operator.MapVoidAction("fireTreeWillCollapse"){

            public void map() throws ExpandVetoException {
                ((JTree)JTreeOperator.this.getSource()).fireTreeWillCollapse(treePath);
            }
        });
    }

    public void fireTreeWillExpand(final TreePath treePath) {
        this.runMapping(new Operator.MapVoidAction("fireTreeWillExpand"){

            public void map() throws ExpandVetoException {
                ((JTree)JTreeOperator.this.getSource()).fireTreeWillExpand(treePath);
            }
        });
    }

    public TreeCellEditor getCellEditor() {
        return (TreeCellEditor)this.runMapping(new Operator.MapAction("getCellEditor"){

            public Object map() {
                return ((JTree)JTreeOperator.this.getSource()).getCellEditor();
            }
        });
    }

    public TreeCellRenderer getCellRenderer() {
        return (TreeCellRenderer)this.runMapping(new Operator.MapAction("getCellRenderer"){

            public Object map() {
                return ((JTree)JTreeOperator.this.getSource()).getCellRenderer();
            }
        });
    }

    public TreePath getClosestPathForLocation(final int i, final int i1) {
        return (TreePath)this.runMapping(new Operator.MapAction("getClosestPathForLocation"){

            public Object map() {
                return ((JTree)JTreeOperator.this.getSource()).getClosestPathForLocation(i, i1);
            }
        });
    }

    public int getClosestRowForLocation(final int i, final int i1) {
        return this.runMapping(new Operator.MapIntegerAction("getClosestRowForLocation"){

            public int map() {
                return ((JTree)JTreeOperator.this.getSource()).getClosestRowForLocation(i, i1);
            }
        });
    }

    public TreePath getEditingPath() {
        return (TreePath)this.runMapping(new Operator.MapAction("getEditingPath"){

            public Object map() {
                return ((JTree)JTreeOperator.this.getSource()).getEditingPath();
            }
        });
    }

    public Enumeration getExpandedDescendants(final TreePath treePath) {
        return (Enumeration)this.runMapping(new Operator.MapAction("getExpandedDescendants"){

            public Object map() {
                return ((JTree)JTreeOperator.this.getSource()).getExpandedDescendants(treePath);
            }
        });
    }

    public boolean getInvokesStopCellEditing() {
        return this.runMapping(new Operator.MapBooleanAction("getInvokesStopCellEditing"){

            public boolean map() {
                return ((JTree)JTreeOperator.this.getSource()).getInvokesStopCellEditing();
            }
        });
    }

    public Object getLastSelectedPathComponent() {
        return this.runMapping(new Operator.MapAction("getLastSelectedPathComponent"){

            public Object map() {
                return ((JTree)JTreeOperator.this.getSource()).getLastSelectedPathComponent();
            }
        });
    }

    public TreePath getLeadSelectionPath() {
        return (TreePath)this.runMapping(new Operator.MapAction("getLeadSelectionPath"){

            public Object map() {
                return ((JTree)JTreeOperator.this.getSource()).getLeadSelectionPath();
            }
        });
    }

    public int getLeadSelectionRow() {
        return this.runMapping(new Operator.MapIntegerAction("getLeadSelectionRow"){

            public int map() {
                return ((JTree)JTreeOperator.this.getSource()).getLeadSelectionRow();
            }
        });
    }

    public int getMaxSelectionRow() {
        return this.runMapping(new Operator.MapIntegerAction("getMaxSelectionRow"){

            public int map() {
                return ((JTree)JTreeOperator.this.getSource()).getMaxSelectionRow();
            }
        });
    }

    public int getMinSelectionRow() {
        return this.runMapping(new Operator.MapIntegerAction("getMinSelectionRow"){

            public int map() {
                return ((JTree)JTreeOperator.this.getSource()).getMinSelectionRow();
            }
        });
    }

    public TreeModel getModel() {
        return (TreeModel)this.runMapping(new Operator.MapAction("getModel"){

            public Object map() {
                return ((JTree)JTreeOperator.this.getSource()).getModel();
            }
        });
    }

    public Rectangle getPathBounds(final TreePath treePath) {
        return (Rectangle)this.runMapping(new Operator.MapAction("getPathBounds"){

            public Object map() {
                return ((JTree)JTreeOperator.this.getSource()).getPathBounds(treePath);
            }
        });
    }

    public TreePath getPathForLocation(final int i, final int i1) {
        return (TreePath)this.runMapping(new Operator.MapAction("getPathForLocation"){

            public Object map() {
                return ((JTree)JTreeOperator.this.getSource()).getPathForLocation(i, i1);
            }
        });
    }

    public TreePath getPathForRow(final int i) {
        return (TreePath)this.runMapping(new Operator.MapAction("getPathForRow"){

            public Object map() {
                return ((JTree)JTreeOperator.this.getSource()).getPathForRow(i);
            }
        });
    }

    public Dimension getPreferredScrollableViewportSize() {
        return (Dimension)this.runMapping(new Operator.MapAction("getPreferredScrollableViewportSize"){

            public Object map() {
                return ((JTree)JTreeOperator.this.getSource()).getPreferredScrollableViewportSize();
            }
        });
    }

    public Rectangle getRowBounds(final int i) {
        return (Rectangle)this.runMapping(new Operator.MapAction("getRowBounds"){

            public Object map() {
                return ((JTree)JTreeOperator.this.getSource()).getRowBounds(i);
            }
        });
    }

    public int getRowCount() {
        return this.runMapping(new Operator.MapIntegerAction("getRowCount"){

            public int map() {
                return ((JTree)JTreeOperator.this.getSource()).getRowCount();
            }
        });
    }

    public int getRowForLocation(final int i, final int i1) {
        return this.runMapping(new Operator.MapIntegerAction("getRowForLocation"){

            public int map() {
                return ((JTree)JTreeOperator.this.getSource()).getRowForLocation(i, i1);
            }
        });
    }

    public int getRowForPath(final TreePath treePath) {
        return this.runMapping(new Operator.MapIntegerAction("getRowForPath"){

            public int map() {
                return ((JTree)JTreeOperator.this.getSource()).getRowForPath(treePath);
            }
        });
    }

    public int getRowHeight() {
        return this.runMapping(new Operator.MapIntegerAction("getRowHeight"){

            public int map() {
                return ((JTree)JTreeOperator.this.getSource()).getRowHeight();
            }
        });
    }

    public int getScrollableBlockIncrement(final Rectangle rectangle, final int i, final int i1) {
        return this.runMapping(new Operator.MapIntegerAction("getScrollableBlockIncrement"){

            public int map() {
                return ((JTree)JTreeOperator.this.getSource()).getScrollableBlockIncrement(rectangle, i, i1);
            }
        });
    }

    public boolean getScrollableTracksViewportHeight() {
        return this.runMapping(new Operator.MapBooleanAction("getScrollableTracksViewportHeight"){

            public boolean map() {
                return ((JTree)JTreeOperator.this.getSource()).getScrollableTracksViewportHeight();
            }
        });
    }

    public boolean getScrollableTracksViewportWidth() {
        return this.runMapping(new Operator.MapBooleanAction("getScrollableTracksViewportWidth"){

            public boolean map() {
                return ((JTree)JTreeOperator.this.getSource()).getScrollableTracksViewportWidth();
            }
        });
    }

    public int getScrollableUnitIncrement(final Rectangle rectangle, final int i, final int i1) {
        return this.runMapping(new Operator.MapIntegerAction("getScrollableUnitIncrement"){

            public int map() {
                return ((JTree)JTreeOperator.this.getSource()).getScrollableUnitIncrement(rectangle, i, i1);
            }
        });
    }

    public boolean getScrollsOnExpand() {
        return this.runMapping(new Operator.MapBooleanAction("getScrollsOnExpand"){

            public boolean map() {
                return ((JTree)JTreeOperator.this.getSource()).getScrollsOnExpand();
            }
        });
    }

    public int getSelectionCount() {
        return this.runMapping(new Operator.MapIntegerAction("getSelectionCount"){

            public int map() {
                return ((JTree)JTreeOperator.this.getSource()).getSelectionCount();
            }
        });
    }

    public TreeSelectionModel getSelectionModel() {
        return (TreeSelectionModel)this.runMapping(new Operator.MapAction("getSelectionModel"){

            public Object map() {
                return ((JTree)JTreeOperator.this.getSource()).getSelectionModel();
            }
        });
    }

    public TreePath getSelectionPath() {
        return (TreePath)this.runMapping(new Operator.MapAction("getSelectionPath"){

            public Object map() {
                return ((JTree)JTreeOperator.this.getSource()).getSelectionPath();
            }
        });
    }

    public TreePath[] getSelectionPaths() {
        return (TreePath[])this.runMapping(new Operator.MapAction("getSelectionPaths"){

            public Object map() {
                return ((JTree)JTreeOperator.this.getSource()).getSelectionPaths();
            }
        });
    }

    public int[] getSelectionRows() {
        return (int[])this.runMapping(new Operator.MapAction("getSelectionRows"){

            public Object map() {
                return ((JTree)JTreeOperator.this.getSource()).getSelectionRows();
            }
        });
    }

    public boolean getShowsRootHandles() {
        return this.runMapping(new Operator.MapBooleanAction("getShowsRootHandles"){

            public boolean map() {
                return ((JTree)JTreeOperator.this.getSource()).getShowsRootHandles();
            }
        });
    }

    public TreeUI getUI() {
        return (TreeUI)this.runMapping(new Operator.MapAction("getUI"){

            public Object map() {
                return ((JTree)JTreeOperator.this.getSource()).getUI();
            }
        });
    }

    public int getVisibleRowCount() {
        return this.runMapping(new Operator.MapIntegerAction("getVisibleRowCount"){

            public int map() {
                return ((JTree)JTreeOperator.this.getSource()).getVisibleRowCount();
            }
        });
    }

    public boolean hasBeenExpanded(final TreePath treePath) {
        return this.runMapping(new Operator.MapBooleanAction("hasBeenExpanded"){

            public boolean map() {
                return ((JTree)JTreeOperator.this.getSource()).hasBeenExpanded(treePath);
            }
        });
    }

    public boolean isCollapsed(final int i) {
        return this.runMapping(new Operator.MapBooleanAction("isCollapsed"){

            public boolean map() {
                return ((JTree)JTreeOperator.this.getSource()).isCollapsed(i);
            }
        });
    }

    public boolean isCollapsed(final TreePath treePath) {
        return this.runMapping(new Operator.MapBooleanAction("isCollapsed"){

            public boolean map() {
                return ((JTree)JTreeOperator.this.getSource()).isCollapsed(treePath);
            }
        });
    }

    public boolean isEditable() {
        return this.runMapping(new Operator.MapBooleanAction("isEditable"){

            public boolean map() {
                return ((JTree)JTreeOperator.this.getSource()).isEditable();
            }
        });
    }

    public boolean isEditing() {
        return this.runMapping(new Operator.MapBooleanAction("isEditing"){

            public boolean map() {
                return ((JTree)JTreeOperator.this.getSource()).isEditing();
            }
        });
    }

    public boolean isExpanded(final int i) {
        return this.runMapping(new Operator.MapBooleanAction("isExpanded"){

            public boolean map() {
                return ((JTree)JTreeOperator.this.getSource()).isExpanded(i);
            }
        });
    }

    public boolean isExpanded(final TreePath treePath) {
        return this.runMapping(new Operator.MapBooleanAction("isExpanded"){

            public boolean map() {
                return ((JTree)JTreeOperator.this.getSource()).isExpanded(treePath);
            }
        });
    }

    public boolean isFixedRowHeight() {
        return this.runMapping(new Operator.MapBooleanAction("isFixedRowHeight"){

            public boolean map() {
                return ((JTree)JTreeOperator.this.getSource()).isFixedRowHeight();
            }
        });
    }

    public boolean isLargeModel() {
        return this.runMapping(new Operator.MapBooleanAction("isLargeModel"){

            public boolean map() {
                return ((JTree)JTreeOperator.this.getSource()).isLargeModel();
            }
        });
    }

    public boolean isPathEditable(final TreePath treePath) {
        return this.runMapping(new Operator.MapBooleanAction("isPathEditable"){

            public boolean map() {
                return ((JTree)JTreeOperator.this.getSource()).isPathEditable(treePath);
            }
        });
    }

    public boolean isPathSelected(final TreePath treePath) {
        return this.runMapping(new Operator.MapBooleanAction("isPathSelected"){

            public boolean map() {
                return ((JTree)JTreeOperator.this.getSource()).isPathSelected(treePath);
            }
        });
    }

    public boolean isRootVisible() {
        return this.runMapping(new Operator.MapBooleanAction("isRootVisible"){

            public boolean map() {
                return ((JTree)JTreeOperator.this.getSource()).isRootVisible();
            }
        });
    }

    public boolean isRowSelected(final int i) {
        return this.runMapping(new Operator.MapBooleanAction("isRowSelected"){

            public boolean map() {
                return ((JTree)JTreeOperator.this.getSource()).isRowSelected(i);
            }
        });
    }

    public boolean isSelectionEmpty() {
        return this.runMapping(new Operator.MapBooleanAction("isSelectionEmpty"){

            public boolean map() {
                return ((JTree)JTreeOperator.this.getSource()).isSelectionEmpty();
            }
        });
    }

    public boolean isVisible(final TreePath treePath) {
        return this.runMapping(new Operator.MapBooleanAction("isVisible"){

            public boolean map() {
                return ((JTree)JTreeOperator.this.getSource()).isVisible(treePath);
            }
        });
    }

    public void makeVisible(final TreePath treePath) {
        this.runMapping(new Operator.MapVoidAction("makeVisible"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).makeVisible(treePath);
            }
        });
    }

    public void removeSelectionInterval(final int i, final int i1) {
        this.runMapping(new Operator.MapVoidAction("removeSelectionInterval"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).removeSelectionInterval(i, i1);
            }
        });
    }

    public void removeSelectionPath(final TreePath treePath) {
        this.runMapping(new Operator.MapVoidAction("removeSelectionPath"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).removeSelectionPath(treePath);
            }
        });
    }

    public void removeSelectionPaths(final TreePath[] treePath) {
        this.runMapping(new Operator.MapVoidAction("removeSelectionPaths"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).removeSelectionPaths(treePath);
            }
        });
    }

    public void removeSelectionRow(final int i) {
        this.runMapping(new Operator.MapVoidAction("removeSelectionRow"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).removeSelectionRow(i);
            }
        });
    }

    public void removeSelectionRows(final int[] i) {
        this.runMapping(new Operator.MapVoidAction("removeSelectionRows"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).removeSelectionRows(i);
            }
        });
    }

    public void removeTreeExpansionListener(final TreeExpansionListener treeExpansionListener) {
        this.runMapping(new Operator.MapVoidAction("removeTreeExpansionListener"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).removeTreeExpansionListener(treeExpansionListener);
            }
        });
    }

    public void removeTreeSelectionListener(final TreeSelectionListener treeSelectionListener) {
        this.runMapping(new Operator.MapVoidAction("removeTreeSelectionListener"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).removeTreeSelectionListener(treeSelectionListener);
            }
        });
    }

    public void removeTreeWillExpandListener(final TreeWillExpandListener treeWillExpandListener) {
        this.runMapping(new Operator.MapVoidAction("removeTreeWillExpandListener"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).removeTreeWillExpandListener(treeWillExpandListener);
            }
        });
    }

    public void scrollPathToVisible(final TreePath treePath) {
        this.runMapping(new Operator.MapVoidAction("scrollPathToVisible"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).scrollPathToVisible(treePath);
            }
        });
    }

    public void scrollRowToVisible(final int i) {
        this.runMapping(new Operator.MapVoidAction("scrollRowToVisible"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).scrollRowToVisible(i);
            }
        });
    }

    public void setCellEditor(final TreeCellEditor treeCellEditor) {
        this.runMapping(new Operator.MapVoidAction("setCellEditor"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).setCellEditor(treeCellEditor);
            }
        });
    }

    public void setCellRenderer(final TreeCellRenderer treeCellRenderer) {
        this.runMapping(new Operator.MapVoidAction("setCellRenderer"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).setCellRenderer(treeCellRenderer);
            }
        });
    }

    public void setEditable(final boolean b) {
        this.runMapping(new Operator.MapVoidAction("setEditable"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).setEditable(b);
            }
        });
    }

    public void setInvokesStopCellEditing(final boolean b) {
        this.runMapping(new Operator.MapVoidAction("setInvokesStopCellEditing"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).setInvokesStopCellEditing(b);
            }
        });
    }

    public void setLargeModel(final boolean b) {
        this.runMapping(new Operator.MapVoidAction("setLargeModel"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).setLargeModel(b);
            }
        });
    }

    public void setModel(final TreeModel treeModel) {
        this.runMapping(new Operator.MapVoidAction("setModel"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).setModel(treeModel);
            }
        });
    }

    public void setRootVisible(final boolean b) {
        this.runMapping(new Operator.MapVoidAction("setRootVisible"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).setRootVisible(b);
            }
        });
    }

    public void setRowHeight(final int i) {
        this.runMapping(new Operator.MapVoidAction("setRowHeight"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).setRowHeight(i);
            }
        });
    }

    public void setScrollsOnExpand(final boolean b) {
        this.runMapping(new Operator.MapVoidAction("setScrollsOnExpand"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).setScrollsOnExpand(b);
            }
        });
    }

    public void setSelectionInterval(final int i, final int i1) {
        this.runMapping(new Operator.MapVoidAction("setSelectionInterval"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).setSelectionInterval(i, i1);
            }
        });
    }

    public void setSelectionModel(final TreeSelectionModel treeSelectionModel) {
        this.runMapping(new Operator.MapVoidAction("setSelectionModel"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).setSelectionModel(treeSelectionModel);
            }
        });
    }

    public void setSelectionPath(final TreePath treePath) {
        this.runMapping(new Operator.MapVoidAction("setSelectionPath"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).setSelectionPath(treePath);
            }
        });
    }

    public void setSelectionPaths(final TreePath[] treePath) {
        this.runMapping(new Operator.MapVoidAction("setSelectionPaths"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).setSelectionPaths(treePath);
            }
        });
    }

    public void setSelectionRow(final int i) {
        this.runMapping(new Operator.MapVoidAction("setSelectionRow"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).setSelectionRow(i);
            }
        });
    }

    public void setSelectionRows(final int[] i) {
        this.runMapping(new Operator.MapVoidAction("setSelectionRows"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).setSelectionRows(i);
            }
        });
    }

    public void setShowsRootHandles(final boolean b) {
        this.runMapping(new Operator.MapVoidAction("setShowsRootHandles"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).setShowsRootHandles(b);
            }
        });
    }

    public void setUI(final TreeUI treeUI) {
        this.runMapping(new Operator.MapVoidAction("setUI"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).setUI(treeUI);
            }
        });
    }

    public void setVisibleRowCount(final int i) {
        this.runMapping(new Operator.MapVoidAction("setVisibleRowCount"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).setVisibleRowCount(i);
            }
        });
    }

    public void startEditingAtPath(final TreePath treePath) {
        this.runMapping(new Operator.MapVoidAction("startEditingAtPath"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).startEditingAtPath(treePath);
            }
        });
    }

    public boolean stopEditing() {
        return this.runMapping(new Operator.MapBooleanAction("stopEditing"){

            public boolean map() {
                return ((JTree)JTreeOperator.this.getSource()).stopEditing();
            }
        });
    }

    public void treeDidChange() {
        this.runMapping(new Operator.MapVoidAction("treeDidChange"){

            public void map() {
                ((JTree)JTreeOperator.this.getSource()).treeDidChange();
            }
        });
    }

    private TreePath findPathPrimitive(TreePath path, TreePathChooser chooser, Waiter loadedWaiter) {
        if (!this.isExpanded(path)) {
            if (!this.isPathSelected(path)) {
                this.clickOnPath(path);
            }
            this.expandPath(path);
        }
        Object[] waitParam = new Object[]{chooser, path};
        Object[] waitResult = null;
        try {
            waitResult = (Object[])loadedWaiter.waitAction(waitParam);
        }
        catch (InterruptedException e) {
            this.output.printStackTrace(e);
            return null;
        }
        TreePath nextPath = (TreePath)waitResult[0];
        boolean found = (Boolean)waitResult[1];
        if (found) {
            return nextPath;
        }
        return this.findPathPrimitive(nextPath, chooser, loadedWaiter);
    }

    private String[] addChildrenToDump(Hashtable table, String title, Object node, TreePath path) {
        if (((JTree)this.getSource()).isExpanded(path)) {
            TreeModel model = ((JTree)this.getSource()).getModel();
            Object[] subNodes = new Object[model.getChildCount(node)];
            for (int i = 0; i < subNodes.length; ++i) {
                subNodes[i] = model.getChild(node, i);
            }
            String[] names = this.addToDump(table, title, subNodes);
            for (int i = 0; i < subNodes.length; ++i) {
                this.addChildrenToDump(table, names[i], subNodes[i], path.pathByAddingChild(subNodes[i]));
            }
            return names;
        }
        return new String[0];
    }

    private static String pathToString(String[] path) {
        String desc = "";
        for (int i = 0; i < path.length; ++i) {
            desc = desc + path[i] + ", ";
        }
        if (desc.length() > 0) {
            desc = desc.substring(0, desc.length() - 2);
        }
        return "[ " + desc + " ]";
    }

    static {
        Timeouts.initDefault("JTreeOperator.WaitNodeExpandedTimeout", 60000L);
        Timeouts.initDefault("JTreeOperator.WaitNodeCollapsedTimeout", 60000L);
        Timeouts.initDefault("JTreeOperator.WaitAfterNodeExpandedTimeout", 0L);
        Timeouts.initDefault("JTreeOperator.WaitNextNodeTimeout", 60000L);
        Timeouts.initDefault("JTreeOperator.WaitNodeVisibleTimeout", 60000L);
        Timeouts.initDefault("JTreeOperator.BeforeEditTimeout", 1000L);
        Timeouts.initDefault("JTreeOperator.WaitEditingTimeout", 60000L);
    }

    public static class JTreeByItemFinder
    implements ComponentChooser {
        String label;
        int rowIndex;
        Operator.StringComparator comparator;

        public JTreeByItemFinder(String lb, int ii, Operator.StringComparator comparator) {
            this.label = lb;
            this.rowIndex = ii;
            this.comparator = comparator;
        }

        public JTreeByItemFinder(String lb, int ii) {
            this(lb, ii, Operator.getDefaultStringComparator());
        }

        public boolean checkComponent(Component comp) {
            if (comp instanceof JTree) {
                if (this.label == null) {
                    return true;
                }
                if (((JTree)comp).getRowCount() > this.rowIndex) {
                    TreePath path;
                    int ii = this.rowIndex;
                    if (ii == -1) {
                        int[] rows = ((JTree)comp).getSelectionRows();
                        if (rows != null && rows.length > 0) {
                            ii = rows[0];
                        } else {
                            return false;
                        }
                    }
                    if ((path = ((JTree)comp).getPathForRow(ii)) != null) {
                        return this.comparator.equals(path.getPathComponent(path.getPathCount() - 1).toString(), this.label);
                    }
                }
            }
            return false;
        }

        public String getDescription() {
            return "JTree with text \"" + this.label + "\" in " + new Integer(this.rowIndex).toString() + "'th row";
        }
    }

    public static class JTreeFinder
    extends Operator.Finder {
        public JTreeFinder(ComponentChooser sf) {
            super(class$javax$swing$JTree == null ? (class$javax$swing$JTree = JTreeOperator.class$("javax.swing.JTree")) : class$javax$swing$JTree, sf);
        }

        public JTreeFinder() {
            super(class$javax$swing$JTree == null ? (class$javax$swing$JTree = JTreeOperator.class$("javax.swing.JTree")) : class$javax$swing$JTree);
        }
    }

    private class ByRenderedComponentTreeRowChooser
    implements TreeRowChooser {
        ComponentChooser chooser;

        public ByRenderedComponentTreeRowChooser(ComponentChooser chooser) {
            this.chooser = chooser;
        }

        public boolean checkRow(JTreeOperator oper, int row) {
            return this.chooser.checkComponent(oper.getRenderedComponent(oper.getPathForRow(row)));
        }

        public String getDescription() {
            return this.chooser.getDescription();
        }
    }

    private class BySubStringTreeRowChooser
    implements TreeRowChooser {
        String subString;
        Operator.StringComparator comparator;

        public BySubStringTreeRowChooser(String subString, Operator.StringComparator comparator) {
            this.subString = subString;
            this.comparator = comparator;
        }

        public boolean checkRow(JTreeOperator oper, int row) {
            return this.comparator.equals(oper.getPathForRow(row).getLastPathComponent().toString(), this.subString);
        }

        public String getDescription() {
            return "Row containing \"" + this.subString + "\" string";
        }
    }

    class StringArrayPathChooser
    implements TreePathChooser {
        String[] arr;
        int[] indices;
        Operator.StringComparator comparator;

        StringArrayPathChooser(String[] arr, int[] indices, Operator.StringComparator comparator) {
            this.arr = arr;
            this.comparator = comparator;
            this.indices = indices;
        }

        public boolean checkPath(TreePath path, int indexInParent) {
            return path.getPathCount() - 1 == this.arr.length && this.hasAsParent(path, indexInParent);
        }

        public boolean hasAsParent(TreePath path, int indexInParent) {
            Object[] comps = path.getPath();
            for (int i = 1; i < comps.length; ++i) {
                if (this.arr.length < path.getPathCount() - 1) {
                    return false;
                }
                Object node = this.indices.length >= path.getPathCount() - 1 ? JTreeOperator.this.chooseSubnode(comps[i - 1], this.arr[i - 1], this.indices[i - 1], this.comparator) : JTreeOperator.this.chooseSubnode(comps[i - 1], this.arr[i - 1], this.comparator);
                if (node == comps[i]) continue;
                return false;
            }
            return true;
        }

        public String getDescription() {
            return JTreeOperator.pathToString(this.arr);
        }
    }

    public static interface TreePathChooser {
        public boolean checkPath(TreePath var1, int var2);

        public boolean hasAsParent(TreePath var1, int var2);

        public String getDescription();
    }

    public class NoSuchPathException
    extends JemmyInputException {
        public NoSuchPathException() {
            super("Unknown/null/invalid tree path.", (Component)null);
        }

        public NoSuchPathException(String[] path) {
            super("No such path as \"" + JTreeOperator.pathToString(path) + "\"", JTreeOperator.this.getSource());
        }

        public NoSuchPathException(int index) {
            super("Tree does not contain " + index + "'th line", JTreeOperator.this.getSource());
        }

        public NoSuchPathException(TreePath path) {
            super("No such path as \"" + path.toString() + "\"", JTreeOperator.this.getSource());
        }
    }

    public static interface TreeRowChooser {
        public boolean checkRow(JTreeOperator var1, int var2);

        public String getDescription();
    }
}

