/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.logging.Logger;

public abstract class Platform {
    private static Platform instance_;
    private final String name_;
    private static final Logger logger_;

    protected Platform(String name) {
        this.name_ = name;
    }

    public abstract File getHomeDirectory();

    public String getEnv(String varname) {
        try {
            return System.getenv(varname);
        }
        catch (Throwable e) {
            String[] argv = this.getGetenvArgs(varname);
            if (argv == null) {
                return null;
            }
            try {
                String cmdout = Platform.exec(argv);
                return cmdout.trim();
            }
            catch (Throwable e2) {
                return null;
            }
        }
    }

    public void setPrivateRead(File file) throws IOException {
        if (Platform.setPrivateReadReflect(file)) {
            return;
        }
        String[] privateReadArgs = this.getPrivateReadArgs(file);
        if (privateReadArgs != null) {
            Platform.exec(privateReadArgs);
        } else {
            logger_.info("No known way to set user-only read permissions; possible security implications on multi-user systems");
        }
    }

    protected abstract String[] getGetenvArgs(String var1);

    protected abstract String[] getPrivateReadArgs(File var1) throws IOException;

    private static boolean setPrivateReadReflect(File file) throws IOException {
        try {
            Method setReadableMethod = File.class.getMethod("setReadable", Boolean.TYPE, Boolean.TYPE);
            boolean success = setReadableMethod.invoke((Object)file, Boolean.FALSE, Boolean.FALSE).equals(Boolean.TRUE) && setReadableMethod.invoke((Object)file, Boolean.TRUE, Boolean.TRUE).equals(Boolean.TRUE);
            return success;
        }
        catch (InvocationTargetException e1) {
            Throwable e2 = e1.getCause();
            if (e2 instanceof IOException) {
                throw (IOException)e2;
            }
            if (e2 instanceof RuntimeException) {
                throw (RuntimeException)e2;
            }
            throw (IOException)new IOException(e2.getMessage()).initCause(e2);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
    }

    private static String exec(String[] args) throws IOException {
        StreamReader errReader;
        StreamReader outReader;
        Process process;
        String argv = Arrays.asList(args).toString();
        logger_.info("System exec: " + argv);
        try {
            process = Runtime.getRuntime().exec(args);
            outReader = new StreamReader(process.getInputStream());
            errReader = new StreamReader(process.getErrorStream());
            outReader.start();
            errReader.start();
            process.waitFor();
        }
        catch (InterruptedException e) {
            throw new IOException("Exec failed: " + argv);
        }
        catch (IOException e) {
            throw (IOException)new IOException("Exec failed: " + argv).initCause(e);
        }
        return process.exitValue() == 0 ? outReader.getContent() : errReader.getContent();
    }

    public static Platform getPlatform() {
        if (instance_ == null) {
            instance_ = Platform.createPlatform();
        }
        return instance_;
    }

    private static Platform createPlatform() {
        String osname = System.getProperty("os.name");
        if (osname.toLowerCase().startsWith("windows") || osname.toLowerCase().indexOf("microsoft") >= 0) {
            return new WindowsPlatform();
        }
        return new UnixPlatform();
    }

    static {
        logger_ = Logger.getLogger(Platform.class.getName());
    }

    private static class WindowsPlatform
    extends Platform {
        WindowsPlatform() {
            super("MS Windows");
        }

        protected String[] getPrivateReadArgs(File file) throws IOException {
            return null;
        }

        public File getHomeDirectory() {
            String userprofile = this.getEnv("USERPROFILE");
            if (userprofile != null && userprofile.trim().length() > 0) {
                return new File(userprofile);
            }
            return new File(System.getProperty("user.home"));
        }

        public String[] getGetenvArgs(String varname) {
            return new String[]{"cmd", "/c", "echo", "%" + varname + "%"};
        }
    }

    private static class UnixPlatform
    extends Platform {
        UnixPlatform() {
            super("Un*x");
        }

        public File getHomeDirectory() {
            return new File(System.getProperty("user.home"));
        }

        protected String[] getGetenvArgs(String varname) {
            return new String[]{"printenv", varname};
        }

        protected String[] getPrivateReadArgs(File file) {
            return new String[]{"chmod", "600", file.toString()};
        }
    }

    private static class StreamReader
    extends Thread {
        private final InputStream in_;
        private final StringBuffer sbuf_;

        StreamReader(InputStream in) {
            super("StreamReader");
            this.in_ = in;
            this.sbuf_ = new StringBuffer();
            this.setDaemon(true);
        }

        public void run() {
            try {
                int c;
                while ((c = this.in_.read()) >= 0) {
                    this.sbuf_.append((char)c);
                }
                this.in_.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String getContent() {
            return this.sbuf_.toString();
        }
    }
}

