/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp;

import java.util.Map;
import org.astrogrid.samp.DataException;
import org.astrogrid.samp.ErrInfo;
import org.astrogrid.samp.SampMap;

public class Response
extends SampMap {
    public static final String STATUS_KEY = "samp.status";
    public static final String RESULT_KEY = "samp.result";
    public static final String ERROR_KEY = "samp.error";
    private static final String[] KNOWN_KEYS = new String[]{"samp.status", "samp.result", "samp.error"};
    public static final String OK_STATUS = "samp.ok";
    public static final String WARNING_STATUS = "samp.warning";
    public static final String ERROR_STATUS = "samp.error";

    public Response() {
        super(KNOWN_KEYS);
    }

    public Response(Map map) {
        this();
        this.putAll(map);
    }

    public Response(String status, Map result, ErrInfo errinfo) {
        this();
        this.put(STATUS_KEY, status);
        if (result != null) {
            this.put(RESULT_KEY, result);
        }
        if (errinfo != null) {
            this.put("samp.error", errinfo);
        }
    }

    public void setStatus(String status) {
        this.put(STATUS_KEY, status);
    }

    public String getStatus() {
        return this.getString(STATUS_KEY);
    }

    public void setResult(Map result) {
        this.put(RESULT_KEY, result);
    }

    public Map getResult() {
        return this.getMap(RESULT_KEY);
    }

    public void setErrInfo(Map errInfo) {
        this.put("samp.error", errInfo);
    }

    public ErrInfo getErrInfo() {
        return ErrInfo.asErrInfo(this.getMap("samp.error"));
    }

    public boolean isOK() {
        return OK_STATUS.equals(this.get(STATUS_KEY));
    }

    public void check() {
        super.check();
        this.checkHasKeys(new String[]{STATUS_KEY});
        String status = this.getStatus();
        if ((OK_STATUS.equals(status) || WARNING_STATUS.equals(status)) && !this.containsKey(RESULT_KEY)) {
            throw new DataException("samp.status=" + status + " but no " + RESULT_KEY);
        }
        if (("samp.error".equals(status) || WARNING_STATUS.equals(status)) && !this.containsKey("samp.error")) {
            throw new DataException("samp.status=" + status + " but not " + "samp.error");
        }
        if (!this.containsKey(RESULT_KEY) && !this.containsKey("samp.error")) {
            throw new DataException("Neither samp.result nor samp.error keys present");
        }
        if (this.containsKey("samp.error")) {
            ErrInfo.asErrInfo(this.getMap("samp.error")).check();
        }
    }

    public static Response createSuccessResponse(Map result) {
        return new Response(OK_STATUS, result, null);
    }

    public static Response createErrorResponse(ErrInfo errinfo) {
        return new Response("samp.error", null, errinfo);
    }

    public static Response asResponse(Map map) {
        return map instanceof Response || map == null ? (Response)map : new Response(map);
    }
}

