/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;

public abstract class ErrorDialog
extends JDialog {
    protected ErrorDialog(Frame owner, String title, String summary) {
        super(owner, title == null ? "Error" : title, true);
        this.setDefaultCloseOperation(2);
        JPanel main = new JPanel(new BorderLayout());
        JButton disposeButton = new JButton();
        JButton detailButton = new JButton();
        final JPanel dataBox = new JPanel(new BorderLayout());
        dataBox.add(new JLabel(summary));
        Box buttonBox = Box.createHorizontalBox();
        Border gapBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        JLabel iconLabel = new JLabel(UIManager.getIcon("OptionPane.errorIcon"));
        iconLabel.setBorder(gapBorder);
        main.add((Component)iconLabel, "West");
        buttonBox.add(Box.createHorizontalGlue());
        buttonBox.add(disposeButton);
        buttonBox.add(Box.createHorizontalStrut(10));
        buttonBox.add(detailButton);
        buttonBox.add(Box.createHorizontalGlue());
        dataBox.setBorder(gapBorder);
        main.add((Component)buttonBox, "South");
        main.add((Component)dataBox, "Center");
        main.setBorder(gapBorder);
        disposeButton.setAction(new AbstractAction("OK"){

            public void actionPerformed(ActionEvent evt) {
                ErrorDialog.this.dispose();
            }
        });
        detailButton.setAction(new AbstractAction("Show Details"){

            public void actionPerformed(ActionEvent evt) {
                JTextArea ta = new JTextArea();
                ta.setLineWrap(false);
                ta.setEditable(false);
                ta.append(ErrorDialog.this.getDetailText());
                ta.setCaretPosition(0);
                JScrollPane scroller = new JScrollPane(ta);
                dataBox.removeAll();
                dataBox.add(scroller);
                Dimension size = dataBox.getPreferredSize();
                size.height = Math.min(size.height, 300);
                size.width = Math.min(size.width, 500);
                dataBox.revalidate();
                dataBox.setPreferredSize(size);
                ErrorDialog.this.pack();
                this.setEnabled(false);
            }
        });
        this.getContentPane().add(main);
    }

    protected abstract String getDetailText();

    public static void showError(Component parent, String title, String summary, final Throwable error) {
        Frame fparent = parent == null ? null : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        ErrorDialog dialog = new ErrorDialog(fparent, title, summary){

            protected String getDetailText() {
                StringWriter traceWriter = new StringWriter();
                error.printStackTrace(new PrintWriter(traceWriter));
                return traceWriter.toString();
            }
        };
        dialog.setLocationRelativeTo(parent);
        dialog.pack();
        dialog.setVisible(true);
    }
}

