/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.gui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.astrogrid.samp.Client;
import org.astrogrid.samp.gui.ClientListCellRenderer;
import org.astrogrid.samp.gui.ClientPanel;

public class HubView
extends JPanel {
    private final JList jlist_ = new JList();
    private final ClientPanel clientPanel_;
    private final ListDataListener listListener_;

    public HubView(boolean hubLike) {
        super(new BorderLayout());
        this.jlist_.setCellRenderer(new ClientListCellRenderer());
        ListSelectionModel selModel = this.jlist_.getSelectionModel();
        selModel.setSelectionMode(0);
        selModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                if (!evt.getValueIsAdjusting()) {
                    HubView.this.updateClientView();
                }
            }
        });
        this.listListener_ = new ListDataListener(){

            public void contentsChanged(ListDataEvent evt) {
                HubView.this.preferSelection();
                int isel = HubView.this.jlist_.getSelectedIndex();
                int i0 = evt.getIndex0();
                int i1 = evt.getIndex1();
                if (isel >= 0 && (i0 < 0 || i1 < 0 || (i0 - isel) * (i1 - isel) <= 0)) {
                    HubView.this.updateClientView();
                }
            }

            public void intervalRemoved(ListDataEvent evt) {
                if (HubView.this.clientPanel_.getClient() != null && HubView.this.jlist_.getSelectedIndex() < 0) {
                    HubView.this.updateClientView();
                }
            }

            public void intervalAdded(ListDataEvent evt) {
                HubView.this.preferSelection();
            }
        };
        this.clientPanel_ = new ClientPanel(hubLike);
        JSplitPane splitter = new JSplitPane();
        splitter.setOneTouchExpandable(true);
        JScrollPane listScroller = new JScrollPane(this.jlist_);
        listScroller.setPreferredSize(new Dimension(200, 400));
        listScroller.setBorder(ClientPanel.createTitledBorder("Clients"));
        splitter.setLeftComponent(listScroller);
        splitter.setRightComponent(this.clientPanel_);
        this.add(splitter);
    }

    public void setClientListModel(ListModel clientModel) {
        ListModel oldModel = this.jlist_.getModel();
        this.jlist_.getSelectionModel().clearSelection();
        if (oldModel != null) {
            oldModel.removeListDataListener(this.listListener_);
        }
        this.jlist_.setModel(clientModel);
        if (clientModel != null) {
            clientModel.addListDataListener(this.listListener_);
            this.preferSelection();
        }
    }

    public JList getClientList() {
        return this.jlist_;
    }

    private void updateClientView() {
        int isel = this.jlist_.getSelectedIndex();
        this.clientPanel_.setClient(isel >= 0 ? (Client)this.jlist_.getModel().getElementAt(isel) : null);
    }

    private void preferSelection() {
        if (this.jlist_.getSelectedIndex() < 0 && this.jlist_.getModel().getSize() > 0) {
            this.jlist_.setSelectedIndex(0);
        }
    }
}

