/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.astrogrid.samp.gui.Transmission;

class TransmissionListModel
extends AbstractListModel {
    private final List list_;
    private final ChangeListener changeListener_;
    private int removeDelay_;
    static /* synthetic */ Class class$org$astrogrid$samp$gui$TransmissionListModel;

    public TransmissionListModel(int removeDelay) {
        this.removeDelay_ = removeDelay;
        this.list_ = new ArrayList();
        this.changeListener_ = new ChangeListener(){
            static final /* synthetic */ boolean $assertionsDisabled;

            public void stateChanged(ChangeEvent evt) {
                Object src = evt.getSource();
                if (!$assertionsDisabled && !(src instanceof Transmission)) {
                    throw new AssertionError();
                }
                if (src instanceof Transmission) {
                    TransmissionListModel.this.transmissionChanged((Transmission)src);
                }
            }

            static {
                $assertionsDisabled = !(class$org$astrogrid$samp$gui$TransmissionListModel == null ? (class$org$astrogrid$samp$gui$TransmissionListModel = TransmissionListModel.class$("org.astrogrid.samp.gui.TransmissionListModel")) : class$org$astrogrid$samp$gui$TransmissionListModel).desiredAssertionStatus();
            }
        };
    }

    private void transmissionChanged(final Transmission trans) {
        int index = this.list_.indexOf(trans);
        if (index >= 0) {
            this.fireContentsChanged(trans, index, index);
            if (trans.isDone() && this.removeDelay_ >= 0) {
                long sinceDone = System.currentTimeMillis() - trans.getDoneTime();
                long delay = (long)this.removeDelay_ - sinceDone;
                if (delay <= 0L) {
                    this.removeTransmission(trans);
                } else {
                    ActionListener remover = new ActionListener(){

                        public void actionPerformed(ActionEvent evt) {
                            TransmissionListModel.this.removeTransmission(trans);
                        }
                    };
                    new Timer((int)delay + 1, remover).start();
                }
            }
        }
    }

    public int getSize() {
        return this.list_.size();
    }

    public Object getElementAt(int index) {
        return this.list_.get(index);
    }

    public void addTransmission(Transmission trans) {
        int index = this.list_.size();
        this.list_.add(trans);
        this.fireIntervalAdded(trans, index, index);
        trans.addChangeListener(this.changeListener_);
    }

    public void removeTransmission(final Transmission trans) {
        int index = this.list_.indexOf(trans);
        if (index >= 0) {
            this.list_.remove(index);
            this.fireIntervalRemoved(trans, index, index);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                trans.removeChangeListener(TransmissionListModel.this.changeListener_);
            }
        });
    }
}

