/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp;

import gnu.regexp.CharIndexed;
import gnu.regexp.REMatch;
import gnu.regexp.REToken;

final class RETokenWordBoundary
extends REToken {
    private boolean negated;
    private int where;
    static final int BEGIN = 1;
    static final int END = 2;

    RETokenWordBoundary(int subIndex, int where, boolean negated) {
        super(subIndex);
        this.where = where;
        this.negated = negated;
    }

    boolean match(CharIndexed input, REMatch mymatch) {
        char ch;
        boolean after = false;
        boolean before = false;
        if (((mymatch.eflags & 0x40) != 64 || mymatch.offset + mymatch.index > mymatch.anchor) && (ch = input.charAt(mymatch.index - 1)) != '\uffff') {
            boolean bl = before = Character.isLetterOrDigit(ch) || ch == '_';
        }
        if ((ch = input.charAt(mymatch.index)) != '\uffff') {
            after = Character.isLetterOrDigit(ch) || ch == '_';
        }
        boolean doNext = false;
        if ((this.where & 1) == 1) {
            boolean bl = doNext = after && !before;
        }
        if ((this.where & 2) == 2) {
            doNext ^= before && !after;
        }
        if (this.negated) {
            doNext = !doNext;
        }
        return doNext ? this.next(input, mymatch) : false;
    }

    void dump(StringBuffer os) {
        if (this.where == 3) {
            os.append(this.negated ? "\\B" : "\\b");
        } else if (this.where == 1) {
            os.append("\\<");
        } else {
            os.append("\\>");
        }
    }

    static {
        BEGIN = 1;
        END = 2;
    }
}

