/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.api.windows;

import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.platform.win32.Win32UserInfo;

public class WinUser {
    public static boolean deleteUser(String nameOrSid) {
        String accountName = Win32UserInfo.getAccountName(nameOrSid);
        return Win32UserInfo.deleteUser(accountName != null ? accountName : nameOrSid);
    }

    public static boolean deleteLocalGroup(String nameOrSid) {
        String accountName = Win32UserInfo.getAccountName(nameOrSid);
        return Win32UserInfo.deleteLocalGroup(accountName != null ? accountName : nameOrSid);
    }

    public static AddUserResult addUser(String name, String password, String comment, GroupCreationMode groupCreationMode, String localGroupNameOrSid, String localGroupComment) {
        Win32UserInfo.Result win32Result;
        String groupAccountName;
        if (name == null) {
            throw new IllegalArgumentException("name required");
        }
        if (password == null) {
            throw new IllegalArgumentException("password required");
        }
        if (groupCreationMode == null) {
            throw new IllegalArgumentException("groupCreationMode required");
        }
        if (localGroupNameOrSid != null && localGroupNameOrSid.trim().length() == 0) {
            localGroupNameOrSid = null;
        }
        if (localGroupNameOrSid == null && groupCreationMode == GroupCreationMode.CREATE_IF_NECESSARY) {
            groupCreationMode = GroupCreationMode.NONE;
        }
        if (groupCreationMode != GroupCreationMode.NONE && localGroupNameOrSid == null) {
            throw new IllegalArgumentException("localGroupName required");
        }
        if (groupCreationMode == GroupCreationMode.NONE) {
            localGroupNameOrSid = null;
        }
        if (localGroupNameOrSid != null && (groupAccountName = Win32UserInfo.getAccountName(localGroupNameOrSid)) != null) {
            localGroupNameOrSid = groupAccountName;
        }
        if ((win32Result = Win32UserInfo.addUser(name, password, comment, localGroupNameOrSid, localGroupComment, groupCreationMode == GroupCreationMode.CREATE_IF_NECESSARY || groupCreationMode == GroupCreationMode.CREATE_OR_FAIL, groupCreationMode == GroupCreationMode.CREATE_OR_FAIL)) == null) {
            return new AddUserResult(AddUserResultType.ERROR_OTHER);
        }
        switch (win32Result.getErrorCode()) {
            case 0: {
                return new AddUserResult(AddUserResultType.SUCCESS, win32Result.getUserSid(), win32Result.getGroupSid(), win32Result.isGroupCreated());
            }
            case 1379: 
            case 2223: {
                return new AddUserResult(AddUserResultType.ERROR_GROUP_EXISTS);
            }
            case 2220: {
                return new AddUserResult(AddUserResultType.ERROR_GROUP_NOT_FOUND);
            }
            case 2224: {
                return new AddUserResult(AddUserResultType.ERROR_USER_EXISTS);
            }
            case 2245: {
                return new AddUserResult(AddUserResultType.ERROR_PASSWORD_REQUIREMENTS);
            }
            case 5: 
            case 2226: {
                return new AddUserResult(AddUserResultType.ERROR_ACCESS_DENIED);
            }
        }
        Logger.getInstance().error(WinUser.class, "Could not create user. Win32 error code is " + win32Result.getErrorCode() + ", raw result: " + win32Result.getRawResult());
        return new AddUserResult(AddUserResultType.ERROR_OTHER);
    }

    public static String getAccountName(String sid) {
        return Win32UserInfo.getAccountName(sid);
    }

    public static String getUserName(String sid) {
        return Win32UserInfo.getAccountName(sid, true);
    }

    public static String getUserSid() {
        return Win32UserInfo.getUserSid();
    }

    public static enum AddUserResultType {
        SUCCESS(""),
        ERROR_ACCESS_DENIED(""),
        ERROR_GROUP_EXISTS(""),
        ERROR_GROUP_NOT_FOUND(""),
        ERROR_USER_EXISTS(""),
        ERROR_PASSWORD_REQUIREMENTS(""),
        ERROR_OTHER("");

        private String verbose;

        private AddUserResultType(String verbose) {
            this.verbose = verbose;
        }

        public String toString() {
            return this.verbose;
        }
    }

    public static enum GroupCreationMode {
        NONE("none"),
        USE_EXISTING("use existing"),
        CREATE_IF_NECESSARY("create if necessary"),
        CREATE_OR_FAIL("create or fail");

        private String name;

        private GroupCreationMode(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class AddUserResult {
        private AddUserResultType resultType;
        private String userSid;
        private String groupSid;
        private boolean groupCreated;

        private AddUserResult(AddUserResultType resultType, String userSid, String groupSid, boolean groupCreated) {
            this.resultType = resultType;
            this.userSid = userSid;
            this.groupSid = groupSid;
            this.groupCreated = groupCreated;
        }

        private AddUserResult(AddUserResultType resultType) {
            this.resultType = resultType;
        }

        public AddUserResultType getType() {
            return this.resultType;
        }

        public String getUserSid() {
            return this.userSid;
        }

        public String getGroupSid() {
            return this.groupSid;
        }

        public boolean isGroupCreated() {
            return this.groupCreated;
        }

        public String toString() {
            return "AddUserResult{resultType=" + (Object)((Object)this.resultType) + ", userSid='" + this.userSid + '\'' + ", groupSid='" + this.groupSid + '\'' + ", groupCreated=" + this.groupCreated + '}';
        }
    }
}

