/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.Util;
import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.events.InstallerEvent;
import com.install4j.api.events.InstallerEventListener;
import com.install4j.api.events.InstallerVariableEvent;
import com.install4j.api.formcomponents.FormEnvironment;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.formcomponents.LeadingLabelComponent;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.frontend.components.AbstractFileSelector;
import com.install4j.runtime.installer.frontend.components.FileValidator;
import com.install4j.runtime.installer.helper.Logger;
import java.io.File;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JTextField;

public abstract class AbstractFileChooserComponent<S extends AbstractFileSelector>
extends LeadingLabelComponent
implements FileValidator {
    private String variableName = "";
    private String initialFile = "";
    private String initialBrowserDirectory = "";
    private boolean manualEntryAllowed = true;
    private ScriptProperty validationScript;
    private S fileSelector;

    protected abstract S createFileSelector();

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public String getInitialFile() {
        return this.replaceFormVariables(this.initialFile);
    }

    public void setInitialFile(String initialFile) {
        this.initialFile = initialFile;
    }

    public String getInitialBrowserDirectory() {
        return this.replaceFormVariables(this.initialBrowserDirectory);
    }

    public void setInitialBrowserDirectory(String initialBrowserDirectory) {
        this.initialBrowserDirectory = initialBrowserDirectory;
    }

    public boolean isManualEntryAllowed() {
        return this.manualEntryAllowed;
    }

    public void setManualEntryAllowed(boolean manualEntryAllowed) {
        this.manualEntryAllowed = manualEntryAllowed;
    }

    public ScriptProperty getValidationScript() {
        return this.validationScript;
    }

    public void setValidationScript(ScriptProperty validationScript) {
        this.validationScript = validationScript;
    }

    @Override
    public void setFormEnvironment(FormEnvironment formEnvironment) {
        super.setFormEnvironment(formEnvironment);
        if (this.fileSelector != null && formEnvironment != null) {
            String id = formEnvironment.getId(this);
            this.fileSelector.getTextField().setName(id);
            this.fileSelector.getButton().setName(id);
        }
    }

    @Override
    public JComponent createCenterComponent() {
        this.fileSelector = this.createFileSelector();
        this.fileSelector.setManualEntryAllowed(this.manualEntryAllowed);
        this.fileSelector.setValidator(this);
        this.getContext().addInstallerEventListener(new InstallerEventListener(){

            @Override
            public void installerEvent(InstallerEvent event) {
                if (!AbstractFileChooserComponent.this.getContext().isConsole() && !AbstractFileChooserComponent.this.getContext().isUnattended() && event instanceof InstallerVariableEvent && Objects.equals(((InstallerVariableEvent)event).getVariableName(), AbstractFileChooserComponent.this.variableName)) {
                    Object value = AbstractFileChooserComponent.this.getContext().getVariable(AbstractFileChooserComponent.this.variableName);
                    if (value instanceof String) {
                        AbstractFileChooserComponent.this.fileSelector.setSelectedFile(new File((String)value));
                    } else {
                        AbstractFileChooserComponent.this.initialize();
                    }
                }
            }
        });
        return (JComponent)this.fileSelector;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.fileSelector.getButton().setEnabled(enabled);
    }

    @Override
    public Object getConfigurationObject() {
        return this.fileSelector.getTextField();
    }

    @Override
    public Class getConfigurationObjectClass() {
        return JTextField.class;
    }

    @Override
    public boolean checkCompleted() {
        if (!this.isEnabled() || !this.isVisible()) {
            return true;
        }
        File selectedFile = this.fileSelector.getSelectedFile();
        if (this.checkSelectedFile()) {
            this.getContext().setVariable(this.getVariableName(), selectedFile == null ? null : selectedFile.getPath());
            this.getContext().registerResponseFileVariable(this.getVariableName());
            return true;
        }
        return false;
    }

    protected boolean checkSelectedFile() {
        return this.fileSelector.checkSelectedFile();
    }

    @Override
    public void initialize() {
        super.initialize();
        String initValue = this.getInitValue();
        if (initValue.length() > 0) {
            this.initFileSelector(new File(initValue));
        }
        try {
            this.fileSelector.setInitialBrowserDirectory(this.getInitialBrowserDirectory().trim());
        }
        catch (Exception e) {
            Logger.getInstance().log(this, "Cannot get initial browser directory", false);
        }
    }

    protected S getFileSelector() {
        return this.fileSelector;
    }

    protected void initFileSelector(File initialFile) {
        this.fileSelector.setSelectedFile(initialFile);
    }

    private String getInitValue() {
        String initValue = (String)this.getInitValue(this.getInitialFile(), this.getVariableName(), String.class);
        if (initValue == null) {
            return "";
        }
        return initValue.trim();
    }

    @Override
    public boolean isFillCenterHorizontal() {
        return true;
    }

    @Override
    public boolean handleConsole(Console console) throws UserCanceledException {
        do {
            String defaultValue = this.initialFile.length() > 0 || this.getInitValue().length() > 0 ? this.fileSelector.getSelectedFile().getAbsolutePath() : "";
            File file = new File(console.askString(this.getConsoleLabelText(false), defaultValue));
            this.fileSelector.setSelectedFile(file);
        } while (!this.checkSelectedFile());
        return true;
    }

    @Override
    public boolean isValidFile(File file) {
        if (this.validationScript != null) {
            try {
                return ContextImpl.getContextInt(this.getContext()).runBooleanScript(this.validationScript.getValue(), this, file, this.getFormEnvironment());
            }
            catch (Exception e) {
                Util.printAnnotatedStackTrace(e);
                Logger.getInstance().log(e);
            }
        }
        return true;
    }
}

