/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper;

import com.install4j.runtime.installer.frontend.ProgressAdapter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;

public class Unpacker {
    private static final long POLLING_INTERVAL = 100L;
    private static ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();

    private static boolean isPacked(File tempFile) {
        try {
            DataInputStream in = new DataInputStream(new FileInputStream(tempFile));
            int firstInt = in.readInt();
            in.close();
            return firstInt == -889270259;
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unpack(File tempFile, File destFile, final ProgressAdapter progressAdapter) throws IOException {
        if (!Unpacker.isPacked(tempFile)) {
            return false;
        }
        final Pack200.Unpacker unpacker = Pack200.newUnpacker();
        ScheduledFuture<?> scheduledFuture = null;
        if (progressAdapter != null) {
            progressAdapter.setMaxCopyProgress(100L);
            scheduledFuture = executor.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    try {
                        String progressValue = (String)unpacker.properties().get("unpack.progress");
                        if (progressValue != null) {
                            int progress = Integer.parseInt(progressValue);
                            progressAdapter.setPercentCompleted(progress);
                            progressAdapter.setSecondaryPercentCompleted(progress);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }, 100L, 100L, TimeUnit.MILLISECONDS);
        }
        try {
            JarOutputStream out = new JarOutputStream(new FileOutputStream(destFile));
            unpacker.unpack(tempFile, out);
            out.close();
            boolean bl = true;
            return bl;
        }
        finally {
            if (scheduledFuture != null) {
                scheduledFuture.cancel(true);
            }
        }
    }
}

